<?php include( 'inc/template.php' );?>
	<div class="container-fluid flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
	<li class="breadcrumb-item"><a href="hotel_list.php">Hotel List</a></li>
    <li class="breadcrumb-item active"><?php echo isset($_GET['id']) ? 'Update Hotel' : 'Hotel Add'; ?></li>
    </ol>
</nav>
	
    
		<div class="card mb-4">

			<form id="hotelForm" class="card-body" enctype="multipart/form-data">
  <div class="row g-3">

    <div class="col-md-6">
      <label class="form-label">Hotel Name</label>
      <input type="text" name="hotel_name" id="hotel_name" class="form-control" required>
    </div>

    <div class="col-md-6 position-relative">
      <label class="form-label">Destination (City)</label>
      
      <div id="citySuggestions" class="list-group position-absolute w-100 bg-white shadow-sm rounded-2" style="z-index:1050; max-height:250px; overflow-y:auto;"></div>
    </div>

    <div class="col-md-6">
      <label class="form-label">Address</label>
		<textarea class="form-control" name="address" id="address"></textarea>
      
    </div>

    <div class="col-md-6">
  <label class="form-label">Stars</label>
  <select name="stars" id="stars" class="form-select">
    <option value="">Select Stars</option>
    <option value="1">★</option>
    <option value="2">★★</option>
    <option value="3">★★★</option>
    <option value="4">★★★★</option>
    <option value="5">★★★★★</option>
  </select>
</div>


   

  </div>

  <div class="pt-4">
    <input type="hidden" name="id" id="id">
    <input type="hidden" name="action" id="action" value="Create">
    <button type="submit" class="btn btn-primary">Save</button>
    <button type="reset" class="btn btn-secondary">Cancel</button>
  </div>
</form>




		</div>
	</div>
<script>
$(document).ready(function () {

    // Form Submit: Create / Update Hotel
    $('#hotelForm').on('submit', function (event) {
        event.preventDefault();

        let formData = new FormData(this);

        // Basic validation
        if (!formData.get("hotel_name") || !formData.get("destination") || !formData.get("stars")) {
            toastr.error("Please fill all required fields.");
            return;
        }

        $.ajax({
            url: 'controller/HotelController.php', // your controller
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (response) {
                if (response.status === 'success') {
                    toastr.success(response.message);
                    setTimeout(() => window.location.href = 'hotel_list.php', 1500);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function (xhr) {
                toastr.error('An error occurred while submitting the form.');
                console.error('AJAX Error:', xhr.responseText);
            }
        });
    });

    const urlParams = new URLSearchParams(window.location.search);
const hotelId = urlParams.get('id');

if (hotelId) {
    $('#id').val(hotelId);
    $('#action').val('Update'); // mark as update mode

    $.ajax({
        url: 'controller/HotelController.php',
        type: 'POST',
        data: { id: hotelId, action: 'Select' },
        dataType: 'json',
        success: function (response) {
            if (response.status === 'success') {
                let data = response.data;
                $('#hotel_name').val(data.hotel_name);
                $('#destination').val(data.city_name);
                $('#city_id').val(data.city_id);
                $('#address').val(data.address);
                $('#stars').val(data.stars);
            } else {
                toastr.error(response.message);
            }
        },
        error: function () {
            toastr.error('Failed to load hotel data.');
        }
    });
}

    // City autocomplete
    $('#destination').on('input', function() {
        let query = $(this).val();
        if (query.length < 2) {
            $('#citySuggestions').empty();
            return;
        }

        $.ajax({
            url: 'ajax/city_search.php',
            type: 'GET',
            data: { q: query },
            success: function(res) {
                let cities = JSON.parse(res);
                let html = '';
                if (cities.length > 0) {
                    cities.forEach(city => {
                        html += `<a href="javascript:void(0)" class="list-group-item list-group-item-action city-item" data-id="${city.id}" data-name="${city.city_name}">${city.city_name}</a>`;
                    });
                } else {
                    html = '<span class="list-group-item">No cities found</span>';
                }
                $('#citySuggestions').html(html);
            }
        });
    });

    // Select city from suggestions
    $(document).on('click', '.city-item', function() {
        let cityName = $(this).data('name');
        let cityId = $(this).data('id');
        $('#destination').val(cityName);
        $('#city_id').val(cityId);
        $('#citySuggestions').empty();
    });

    // Hide suggestions if clicked outside
    $(document).click(function(e) {
        if (!$(e.target).closest('#destination, #citySuggestions').length) {
            $('#citySuggestions').empty();
        }
    });

});
</script>

<?php include('inc/footer.php');?>