<?php include( 'inc/template.php' );?>
<div class="container-xxl flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
			<ol class="breadcrumb breadcrumb-custom-icon">
				<li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item active">Financial Years</li>
			</ol>
		</nav>
		<button type="button" class="btn btn-sm rounded-pill btn-primary" data-bs-toggle="modal" data-bs-target="#fyModal"><span class="ti tabler-square-rounded-plus icon-20px me-2"></span>Add Financial Years</button>
		<div class="card">
			<div id="alert-box" class="alert d-none" role="alert"></div>

			<div class="modal fade" id="fyModal" tabindex="-1" aria-hidden="true">
				<div class="modal-dialog modal-lg">
					<form id="fyForm" method="post">
						<div class="modal-content">
							<div class="modal-header">
								<h5 class="modal-title">Add/Edit Financial Year</h5>
								<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
							</div>
							<div class="modal-body">
								<input type="hidden" id="id" name="id"/>
								<div class="row">
									<div class="col-md-6 mb-3">
										<label class="form-label">Year Label</label>
										<input type="text" class="form-control" name="year_label" id="year_label" placeholder="e.g. 2024-2025" pattern="^\d{4}-\d{4}$" inputmode="numeric" minlength="9" maxlength="9" title="Please enter in format: 2024-2025" required>

									</div>
									<script>
										document.addEventListener( "DOMContentLoaded", function () {
											const input = document.getElementById( "year_label" );
											const today = new Date();
											const year = today.getMonth() >= 3 ? today.getFullYear() : today.getFullYear() - 1;
											const nextYear = year + 1;
											input.value = `${year}-${nextYear}`;
										} );
									</script>
									<div class="col-md-6 mb-3">
										<label class="form-label">Status</label>
										<select class="form-control" name="status" id="status">
											<option value="active">Active</option>
											<option value="inactive">Inactive</option>
										</select>
									</div>
									<div class="col-md-6 mb-3">
										<label class="form-label">Start Date</label>
										<input type="date" class="form-control" name="start_date" id="start_date" required>
									</div>
									<div class="col-md-6 mb-3">
										<label class="form-label">End Date</label>
										<input type="date" class="form-control" name="end_date" id="end_date" required>
									</div>
								</div>
							</div>
							<div class="modal-footer">
								<button type="submit" class="btn btn-primary">Save</button>
								<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
							</div>
						</div>
					</form>
				</div>
			</div>


			<!-- Toast -->


			<div class="card-datatable text-nowrap">
				<table id="fyTable" class="datatables-ajax table table-bordered">
					<thead>
						<tr>
							<th>Year Label</th>
							<th>Start Date</th>
							<th>End Date</th>
							<th>Status</th>
							<th>Action</th>
						</tr>
					</thead>
					<tbody></tbody>
				</table>
			</div>
		</div>
	</div>
	<script>
$(document).ready(function () {

  // INITIAL LOAD
  fetchFinancialyears();

  // 🔹 SHOW TOAST
  function showToast(message, type = 'success') {
    const alertBox = $('#alert-box');
    alertBox.removeClass('d-none alert-success alert-danger')
      .addClass(`alert alert-${type}`)
      .text(message);

    setTimeout(() => {
      alertBox.addClass('d-none').text('');
    }, 3000);
  }

  // 🔹 FETCH FINANCIAL YEARS
  function fetchFinancialyears() {
    $.get('controller/fyController.php', { action: 'list' }, function (html) {
      const $table = $('#fyTable');

      // Destroy old DataTable instance
      if ($.fn.DataTable.isDataTable($table)) {
        $table.DataTable().clear().destroy();
      }

      $table.find('tbody').html(html);

      // Re-initialize DataTable
      $table.DataTable({
        responsive: true,
        order: [[0, 'desc']],
      });
    });
  }

  // 🔹 FORM SUBMIT
  $('#fyForm').on('submit', function (e) {
    e.preventDefault();
    const id = $('#id').val();
    const formData = new FormData(this);
    formData.append('action', id ? 'update' : 'add');

    $.ajax({
      url: 'controller/fyController.php',
      method: 'POST',
      data: formData,
      contentType: false,
      processData: false,
      success: function (res) {
        let result;
        try { result = JSON.parse(res); } catch { return showToast('Invalid response', 'danger'); }

        if (result.status === 'success') {
          $('#fyForm')[0].reset();
          $('#fyModal').modal('hide');
          fetchFinancialyears();
          showToast(result.message, 'success');
        } else {
          showToast(result.message, 'danger');
        }
      },
      error: function () {
        showToast('Something went wrong.', 'danger');
      }
    });
  });

  // 🔹 EDIT BUTTON
  $(document).on('click', '.editBtn', function () {
    const id = $(this).data('id');
    $.post('controller/fyController.php', { action: 'getFinancialyear', id }, function (res) {
      const fy = JSON.parse(res);
      if (!fy.id) return showToast('Data not found', 'danger');

      $('#id').val(fy.id);
      $('#year_label').val(fy.year_label);
      $('#start_date').val(fy.start_date);
      $('#end_date').val(fy.end_date);
      $('#status').val(fy.status);
      $('#fyModal').modal('show');
    });
  });

  // 🔹 DELETE BUTTON
  $(document).on('click', '.deleteBtn', function () {
    const id = $(this).data('id');
    const row = $(this).closest('tr');
    Swal.fire({
      title: 'Are you sure?',
      text: 'This will delete the record permanently.',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#6c757d',
      confirmButtonText: 'Yes, delete it!',
    }).then((result) => {
      if (result.isConfirmed) {
        $.post('controller/fyController.php', { action: 'deleteFinancialyear', id }, function (res) {
          const result = JSON.parse(res);
          if (result.status === 'success') {
            const table = $('#fyTable').DataTable();
            table.row(row).remove().draw(false);
            Swal.fire('Deleted!', result.message, 'success');
          } else {
            Swal.fire('Error!', result.message, 'error');
          }
        });
      }
    });
  });

  // 🔹 TOGGLE STATUS
  $(document).on('change', '.toggleStatus', function () {
    const id = $(this).data('id');
    const status = $(this).is(':checked');
    $.post('controller/fyController.php', { action: 'toggleStatus', id, status }, function (res) {
      const result = JSON.parse(res);
      showToast(result.message, result.status === 'success' ? 'success' : 'danger');
    });
  });
});
</script>

	<?php include('inc/footer.php');?>