<?php
// dashboard.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include('inc/template.php');   // your template/header (assumed to include $conn, session etc.)
include(__DIR__ . '/inc/db.php'); // ensure $conn is available

//session_start();
//$userRole = $_SESSION['user_role'] ?? 'admin';
//$userId   = $_SESSION['user_id'] ?? 0;

// -------- helpers ----------
function formatIndianCurrency($number) {
    $number = (string)$number;
    $decimal = '';
    if (strpos($number, '.') !== false) {
        list($number, $decimal) = explode('.', $number);
        $decimal = '.' . $decimal;
    }
    $lastThree = substr($number, -3);
    $restUnits = substr($number, 0, -3);
    if ($restUnits != '') {
        $restUnits = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $restUnits);
        return '₹' . $restUnits . "," . $lastThree . $decimal;
    } else {
        return '₹' . $lastThree . $decimal;
    }
}

// validate date in Y-m-d format
function validDate($d){
    $date = DateTime::createFromFormat('Y-m-d', $d);
    return $date && $date->format('Y-m-d') === $d;
}

// -------- date filter handling ----------
$from = $_GET['from'] ?? '';
$to   = $_GET['to'] ?? '';
$dateConditionPayments = '';
$dateConditionGeneral  = '';
if ($from && validDate($from)) {
    if ($to && validDate($to)) {
        // use inclusive between
        $dateConditionPayments = " AND DATE(payment_date) BETWEEN '{$from}' AND '{$to}' ";
        $dateConditionGeneral  = " AND DATE(created_at) BETWEEN '{$from}' AND '{$to}' ";
    } else {
        $dateConditionPayments = " AND DATE(payment_date) = '{$from}' ";
        $dateConditionGeneral  = " AND DATE(created_at) = '{$from}' ";
    }
} elseif ($to && validDate($to)) {
    $dateConditionPayments = " AND DATE(payment_date) = '{$to}' ";
    $dateConditionGeneral  = " AND DATE(created_at) = '{$to}' ";
}

// default today when no filter for "today" widgets
$today = date('Y-m-d');

// ---------- Start HTML output ----------
?>
<style>

.bg-purple {
    background: #0c456e;
    color: #fff;
}



.card-title.titelcolor {
    color: #fff;
}

.smllalcolor {
    
    color: #fff;
    
}

</style>
<div class="container-fluid flex-grow-1 container-p-y">
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item">
       <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#smallModal">
  <i class="ti ti-search ti-xs"></i> Search
</a>

      </li>
    </ol>
  </nav>

  <!-- Date filter modal -->
  <div class="modal fade" id="smallModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
      <form method="get" class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Filter by Date</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="row g-2">
            <div class="col mb-0">
              <label class="form-label">From</label>
              <input type="date" name="from" class="form-control" value="<?php echo htmlspecialchars($from); ?>" />
            </div>
            <div class="col mb-0">
              <label class="form-label">To</label>
              <input type="date" name="to" class="form-control" value="<?php echo htmlspecialchars($to); ?>" />
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <a href="dashboard.php" class="btn btn-outline-secondary">Reset</a>
          <button type="submit" class="btn btn-primary">Apply</button>
        </div>
      </form>
    </div>
  </div>

  <style>
    .scroll-list { max-height: 350px; overflow-y:auto; padding:0; margin:0; list-style:none; }
    .scroll-list::-webkit-scrollbar { width: 6px; }
    .scroll-list::-webkit-scrollbar-thumb { background:#ddd; border-radius:4px; }
  </style>

  <div class="row">
    <!-- Inquiry counters -->
    <?php
    $types = ['package'=>'Package','hotel'=>'Hotel','flight'=>'Flight','vehicle'=>'Vehicle','insurance'=>'Insurance'];
    foreach ($types as $key=>$label) {
        if ($userRole == 'admin') {
            $sql = "SELECT COUNT(*) AS cnt FROM inquiries WHERE inquiry_type = '{$key}' {$dateConditionGeneral}";
        } else {
            $sql = "SELECT COUNT(*) AS cnt FROM inquiries WHERE inquiry_type = '{$key}' AND assigned_to = '".(int)$userId."' {$dateConditionGeneral}";
        }
        $res = mysqli_query($conn, $sql);
        $r = mysqli_fetch_assoc($res);
        $count = (int)($r['cnt'] ?? 0);
        ?>
        <div class="col-lg-2 col-6 mb-4">
          <div class="card h-100 bg-purple">
            <a href="inquiry_list.php?type=<?php echo urlencode($key); ?>">
              <div class="card-body text-center">
                <h5 class="card-title mb-2 titelcolor"><?php echo $count; ?></h5>
                <small class="smllalcolor"><?php echo $label; ?> Inquiries</small>
              </div>
            </a>
          </div>
        </div>
    <?php } ?>
	   <!-- Quotations pending -->
    <?php
    if ($userRole == 'admin') {
        $sql = "SELECT COUNT(*) AS cnt FROM quotations WHERE status = 'pending' {$dateConditionGeneral}";
    } else {
        $sql = "SELECT COUNT(*) AS cnt FROM quotations WHERE status = 'pending' AND assigned_to = '".(int)$userId."' {$dateConditionGeneral}";
    }
    $res = mysqli_query($conn, $sql);
    $r = mysqli_fetch_assoc($res);
    $pendingQuotations = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="quotations_list.php">
          <div class="card-body text-center">
            <h5 class="card-title mb-2 titelcolor"><?php echo $pendingQuotations; ?></h5>
            <small class="smllalcolor">Pending Quotations</small>
          </div>
        </a>
      </div>
    </div>

	 <!-- Inquiry counters -->
    <?php
    $types = ['package'=>'Package','hotel'=>'Hotel','flight'=>'Flight','vehicle'=>'Vehicle','insurance'=>'Insurance'];
    foreach ($types as $key=>$label) {
        if ($userRole == 'admin') {
            $sql = "SELECT COUNT(*) AS cnt FROM bookings WHERE booking_type = '{$key}' {$dateConditionGeneral}";
        } else {
            $sql = "SELECT COUNT(*) AS cnt FROM bookings WHERE booking_type = '{$key}' AND created_by = '".(int)$userId."' {$dateConditionGeneral}";
        }
        $res = mysqli_query($conn, $sql);
        $r = mysqli_fetch_assoc($res);
        $count = (int)($r['cnt'] ?? 0);
        ?>
        <div class="col-lg-2 col-6 mb-4">
          <div class="card h-100 bg-purple">
            <a href="<?php echo urlencode($key); ?>_booking_list.php">
              <div class="card-body text-center">
                <h5 class="card-title mb-2 titelcolor"><?php echo $count; ?></h5>
                <small class="smllalcolor"><?php echo $label; ?> Booking</small>
              </div>
            </a>
          </div>
        </div>
    <?php } ?>

   
    <!-- Customers -->
    <?php
    $res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM customers");
    $r = mysqli_fetch_assoc($res);
    $customers = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="customers_list.php">
          <div class="card-body text-center">
            <h5 class="card-title mb-2 titelcolor"><?php echo $customers; ?></h5>
            <small class="smllalcolor">Customers</small>
          </div>
        </a>
      </div>
    </div>
	  
	 <!-- Customers -->
    <?php
    $res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM packages WHERE status = 'active'");
    $r = mysqli_fetch_assoc($res);
    $Packages = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="package_list.php">
          <div class="card-body text-center">
            <h5 class="card-title mb-2 titelcolor"><?php echo $Packages; ?></h5>
            <small class="smllalcolor">Packages</small>
          </div>
        </a>
      </div>
    </div>
	  
	 <!-- Customers -->
    <?php
    $res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM package_categories WHERE status = 'active'");
    $r = mysqli_fetch_assoc($res);
    $packagescategories = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="packages_categories.php">
          <div class="card-body text-center primary">
            <h5 class="card-title mb-2 titelcolor"><?php echo $packagescategories; ?></h5>
            <small class="smllalcolor">Categories</small>
          </div>
        </a>
      </div>
    </div>
	  
	  
	  <!-- Customers -->
    <?php
    $res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM hotels WHERE status = 'active'");
    $r = mysqli_fetch_assoc($res);
    $hotels = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="hotel_list.php">
          <div class="card-body text-center">
            <h5 class="card-title mb-2 titelcolor"><?php echo $hotels; ?></h5>
            <small class="smllalcolor">Hotels</small>
          </div>
        </a>
      </div>
    </div>
	   <?php
    $res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM cities WHERE status = '1'");
    $r = mysqli_fetch_assoc($res);
    $cities = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="city_master.php">
          <div class="card-body text-center">
            <h5 class="card-title mb-2 titelcolor"><?php echo $cities; ?></h5>
            <small class="smllalcolor">Cities</small>
          </div>
        </a>
      </div>
    </div>
	   <?php
    $res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM states WHERE status = '1'");
    $r = mysqli_fetch_assoc($res);
    $states = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="state_master.php">
          <div class="card-body text-center">
            <h5 class="card-title mb-2 titelcolor"><?php echo $states; ?></h5>
            <small class="smllalcolor">States</small>
          </div>
        </a>
      </div>
    </div>
     <?php if($_SESSION["userrole"] != 'sales') { ?>
    <!-- Sales users count -->
    <?php
    $res = mysqli_query($conn, "SELECT COUNT(*) AS cnt FROM users WHERE role = 'sales'");
    $r = mysqli_fetch_assoc($res);
    $salesUsers = (int)($r['cnt'] ?? 0);
    ?>
    <div class="col-lg-2 col-6 mb-4">
      <div class="card h-100 bg-purple">
        <a href="sales_master.php">
          <div class="card-body text-center">
            <h5 class="card-title mb-2 titelcolor"><?php echo $salesUsers; ?></h5>
            <small class="smllalcolor">Sales</small>
          </div>
        </a>
      </div>
    </div>
	<?php
// ===================== TOTAL BOOKING AMOUNT =====================
$sql_total = "
  SELECT 
    COALESCE(SUM(b.total_amount), 0) AS total_booking_amount
  FROM bookings b
  WHERE b.status IN ('pending','confirmed','completed') $dateConditionGeneral
";
$total = mysqli_fetch_assoc(mysqli_query($conn, $sql_total));
$total_booking_amount = (float)$total['total_booking_amount'];

// ===================== TOTAL RECEIVED PAYMENTS =====================
$sql_received = "
  SELECT 
    COALESCE(SUM(p.amount), 0) AS total_received
  FROM payments p
  WHERE p.payment_type = 'received' 
    AND p.status = 'completed' 
    $dateConditionPayments
";
$received = mysqli_fetch_assoc(mysqli_query($conn, $sql_received));
$total_received = (float)$received['total_received'];

// ===================== TOTAL REFUND =====================
$sql_refund = "
  SELECT 
    COALESCE(SUM(p.amount), 0) AS total_refund
  FROM payments p
  WHERE p.payment_type = 'refund'
    AND p.status = 'completed'
    $dateConditionPayments
";
$refund = mysqli_fetch_assoc(mysqli_query($conn, $sql_refund));
$total_refund = (float)$refund['total_refund'];

// ===================== FINAL PENDING AMOUNT =====================
$total_pending = $total_booking_amount - $total_received + $total_refund;

// ===================== DISPLAY DASHBOARD CARDS =====================
echo "
<div class='col-lg-3 col-sm-6 mb-4'>
  <div class='card h-100 text-center text-white bg-info'>
    <div class='card-body'>
      <h5 class='text-white'>" . formatIndianCurrency($total_booking_amount) . "</h5>
      <small>Total Booking Amount</small>
    </div>
  </div>
</div>

<div class='col-lg-3 col-sm-6 mb-4'>
  <div class='card h-100 text-center text-white bg-success'>
    <div class='card-body'>
      <h5 class='text-white'>" . formatIndianCurrency($total_received) . "</h5>
      <small>Total Received</small>
    </div>
  </div>
</div>

<div class='col-lg-3 col-sm-6 mb-4'>
  <div class='card h-100 text-center text-white bg-warning'>
    <div class='card-body'>
      <h5 class='text-white'>" . formatIndianCurrency($total_refund) . "</h5>
      <small>Total Refunded</small>
    </div>
  </div>
</div>

<div class='col-lg-3 col-sm-6 mb-4'>
  <div class='card h-100 text-center text-white bg-danger'>
    <div class='card-body'>
      <h5 class='text-white'>" . formatIndianCurrency($total_pending) . "</h5>
      <small>Pending Balance</small>
    </div>
  </div>
</div>
";
?>
<?php } ?>
  </div>

  <!-- Two-column area: Today's Inquiries/Quotations/Bookings and Followups -->
  <div class="row">
    <div class="col-12 col-xl-6 col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between pb-2">
          <div class="card-title mb-1"><h5 class="m-0">Today's</h5></div>
        </div>
        <div class="card-body">
          <div class="nav-align-top">
            <ul class="nav nav-tabs nav-fill" role="tablist">
              <li class="nav-item">
                <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#tab-inquiries">Inquiries</button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#tab-quotations">Quotations</button>
              </li>
              <li class="nav-item">
                <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#tab-bookings">Package Bookings</button>
              </li>
            </ul>

            <div class="tab-content px-2 mx-1 pb-0">
              <!-- Inquiries -->
              <div class="tab-pane fade show active" id="tab-inquiries" role="tabpanel">
               <?php
$today = date('Y-m-d');
$inqDateField = "DATE(inquiries.created_at)";

$sqlInq = "
  SELECT 
    inquiries.id AS inquiry_id, 
    inquiries.*, 
    customers.name AS customer_name,
    customers.phone AS customer_phone,
    customers.email AS customer_email, 
    users.name AS assigned_user
  FROM inquiries
  LEFT JOIN customers ON inquiries.customer_id = customers.id
  LEFT JOIN users ON inquiries.assigned_to = users.id
  WHERE {$inqDateField} = '{$today}'
  ORDER BY inquiries.created_at ASC
";

$resInq = mysqli_query($conn, $sqlInq);

if (mysqli_num_rows($resInq) > 0) {
  echo '<ul class="timeline mb-0 pb-1 scroll-list">';
  while ($row = mysqli_fetch_assoc($resInq)) {

    // --- Customer & Type ---
    $cust = htmlspecialchars(ucwords(strtolower($row['customer_name'] ?? 'Unknown')));
    $inquiryType = htmlspecialchars(ucwords($row['inquiry_type'] ?? '-'));

    // --- Destination ---
    if (!empty($row['package_name'])) {
        $dest = htmlspecialchars(ucwords($row['package_name']));
    } elseif (!empty($row['hotel_city'])) {
        $dest = htmlspecialchars(ucwords($row['hotel_city']));
    } elseif (!empty($row['flight_to_city'])) {
        $dest = htmlspecialchars(ucwords($row['flight_to_city']));
    } elseif (!empty($row['insurance_destination'])) {
        $dest = htmlspecialchars(ucwords($row['insurance_destination']));
    } elseif (!empty($row['vehicle_drop_location'])) {
        $dest = htmlspecialchars(ucwords($row['vehicle_drop_location']));
    } else {
        $dest = '-';
    }

    // --- Travel Date ---
    if (!empty($row['package_start_date'])) {
        $travelDate = date('d-m-Y', strtotime($row['package_start_date']));
    } elseif (!empty($row['hotel_checkin_date'])) {
        $travelDate = date('d-m-Y', strtotime($row['hotel_checkin_date']));
    } elseif (!empty($row['flight_departure_date'])) {
        $travelDate = date('d-m-Y', strtotime($row['flight_departure_date']));
    } elseif (!empty($row['insurance_start_date'])) {
        $travelDate = date('d-m-Y', strtotime($row['insurance_start_date']));
    } elseif (!empty($row['vehicle_pickup_datetime'])) {
        $travelDate = date('d-m-Y', strtotime($row['vehicle_pickup_datetime']));
    } else {
        $travelDate = '-';
    }

    // --- Nights (only for package/hotel) ---
    if (!empty($row['package_start_date']) && !empty($row['package_end_date'])) {
        $start = new DateTime($row['package_start_date']);
        $end = new DateTime($row['package_end_date']);
        $nights = $start->diff($end)->days;
    } elseif (!empty($row['hotel_checkin_date']) && !empty($row['hotel_checkout_date'])) {
        $start = new DateTime($row['hotel_checkin_date']);
        $end = new DateTime($row['hotel_checkout_date']);
        $nights = $start->diff($end)->days;
    } else {
        $nights = '-';
    }

    // --- Adults / Children / Passengers ---
    switch ($row['inquiry_type']) {
        case 'package':
            $adultsChildren = "{$row['package_adults']}/{$row['package_children']}";
            break;
        case 'hotel':
            $adultsChildren = "{$row['hotel_adults']}/{$row['hotel_children']}";
            break;
        case 'flight':
            $adultsChildren = "{$row['flight_passengers']}";
            break;
        case 'vehicle':
            $adultsChildren = "{$row['vehicle_passengers']}";
            break;
        default:
            $adultsChildren = "-";
            break;
    }

    // --- Rooms ---
    $rooms = !empty($row['hotel_rooms']) ? $row['hotel_rooms'] : '-';

    // --- Status & Assigned ---
    $status = htmlspecialchars(ucwords($row['status'] ?? $row['followup_status'] ?? '-'));
    $assigned = htmlspecialchars($row['assigned_user'] ?? '-');
    $iid = (int)$row['inquiry_id'];

    // --- Timeline Item ---
    echo "
    <li class='timeline-item'>
      <div class='timeline-event px-0 pb-0'>
        <h6 class='mb-1'>Customer: {$cust}</h6>
        <p class='text-muted mb-0'><strong>Inquiry Type:</strong> {$inquiryType}</p>
        <p class='text-muted mb-0'><strong>Destination:</strong> {$dest}</p>
        <p class='text-muted mb-0'><strong>Travel Date:</strong> {$travelDate}</p>
        <p class='text-muted mb-0'><strong>Status:</strong> {$status}</p>
        <p class='text-muted mb-0'><strong>Assign To:</strong> {$assigned}</p>
        <p class='text-muted mb-0'><a href='#' data-bs-toggle='modal' data-bs-target='#viewInquiry{$iid}' class='fst-italic'>More Details</a></p>
      </div>
    </li>
    ";

    // --- Modal ---
    echo "
    <div class='modal fade' id='viewInquiry{$iid}' tabindex='-1' aria-hidden='true'>
      <div class='modal-dialog modal-dialog-centered'>
        <div class='modal-content'>
          <div class='modal-header'>
            <h5 class='modal-title'>Inquiry Details</h5>
            <button type='button' class='btn-close' data-bs-dismiss='modal' aria-label='Close'></button>
          </div>
          <div class='modal-body'>
            <ul class='list-unstyled mb-0 mt-0'>
              <li><strong>Customer Name:</strong> {$cust}</li>
              <li><strong>Email:</strong> " . htmlspecialchars($row['customer_email'] ?? '-') . "</li>
              <li><strong>Phone:</strong> " . htmlspecialchars($row['customer_phone'] ?? '-') . "</li>
              <li><strong>Destination:</strong> {$dest}</li>
              <li><strong>Travel Date:</strong> {$travelDate}</li>
              <li><strong>Nights:</strong> {$nights}</li>
              <li><strong>Adults/Children:</strong> {$adultsChildren}</li>
              <li><strong>Rooms:</strong> {$rooms}</li>
              <li><strong>Remarks:</strong> " . nl2br(htmlspecialchars($row['remarks'] ?? '-')) . "</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    ";
  }
  echo '</ul>';
} else {
  echo "<h6 class='text-center'>No inquiries today</h6>";
}
?>

              </div>

              <!-- Quotations -->
              <div class="tab-pane fade" id="tab-quotations" role="tabpanel">
                <?php
                $sqlQuo = "
                  SELECT quotations.id AS quotation_id, quotations.*, customers.name AS customer_name, users.name AS assigned_user
                  FROM quotations
                  LEFT JOIN customers ON quotations.customer_id = customers.id
                  LEFT JOIN users ON quotations.assigned_to = users.id
                  WHERE DATE(quotations.quotation_date) = '{$today}'
                  ORDER BY quotations.created_at ASC
                ";
                $resQuo = mysqli_query($conn, $sqlQuo);
                if (mysqli_num_rows($resQuo) > 0) {
                  echo '<ul class="timeline mb-0 pb-1 scroll-list">';
                  while ($row = mysqli_fetch_assoc($resQuo)) {
                    $cust = htmlspecialchars(ucwords(strtolower($row['customer_name'] ?? '-')));
                    $qid = (int)$row['quotation_id'];
                    echo "<li class='timeline-item'>
                            <div class='timeline-event px-0 pb-0'>
                              <h6 class='mb-1'>Customer: {$cust}</h6>
                              <p class='text-muted mb-0'><strong>Quotation No.:</strong> ".htmlspecialchars($row['quotation_no'] ?? '-')."</p>
                              <p class='text-muted mb-0'><strong>Package Name:</strong> ".htmlspecialchars($row['package_name'] ?? '-')."</p>
                              <p class='text-muted mb-0'><strong>Quotation Amount:</strong> ".htmlspecialchars($row['grand_total'] ?? '-')."</p>
                              <p class='text-muted mb-0'><strong>Status:</strong> ".htmlspecialchars($row['status'] ?? '-')."</p>
                              <p class='text-muted mb-0'><a href='#' data-bs-toggle='modal' data-bs-target='#viewQuotation{$qid}' class='fst-italic'>More Details</a></p>
                            </div>
                          </li>";

                    // modal:
                    echo "<div class='modal fade' id='viewQuotation{$qid}' tabindex='-1' aria-hidden='true'>
                            <div class='modal-dialog modal-dialog-centered'>
                              <div class='modal-content'>
                                <div class='modal-header'>
                                  <h5 class='modal-title'>Quotation Details</h5>
                                  <button type='button' class='btn-close' data-bs-dismiss='modal' aria-label='Close'></button>
                                </div>
                                <div class='modal-body'>
                                  <ul class='list-unstyled mb-0 mt-0'>
                                    <li><strong>Customer:</strong> {$cust}</li>
                                    <li><strong>Phone:</strong> ".htmlspecialchars($row['customer_phone'] ?? $row['phone'] ?? '-')."</li>
                                    <li><strong>Package:</strong> ".htmlspecialchars($row['package_name'] ?? '-')."</li>
                                    <li><strong>Travel Date:</strong> ".(!empty($row['travel_date'])?date('d-m-Y',strtotime($row['travel_date'])):'-')."</li>
                                    <li><strong>Nights:</strong> ".htmlspecialchars($row['nights'] ?? '-')."</li>
                                    <li><strong>Adults/Children:</strong> ".htmlspecialchars(($row['adults']??'-').'/'.($row['child']??'-'))."</li>
                                    <li><strong>Grand Total:</strong> ".htmlspecialchars($row['grand_total'] ?? '-')."</li>
                                  </ul>
                                </div>
                              </div>
                            </div>
                          </div>";
                  }
                  echo '</ul>';
                } else {
                  echo "<h6 class='text-center'>No quotations today</h6>";
                }
                ?>
              </div>

              <!-- Package bookings -->
              <div class="tab-pane fade" id="tab-bookings" role="tabpanel">
                <?php
                // your schema had package_bookings separate from bookings; adapt to either table: prefer bookings
                $sqlBookings = "
                  SELECT b.*, c.name AS customer_name, u.name AS assigned_user
                  FROM bookings b
                  LEFT JOIN customers c ON b.customer_id = c.id
                  LEFT JOIN users u ON b.created_by = u.id
                  WHERE DATE(b.booking_date) = '{$today}'
                  ORDER BY b.created_at ASC
                ";
                $resBook = mysqli_query($conn, $sqlBookings);
                if ($resBook && mysqli_num_rows($resBook) > 0) {
                  echo '<ul class="timeline mb-0 pb-1 scroll-list">';
                  while ($row = mysqli_fetch_assoc($resBook)) {
                    $cust = htmlspecialchars(ucwords(strtolower($row['customer_name'] ?? '-')));
                    $bid = (int)$row['id'];
                    echo "<li class='timeline-item'>
                            <div class='timeline-event px-0 pb-0'>
                              <h6 class='mb-1'>Customer: {$cust}</h6>
                              <p class='text-muted mb-0'><strong>Book No.:</strong> ".htmlspecialchars($row['booking_code'] ?? '-')."</p>
                              <p class='text-muted mb-0'><strong>Package Name:</strong> ".htmlspecialchars($row['package_name'] ?? '-')."</p>
                              <p class='text-muted mb-0'><strong>Total Amount:</strong> ".htmlspecialchars($row['total_amount'] ?? '-')."</p>
                              <p class='text-muted mb-0'><strong>Adv Amount:</strong> ".htmlspecialchars($row['paid_amount'] ?? '-')."</p>
                              <p class='text-muted mb-0'><a href='#' data-bs-toggle='modal' data-bs-target='#viewBooking{$bid}' class='fst-italic'>More Details</a></p>
                            </div>
                          </li>";

                    // modal:
                    echo "<div class='modal fade' id='viewBooking{$bid}' tabindex='-1' aria-hidden='true'>
                            <div class='modal-dialog modal-dialog-centered'>
                              <div class='modal-content'>
                                <div class='modal-header'>
                                  <h5 class='modal-title'>Booking Details</h5>
                                  <button type='button' class='btn-close' data-bs-dismiss='modal' aria-label='Close'></button>
                                </div>
                                <div class='modal-body'>
                                  <ul class='list-unstyled mb-0 mt-0'>
                                    <li><strong>Customer:</strong> {$cust}</li>
                                    <li><strong>Phone:</strong> ".htmlspecialchars($row['phone'] ?? '-')."</li>
                                    <li><strong>Package:</strong> ".htmlspecialchars($row['package_name'] ?? '-')."</li>
                                    <li><strong>Travel Date:</strong> ".(!empty($row['package_start_date'])?date('d-m-Y',strtotime($row['package_start_date'])):'-')."</li>
                                    <li><strong>Nights:</strong> ".htmlspecialchars($row['nights'] ?? '-')."</li>
                                    <li><strong>Total Amount:</strong> ".htmlspecialchars($row['total_amount'] ?? '-')."</li>
                                    <li><strong>Paid:</strong> ".htmlspecialchars($row['paid_amount'] ?? '-')."</li>
                                  </ul>
                                </div>
                              </div>
                            </div>
                          </div>";
                  }
                  echo '</ul>';
                } else {
                  echo "<h6 class='text-center'>No bookings today</h6>";
                }
                ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div> <!-- /left column -->

    <!-- Followup column -->
    <div class="col-12 col-xl-6 col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between pb-2">
          <div class="card-title mb-1"><h5 class="m-0">Followup</h5></div>
        </div>
        <div class="card-body">
  <div class="nav-align-top">
    <ul class="nav nav-tabs nav-fill" role="tablist">
      <li class="nav-item">
        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#follow-today">Today Followup</button>
      </li>
      <li class="nav-item">
        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#follow-reminder">Reminder Call</button>
      </li>
    </ul>

    <div class="tab-content px-2 mx-1 pb-0">

      <!-- ===== TODAY FOLLOWUP TAB ===== -->
      <div class="tab-pane fade show active" id="follow-today">
<?php
$today = date('Y-m-d');

$sqlFollow = "
  SELECT f.*, i.*, c.name AS customer_name, c.phone AS customer_phone, 
         u.name AS followed_user
  FROM inquiry_followups f
  LEFT JOIN inquiries i ON f.inquiry_id = i.id
  LEFT JOIN customers c ON i.customer_id = c.id
  LEFT JOIN users u ON f.followed_by = u.id
  WHERE DATE(f.followup_date) = '{$today}'
  ORDER BY f.followup_date DESC
";
$resFollow = mysqli_query($conn, $sqlFollow);

if ($resFollow && mysqli_num_rows($resFollow) > 0) {
  echo '<ul class="timeline mb-0 pb-1 scroll-list">';
  while ($row = mysqli_fetch_assoc($resFollow)) {
    $cust = htmlspecialchars(ucwords(strtolower($row['customer_name'] ?? '-')));
    $iid  = (int)$row['inquiry_id'];
    $statusBadge = ($row['status'] == 'done') ? 'success' : (($row['status'] == 'closed') ? 'secondary' : 'warning');
	  // ===== Destination Logic =====
            if (!empty($row['package_name'])) {
              $dest = htmlspecialchars(ucwords($row['package_name']));
            } elseif (!empty($row['hotel_city'])) {
              $dest = htmlspecialchars(ucwords($row['hotel_city']));
            } elseif (!empty($row['flight_to_city'])) {
              $dest = htmlspecialchars(ucwords($row['flight_to_city']));
            } elseif (!empty($row['insurance_destination'])) {
              $dest = htmlspecialchars(ucwords($row['insurance_destination']));
            } elseif (!empty($row['vehicle_drop_location'])) {
              $dest = htmlspecialchars(ucwords($row['vehicle_drop_location']));
            } else {
              $dest = '-';
            }
	  
	  // ===== Travelers Logic =====
            if ($row['inquiry_type'] == 'package') {
              $travellers = ($row['package_adults'] ?? 0) . 'A / ' . ($row['package_children'] ?? 0) . 'C';
            } elseif ($row['inquiry_type'] == 'hotel') {
              $travellers = ($row['hotel_adults'] ?? 0) . 'A / ' . ($row['hotel_children'] ?? 0) . 'C';
            } elseif ($row['inquiry_type'] == 'flight') {
              $travellers = ($row['flight_passengers'] ?? 0) . ' Passengers';
            } elseif ($row['inquiry_type'] == 'vehicle') {
              $travellers = ($row['vehicle_passengers'] ?? 0) . ' Passengers';
            } else {
              $travellers = '-';
            }
    echo "
    <li class='timeline-item'>
      <div class='timeline-event px-0 pb-0'>
        <h6 class='mb-1'>Customer: {$cust}</h6>
        <p class='text-muted mb-0'><strong>Follow-up Mode:</strong> " . ucfirst($row['followup_mode']) . "</p>
		<p class='text-muted mb-0'><strong>Status:</strong> " . ucfirst($row['status']) . "</p>
        <p class='text-muted mb-0'><strong>Followed By:</strong> " . htmlspecialchars($row['followed_user'] ?? '-') . "</p>
        <p class='text-muted mb-0'><a href='#' data-bs-toggle='modal' data-bs-target='#viewFollowup{$row['id']}' class='fst-italic'>View Details</a></p>
      </div>
    </li>
    ";

    // MODAL
    echo "
    <div class='modal fade' id='viewFollowup{$row['id']}' tabindex='-1' aria-hidden='true'>
      <div class='modal-dialog modal-dialog-centered'>
        <div class='modal-content'>
          <div class='modal-header'>
            <h5 class='modal-title'>Follow-up Details</h5>
            <button type='button' class='btn-close' data-bs-dismiss='modal'></button>
          </div>
          <div class='modal-body'>
            <ul class='list-unstyled mb-0'>
              <li><strong>Customer:</strong> {$cust}</li>
              <li><strong>Phone:</strong> " . htmlspecialchars($row['customer_phone'] ?? '-') . "</li>
			  <li><strong>Destination:</strong> " . htmlspecialchars($dest) . "</li>
			  <li><strong>Travellers:</strong> " . htmlspecialchars($travellers) . "</li>
              
              <li><strong>Next Follow-up:</strong> " . (!empty($row['next_followup_date']) ? date('d-m-Y h:i A', strtotime($row['next_followup_date'])) : '-') . "</li>
              <li><strong>Remarks:</strong> " . nl2br(htmlspecialchars($row['remarks'] ?? '-')) . "</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    ";
  }
  echo '</ul>';
} else {
  echo "<h6 class='text-center'>No Follow-up Today</h6>";
}
?>
</div>


      <!-- ===== REMINDER TAB ===== -->
      <div class="tab-pane fade" id="follow-reminder">
<?php
$ten_days_later = date('Y-m-d', strtotime('+10 days'));

$sqlRem = "
  SELECT f.*, i.inquiry_type, c.name AS customer_name, c.phone AS customer_phone, 
         u.name AS followed_user
  FROM inquiry_followups f
  LEFT JOIN inquiries i ON f.inquiry_id = i.id
  LEFT JOIN customers c ON i.customer_id = c.id
  LEFT JOIN users u ON f.followed_by = u.id
  WHERE DATE(f.next_followup_date) BETWEEN '{$today}' AND '{$ten_days_later}'
  ORDER BY f.next_followup_date ASC
";
$resRem = mysqli_query($conn, $sqlRem);

if ($resRem && mysqli_num_rows($resRem) > 0) {
  echo '<ul class="timeline mb-0 pb-1 scroll-list">';
  while ($row = mysqli_fetch_assoc($resRem)) {
    $cust = htmlspecialchars(ucwords(strtolower($row['customer_name'] ?? '-')));
    $iid  = (int)$row['inquiry_id'];

    echo "
    <li class='timeline-item'>
      <div class='timeline-event px-0 pb-0'>
        <h6 class='mb-1'>Customer: {$cust}</h6>
        <p class='text-muted mb-0'><strong>Reminder Date:</strong> " . date('d-m-Y', strtotime($row['next_followup_date'])) . "</p>
        <p class='text-muted mb-0'><a href='#' data-bs-toggle='modal' data-bs-target='#viewReminder{$row['id']}' class='fst-italic'>More Details</a></p>
      </div>
    </li>";

    echo "
    <div class='modal fade' id='viewReminder{$row['id']}' tabindex='-1' aria-hidden='true'>
      <div class='modal-dialog modal-dialog-centered'>
        <div class='modal-content'>
          <div class='modal-header'>
            <h5 class='modal-title'>Reminder Details</h5>
            <button type='button' class='btn-close' data-bs-dismiss='modal'></button>
          </div>
          <div class='modal-body'>
            <ul class='list-unstyled mb-0'>
              <li><strong>Customer:</strong> {$cust}</li>
              <li><strong>Phone:</strong> " . htmlspecialchars($row['customer_phone'] ?? '-') . "</li>
              <li><strong>Next Followup:</strong> " . date('d-m-Y h:i A', strtotime($row['next_followup_date'])) . "</li>
              <li><strong>Mode:</strong> " . ucfirst($row['followup_mode']) . "</li>
              <li><strong>Status:</strong> " . ucfirst($row['status']) . "</li>
              <li><strong>Remarks:</strong> " . nl2br(htmlspecialchars($row['remarks'] ?? '-')) . "</li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    ";
  }
  echo '</ul>';
} else {
  echo "<h6 class='text-center'>No Reminder Calls</h6>";
}
?>
</div>


    </div>
  </div>
</div>

      </div>
    </div> <!-- /followup column -->
  </div> <!-- /row -->
    <?php if($_SESSION["userrole"] != 'sales') { ?>
  <!-- Team follow-up status table -->
  <div class="row">
    <div class="col-md-6 mb-4">
      <div class="card h-100">
        <div class="card-header d-flex justify-content-between pb-2">
          <div class="card-title mb-1"><h5 class="m-0">Team Follow-Up Status</h5></div>
        </div>
        <div class="card-body">
          <div class="table-responsive text-nowrap">
            <table class="table table-bordered table-sm">
  <thead>
    <tr>
      <th>Name</th>
      <th>Pending</th>
      <th>In Progress</th>
      <th>Closed</th>
    </tr>
  </thead>
  <tbody class="table-border-bottom-0">
    <?php
    $sqlTeam = "
      SELECT 
        u.id AS user_id,
        u.name AS user_name,
		u.role AS role,
        COALESCE(SUM(CASE WHEN i.status = 'pending' THEN 1 ELSE 0 END), 0) AS pending_count,
        COALESCE(SUM(CASE WHEN i.status = 'in-progress' THEN 1 ELSE 0 END), 0) AS inprogress_count,
        COALESCE(SUM(CASE WHEN i.status = 'closed' THEN 1 ELSE 0 END), 0) AS closed_count
      FROM users u
      LEFT JOIN inquiries i ON i.assigned_to = u.id
      GROUP BY u.id
      ORDER BY u.name ASC
    ";

    $resTeam = mysqli_query($conn, $sqlTeam);
    while ($row = mysqli_fetch_assoc($resTeam)) {
      echo "<tr>
              <td>" . htmlspecialchars(ucwords($row['user_name'])) . " (<small><i>" . htmlspecialchars(ucwords($row['role'])) . "</i></small>)</td>
              <td>" . (int)$row['pending_count'] . "</td>
              <td>" . (int)$row['inprogress_count'] . "</td>
              <td>" . (int)$row['closed_count'] . "</td>
            </tr>";
    }
    ?>
  </tbody>
</table>

          </div>
        </div>
      </div>
    </div>
	  <div class="col-md-6 mb-4">
  <div class="card h-100">
    <div class="card-header d-flex justify-content-between pb-2">
      <div class="card-title mb-1"><h5 class="m-0">Booking Summary by Type</h5></div>
    </div>
    <div class="card-body">
      <div class="table-responsive text-nowrap">
		  <table class="table table-bordered table-sm">
  <thead>
    <tr>
      <th>Booking Type</th>
      <th>Total Bookings</th>
      <th>Total Amount (₹)</th>
      <th>Received (₹)</th>
    </tr>
  </thead>
  <tbody>
    <?php
    // --- Default empty ---
    $dateConditionPayments1 = '';
    $dateConditionGeneral1  = '';

    // --- DATE FILTER ---
    if (!empty($from) && !empty($to)) {
      $dateConditionPayments1 = "AND DATE(p.payment_date) BETWEEN '$from' AND '$to'";
      $dateConditionGeneral1  = "AND DATE(b.created_at) BETWEEN '$from' AND '$to'";
    } elseif (!empty($from)) {
      $dateConditionPayments1 = "AND DATE(p.payment_date) = '$from'";
      $dateConditionGeneral1  = "AND DATE(b.created_at) = '$from'";
    } elseif (!empty($to)) {
      $dateConditionPayments1 = "AND DATE(p.payment_date) = '$to'";
      $dateConditionGeneral1  = "AND DATE(b.created_at) = '$to'";
    }

    // --- MAIN QUERY ---
    $sqlSummary = "
      SELECT 
        b.booking_type, 
        COUNT(b.id) AS total_bookings, 
        COALESCE(SUM(b.total_amount), 0) AS total_booking_value, 
        COALESCE(SUM(p.amount), 0) AS total_received 
      FROM bookings b
      LEFT JOIN payments p 
        ON p.booking_id = b.id 
        AND p.status = 'completed' 
        AND p.payment_type = 'received' 
        $dateConditionPayments1
      WHERE 1=1 
        $dateConditionGeneral1
      GROUP BY b.booking_type 
      ORDER BY total_booking_value DESC
    ";

    $resSummary = mysqli_query($conn, $sqlSummary);
    $chartData = [];

    if ($resSummary && mysqli_num_rows($resSummary) > 0) {
      while ($row = mysqli_fetch_assoc($resSummary)) {
        $chartData[] = [
          'type' => ucfirst($row['booking_type']),
          'bookings' => (int)$row['total_bookings'],
          'value' => (float)$row['total_booking_value'],
          'received' => (float)$row['total_received']
        ];
      }
    }

    // --- OUTPUT ---
    if (!empty($chartData)) {
      foreach ($chartData as $r) {
        echo "<tr>
                <td>{$r['type']}</td>
                <td>{$r['bookings']}</td>
                <td>" . number_format($r['value'], 2) . "</td>
                <td><strong>" . number_format($r['received'], 2) . "</strong></td>
              </tr>";
      }
    } else {
      echo "<tr><td colspan='4' class='text-center'>No Booking Data</td></tr>";
    }
    ?>
  </tbody>
</table>


        

      </div>
    </div>
  </div>
</div>

  </div>
<?php } ?>
</div> <!-- container -->
<?php include('inc/footer.php');?>