<?php include('inc/template.php'); ?>
<div class="container-fluid flex-grow-1 container-p-y">

  <!-- Breadcrumb -->
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
      <li class="breadcrumb-item active">Customer Wise Report</li>
    </ol>
  </nav>

  <div class="card shadow-sm">
    <div class="card-body">

      <h5 class="card-title mb-4"><i class="ti ti-user-check me-2"></i>Customer Wise Report</h5>

      <!-- ðŸ”¹ Filters -->
      <form class="row g-3 mb-4" method="GET">
        <div class="col-md-3">
          <label for="from_date" class="form-label">From Date</label>
          <input type="date" id="from_date" name="from_date" class="form-control"
                 value="<?= htmlspecialchars($_GET['from_date'] ?? '') ?>">
        </div>
        <div class="col-md-3">
          <label for="to_date" class="form-label">To Date</label>
          <input type="date" id="to_date" name="to_date" class="form-control"
                 value="<?= htmlspecialchars($_GET['to_date'] ?? '') ?>">
        </div>
        <div class="col-md-3">
          <label for="search" class="form-label">Search (Name / Phone)</label>
          <input type="text" id="search" name="search" class="form-control"
                 placeholder="Enter name or phone"
                 value="<?= htmlspecialchars($_GET['search'] ?? '') ?>">
        </div>
        <div class="col-md-3 align-self-end">
          <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary flex-fill"><i class="ti ti-filter me-1"></i> Filter</button>
            <a href="customer_report.php" class="btn btn-secondary flex-fill"><i class="ti ti-refresh me-1"></i> Reset</a>
          </div>
        </div>
      </form>

      <!-- ðŸ”¹ Export Buttons -->
      <!--<div class="mb-3 text-end">
        <button id="exportExcel" class="btn btn-success btn-sm"><i class="ti ti-file-spreadsheet me-1"></i>Export Excel</button>
        <button id="exportPDF" class="btn btn-danger btn-sm"><i class="ti ti-file-text me-1"></i>Export PDF</button>
      </div>-->

      <!-- ðŸ”¹ Report Table -->
      <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-center" id="customerReport">
          <thead class="table-light">
            <tr>
              <th>#</th>
              <th>Customer Name</th>
              <th>Phone</th>
              <th>Total Bookings</th>
              <th>Total Amount (â‚¹)</th>
              <th>Paid (â‚¹)</th>
              <th>Pending (â‚¹)</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
          <?php
          

          $where = "WHERE 1";
          if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
              $from = $_GET['from_date'];
              $to   = $_GET['to_date'];
              $where .= " AND b.booking_date BETWEEN '$from' AND '$to'";
          }

          if (!empty($_GET['search'])) {
              $search = $conn->real_escape_string($_GET['search']);
              $where .= " AND (c.name LIKE '%$search%' OR c.phone LIKE '%$search%')";
          }

           $query = "
            SELECT 
              c.id AS customer_id,
              c.name AS customer_name,
              c.phone AS customer_phone,
              COUNT(b.id) AS total_bookings,
              SUM(b.total_amount) AS total_amount,
              SUM(b.paid_amount) AS total_paid,
              SUM(b.balance_amount) AS total_pending
            FROM bookings b
            LEFT JOIN customers c ON b.customer_id = c.id
            $where
            GROUP BY c.id
            ORDER BY total_amount DESC
          ";

          $result = $conn->query($query);
          $i = 1;
          $total = $paid = $pending = 0;

          if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
              $total += $row['total_amount'];
              $paid += $row['total_paid'];
              $pending += $row['total_pending'];
          ?>
            <tr>
              <td><?= $i++; ?></td>
              <td><?= htmlspecialchars($row['customer_name']); ?></td>
              <td><?= htmlspecialchars($row['customer_phone']); ?></td>
              <td><?= $row['total_bookings']; ?></td>
              <td><?= number_format($row['total_amount'], 2); ?></td>
              <td><?= number_format($row['total_paid'], 2); ?></td>
              <td class="text-danger"><?= number_format($row['total_pending'], 2); ?></td>
              <td>
                <button class="btn btn-sm btn-outline-primary viewBookings" data-id="<?= $row['customer_id']; ?>">
                  <i class="ti ti-eye"></i> View
                </button>
              </td>
            </tr>
          <?php
            }
          } else {
            echo '<tr><td colspan="8" class="text-muted">No data found</td></tr>';
          }
          ?>
          </tbody>
          <tfoot class="fw-bold table-secondary">
            <tr>
              <td colspan="4" class="text-end">Grand Total</td>
              <td>â‚¹<?= number_format($total, 2); ?></td>
              <td>â‚¹<?= number_format($paid, 2); ?></td>
              <td>â‚¹<?= number_format($pending, 2); ?></td>
              <td></td>
            </tr>
          </tfoot>
        </table>
      </div>

    </div>
  </div>
</div>

<!-- ðŸ”¹ Drill-down Modal -->
<div class="modal fade" id="bookingModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><i class="ti ti-list-details me-2"></i>Customer Bookings</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="bookingDetails">Loading...</div>
      </div>
    </div>
  </div>
</div>

<!-- ðŸ”¹ JS Section -->
<!--
<script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
-->
<script>
$(function() {
  // Excel Export
  $('#exportExcel').on('click', function() {
    var wb = XLSX.utils.table_to_book(document.getElementById('customerReport'), {sheet:"Report"});
    XLSX.writeFile(wb, 'Customer_Report.xlsx');
  });

  // PDF Export
  $('#exportPDF').on('click', function() {
    const { jsPDF } = window.jspdf;
    let doc = new jsPDF('l', 'pt', 'a4');
    doc.html(document.getElementById('customerReport'), {
      callback: function (doc) {
        doc.save('Customer_Report.pdf');
      },
      margin: [20, 20, 20, 20],
      autoPaging: 'text'
    });
  });

  // View Bookings (Drill-down)
  $(document).on('click', '.viewBookings', function() {
    const id = $(this).data('id');
    $('#bookingDetails').html('<div class="text-center text-muted p-3">Loading...</div>');
    $('#bookingModal').modal('show');

    $.post('controller/CustomerController.php', { action: 'getCustomerReports', customer_id: id }, function(res) {
      $('#bookingDetails').html(res);
    });
  });
});
</script>
<?php include('inc/footer.php');?>