<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

$action = $_REQUEST['action'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? null;

    // ---------- STATES ----------
    $state_name = $_POST['state_name'] ?? '';
    $country = $_POST['country'] ?? 'India';

    if ($action === 'CreateState') {
        if (empty($state_name)) {
            echo json_encode(["status" => "error", "message" => "State name is required"]);
            exit;
        }

        $stmt = $conn->prepare("SELECT id FROM states WHERE state_name=? AND country=?");
        $stmt->bind_param("ss", $state_name, $country);
        $stmt->execute();
        if ($stmt->get_result()->num_rows > 0) {
            echo json_encode(["status" => "error", "message" => "State already exists"]);
            exit;
        }

        $stmt = $conn->prepare("INSERT INTO states (state_name, country) VALUES (?, ?)");
        $stmt->bind_param("ss", $state_name, $country);
        echo $stmt->execute()
            ? json_encode(["status" => "success", "message" => "State added successfully"])
            : json_encode(["status" => "error", "message" => "Failed to add state", "error" => $stmt->error]);
        exit;
    }

    if ($action === 'Update' && $id) {
        if (empty($state_name)) {
            echo json_encode(["status" => "error", "message" => "State name is required"]);
            exit;
        }
        $stmt = $conn->prepare("UPDATE states SET state_name=?, country=? WHERE id=?");
        $stmt->bind_param("ssi", $state_name, $country, $id);
        echo $stmt->execute()
            ? json_encode(["status" => "success", "message" => "State updated successfully"])
            : json_encode(["status" => "error", "message" => "Failed to update state", "error" => $stmt->error]);
        exit;
    }

    if ($action === 'DeleteState' && $id) {
        $stmt = $conn->prepare("DELETE FROM states WHERE id=?");
        $stmt->bind_param("i", $id);
        echo $stmt->execute()
            ? json_encode(["status" => "success", "message" => "State deleted successfully"])
            : json_encode(["status" => "error", "message" => "Failed to delete state", "error" => $stmt->error]);
        exit;
    }

    if ($action === 'SelectState' && $id) {
        $stmt = $conn->prepare("SELECT id, state_name, country, status FROM states WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $state = $stmt->get_result()->fetch_assoc();
        echo $state ? json_encode($state) : json_encode(["status" => "error", "message" => "State not found"]);
        exit;
    }

    if ($action === 'StateToggleStatus' && $id) {
        $stmt = $conn->prepare("SELECT status FROM states WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        if (!$result) { echo json_encode(["status"=>"error","message"=>"State not found"]); exit; }
        $new_status = ($result['status'] == 1) ? 0 : 1;
        $stmt = $conn->prepare("UPDATE states SET status=? WHERE id=?");
        $stmt->bind_param("ii", $new_status, $id);
        echo $stmt->execute()
            ? json_encode(["status"=>"success","message"=>"Status updated","new_status"=> $new_status ? "active" : "inactive"])
            : json_encode(["status"=>"error","message"=>"Failed to update status","error"=>$stmt->error]);
        exit;
    }

    // ---------- CITIES ----------
    $city_name = $_POST['city_name'] ?? '';
    $state_id = $_POST['state_id'] ?? null;

    if ($action === 'CreateCity') {
        if (empty($city_name) || empty($state_id)) {
            echo json_encode(["status"=>"error","message"=>"City name and state are required"]);
            exit;
        }
        // Check if city already exists in the same state
        $stmt = $conn->prepare("SELECT id FROM cities WHERE city_name=? AND state_id=?");
        $stmt->bind_param("si", $city_name, $state_id);
        $stmt->execute();
        if ($stmt->get_result()->num_rows > 0) {
            echo json_encode(["status"=>"error","message"=>"City already exists in this state"]);
            exit;
        }
        $stmt = $conn->prepare("INSERT INTO cities (city_name,state_id) VALUES (?,?)");
        $stmt->bind_param("si", $city_name, $state_id);
        echo $stmt->execute()
            ? json_encode(["status"=>"success","message"=>"City added successfully"])
            : json_encode(["status"=>"error","message"=>"Failed to add city","error"=>$stmt->error]);
        exit;
    }

    if ($action === 'UpdateCity' && $id) {
        if (empty($city_name) || empty($state_id)) {
            echo json_encode(["status"=>"error","message"=>"City name and state are required"]);
            exit;
        }
        $stmt = $conn->prepare("UPDATE cities SET city_name=?, state_id=? WHERE id=?");
        $stmt->bind_param("sii", $city_name, $state_id, $id);
        echo $stmt->execute()
            ? json_encode(["status"=>"success","message"=>"City updated successfully"])
            : json_encode(["status"=>"error","message"=>"Failed to update city","error"=>$stmt->error]);
        exit;
    }

    if ($action === 'DeleteCity' && $id) {
        $stmt = $conn->prepare("DELETE FROM cities WHERE id=?");
        $stmt->bind_param("i", $id);
        echo $stmt->execute()
            ? json_encode(["status"=>"success","message"=>"City deleted successfully"])
            : json_encode(["status"=>"error","message"=>"Failed to delete city","error"=>$stmt->error]);
        exit;
    }

    if ($action === 'SelectCity' && $id) {
        $stmt = $conn->prepare("SELECT id, city_name, state_id, status FROM cities WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $city = $stmt->get_result()->fetch_assoc();
        echo $city ? json_encode($city) : json_encode(["status"=>"error","message"=>"City not found"]);
        exit;
    }

    if ($action === 'CityToggleStatus' && $id) {
        $stmt = $conn->prepare("SELECT status FROM cities WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        if (!$result) { echo json_encode(["status"=>"error","message"=>"City not found"]); exit; }
        $new_status = ($result['status']==1)?0:1;
        $stmt = $conn->prepare("UPDATE cities SET status=? WHERE id=?");
        $stmt->bind_param("ii",$new_status,$id);
        echo $stmt->execute()
            ? json_encode(["status"=>"success","message"=>"Status updated","new_status"=> $new_status ? "active" : "inactive"])
            : json_encode(["status"=>"error","message"=>"Failed to update status","error"=>$stmt->error]);
        exit;
    }
}
?>
