<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
include __DIR__ . '/../inc/db.php';


$response = ['status' => 'error', 'message' => 'Something went wrong'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'Create';
    $id = $_POST['id'] ?? null;

    $customer_id   = mysqli_real_escape_string($conn, $_POST['customer_id'] ?? '');
    $inquiry_id = (int) ($_POST['inquiry_id'] ?? 0);
    $assigned_to   = mysqli_real_escape_string($conn, $_POST['useridnew'] ?? '');
    $quotation_type = mysqli_real_escape_string($conn, $_POST['quotation_type'] ?? 'package');
    $category_id   = mysqli_real_escape_string($conn, $_POST['category_id'] ?? '');
    $package_id    = mysqli_real_escape_string($conn, $_POST['package_id'] ?? '');
    $package_name  = mysqli_real_escape_string($conn, $_POST['package_name'] ?? '');
    $destination   = mysqli_real_escape_string($conn, $_POST['destination'] ?? '');
    $travel_date   = mysqli_real_escape_string($conn, $_POST['travel_date'] ?? '');
    $nights        = mysqli_real_escape_string($conn, $_POST['nights'] ?? 1);
    $rooms         = mysqli_real_escape_string($conn, $_POST['rooms'] ?? 1);
    $adults        = mysqli_real_escape_string($conn, $_POST['adults'] ?? 1);
    $child         = mysqli_real_escape_string($conn, $_POST['child'] ?? 0);
    $extrabed      = mysqli_real_escape_string($conn, $_POST['extrabed'] ?? 0);
    $description   = mysqli_real_escape_string($conn, $_POST['description'] ?? '');
    $inclusions    = mysqli_real_escape_string($conn, $_POST['inclusions'] ?? '');
    $exclusions    = mysqli_real_escape_string($conn, $_POST['exclusions'] ?? '');

    // =======================
    // 💰 Pricing Fields
    // =======================
    $adult_price     = mysqli_real_escape_string($conn, $_POST['adult_price'] ?? 0);
    $child_price     = mysqli_real_escape_string($conn, $_POST['child_price'] ?? 0);
    $extra_bed_price = mysqli_real_escape_string($conn, $_POST['extra_bed_price'] ?? 0);
    $transport_type  = mysqli_real_escape_string($conn, $_POST['transport_type'] ?? '');
    $transport_charges = mysqli_real_escape_string($conn, $_POST['transport_charges'] ?? 0);
    $extra_charges   = mysqli_real_escape_string($conn, $_POST['extra_charges'] ?? 0);
    $gst_included    = mysqli_real_escape_string($conn, $_POST['gst_included'] ?? 'no');
    $gst_rate        = mysqli_real_escape_string($conn, $_POST['gst_rate'] ?? 5);
    $discount        = mysqli_real_escape_string($conn, $_POST['discount'] ?? 0);

    // ====================
    // 💰 Price Calculation
    // ====================
    $base_total = ($adult_price * $adults) + ($child_price * $child) + ($extra_bed_price * $extrabed) + $extra_charges;
    $discount_amount = ($discount > 0) ? ($discount / 100) * $base_total : 0;
    $subtotal = $base_total - $discount_amount;
    $gst_amount = ($gst_included === 'yes' && $gst_rate > 0) ? ($gst_rate / 100) * $subtotal : 0;
    $grand_total = ceil($subtotal + $gst_amount + $transport_charges);

    // ====================
    // 🆕 CREATE QUOTATION
    // ====================
    if ($action === 'Create') {

        // Generate quotation number per GST type
        $res = mysqli_query($conn, "
            SELECT MAX(CAST(SUBSTRING(quotation_no, 5) AS UNSIGNED)) AS last_no
            FROM quotations 
            WHERE gst_included = '$gst_included' 
            AND financial_year = '$financial_year'
        ");
        $row = mysqli_fetch_assoc($res);
        $last_no = $row['last_no'] ?? 0;
        $next_no = $last_no + 1;
        $quotation_no = 'QTN-' . str_pad($next_no, 4, '0', STR_PAD_LEFT);

        // Check duplicate quotation for inquiry
        $check = mysqli_query($conn, "SELECT id FROM quotations WHERE inquiry_id = '$inquiry_id'");
        if (mysqli_num_rows($check) > 0) {
            echo json_encode(['status' => 'error', 'message' => 'A quotation already exists for this inquiry.']);
            exit;
        }

        // Insert quotation
        $status = 'pending';
         $insert = "
            INSERT INTO quotations (
                customer_id, inquiry_id, assigned_to, quotation_no, quotation_date, financial_year, quotation_type,
                category_id, package_id, package_name, destination, travel_date, nights, rooms, adults, child, extrabed,
                transport_type, transport_charges, extra_charges, adult_price, child_price, extra_bed_price,
                discount, gst_rate, gst_included, total_amount, discount_amount, gst_amount, grand_total,
                inclusions, exclusions, description, status
            ) VALUES (
                '$customer_id', '$inquiry_id', '$assigned_to', '$quotation_no', NOW(), '$financial_year', '$quotation_type',
                '$category_id', '$package_id', '$package_name', '$destination', '$travel_date', '$nights', '$rooms', '$adults', '$child', '$extrabed',
                '$transport_type', '$transport_charges', '$extra_charges', '$adult_price', '$child_price', '$extra_bed_price',
                '$discount', '$gst_rate', '$gst_included', '$base_total', '$discount_amount', '$gst_amount', '$grand_total',
                '$inclusions', '$exclusions', '$description', '$status'
            )
        ";

        if (mysqli_query($conn, $insert)) {
            $quotation_id = mysqli_insert_id($conn);

            // Insert Hotels
            if (isset($_POST['hotels']) && is_array($_POST['hotels'])) {
                foreach ($_POST['hotels'] as $hotel) {
                    $hotel_id = mysqli_real_escape_string($conn, $hotel['hotel_id'] ?? '');
                    $city = mysqli_real_escape_string($conn, $hotel['city'] ?? '');
                    $nights = mysqli_real_escape_string($conn, $hotel['nights'] ?? 1);
                    $meal_plan = mysqli_real_escape_string($conn, $hotel['meal_plan'] ?? 'CP');
                    $rooms = mysqli_real_escape_string($conn, $hotel['rooms'] ?? 1);
                    $stars = mysqli_real_escape_string($conn, $hotel['stars'] ?? '');

                    mysqli_query($conn, "
                        INSERT INTO quotation_hotels 
                        (quotation_id, hotel_id, city, nights, meal_plan, rooms, stars)
                        VALUES ('$quotation_id', '$hotel_id', '$city', '$nights', '$meal_plan', '$rooms', '$stars')
                    ");
                }
            }

            $response = ['status' => 'success', 'message' => 'Quotation created successfully', 'id' => $quotation_id];
        } else {
            $response = ['status' => 'error', 'message' => 'Failed to create quotation'];
        }
           
    }
	
    if ($action === 'Update' && $id) {
		
	$check_stmt = $conn->prepare("SELECT id FROM quotations WHERE inquiry_id = ? AND id != ?");
$check_stmt->bind_param("ii", $inquiry_id, $id);
$check_stmt->execute();
$check_stmt->store_result();

if ($check_stmt->num_rows > 0) {
    $response = ['status' => 'error', 'message' => 'Another quotation with this Inquiry already exists.'];
    echo json_encode($response);
    exit;
}
    // Update quotations table
		$stmt = $conn->prepare("UPDATE quotations SET customer_id = ?, inquiry_id = ?,package_name = ?, destination = ?, travel_date = ?, nights = ?,rooms = ?,adults = ?, child = ?, extrabed = ?, transport_type = ?, transport_charges = ?, adult_price = ?,  child_price = ?, extra_bed_price = ?, discount = ?, gst_rate = ?, gst_included = ?, 
    total_amount = ?,discount_amount = ?,gst_amount = ?, grand_total = ?,exclusions = ?,inclusions = ?, remarks = ?, updated_at = NOW() 
    WHERE id = ?");

		$stmt->bind_param("iisssiiiiisddddddsddddsssi",$customer_id, $inquiry_id, $package_name, $destination, $travel_date,$nights,$rooms,$adults, $child, $extrabed,
    $transport_type, $transport_charges, $adult_price,$child_price, $extra_bed_price, $discount, $gst, $gst_included,$base_total,$discount_amount,$gst_amount, $grand_total,$exclusions,$inclusions, $description, $id
						 );
			
		
	 if ($stmt->execute()) {
        // Step 1: Fetch existing hotel IDs
        $existingHotelIds = [];
        $result = $conn->query("SELECT id FROM quotation_hotels WHERE quotation_id = $id");
        while ($row = $result->fetch_assoc()) {
            $existingHotelIds[] = $row['id'];
        }

        // Step 2: Track IDs received in the POST
        $submittedHotelIds = [];

        if (isset($_POST['hotels']) && is_array($_POST['hotels'])) {
            foreach ($_POST['hotels'] as $hotel) {
                $hotel_id = $hotel['id'] ?? null;
                $hotel_name = $hotel['hotel_name'] ?? '';
                $hotel_location = $hotel['hotel_location'] ?? '';
                $hotel_rooms = $hotel['hotel_rooms'] ?? 0;
                $hotel_type = $hotel['hotel_type'] ?? '';
                $meal_plan = $hotel['meal_plan'] ?? '';

                if ($hotel_id) {
                    // Update existing
                    $submittedHotelIds[] = $hotel_id;
                    $stmt_hotel_update = $conn->prepare("UPDATE quotation_hotels SET hotel_name = ?, hotel_location = ?, hotel_rooms = ?, hotel_type = ?, meal_plan = ? WHERE id = ? AND quotation_id = ?");
                    $stmt_hotel_update->bind_param("ssissii", $hotel_name, $hotel_location, $hotel_rooms, $hotel_type, $meal_plan, $hotel_id, $id);
                    $stmt_hotel_update->execute();
                    $stmt_hotel_update->close();
                } else {
                    // Insert new
                    $stmt_hotels = $conn->prepare("INSERT INTO quotation_hotels (quotation_id, hotel_name, hotel_location, hotel_rooms, hotel_type, meal_plan) VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt_hotels->bind_param("ississ", $id, $hotel_name, $hotel_location, $hotel_rooms, $hotel_type, $meal_plan);
                    $stmt_hotels->execute();
                    $stmt_hotels->close();
                }
            }
        }

        // Step 3: Delete hotels that were removed in frontend
        $idsToDelete = array_diff($existingHotelIds, $submittedHotelIds);
        if (!empty($idsToDelete)) {
            $idsStr = implode(',', array_map('intval', $idsToDelete));
            $conn->query("DELETE FROM quotation_hotels WHERE id IN ($idsStr)");
        }
		  $response = ['status' => 'success', 'message' => 'Quotation updated successfully.', 'id' => $id];
        
    } else {
        $response = ['status' => 'error', 'message' => $stmt->error];
    }
}


    if ($action === 'Select' && $id) {
    // Select quotation and join with customer
    $stmt = $conn->prepare("
        SELECT q.*, c.name AS customer_name
        FROM quotations q
        LEFT JOIN customers c ON q.customer_id = c.id
        WHERE q.id = ?
    ");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $quotation = $stmt->get_result()->fetch_assoc();

    if ($quotation) {
        // Fetch hotel blocks
        $hotels = [];
        $stmt_hotel = $conn->prepare("SELECT * FROM quotation_hotels WHERE quotation_id = ?");
        $stmt_hotel->bind_param("i", $id);
        $stmt_hotel->execute();
        $result_hotel = $stmt_hotel->get_result();
        while ($row = $result_hotel->fetch_assoc()) {
            $hotels[] = $row;
        }

        // Add hotels data to the quotation
        $quotation['hotels'] = $hotels;

        // Return the JSON-encoded quotation data
        echo json_encode($quotation);
        exit;
    }
}

    if ($action === 'update_status' && $id && isset($_POST['status'])) {
        // Sanitize the input status value
        $newStatus = mysqli_real_escape_string($conn, $_POST['status']);
        $last_followup_date = date('Y-m-d H:i:s');  // Get current timestamp

        // Update quotation status and set the last follow-up date
        $query = "UPDATE quotations SET status = ?, last_followup_date = ? WHERE id = ?";
        $stmt = $conn->prepare($query);
        if ($stmt === false) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to prepare the query.']);
            exit;
        }
        
        // Bind parameters: status (string), last_followup_date (string), id (integer)
        $stmt->bind_param("ssi", $newStatus, $last_followup_date, $id);

        if ($stmt->execute()) {
            // Successfully updated status
            echo json_encode(['status' => 'success', 'message' => 'Status updated successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update status.']);
        }

        // Close the statement
        $stmt->close();
        exit;
    }

    if ($action === 'Delete' && $id) {
    // Begin transaction for safety
    $conn->begin_transaction();

    try {
        // Step 1: Delete related hotels
        $stmt_hotels = $conn->prepare("DELETE FROM quotation_hotels WHERE quotation_id = ?");
        $stmt_hotels->bind_param("i", $id);
        $stmt_hotels->execute();

        // Step 2: Delete main quotation
        $stmt = $conn->prepare("DELETE FROM quotations WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();

        // Commit transaction
        $conn->commit();

        $response = [
            'status' => 'Delete',
            'message' => 'Quotation and related hotel details deleted successfully'
        ];
    } catch (Exception $e) {
        // Rollback on any error
        $conn->rollback();

        $response = [
            'status' => 'error',
            'message' => 'Failed to delete quotation: ' . $e->getMessage()
        ];
    }
}

}

echo json_encode($response);
?>
