<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Something went wrong'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $action = $_POST['action'] ?? '';
    $id = (int)($_POST['id'] ?? 0);

    // Fields
    $package_id = (int)($_POST['package_id'] ?? 0);
    $category_id = (int)($_POST['category_id'] ?? 0);
    $purchase_price = (float)($_POST['purchase_price'] ?? 0);
    $sale_price = (float)($_POST['sale_price'] ?? 0);
    $status = 'active';
	
	if ($action === 'GetPackages') {
    $destination_id = (int)$_POST['destination_id'];
    $packages = [];
    $query = mysqli_query($conn, "SELECT id, package_code, package_name, days, nights FROM packages WHERE destination_id = $destination_id AND status='active' ORDER BY package_name ASC");
    while ($row = mysqli_fetch_assoc($query)) {
        $row['package_name'] = ucwords(strtolower($row['package_name']));
        $packages[] = $row;
    }

    if ($packages) {
        echo json_encode(['status' => 'success', 'data' => $packages]);
    } else {
        echo json_encode(['status' => 'error', 'data' => []]);
    }
    exit;
}
	
	if ($action === 'GetPackageNights') {
    $package_id = (int)$_POST['package_id'];

    $res = mysqli_query($conn, "SELECT nights FROM packages WHERE id = $package_id LIMIT 1");
    $data = mysqli_fetch_assoc($res);

    if ($data) {
        echo json_encode(['status' => 'success', 'data' => $data]);
    } else {
        echo json_encode(['status' => 'error', 'data' => []]);
    }
    exit;
}

	
	if ($action === 'GetPackagesCategories') {
    $package_id = (int)$_POST['package_id'];

    $categories = [];
    $query = mysqli_query($conn, "SELECT pcp.id,pcp.category_id,pc.category_name FROM package_category_prices AS pcp
        INNER JOIN package_categories AS pc ON pcp.category_id = pc.id WHERE pcp.package_id = $package_id AND pcp.status = 'active' 
          AND pc.status = 'active'
        ORDER BY pc.category_name ASC
    ");

    while ($row = mysqli_fetch_assoc($query)) {
        $categories[] = $row;
    }

    if ($categories) {
        echo json_encode(['status' => 'success', 'data' => $categories]);
    } else {
        echo json_encode(['status' => 'error', 'data' => []]);
    }
    exit;
}

	
	if ($action === 'fetchCategoryDetails') {
    $package_id = intval($_POST['package_id']);
    $category_id = intval($_POST['category_id']);

    // ✅ Fix 1: Include missing fields in query
    $p = $conn->query("
        SELECT sale_price, purchase_price 
        FROM package_category_prices 
        WHERE package_id='$package_id' AND category_id='$category_id'
        LIMIT 1
    ")->fetch_assoc();

    // ✅ Handle no price found
    if (!$p) {
        echo json_encode(['status' => 'error', 'message' => 'No price found']);
        exit;
    }

    // ✅ Fix 2: Proper hotel join query
    $hotels = [];
    $hRes = $conn->query("
        SELECT 
            h.id AS hotel_id,
			h.hotel_name,
            c.city_name AS city,
            h.stars,
            ph.id AS package_hotel_id
        FROM package_hotels ph
        INNER JOIN hotels h ON ph.hotel_id = h.id
        LEFT JOIN cities c ON h.city_id = c.id
        WHERE ph.package_id = '$package_id'
          AND (ph.category_id = '$category_id' OR ph.category_id IS NULL)
          AND ph.status = 'active'
          AND h.status = 'active'
        ORDER BY c.city_name ASC, h.hotel_name ASC
    ");

    while ($row = $hRes->fetch_assoc()) {
        $hotels[] = $row;
    }

    // ✅ Return structured response
    echo json_encode([
        'status' => 'success',
        'adult_price' => $p['sale_price'],
        'child_price' => $p['sale_price'] * 0.7, // Example: 70% of adult price
        'extra_bed_price' => $p['sale_price'] * 0.85, // Example: 85% of adult price
        'hotels' => $hotels
    ]);
    exit;
}
    // ===== CREATE =====
    if ($action === 'Create') {
        // Validation
        if (!$package_id || !$category_id || $purchase_price <= 0 || $sale_price <= 0) {
            echo json_encode(['status' => 'error', 'message' => 'All fields are required and must be valid.']);
            exit;
        }

        // Prevent duplicate
        $check = $conn->prepare("SELECT id FROM package_category_prices WHERE package_id=? AND category_id=?");
        $check->bind_param("ii", $package_id, $category_id);
        $check->execute();
        if ($check->get_result()->num_rows > 0) {
            echo json_encode(['status' => 'error', 'message' => 'This package category combination already exists.']);
            exit;
        }

        $stmt = $conn->prepare("
            INSERT INTO package_category_prices 
            (package_id, category_id, purchase_price, sale_price, status, created_at) 
            VALUES (?, ?, ?, ?, ?, NOW())
        ");
        $stmt->bind_param("iidds", $package_id, $category_id, $purchase_price, $sale_price, $status);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Package category price created successfully'];
        } else {
            $response['message'] = 'Failed to create record';
        }
    }

    // ===== UPDATE =====
    elseif ($action === 'Update' && $id) {
        if (!$package_id || !$category_id || $purchase_price <= 0 || $sale_price <= 0) {
            echo json_encode(['status' => 'error', 'message' => 'All fields are required and must be valid.']);
            exit;
        }

        $stmt = $conn->prepare("
            UPDATE package_category_prices 
            SET package_id=?, category_id=?, purchase_price=?, sale_price=?, updated_at=NOW()
            WHERE id=?
        ");
        $stmt->bind_param("iiddi", $package_id, $category_id, $purchase_price, $sale_price, $id);

        if ($stmt->execute()) {
            $response = ['status' => 'success', 'message' => 'Package category price updated successfully'];
        } else {
            $response['message'] = 'Failed to update record';
        }
    }

    elseif ($action === 'Select' && $id) {
    $stmt = $conn->prepare("
        SELECT 
        pcp.*, 
        pk.id AS package_id,
        s.id AS destination_id, 
        pc.id AS category_id
    FROM package_category_prices pcp
    JOIN packages pk ON pk.id = pcp.package_id
    JOIN states s ON s.id = pk.destination_id
    JOIN package_categories pc ON pc.id = pcp.category_id
    WHERE pcp.id=?
    ");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();

    if ($result) {
        $response = ['status' => 'success', 'data' => $result];
    } else {
        $response = ['status' => 'error', 'message' => 'Record not found'];
    }

    echo json_encode($response);
    exit;
}


    // ===== TOGGLE STATUS =====
    elseif ($action === 'ToggleStatus' && $id) {
        $stmt = $conn->prepare("SELECT status FROM package_category_prices WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $row = $stmt->get_result()->fetch_assoc();

        if (!$row) {
            echo json_encode(['status' => 'error', 'message' => 'Record not found']);
            exit;
        }

        $new_status = ($row['status'] === 'active') ? 'inactive' : 'active';
        $stmt = $conn->prepare("UPDATE package_category_prices SET status=? WHERE id=?");
        $stmt->bind_param("si", $new_status, $id);
        $stmt->execute();

        $response = ['status' => 'success', 'message' => 'Status updated', 'new_status' => $new_status];
    }

    // ===== DELETE =====
    elseif ($action === 'Delete' && $id) {
        $stmt = $conn->prepare("DELETE FROM package_category_prices WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();

        $response = ['status' => 'success', 'message' => 'Record deleted successfully'];
    }
}

echo json_encode($response);
?>
