<?php
include __DIR__ . '/../inc/db.php';
header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;
$category_name = $_POST['category_name'] ?? '';

if ($action === 'Create' || $action === 'Update') {
    if (empty($category_name)) {
        echo json_encode(['status' => 'error', 'message' => 'Category name is required']);
        exit;
    }

    if ($action === 'Create') {
        $stmt = $conn->prepare("INSERT INTO package_categories (category_name) VALUES (?)");
        $stmt->bind_param("s", $category_name);
        $stmt->execute();
        echo json_encode(['status' => 'success', 'message' => 'Category created successfully']);
    } else {
        $stmt = $conn->prepare("UPDATE package_categories SET category_name=? WHERE id=?");
        $stmt->bind_param("si", $category_name, $id);
        $stmt->execute();
        echo json_encode(['status' => 'success', 'message' => 'Category updated successfully']);
    }
    exit;
}

if ($action === 'Select' && $id) {
    $stmt = $conn->prepare("SELECT id, category_name FROM package_categories WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $data = $stmt->get_result()->fetch_assoc();
    echo json_encode(['status' => 'success', 'data' => $data]);
    exit;
}

if ($action === 'ToggleStatus' && $id) {
    $stmt = $conn->prepare("SELECT status FROM package_categories WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $status = $stmt->get_result()->fetch_assoc()['status'];
    $new_status = ($status === 'active') ? 'inactive' : 'active';
    $stmt = $conn->prepare("UPDATE package_categories SET status=? WHERE id=?");
    $stmt->bind_param("si", $new_status, $id);
    $stmt->execute();
    echo json_encode(['status' => 'success', 'new_status' => $new_status]);
    exit;
}

if ($action === 'Delete' && $id) {
    $stmt = $conn->prepare("DELETE FROM package_categories WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    echo json_encode(['status' => 'success', 'message' => 'Category deleted successfully']);
    exit;
}

echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
