<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
include '../inc/db.php';
// Financial Year
$month = date('n');
$year = date('Y');
if ($month < 4) {
    $financial_year = ($year - 1) . '-' . substr($year, 2);
} else {
    $financial_year = $year . '-' . substr($year + 1, 2);
}
$action = $_POST['action'] ?? '';
$id = intval($_POST['id'] ?? 0);

function responseJSON($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

/* =======================================================
    CREATE BOOKING
   ======================================================= */
if ($action === 'Create') {

    $customer_id       = intval($_POST['customer_id']);
    $inquiry_id        = intval($_POST['inquiry_id'] ?? 0);
    $booking_date      = $_POST['booking_date'] ?? date('Y-m-d');
    $policy_no         = $_POST['policy_no'] ?? '';
    $insurance_type    = $_POST['insurance_type'] ?? '';
    $insurance_company = $_POST['insurance_company'] ?? '';
    $insurance_destination = $_POST['destination'] ?? '';
    $insurance_travel_type = $_POST['insurance_travel_type'] ?? 'domestic';
    $no_of_travelers   = intval($_POST['no_of_travelers'] ?? 1);
    $insurance_start_date = $_POST['insurance_start_date'] ?? null;
    $insurance_end_date   = $_POST['insurance_end_date'] ?? null;
    $insurance_sum_insured = floatval($_POST['insurance_sum_insured'] ?? 0);
    $premium_rate      = floatval($_POST['premium_rate'] ?? 0);
    $gst_included      = $_POST['gst_included'] ?? 'no'; 
    $gst_rate          = floatval($_POST['gst_rate'] ?? 18);
    $payment_mode      = $_POST['payment_mode'] ?? 'cash';
    $advance_payment   = floatval($_POST['advance_payment'] ?? 0);
    $useridnew         = intval($_POST['created_by']);
    $upi_id            = $_POST['upi_id'] ?? null;
    $bank_name         = $_POST['bank_name'] ?? null;
    $account_no        = $_POST['account_no'] ?? null;
    $transaction_id    = $_POST['transaction_id'] ?? null;

 // --- Duration ---
$duration_days = 1;
if (!empty($insurance_start_date) && !empty($insurance_end_date)) {
    $start_date = new DateTime($insurance_start_date);
    $end_date   = new DateTime($insurance_end_date);
    $duration_days = $end_date->diff($start_date)->days + 1;
}

// --- Premium Calculation ---
$premium_amount = round(($insurance_sum_insured * $premium_rate / 100) * $duration_days * $no_of_travelers, 2);

if ($gst_included === 'yes') {
    // ✅ GST should be added on top
    $gst_amount = round(($premium_amount * $gst_rate) / 100, 2);
    $base_without_gst = $premium_amount;
    $total_amount = round($premium_amount + $gst_amount, 2);
} else {
    // ❌ GST not included → total = base premium
    $gst_amount = 0;
    $base_without_gst = $premium_amount;
    $total_amount = $premium_amount;
}

	
    // === Payment Status ===
    if ($advance_payment >= $total_amount) $payment_status = 'paid';
    elseif ($advance_payment > 0) $payment_status = 'partial';
    else $payment_status = 'unpaid';

    // === Booking Code ===
    $prefix = "MTI/"; // MTI = Insurance
    $yearStart = (date('n') >= 4) ? date('y') : date('y') - 1;
    $yearEnd   = $yearStart + 1;
    $fy = $yearStart . '-' . $yearEnd;

    $lastCodeQ = $conn->query("SELECT booking_code FROM bookings WHERE booking_code LIKE '%$fy%' AND booking_type='insurance' ORDER BY id DESC LIMIT 1");
    if ($lastCodeQ && $lastCodeQ->num_rows > 0) {
        $last = $lastCodeQ->fetch_assoc()['booking_code'];
        preg_match('/(\d+)$/', $last, $m);
        $next = isset($m[1]) ? intval($m[1]) + 1 : 1;
    } else {
        $next = 1;
    }
    $booking_code = sprintf("%s%s/%04d", $prefix, $fy, $next);

    // === Insert Query ===
    $sql = "
    INSERT INTO bookings (
        inquiry_id, customer_id, booking_type, booking_code, booking_date,
        status, payment_status, policy_no, insurance_type, insurance_company,
        insurance_destination, insurance_travel_type, no_of_travelers,
        insurance_start_date, insurance_end_date, insurance_sum_insured,
        premium_rate, premium_amount, gst_rate, gst_amount, gst_included,
        total_amount, paid_amount, payment_mode, created_by, financial_year
    ) VALUES (
        '$inquiry_id', '$customer_id', 'insurance', '$booking_code', '$booking_date',
        'confirmed', '$payment_status', '$policy_no', '$insurance_type', '$insurance_company',
        '$insurance_destination', '$insurance_travel_type', '$no_of_travelers',
        '$insurance_start_date', '$insurance_end_date', '$insurance_sum_insured',
        '$premium_rate', '$premium_amount', '$gst_rate', '$gst_amount', '$gst_included',
        '$total_amount', '$advance_payment', '$payment_mode', '$useridnew', '$financial_year'
    )
    ";

    if ($conn->query($sql)) {
        $booking_id = $conn->insert_id;

        // === Receipt Generation ===
        function generateReceiptNo($conn) {
            $fy_short = substr(date('Y'), 2);
            $r = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
            $next = 1;
            if ($r && $r->num_rows > 0) {
                $row = $r->fetch_assoc();
                preg_match('/(\d+)$/', $row['receipt_no'], $m);
                $next = isset($m[1]) ? ((int)$m[1] + 1) : 1;
            }
            return "RC{$fy_short}-" . str_pad($next, 4, '0', STR_PAD_LEFT);
        }

        if ($advance_payment > 0) {
            $receipt_no = generateReceiptNo($conn);
            $conn->query("
                INSERT INTO payments (
                    booking_id, customer_id, payment_type, amount, mode, transaction_id,
                    receipt_no, bank_name, account_no, upi_id, received_by, financial_year, status
                ) VALUES (
                    '$booking_id', '$customer_id', 'received', '$advance_payment', '$payment_mode', '$transaction_id',
                    '$receipt_no', '$bank_name', '$account_no', '$upi_id', '$useridnew', '$financial_year', 'completed'
                )
            ");
        }

        if ($inquiry_id > 0) {
            $conn->query("UPDATE inquiries SET status='closed' WHERE id='$inquiry_id'");
        }

        responseJSON('success', 'Insurance booking created successfully.', ['id' => $booking_id]);
    } else {
        responseJSON('error', 'Database insert failed: ' . $conn->error);
    }
}
/* =======================================================
    UPDATE VEHICLE BOOKING
   ======================================================= */
elseif ($action === 'Update' && $id > 0) {

     $customer_id       = intval($_POST['customer_id']);
    $inquiry_id        = intval($_POST['inquiry_id'] ?? 0);
    $booking_date      = $_POST['booking_date'] ?? date('Y-m-d');
    $policy_no         = $_POST['policy_no'] ?? '';
    $insurance_type    = $_POST['insurance_type'] ?? '';
    $insurance_company = $_POST['insurance_company'] ?? '';
    $insurance_destination = $_POST['destination'] ?? '';
    $insurance_travel_type = $_POST['insurance_travel_type'] ?? 'domestic';
    $no_of_travelers   = intval($_POST['no_of_travelers'] ?? 1);
    $insurance_start_date = $_POST['insurance_start_date'] ?? null;
    $insurance_end_date   = $_POST['insurance_end_date'] ?? null;
    $insurance_sum_insured = floatval($_POST['insurance_sum_insured'] ?? 0);
    $premium_rate      = floatval($_POST['premium_rate'] ?? 0);
    $gst_included      = $_POST['gst_included'] ?? 'no';
    $gst_rate          = floatval($_POST['gst_rate'] ?? 18);
    $payment_mode      = $_POST['payment_mode'] ?? 'cash';
    $advance_payment   = floatval($_POST['advance_payment'] ?? 0);
    $useridnew         = intval($_POST['created_by']);
    $upi_id            = $_POST['upi_id'] ?? null;
    $bank_name         = $_POST['bank_name'] ?? null;
    $account_no        = $_POST['account_no'] ?? null;
    $transaction_id    = $_POST['transaction_id'] ?? null;

    $transport_total = $vehicle_total_km * $vehicle_rate_per_km;
    $base_total = $transport_total + $vehicle_driver_allowance + $extra_charges;
    $discount_amount = ($discount > 0) ? ($base_total * $discount / 100) : 0;
    $after_discount  = $base_total - $discount_amount;
    if ($gst_included === 'yes') {
        // Price already includes GST → extract GST from total
        $gst_amount = round(($after_discount * $gst_rate) / (100 + $gst_rate), 2);
        $base_without_gst = round($after_discount - $gst_amount, 2);
        $total_amount = $after_discount; // already includes GST
    } else {
        // Add GST on top of discounted amount
        $gst_amount = round(($after_discount * $gst_rate / 100), 2);
        $base_without_gst = round($after_discount, 2);
        $total_amount = round($after_discount + $gst_amount, 2);
    }
// ====== Payment Status ======
    // ====== Payment Status ======
    if ($advance_payment >= $total_amount) $payment_status = 'paid';
    elseif ($advance_payment > 0) $payment_status = 'partial';
    else $payment_status = 'unpaid';

    // ====== Update Query ======
    $stmt = $conn->prepare("
        UPDATE bookings SET 
            customer_id=?, inquiry_id=?, booking_date=?, vehicle_type=?, vehicle_name=?,
            vehicle_pickup_location=?, vehicle_drop_location=?, vehicle_pickup_datetime=?,
            vehicle_return_datetime=?, vehicle_passengers=?, vehicle_total_km=?,
            vehicle_rate_per_km=?,transport_charges=?, vehicle_driver_allowance=?, extra_charges=?,
            discount=?, gst_rate=?, gst_included=?, gst_amount=?, discount_amount=?,
            total_amount=?, paid_amount=?, payment_mode=?, payment_status=?, updated_at=NOW()
        WHERE id=?
    ");

    $stmt->bind_param(
        'iisssssssdiddddddsddddssi',
        $customer_id, $inquiry_id, $booking_date, $vehicle_type, $vehicle_name,
        $vehicle_pickup_location, $vehicle_drop_location, $vehicle_pickup_datetime,
        $vehicle_return_datetime, $vehicle_passengers, $vehicle_total_km,
        $vehicle_rate_per_km,$transport_total, $vehicle_driver_allowance, $extra_charges,
        $discount, $gst_rate, $gst_included, $gst_amount, $discount_amount,
        $total_amount, $advance_payment, $payment_mode, $payment_status, $id
    );

    if ($stmt->execute()) {
        // Delete old payments
        $conn->query("DELETE FROM payments WHERE booking_id = '$id'");

        // ====== Generate new payment if advance given ======
        if ($advance_payment > 0) {
            function generateReceiptNo($conn) {
                $month = date('n');
                $year = date('Y');
                $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
                $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
                $nextNumber = 1;
                if ($res && $res->num_rows > 0) {
                    $row = $res->fetch_assoc();
                    preg_match('/(\d+)$/', $row['receipt_no'], $matches);
                    $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
                }
                return "RC{$fy_short}-" . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
            }

            $receipt_no = generateReceiptNo($conn);
            $conn->query("
                INSERT INTO payments (
                    booking_id, customer_id, payment_type, amount, mode, transaction_id,
                    receipt_no, bank_name, account_no, upi_id, received_by, status
                ) VALUES (
                    '$id', '$customer_id', 'received', '$advance_payment', '$payment_mode', '$transaction_id',
                    '$receipt_no', '$bank_name', '$account_no', '$upi_id', '$useridnew', 'completed'
                )
            ");
        }

        responseJSON('success', 'Vehicle booking updated successfully.', ['id' => $id]);
    } else {
        responseJSON('error', 'Failed to update booking: ' . $stmt->error);
    }
}


/* =======================================================
    SELECT BOOKING
   ======================================================= */
elseif ($action === 'Select' && $id > 0) {
    $result = $conn->query("SELECT * FROM bookings WHERE id='$id' LIMIT 1");
    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_assoc();
        responseJSON('success', 'Booking fetched successfully.', ['data' => $data]);
    } else {
        responseJSON('error', 'Booking not found.');
    }
}

/* =======================================================
    FETCH FOR DATATABLE
   ======================================================= */
elseif ($action === 'fetch') { 
    $draw   = intval($_POST['draw'] ?? 1);
    $start  = intval($_POST['start'] ?? 0);
    $length = intval($_POST['length'] ?? 25);
    $search = $_POST['search']['value'] ?? '';

    $where = "WHERE b.booking_type = 'insurance'";
    if (!empty($search)) {
        $search = $conn->real_escape_string($search);
        $where .= " AND (
            b.booking_code LIKE '%$search%' OR
            b.insurance_destination LIKE '%$search%' OR
            b.insurance_company LIKE '%$search%' OR
            c.name LIKE '%$search%' OR
            c.phone LIKE '%$search%'
        )";
    }

    // Total records
    $totalQuery = $conn->query("SELECT COUNT(*) AS total FROM bookings WHERE booking_type = 'insurance'");
    $totalData  = $totalQuery->fetch_assoc()['total'];

    // Main query
    $query = "
        SELECT 
            b.id, b.customer_id, b.booking_code, b.booking_date, 
            b.insurance_type, b.insurance_company, b.insurance_destination, 
            b.insurance_start_date, b.insurance_end_date,
            b.total_amount, b.paid_amount, 
            (b.total_amount - b.paid_amount) AS due_amount,
            b.payment_status,
            c.name AS customer_name, c.phone AS customer_phone,
            p.last_payment_date, p.last_payment_type, p.last_payment_amount
        FROM bookings b
        LEFT JOIN customers c ON c.id = b.customer_id
        LEFT JOIN (
            SELECT 
                booking_id,
                MAX(created_at) AS last_payment_date,
                SUBSTRING_INDEX(GROUP_CONCAT(payment_type ORDER BY created_at DESC), ',', 1) AS last_payment_type,
                SUBSTRING_INDEX(GROUP_CONCAT(amount ORDER BY created_at DESC), ',', 1) AS last_payment_amount
            FROM payments
            WHERE status = 'completed'
            GROUP BY booking_id
        ) p ON p.booking_id = b.id
        $where
        ORDER BY b.id DESC
        LIMIT $start, $length
    ";

    $result = $conn->query($query);
    $data = [];

    while ($row = $result->fetch_assoc()) {
        $due   = floatval($row['due_amount']);
        $total = floatval($row['total_amount']);

        // Payment Status Badge
        if ($due <= 0) {
            $statusBadge = '<span class="badge bg-success">Paid</span>';
        } elseif ($due < $total) {
            $statusBadge = '<span class="badge bg-warning text-dark">Partial</span>';
        } else {
            $statusBadge = '<span class="badge bg-danger">Unpaid</span>';
        }

        // Add last payment info
        if (!empty($row['last_payment_date'])) {
            $statusBadge .= '<br><small class="text-muted">
                Last: ' . date('d-m-Y', strtotime($row['last_payment_date'])) . '<br>
                ' . ucfirst($row['last_payment_type']) . ': ' . number_format($row['last_payment_amount'], 2) . '
            </small>';
        }

        // Action Buttons
        $actions = '
            <button class="btn btn-xs btn-success changeStatusBtn" 
                data-id="' . $row['id'] . '" 
                data-customer_id="' . $row['customer_id'] . '" 
                data-total_amount="' . $row['total_amount'] . '" 
                data-balance_amount="' . $row['due_amount'] . '" 
                title="Add Payment">
                <i class="ti ti-credit-card"></i>
            </button>
            <button class="btn btn-xs btn-info download" data-id="' . $row['id'] . '" title="Download Invoice">
                <i class="ti ti-file-download"></i>
            </button>
            <button class="btn btn-xs btn-danger delete" id="' . $row['id'] . '" title="Delete">
                <i class="ti ti-trash"></i>
            </button>
        ';

        $data[] = [
            'booking_date'   => date('d-m-Y', strtotime($row['booking_date'])),
            'booking_code'   => htmlspecialchars($row['booking_code']),
            'customer_name'  => '<a href="insurance_booking_payment.php?book_id=' . intval($row['id']) . '">' . htmlspecialchars($row['customer_name']) . '</a>',
            'customer_phone' => htmlspecialchars($row['customer_phone']),
            'destination'    => htmlspecialchars($row['insurance_destination']),
            'start_date'     => !empty($row['insurance_start_date']) ? date('d-m-Y', strtotime($row['insurance_start_date'])) : '-',
            'end_date'       => !empty($row['insurance_end_date']) ? date('d-m-Y', strtotime($row['insurance_end_date'])) : '-',
            'insurance_type' => htmlspecialchars($row['insurance_type'] . ' (' . $row['insurance_company'] . ')'),
            'total_amount'   => number_format($row['total_amount'], 2),
            'due_amount'     => number_format($row['due_amount'], 2),
            'payment_status' => $statusBadge,
            'action'         => $actions
        ];
    }

    echo json_encode([
        'draw'            => $draw,
        'recordsTotal'    => $totalData,
        'recordsFiltered' => !empty($search) ? count($data) : $totalData,
        'data'            => $data
    ]);
    exit;
}

//
//elseif ($action === 'savepayment') {
//    $booking_id   = intval($_POST['booking_id'] ?? 0);
//    $customer_id  = intval($_POST['customer_id'] ?? 0);
//    $amount       = floatval($_POST['amount'] ?? 0);
//    $mode         = $conn->real_escape_string($_POST['payment_mode'] ?? 'cash');
//    $upi_id       = $conn->real_escape_string($_POST['upi_id'] ?? '');
//    $reference_no = $conn->real_escape_string($_POST['transaction_id'] ?? '');
//    $bank_name    = $conn->real_escape_string($_POST['bank_name'] ?? '');
//    $narration    = $conn->real_escape_string($_POST['narration'] ?? '');
//    $received_by  = intval($_POST['received_by'] ?? 0);
//
//    if ($booking_id <= 0 || $amount <= 0) {
//        responseJSON('error', 'Invalid booking or amount.');
//    }
//
//    // --- Fetch booking ---
//    $bq = $conn->query("SELECT total_amount, paid_amount FROM bookings WHERE id = $booking_id LIMIT 1");
//    if (!$bq || $bq->num_rows == 0) {
//        responseJSON('error', 'Booking not found.');
//    }
//    $b = $bq->fetch_assoc();
//    $balance = $b['total_amount'] - $b['paid_amount'];
//
//    if ($amount > $balance) {
//        responseJSON('error', 'Received amount cannot be greater than balance amount.');
//    }
//
//    // --- Generate Receipt No ---
//    function generateReceiptNo($conn) {
//        $month = date('n');
//        $year = date('Y');
//        $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
//        $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
//        $nextNumber = 1;
//        if ($res && $res->num_rows > 0) {
//            $row = $res->fetch_assoc();
//            preg_match('/(\d+)$/', $row['receipt_no'], $matches);
//            $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
//        }
//        $formattedNo = str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
//        return "RC{$fy_short}-{$formattedNo}";
//    }
//
//    $receipt_no = generateReceiptNo($conn);
//
//    // --- Save Payment ---
//    $stmt = $conn->prepare("
//        INSERT INTO payments 
//        (booking_id, customer_id, amount, mode, upi_id, reference_no, bank_name, narration, receipt_no, payment_type, received_by, status, created_at)
//        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'received', ?, 'completed', NOW())
//    ");
//    $stmt->bind_param('iidssssssi', $booking_id, $customer_id, $amount, $mode, $upi_id, $reference_no, $bank_name, $narration, $receipt_no, $received_by);
//
//    if ($stmt->execute()) {
//        $payment_id = $conn->insert_id;
//
//        // --- Update booking ---
//        $conn->query("UPDATE bookings 
//                      SET paid_amount = paid_amount + $amount, 
//                          payment_status = CASE 
//                              WHEN paid_amount + $amount >= total_amount THEN 'paid'
//                              WHEN paid_amount + $amount > 0 THEN 'partial'
//                              ELSE 'unpaid'
//                          END
//                      WHERE id = $booking_id");
//
//        responseJSON('success', 'Payment added successfully.', ['payment_id' => $payment_id]);
//    } else {
//        responseJSON('error', 'Failed to save payment: ' . $conn->error);
//    }
//}


/* =======================================================
   ❌ DELETE BOOKING
   ======================================================= */
elseif ($action === 'Delete' && $id > 0) {
    $conn->query("DELETE FROM payments WHERE booking_id = '$id'");
    $conn->query("DELETE FROM bookings WHERE id = '$id'");
    responseJSON('Delete', 'Booking deleted successfully.');
}

/* =======================================================
   ⚠️ INVALID ACTION
   ======================================================= */
else {
    responseJSON('error', 'Invalid action or missing parameters.');
}
?>
