<?php
ini_set( 'display_errors', 1 );
ini_set( 'display_startup_errors', 1 );
error_reporting( E_ALL );
header( 'Content-Type: application/json' );

include __DIR__ . '/../inc/db.php';

$response = [ 'status' => 'error', 'message' => 'Something went wrong' ];

if ( $_SERVER[ 'REQUEST_METHOD' ] === 'POST' ) {

	$action = $_POST[ 'action' ] ?? 'Create';
	$id = $_POST[ 'id' ] ?? null;

	// Common fields
	$name = trim( $_POST[ 'name' ] ?? '' );
	$phone = trim( $_POST[ 'phone' ] ?? '' );
	$email = trim( $_POST[ 'email' ] ?? '' );
	$address = trim( $_POST[ 'address' ] ?? '' );
	$assigned_to = $_POST[ 'assigned_to' ] ?? null;
	$remarks = $_POST[ 'remarks' ] ?? null;
	$inquiry_type = $_POST[ 'inquiry_type' ] ?? 'package';

	// Package
	$package_name = $_POST[ 'package_name' ] ?? null;
	$package_start_date = $_POST[ 'package_start_date' ] ?? null;
	$package_end_date = $_POST[ 'package_end_date' ] ?? null;
	$package_adults = $_POST[ 'package_adults' ] ?? 1;
	$package_children = $_POST[ 'package_children' ] ?? 0;
	$package_special_requests = $_POST[ 'package_requests' ] ?? null;
	$source = $_POST[ 'source' ] ?? null;

	// Hotel
	$hotel_city = $_POST[ 'hotel_city' ] ?? null;
	$hotel_name = $_POST[ 'hotel_name' ] ?? null;
	$hotel_checkin = $_POST[ 'hotel_checkin_date' ] ?? null;
	$hotel_checkout = $_POST[ 'hotel_checkout_date' ] ?? null;
	$hotel_rooms = $_POST[ 'hotel_rooms' ] ?? 1;
	$hotel_adults = $_POST[ 'hotel_adults' ] ?? 1;
	$hotel_children = $_POST[ 'hotel_children' ] ?? 0;
	$hotel_type = $_POST[ 'hotel_type' ] ?? null;

	// Flight
	$flight_from = $_POST[ 'flight_from' ] ?? null;
	$flight_to = $_POST[ 'flight_to' ] ?? null;
	$flight_departure = $_POST[ 'flight_departure' ] ?? null;
	$flight_return = $_POST[ 'flight_return' ] ?? null;
	$flight_adult = $_POST[ 'flight_adult' ] ?? 1;
	$flight_children = $_POST[ 'flight_children' ] ?? 0;
	$flight_infant = $_POST[ 'flight_infant' ] ?? 0;
	$flight_class = $_POST[ 'flight_class' ] ?? 'economy';

	// Insurance
	$insurance_destination = $_POST[ 'insurance_destination' ] ?? null;
	$travel_type = $_POST['travel_type'] ?? 'domestic';
if (!in_array($travel_type, ['domestic', 'international'])) {
    $travel_type = 'domestic';
}
	$no_of_travelers = $_POST[ 'no_of_travelers' ] ?? null;
	$insurance_type = $_POST[ 'insurance_type' ] ?? null;
	$insurance_start = $_POST[ 'insurance_start' ] ?? null;
	$insurance_end = $_POST[ 'insurance_end' ] ?? null;
	$insurance_sum = $_POST[ 'insurance_sum' ] ?? null;

	// Vehicle
	$vehicle_type = $_POST[ 'vehicle_type' ] ?? null;
	$vehicle_pickup = $_POST[ 'vehicle_pickup' ] ?? null;
	$vehicle_drop = $_POST[ 'vehicle_drop' ] ?? null;
	$vehicle_pickup_date = $_POST[ 'vehicle_pickup_date' ] ?? null;
	$vehicle_drop_date = $_POST[ 'vehicle_drop_date' ] ?? null;
	$vehicle_passengers = $_POST[ 'vehicle_passengers' ] ?? 1;

	// Validation
	// Only validate when creating or updating
	if ( in_array( $action, [ 'Create', 'Update' ] ) ) {
		if ( empty( $name ) || empty( $phone ) || empty( $assigned_to ) ) {
			echo json_encode( [ 'status' => 'error', 'message' => 'Customer Name, Mobile, and Assigned To are required.' ] );
			exit;
		}
	}

	$customer_id = null;

// ✅ Ensure phone is not empty before checking
if (!empty($phone)) {
    // Check if customer already exists
    $check = $conn->prepare("SELECT id FROM customers WHERE phone = ? LIMIT 1");
    $check->bind_param("s", $phone);
    $check->execute();
    $check->bind_result($existing_id);
    if ($check->fetch()) {
        $customer_id = $existing_id;
    }
    $check->close();
}

// ✅ Create new customer only if phone is not empty and not found
if (!$customer_id && !empty($phone)) {
    $insert_customer = $conn->prepare("INSERT INTO customers (name, email, phone, address, status, created_at, updated_at) VALUES (?, ?, ?, ?, 'active', NOW(), NOW())");
    $insert_customer->bind_param("ssss", $name, $email, $phone, $address);
    $insert_customer->execute();
    $customer_id = $insert_customer->insert_id;
    $insert_customer->close();
}



	// CREATE
	if ( $action === 'Create' ) {
		$sql = "INSERT INTO inquiries (
        customer_id, inquiry_type,
        package_name, package_start_date, package_end_date, package_adults, package_children, package_special_requests,
        hotel_city, hotel_name, hotel_checkin_date, hotel_checkout_date, hotel_rooms, hotel_adults, hotel_children, hotel_type,
        flight_from_city, flight_to_city, flight_departure_date, flight_return_date, flight_adult,flight_children,flight_infant, flight_class,
        insurance_destination, travel_type, no_of_travelers, insurance_type, insurance_start_date, insurance_end_date, insurance_sum_insured,
        vehicle_type, vehicle_pickup_location, vehicle_drop_location, vehicle_pickup_datetime, vehicle_drop_datetime, vehicle_passengers,
        assigned_to, remarks, source
    ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    $stmt = $conn->prepare($sql);

    $stmt->bind_param(
        "issssiiissssiissssssssssssisssisssssiiss",
        $customer_id, $inquiry_type,
        $package_name, $package_start_date, $package_end_date, $package_adults, $package_children, $package_special_requests,
        $hotel_city, $hotel_name, $hotel_checkin, $hotel_checkout, $hotel_rooms, $hotel_adults, $hotel_children, $hotel_type,
        $flight_from, $flight_to, $flight_departure, $flight_return, $flight_adult,$flight_children,$flight_infant, $flight_class,
        $insurance_destination, $travel_type, $no_of_travelers, $insurance_type, $insurance_start, $insurance_end, $insurance_sum,
        $vehicle_type, $vehicle_pickup, $vehicle_drop, $vehicle_pickup_date, $vehicle_drop_date, $vehicle_passengers,
        $assigned_to, $remarks, $source
    );

		if ( $stmt->execute() ) {
			$response = [ 'status' => 'success', 'message' => 'Inquiry created successfully' ];
		} else {
			$response = [ 'status' => 'error', 'message' => 'Database error: ' . $stmt->error ];
		}
	} elseif ( $action === 'Update' && $id ) {

		$stmt = $conn->prepare( "UPDATE customers SET name=?, email=?, phone=?, address=? 
        WHERE id=(SELECT customer_id FROM inquiries WHERE id=?)" );
		$stmt->bind_param( "ssssi", $name, $email, $phone, $address, $id );
		$stmt->execute();

		$sql = "UPDATE inquiries SET 
    inquiry_type=?, package_name=?, package_start_date=?, package_end_date=?, package_adults=?, package_children=?, package_special_requests=?,
    hotel_city=?, hotel_name=?, hotel_checkin_date=?, hotel_checkout_date=?, hotel_rooms=?, hotel_adults=?, hotel_children=?, hotel_type=?,
    flight_from_city=?, flight_to_city=?, flight_departure_date=?, flight_return_date=?, flight_adult=?, flight_class=?,
    insurance_destination=?,travel_type=?,no_of_travelers=?,insurance_type=?, insurance_start_date=?, insurance_end_date=?, insurance_sum_insured=?,
    vehicle_type=?, vehicle_pickup_location=?, vehicle_drop_location=?, vehicle_pickup_datetime=?, vehicle_drop_datetime=?, vehicle_passengers=?,
    assigned_to=?, remarks=? WHERE id=?";

		$stmt = $conn->prepare( $sql );
		$stmt->bind_param(
			"ssssiisssssiiisssssisssisssdsssssiisi",
			$inquiry_type, $package_name, $package_start_date, $package_end_date,
			$package_adults, $package_children, $package_special_requests,
			$hotel_city, $hotel_name, $hotel_checkin, $hotel_checkout,
			$hotel_rooms, $hotel_adults, $hotel_children, $hotel_type,
			$flight_from, $flight_to, $flight_departure, $flight_return,
			$flight_adult, $flight_class,
			$insurance_destination, $travel_type, $no_of_travelers, $insurance_type, $insurance_start, $insurance_end, $insurance_sum,
			$vehicle_type, $vehicle_pickup, $vehicle_drop,
			$vehicle_pickup_date, $vehicle_drop_date, $vehicle_passengers,
			$assigned_to, $remarks, $id
		);

		if ( $stmt->execute() ) {
			$response = [ 'status' => 'success', 'message' => 'Inquiry updated successfully' ];
		} else {
			$response = [ 'status' => 'error', 'message' => 'Database update failed: ' . $stmt->error ];
		}

		echo json_encode( $response );
		exit;
	}


	// ✅ SELECT (Edit)
	elseif ( $action === 'Select' && $id ) {
		$query = "SELECT i.*, c.name, c.phone, c.email, c.address
                  FROM inquiries i
                  JOIN customers c ON i.customer_id = c.id
                  WHERE i.id = ?";
		$stmt = $conn->prepare( $query );
		$stmt->bind_param( "i", $id );
		$stmt->execute();
		$result = $stmt->get_result();
		echo json_encode( [ 'status' => 'success', 'data' => $result->fetch_assoc() ] );
		exit;
	}

	// ✅ DataTables Inquiry List
	elseif ( $action === 'InquiryList' ) {
		$inquiry_type = $_POST[ 'inquiry_type' ] ?? 'package';

		$draw = intval( $_POST[ 'draw' ] ?? 0 );
		$start = intval( $_POST[ 'start' ] ?? 0 );
		$length = intval( $_POST[ 'length' ] ?? 25 );
		$searchValue = $_POST[ 'search' ][ 'value' ] ?? '';

		$where = "WHERE i.inquiry_type = ?";
		$params = [ $inquiry_type ];
		$types = "s";

		if ( !empty( $searchValue ) ) {
			$where .= " AND (c.name LIKE ? OR c.phone LIKE ? OR i.remarks LIKE ?)";
			$searchParam = "%" . $searchValue . "%";
			$params = [ $inquiry_type, $searchParam, $searchParam, $searchParam ];
			$types = "ssss";
		}

		// Count total
		$stmt = $conn->prepare( "SELECT COUNT(*) FROM inquiries i JOIN customers c ON i.customer_id = c.id WHERE i.inquiry_type = ?" );
		$stmt->bind_param( "s", $inquiry_type );
		$stmt->execute();
		$stmt->bind_result( $recordsTotal );
		$stmt->fetch();
		$stmt->close();

		// Count filtered
		if ( !empty( $searchValue ) ) {
			$stmt = $conn->prepare( "SELECT COUNT(*) FROM inquiries i JOIN customers c ON i.customer_id = c.id $where" );
			$stmt->bind_param( $types, ... $params );
			$stmt->execute();
			$stmt->bind_result( $recordsFiltered );
			$stmt->fetch();
			$stmt->close();
		} else {
			$recordsFiltered = $recordsTotal;
		}

		// Fetch data
		$sql = "SELECT 
                i.id, i.created_at, i.inquiry_type, i.remarks, 
                COALESCE(c.name, i.customer_name) AS customer_name,
                COALESCE(c.phone, i.customer_phone) AS phone,
                i.status,
                i.last_followup_date
            FROM inquiries i
            LEFT JOIN customers c ON i.customer_id = c.id
            $where
            ORDER BY i.created_at DESC
            LIMIT ?, ?";
		$stmt = $conn->prepare( $sql );

		if ( !empty( $searchValue ) ) {
			$params[] = $start;
			$params[] = $length;
			$types .= "ii";
			$stmt->bind_param( $types, ... $params );
		} else {
			$stmt->bind_param( "sii", $inquiry_type, $start, $length );
		}

		$stmt->execute();
		$result = $stmt->get_result();

		$data = [];
		while ( $row = $result->fetch_assoc() ) {
			$row[ 'created_at' ] = date( 'd-m-Y', strtotime( $row[ 'created_at' ] ) );
			$status = strtolower( $row[ 'status' ] ?? '' );


			// ✅ Assign color class based on status
			$statusclass = match( $status ) {
				'pending' => 'bg-warning',
				'in-progress' => 'bg-info',
				'closed' => 'bg-success',
				default => 'bg-secondary',
			};

			// ✅ Format status as HTML badge
			$statusHtml = '
            <span class="badge ' . $statusclass . ' bg-glow">'
			. htmlspecialchars( ucwords( $status ) ) .
			'</span>';

			// ✅ Append last follow-up date if available
			if ( !empty( $row[ 'last_followup_date' ] ) ) {
				$statusHtml .= '<br><small class="text-muted">Last: '
					. date( 'd-m-Y', strtotime( $row[ 'last_followup_date' ] ) ) . '</small>';
			}

			$row[ 'status' ] = $statusHtml;

			$id = $row[ 'id' ];
			$row[ 'action' ] = "<a href='inquiry_followup.php?id={$id}&type={$row['inquiry_type']}' class='btn btn-xs btn-info'>
                <i class='ti ti-eye'></i>
            </a>
            <a href='inquiry_edit.php?id={$id}&type={$row['inquiry_type']}' class='btn btn-xs btn-warning'>
                <i class='ti ti-edit'></i>
            </a>
            <button class='btn btn-xs btn-danger delete' data-id='{$id}'>
                <i class='ti ti-trash'></i>
            </button>";

			$data[] = $row;
		}

		echo json_encode( [
			"draw" => $draw,
			"recordsTotal" => $recordsTotal,
			"recordsFiltered" => $recordsFiltered,
			"data" => $data
		] );
		exit;
	}


	elseif ( $action === 'Delete' && !empty( $id ) ) {

		// Delete follow-ups first
		$stmt1 = $conn->prepare( "DELETE FROM inquiry_followups WHERE inquiry_id = ?" );
		$stmt1->bind_param( "i", $id );
		$stmt1->execute();

		// Then delete inquiry
		$stmt2 = $conn->prepare( "DELETE FROM inquiries WHERE id = ?" );
		$stmt2->bind_param( "i", $id );
		$stmt2->execute();

		if ( $stmt2->affected_rows > 0 ) {
			echo json_encode( [
				'status' => 'success',
				'message' => 'Inquiry and related follow-ups deleted successfully'
			] );
		} else {
			echo json_encode( [
				'status' => 'error',
				'message' => 'Failed to delete inquiry'
			] );
		}

		exit;
	}
	
	elseif ( $action === 'Delete' && !empty( $id ) ) {

		// Delete follow-ups first
		$stmt1 = $conn->prepare( "DELETE FROM inquiry_followups WHERE inquiry_id = ?" );
		$stmt1->bind_param( "i", $id );
		$stmt1->execute();

		// Then delete inquiry
		$stmt2 = $conn->prepare( "DELETE FROM inquiries WHERE id = ?" );
		$stmt2->bind_param( "i", $id );
		$stmt2->execute();

		if ( $stmt2->affected_rows > 0 ) {
			echo json_encode( [
				'status' => 'success',
				'message' => 'Inquiry and related follow-ups deleted successfully'
			] );
		} else {
			echo json_encode( [
				'status' => 'error',
				'message' => 'Failed to delete inquiry'
			] );
		}

		exit;
	}
	
	
elseif ($action === 'ImportInquiries') {
	session_start();
    if (!empty($_FILES['file']['tmp_name'])) {
        $file = fopen($_FILES['file']['tmp_name'], 'r');
        $count = 0;
		$assigned_to = $_POST['assigned_to'] ?? ($_SESSION['userid'] ?? 1);
        // Skip header
        fgetcsv($file);

        while (($row = fgetcsv($file, 1000, ",")) !== FALSE) {
            [$name, $phone, $email, $address, $source, $inquiry_type, $remarks] = $row;

            // Check existing customer
            $stmt = $conn->prepare("SELECT id FROM customers WHERE phone=? LIMIT 1");
            $stmt->bind_param("s", $phone);
            $stmt->execute();
            $stmt->bind_result($customer_id);
            if (!$stmt->fetch()) {
                // New customer
                $stmt->close();
                $stmt2 = $conn->prepare("INSERT INTO customers (name, email, phone, address, status, created_at, updated_at)
                                         VALUES (?, ?, ?, ?, 'active', NOW(), NOW())");
                $stmt2->bind_param("ssss", $name, $email, $phone, $address);
                $stmt2->execute();
                $customer_id = $stmt2->insert_id;
                $stmt2->close();
            } else {
                $stmt->close();
            }

            // Insert inquiry
            $stmt3 = $conn->prepare("INSERT INTO inquiries (customer_id, inquiry_type, source, remarks, assigned_to)
                                     VALUES (?, ?, ?, ?, ?)");
            $stmt3->bind_param("isssi", $customer_id, $inquiry_type, $source, $remarks,$assigned_to);
            $stmt3->execute();
            $stmt3->close();

            $count++;
        }
        fclose($file);

        echo json_encode(['status' => 'success', 'message' => "$count inquiries imported successfully."]);
        exit;
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No file uploaded']);
        exit;
    }
}

}
echo json_encode( $response );
if (isset($_GET['action']) && $_GET['action'] === 'ExportInquiries') {
    $type = $_GET['type'] ?? 'package';

    if (ob_get_level()) ob_end_clean();

    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="inquiries_' . $type . '_' . date('Ymd_His') . '.csv"');

    $output = fopen('php://output', 'w');
    fputcsv($output, ['Name', 'Mobile', 'Email', 'Address', 'Source', 'Type', 'Remarks']);

    $query = $conn->query("
        SELECT c.name, c.phone, c.email, c.address, i.source, i.inquiry_type, i.remarks 
        FROM inquiries i
        LEFT JOIN customers c ON i.customer_id = c.id
        WHERE i.inquiry_type = '$type'
        ORDER BY i.id DESC
    ");

    if ($query && $query->num_rows > 0) {
        while ($row = $query->fetch_assoc()) {
            fputcsv($output, $row);
        }
    } else {
        fputcsv($output, ['No data found']);
    }

    fclose($output);
    exit;
}
?>