<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
include '../inc/db.php';

$action = $_POST['action'] ?? '';
$id = intval($_POST['id'] ?? 0);

function responseJSON($status, $message, $extra = []) {
    echo json_encode(array_merge(['status' => $status, 'message' => $message], $extra));
    exit;
}

/* =======================================================
    CREATE BOOKING
   ======================================================= */
if ($action === 'Create') { 
	$inquiry_id        = intval($_POST['inquiry_id'] ?? 0);
    $customer_id       = intval($_POST['customer_id']);
    $booking_date      = $_POST['booking_date'] ?? date('Y-m-d');
    $hotel_city_id     = intval($_POST['hotel_city_id']);
    $hotel_id          = intval($_POST['hotel_id']);
    $meal_plan         = $conn->real_escape_string($_POST['meal_plan'][0] ?? '');
    $hotel_checkin_date  = $_POST['hotel_checkin_date'] ?? null;
	$hotel_checkout_date = $_POST['hotel_checkout_date'] ?? null;
	$hotel_rooms       = intval($_POST['hotel_rooms']);
	$hotel_room_type = $conn->real_escape_string($_POST['hotel_room_type'] ?? '');
	$hotel_adults      = intval($_POST['hotel_adults']);
    $hotel_children    = intval($_POST['hotel_children']);
    $hotel_extrabed    = intval($_POST['hotel_extrabed']);
    $adult_price       = floatval($_POST['adult_price']);
    $child_price       = floatval($_POST['child_price']);
    $extra_bed_price   = floatval($_POST['extra_bed_price']);
	$vehicle_type       = $conn->real_escape_string($_POST['transport_type'] ?? '');
    $transport_charges = floatval($_POST['transport_charges']);
	$extra_charges      = floatval($_POST['extra_charges'] ?? 0);
    $gst_included      = $conn->real_escape_string($_POST['gst_included'] ?? 'no');
    //$gst_rate          = floatval($_POST['gst']);
    $discount          = floatval($_POST['discount']);
    $grand_total       = floatval($_POST['grand_total']);
    $payment_mode      = $conn->real_escape_string($_POST['payment_mode'] ?? 'cash');
    $advance_payment   = floatval($_POST['advance_payment']);
    $useridnew         = intval($_POST['useridnew']);
	
	$upi_id         = $_POST['upi_id'] ?? null;
    $bank_name      = $_POST['bank_name'] ?? null;
    $account_no     = $_POST['account_no'] ?? null;
    $transaction_id = $_POST['transaction_id'] ?? null;

    // Fetch hotel & city names
    $hotel_name = '';
    $city_name  = '';

   $stmt = $conn->prepare("SELECT hotel_name, stars FROM hotels WHERE id = ? LIMIT 1");
$stmt->bind_param("i", $hotel_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $hotel_name = $row['hotel_name'];
    $stars = $row['stars'];
}

    $cityRes = $conn->query("SELECT city_name FROM cities WHERE id='$hotel_city_id' LIMIT 1");
    if ($cityRes && $cityRes->num_rows > 0) {
        $city_name = $conn->real_escape_string($cityRes->fetch_assoc()['city_name']);
    }

    // Generate booking code
    // Company prefix
$prefix = "MTT/";

// Determine current financial year (April–March)
$yearStart = (date('n') >= 4) ? date('y') : date('y') - 1;
$yearEnd   = $yearStart + 1;
$financialYear = $yearStart . '-' . $yearEnd;

// Fetch last booking number for this financial year
$codeQuery = $conn->query("
    SELECT booking_code FROM bookings 
    WHERE booking_code LIKE '%$financialYear%' 
    ORDER BY id DESC LIMIT 1
");

if ($codeQuery && $codeQuery->num_rows > 0) {
    $lastCode = $codeQuery->fetch_assoc()['booking_code'];
    preg_match('/(\d+)$/', $lastCode, $matches);
    $nextNumber = isset($matches[1]) ? intval($matches[1]) + 1 : 1;
} else {
    $nextNumber = 1;
}

// Format new booking code
$booking_code = sprintf("%s%s/%04d", $prefix, $financialYear, $nextNumber);
	
	// --- Base Calculation ---
	$base = ($hotel_rooms * $adult_price) + $child_price + $extra_bed_price; 
	$discount_amt = ($discount > 0) ? ($base * $discount / 100) : 0;
	$after_discount = $base - $discount_amt;
	$gst_rate = 5; // example 5%

	if ($gst_included === 'yes') {
		// GST already included ? extract GST portion
		$gst_amount = round(($after_discount * $gst_rate) / (100 + $gst_rate), 2);
		$base_with_gst = round($after_discount + $gst_amount, 2);
		$total = round($base_with_gst + $transport_charges + $extra_charges, 2);
	} else {
		// GST not included ? do NOT add GST
		$gst_amount = 0;
		$base_without_gst = round($after_discount, 2);
		$total = round($base_without_gst + $transport_charges + $extra_charges, 2);
	}

    // ✅ Determine payment & booking status
    $payment_status = 'unpaid';
    if ($advance_payment > 0 && $advance_payment < $total) {
        $payment_status = 'partial';
    } elseif ($advance_payment >= $total) {
        $payment_status = 'paid';
    }

    $status = 'confirmed';

    // ✅ Insert Booking
     $sql = "
        INSERT INTO bookings (
            inquiry_id, quotation_id, customer_id, booking_type, booking_code, booking_date,
            status, payment_status,hotel_checkin_date,hotel_checkout_date,
            hotel_city_id, hotel_city, hotel_id, hotel_name, hotel_rooms, hotel_adults,
            hotel_children, hotel_extrabed,hotel_room_type, adult_price, child_price, extra_bed_price,
            meal_plan, hotel_type, vehicle_type,transport_charges, discount, gst_rate, gst_included,
            gst_amount, discount_amount, total_amount, paid_amount, payment_mode, created_by,financial_year
        )
        VALUES (
            '$inquiry_id', NULL, '$customer_id', 'hotel', '$booking_code', '$booking_date',
            '$status', '$payment_status','$hotel_checkin_date','$hotel_checkout_date',
            '$hotel_city_id', '$city_name', '$hotel_id', '$hotel_name', '$hotel_rooms', '$hotel_adults',
            '$hotel_children', '$hotel_extrabed','$hotel_room_type', '$adult_price', '$child_price', '$extra_bed_price',
            '$meal_plan', '$stars','$vehicle_type', '$transport_charges', '$discount', '$gst_rate', '$gst_included',
            '$gst_amount', '$discount_amt', '$total', '$advance_payment', '$payment_mode', '$useridnew','$financial_year'
        )
    ";

    if (mysqli_query($conn, $sql)) {
        $booking_id = $conn->insert_id;
		
		// --- NEW PAYMENT ---
        function generateReceiptNo($conn) {
            $month = date('n');
            $year = date('Y');
            $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
            $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
            $nextNumber = 1;
            if ($res && $res->num_rows > 0) {
                $row = $res->fetch_assoc();
                preg_match('/(\d+)$/', $row['receipt_no'], $matches);
                $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
            }
            $formattedNo = str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
            return "RC{$fy_short}-{$formattedNo}";
        }

        $receipt_no = generateReceiptNo($conn);

        // 💰 Insert payment record if advance paid
        if ($advance_payment > 0) {
          $p_sql = "
        INSERT INTO payments 
        (booking_id, customer_id, payment_type, amount, mode, transaction_id, 
         receipt_no, reference_no, bank_name, account_no, upi_id, narration, received_by, 
         financial_year, status)
        VALUES (
            '$booking_id', '$customer_id', 'received', '$advance_payment', '$payment_mode', '$transaction_id',
            '$receipt_no', NULL, '$bank_name', '$account_no', '$upi_id', 'Hotel Booking',
            '$useridnew', '$financial_year', 'completed'
        )
    ";
            mysqli_query($conn, $p_sql);
        }
		if (!empty($inquiry_id) && $inquiry_id > 0) {
        $conn->query("UPDATE inquiries SET status = 'closed' WHERE id = '$inquiry_id'");
    }

        responseJSON('success', 'Booking created successfully.', [
            'id' => $booking_id,
            'gst_included' => $gst_included
        ]);
    } else {
        responseJSON('error', 'Failed to create booking: ' . mysqli_error($conn));
    }
}

/* =======================================================
    UPDATE BOOKING
   ======================================================= */
elseif ($action === 'Update' && $id > 0) {

    $inquiry_id        = intval($_POST['inquiry_id'] ?? 0);
    $customer_id       = intval($_POST['customer_id']);
    $booking_date      = $_POST['booking_date'] ?? date('Y-m-d');
    $hotel_city_id     = intval($_POST['hotel_city_id']);
    $hotel_id          = intval($_POST['hotel_id']);
    $meal_plan         = $conn->real_escape_string($_POST['meal_plan'][0] ?? '');
    $hotel_checkin_date  = $_POST['hotel_checkin_date'] ?? null;
	$hotel_checkout_date = $_POST['hotel_checkout_date'] ?? null;
	$hotel_rooms       = intval($_POST['hotel_rooms']);
	$hotel_room_type = $conn->real_escape_string($_POST['hotel_room_type'] ?? '');
	$hotel_adults      = intval($_POST['hotel_adults']);
    $hotel_children    = intval($_POST['hotel_children']);
    $hotel_extrabed    = intval($_POST['hotel_extrabed']);
    $adult_price       = floatval($_POST['adult_price']);
    $child_price       = floatval($_POST['child_price']);
    $extra_bed_price   = floatval($_POST['extra_bed_price']);
	$vehicle_type       = $conn->real_escape_string($_POST['transport_type'] ?? '');
    $transport_charges = floatval($_POST['transport_charges']);
	$extra_charges      = floatval($_POST['extra_charges'] ?? 0);
    $gst_included      = $conn->real_escape_string($_POST['gst_included'] ?? 'no');
    //$gst_rate          = floatval($_POST['gst']);
    $discount          = floatval($_POST['discount']);
    $grand_total       = floatval($_POST['grand_total']);
    $payment_mode      = $conn->real_escape_string($_POST['payment_mode'] ?? 'cash');
    $advance_payment   = floatval($_POST['advance_payment']);
    $useridnew         = intval($_POST['useridnew']);
	
	$upi_id         = $_POST['upi_id'] ?? null;
    $bank_name      = $_POST['bank_name'] ?? null;
    $account_no     = $_POST['account_no'] ?? null;
    $transaction_id = $_POST['transaction_id'] ?? null;

    // Fetch hotel & city names
    $hotel_name = '';
    $city_name  = '';

   $stmt = $conn->prepare("SELECT hotel_name, stars FROM hotels WHERE id = ? LIMIT 1");
$stmt->bind_param("i", $hotel_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $hotel_name = $row['hotel_name'];
    $stars = $row['stars'];
}

    $cityRes = $conn->query("SELECT city_name FROM cities WHERE id='$hotel_city_id' LIMIT 1");
    if ($cityRes && $cityRes->num_rows > 0) {
        $city_name = $conn->real_escape_string($cityRes->fetch_assoc()['city_name']);
    }

	// --- Base Calculation ---
	$base = ($hotel_rooms * $hotel_adults) + $hotel_children + $hotel_extrabed;
	$discount_amt = ($discount > 0) ? ($base * $discount / 100) : 0;
	$after_discount = $base - $discount_amt;
	$gst_rate = 5; // example 5%

	if ($gst_included === 'yes') {
		// GST already included ? extract GST portion
		$gst_amount = round(($after_discount * $gst_rate) / (100 + $gst_rate), 2);
		$base_with_gst = round($after_discount + $gst_amount, 2);
		$total = round($base_with_gst + $transport_charges + $extra_charges, 2);
	} else {
		// GST not included ? do NOT add GST
		$gst_amount = 0;
		$base_without_gst = round($after_discount, 2);
		$total = round($base_without_gst + $transport_charges + $extra_charges, 2);
	}

    // ✅ Determine payment & booking status
    $payment_status = 'unpaid';
    if ($advance_payment > 0 && $advance_payment < $total) {
        $payment_status = 'partial';
    } elseif ($advance_payment >= $total) {
        $payment_status = 'paid';
    }

    // ✅ Determine payment & booking status
    $payment_status = 'unpaid';
    if ($advance_payment > 0 && $advance_payment < $total_amount) {
        $payment_status = 'partial';
    } elseif ($advance_payment >= $total_amount) {
        $payment_status = 'paid';
    }

    // Update booking
    $stmt = $conn->prepare("
        UPDATE bookings SET 
            hotel_rooms=?, adult_price=?, child_price=?, extra_bed_price=?, transport_charges=?, 
            discount=?, gst_rate=?, gst_included=?, total_amount=?, paid_amount=?, payment_mode=?, 
            updated_at=NOW()
        WHERE id=?
    ");
    $stmt->bind_param(
        'iddddddssdsi',
        $hotel_rooms, $adult_price, $child_price, $extra_bed_price, $transport_charges,
        $discount, $gst_rate, $gst_included, $total_amount, $advance_payment, $payment_mode, $id
    );

    if ($stmt->execute()) {
        // Reset old payments and insert updated advance
        $conn->query("DELETE FROM payments WHERE booking_id = '$id'");

        if ($advance_payment > 0) {
            $pstmt = $conn->prepare("
                INSERT INTO payments (booking_id, customer_id, amount, mode, payment_type, received_by)
                VALUES (?, ?, ?, ?, 'received', ?)
            ");
            $pstmt->bind_param('iidss', $id, $customer_id, $advance_payment, $payment_mode, $useridnew);
            $pstmt->execute();
        }

        responseJSON('success', 'Booking updated successfully.', ['id' => $id]);
    } else {
        responseJSON('error', 'Failed to update booking.');
    }
}

/* =======================================================
    SELECT BOOKING
   ======================================================= */
elseif ($action === 'Select' && $id > 0) {
    $result = $conn->query("SELECT * FROM bookings WHERE id='$id' LIMIT 1");
    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_assoc();
        responseJSON('success', 'Booking fetched successfully.', ['data' => $data]);
    } else {
        responseJSON('error', 'Booking not found.');
    }
}

/* =======================================================
    FETCH FOR DATATABLE
   ======================================================= */
elseif ($action === 'fetch') {
    $draw   = intval($_POST['draw'] ?? 1);
    $start  = intval($_POST['start'] ?? 0);
    $length = intval($_POST['length'] ?? 25);
    $search = $_POST['search']['value'] ?? '';

    $where = "WHERE b.booking_type = 'hotel'";
    if (!empty($search)) {
        $search = $conn->real_escape_string($search);
        $where = "WHERE (
            b.booking_code LIKE '%$search%' OR
            b.hotel_name LIKE '%$search%' OR
            c.name LIKE '%$search%' OR
            c.phone LIKE '%$search%'
        )";
    }

    //  Total records
    $totalQuery = $conn->query("SELECT COUNT(*) AS total FROM bookings WHERE booking_type = 'hotel'");
    $totalData  = $totalQuery->fetch_assoc()['total'];

    //  Main query with last payment info using LEFT JOIN + subquery
    $query = "
        SELECT 
            b.id, b.customer_id, b.booking_code, b.booking_date, b.hotel_name, b.hotel_checkin_date, b.hotel_checkout_date, b.hotel_city,
            b.total_amount, b.paid_amount,
            (b.total_amount - b.paid_amount) AS due_amount,
            c.name AS customer_name, c.phone AS customer_phone,
            p.last_payment_date, p.last_payment_type, p.last_payment_amount
        FROM bookings b
        LEFT JOIN customers c ON c.id = b.customer_id
        LEFT JOIN (
            SELECT 
                booking_id,
                MAX(payment_date) AS last_payment_date,
                SUBSTRING_INDEX(GROUP_CONCAT(payment_type ORDER BY payment_date DESC), ',', 1) AS last_payment_type,
                SUBSTRING_INDEX(GROUP_CONCAT(amount ORDER BY payment_date DESC), ',', 1) AS last_payment_amount
            FROM payments
            WHERE status = 'completed'
            GROUP BY booking_id
        ) p ON p.booking_id = b.id
        $where
        ORDER BY b.id DESC
        LIMIT $start, $length
    ";
    $result = $conn->query($query);

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $due   = floatval($row['due_amount']);
        $total = floatval($row['total_amount']);

        //  Determine payment status
        if ($due <= 0) {
            $statusBadge = '<span class="badge bg-success">Paid</span>';
            $paymentBtn = '';
        } else {
            $statusBadge = ($due < $total)
                ? '<span class="badge bg-warning text-dark">Partial</span>'
                : '<span class="badge bg-danger">Unpaid</span>';

            $paymentBtn = '
                <div class="mb-1">
                    <button class="btn btn-xs btn-success changeStatusBtn" 
                        data-id="' . $row['id'] . '" 
                        data-customer_id="' . $row['customer_id'] . '" 
                        data-total_amount="' . $row['total_amount'] . '" 
						data-balance_amount="' . $row['due_amount'] . '" 
                        data-gst_included="yes"
                        title="Add Payment">
                        <i class="far fa-rupee-sign"></i>
                    </button>
                </div>';
            
            //  Add last payment info (if available)
            if (!empty($row['last_payment_date'])) {
                $statusBadge .= '<br>
                    <small class="text-muted">
                        Last: ' . date('d-m-Y', strtotime($row['last_payment_date'])) . '<br>
                        ' . ucfirst($row['last_payment_type']) . ': ₹' . number_format($row['last_payment_amount'], 2) . '
                    </small>';
            }
        }

        //  Action buttons
        $actions = '
            ' . $paymentBtn . '
            <button class="btn btn-xs btn-info download" data-id="' . $row['id'] . '" title="Download PDF">
                <i class="far fa-file-pdf"></i>
            </button>
            <button class="btn btn-xs btn-danger delete" id="' . $row['id'] . '" title="Delete Booking">
                <i class="far fa-trash-alt"></i>
            </button>
        ';

        $data[] = [
            'booking_date'   => date('d-m-Y', strtotime($row['booking_date'])),
            'booking_code'   => htmlspecialchars($row['booking_code']),
            'customer_name'  => '<a href="hotel_booking_details.php?book_id=' . intval($row['id']) . '">'
                     . ($row['customer_name'] ?? '') . 
                   '</a>',
            'customer_phone' => htmlspecialchars($row['customer_phone']),
            'hotel_name'     => htmlspecialchars($row['hotel_name']),
			'hotel_city'   => htmlspecialchars($row['hotel_city']),
			'checkin_checkout' => (
    !empty($row['hotel_checkin_date']) && !empty($row['hotel_checkout_date'])
        ? date('d-m-Y', strtotime($row['hotel_checkin_date'])) . '<br>' . date('d-m-Y', strtotime($row['hotel_checkout_date']))
        : '-'
),

            'total_amount'   => number_format($row['total_amount'], 2),
            'due_amount'     => number_format($row['due_amount'], 2),
            'payment_status' => $statusBadge,
            'action'         => $actions
        ];
    }

    echo json_encode([
        'draw'            => $draw,
        'recordsTotal'    => $totalData,
        'recordsFiltered' => !empty($search) ? count($data) : $totalData,
        'data'            => $data
    ]);
    exit;
}


elseif ($action === 'savepayment') {
    $booking_id   = intval($_POST['booking_id'] ?? 0);
    $customer_id  = intval($_POST['customer_id'] ?? 0);
    $amount       = floatval($_POST['amount'] ?? 0);
    $mode         = $conn->real_escape_string($_POST['payment_mode'] ?? 'cash');
    $upi_id       = $conn->real_escape_string($_POST['upi_id'] ?? '');
    $reference_no = $conn->real_escape_string($_POST['transaction_id'] ?? '');
    $bank_name    = $conn->real_escape_string($_POST['bank_name'] ?? '');
    $narration    = $conn->real_escape_string($_POST['narration'] ?? '');
    $received_by  = intval($_POST['received_by'] ?? 0);

    if ($booking_id <= 0 || $amount <= 0) {
        responseJSON('error', 'Invalid booking or amount.');
    }

    // --- Fetch booking ---
    $bq = $conn->query("SELECT total_amount, paid_amount FROM bookings WHERE id = $booking_id LIMIT 1");
    if (!$bq || $bq->num_rows == 0) {
        responseJSON('error', 'Booking not found.');
    }
    $b = $bq->fetch_assoc();
    $balance = $b['total_amount'] - $b['paid_amount'];

    if ($amount > $balance) {
        responseJSON('error', 'Received amount cannot be greater than balance amount.');
    }

    // --- Generate Receipt No ---
    function generateReceiptNo($conn) {
        $month = date('n');
        $year = date('Y');
        $fy_short = ($month < 4) ? substr($year - 1, 2) : substr($year, 2);
        $res = $conn->query("SELECT receipt_no FROM payments WHERE receipt_no LIKE 'RC{$fy_short}-%' ORDER BY id DESC LIMIT 1");
        $nextNumber = 1;
        if ($res && $res->num_rows > 0) {
            $row = $res->fetch_assoc();
            preg_match('/(\d+)$/', $row['receipt_no'], $matches);
            $nextNumber = isset($matches[1]) ? ((int)$matches[1] + 1) : 1;
        }
        $formattedNo = str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
        return "RC{$fy_short}-{$formattedNo}";
    }

    $receipt_no = generateReceiptNo($conn);

    // --- Save Payment ---
    $stmt = $conn->prepare("
        INSERT INTO payments 
        (booking_id, customer_id, amount, mode, upi_id, reference_no, bank_name, narration, receipt_no, payment_type, received_by, status, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'received', ?, 'completed', NOW())
    ");
    $stmt->bind_param('iidssssssi', $booking_id, $customer_id, $amount, $mode, $upi_id, $reference_no, $bank_name, $narration, $receipt_no, $received_by);

    if ($stmt->execute()) {
        $payment_id = $conn->insert_id;

        // --- Update booking ---
        $conn->query("UPDATE bookings 
                      SET paid_amount = paid_amount + $amount, 
                          payment_status = CASE 
                              WHEN paid_amount + $amount >= total_amount THEN 'paid'
                              WHEN paid_amount + $amount > 0 THEN 'partial'
                              ELSE 'unpaid'
                          END
                      WHERE id = $booking_id");

        responseJSON('success', 'Payment added successfully.', ['payment_id' => $payment_id]);
    } else {
        responseJSON('error', 'Failed to save payment: ' . $conn->error);
    }
}


/* =======================================================
   ❌ DELETE BOOKING
   ======================================================= */
elseif ($action === 'Delete' && $id > 0) {
    $conn->query("DELETE FROM payments WHERE booking_id = '$id'");
    $conn->query("DELETE FROM bookings WHERE id = '$id'");
    responseJSON('Delete', 'Booking deleted successfully.');
}

/* =======================================================
   ⚠️ INVALID ACTION
   ======================================================= */
else {
    responseJSON('error', 'Invalid action or missing parameters.');
}
?>
