<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php'; 

if (isset($_POST['package_id'])) {
    $package_id = intval($_POST['package_id']);
    
    $stmt = $conn->prepare("SELECT price_per_person as price FROM packages WHERE id = ? AND status = 'active'");
    
    if (!$stmt) {
        // If prepare fails, show the exact SQL error
        die('Prepare failed: ' . $conn->error);
    }

    $stmt->bind_param("i", $package_id);
    $stmt->execute();
    $stmt->bind_result($price);
    $stmt->fetch();
    echo $price ?: 0;
    $stmt->close();
}
?>
