<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../TCPDF/tcpdf.php';

// =============================
// Helper: Indian Number Format
// =============================
function indian_number_format($num, $decimals = 2) {
    $exploded = explode(".", number_format($num, $decimals, ".", ""));
    $whole = $exploded[0];
    $decimal = isset($exploded[1]) ? $exploded[1] : '';
    $last3 = substr($whole, -3);
    $rest = substr($whole, 0, -3);
    if ($rest != '') {
        $rest = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $rest);
        $whole = $rest . "," . $last3;
    }
    return $decimal ? $whole . "." . $decimal : $whole;
}

// =============================
// PDF CLASS
// =============================
class FlightInvoicePDF extends TCPDF {
    public function Header() {
        $this->Image(__DIR__ . '/../assets/img/logo.png', 12, 10, 40);
        $this->SetFont('dejavusans', '', 8);
        $this->SetXY(140, 10);
        $this->MultiCell(60, 5,
            "GST No: 27ABCDE1234F1Z5\nMobile: +91 98255 59080\nEmail: mytreasuretrip@gmail.com",
            0, 'R', false
        );

        $this->Line(10, 30, 200, 30);
        $this->Ln(5);
        $this->SetFont('dejavusans', 'B', 13);
        $this->SetTextColor(10, 69, 110);
        $this->Cell(0, 23, 'FLIGHT BOOKING INVOICE', 0, 1, 'C');
        $this->SetTextColor(0, 0, 0);
        $this->Line(10, 43, 200, 43);
        $this->Ln(4);
    }

    public function Footer() {
        $this->SetY(-20);
        $this->SetDrawColor(12, 69, 110);
        $this->Line(10, $this->GetY(), 200, $this->GetY());
        $this->Ln(2);
        $this->SetFont('dejavusans', '', 8);
        $this->SetTextColor(80, 80, 80);
        $this->MultiCell(0, 5,
            "My Treasure Trip | 17, Suman Sajni Society, Near Jayant Park, Ghodasar, Ahmedabad\n" .
            "Mobile: +91 98255 59080 | Email: mytreasuretrip@gmail.com | GST: 27ABCDE1234F1Z5",
            0, 'C', false
        );
    }

    public function sectionTitle($title) {
        $this->Ln(3);
        $this->SetFont('dejavusans', 'B', 10);
        $this->SetFillColor(12, 69, 110);
        $this->SetTextColor(255, 255, 255);
        $this->Cell(0, 7, "  " . strtoupper($title), 0, 1, 'L', true);
        $this->SetTextColor(0, 0, 0);
        $this->Ln(2);
    }
}

// =============================
// FETCH BOOKING DATA
// =============================
$booking_id = intval($_GET['id'] ?? 0);
$query = "
SELECT b.*, c.name AS customer_name, c.email AS customer_email, c.phone AS customer_phone, c.address AS customer_address
FROM bookings b
LEFT JOIN customers c ON c.id = b.customer_id
WHERE b.id = $booking_id
";
$result = $conn->query($query);
$booking = $result->fetch_assoc();

if (!$booking) die("Booking not found.");

// Fetch Payments
$payment_query = "
SELECT * FROM payments 
WHERE booking_id = '$booking_id' 
AND status = 'completed' 
ORDER BY payment_date ASC";
$payments = $conn->query($payment_query);

// =============================
// CREATE PDF
// =============================
$pdf = new FlightInvoicePDF();
$pdf->SetMargins(10, 50, 10);
$pdf->AddPage();
$pdf->SetFont('dejavusans', '', 9);
$rupee = '₹';

// =============================
// SECTION: Customer & Booking
// =============================
$pdf->sectionTitle("Customer & Booking Details");

$html = '
<style>
td strong { font-weight: bold; color: #0a456e; }
</style>
<table cellpadding="5" border="0.5" width="100%">
<tr>
<td width="50%">
<strong>Name:</strong> ' . ucwords($booking['customer_name']) . '<br/>
<strong>Phone:</strong> ' . $booking['customer_phone'] . '<br/>
<strong>Email:</strong> ' . $booking['customer_email'] . '<br/>
<strong>Address:</strong> ' . ucwords($booking['customer_address']) . '
</td>
<td width="50%">
<strong>Booking No:</strong> ' . $booking['booking_code'] . '<br/>
<strong>Booking Date:</strong> ' . date('d-m-Y', strtotime($booking['booking_date'])) . '<br/>
<strong>Status:</strong> ' . ucfirst($booking['status']) . '<br/>
<strong>Payment Status:</strong> ' . ucfirst($booking['payment_status']) . '
</td>
</tr>
</table>';
$pdf->writeHTML($html, true, false, false, false, '');

// =============================
// SECTION: Departure Details
// =============================
$pdf->sectionTitle("Departure Flight Details");

$departure_html = '
<style>
th { background-color:#f0f8ff; color:#0a456e; font-weight:bold; text-align:center; }
</style>
<table cellpadding="5" border="0.5" width="100%">
<tr>
<th>From</th><th>To</th><th>Airline</th><th>Flight No</th><th>Departure Date</th><th>Class</th>
</tr>
<tr>
<td align="center">' . strtoupper($booking['flight_from_city']) . '</td>
<td align="center">' . strtoupper($booking['flight_to_city']) . '</td>
<td align="center">' . strtoupper($booking['flight_departure_name'] ?: '-') . '</td>
<td align="center">' . strtoupper($booking['flight_departure_no'] ?: '-') . '</td>
<td>' . ($booking['flight_departure_date'] ? date('d-m-Y', strtotime($booking['flight_departure_date'])) : '-') . '</td>
<td align="center">' . strtoupper($booking['flight_class']) . '</td>
</tr>
<tr>
<td colspan="2"><strong>Adults:</strong> ' . ($booking['flight_adult'] ?? 0) . '</td>
<td colspan="2"><strong>Children:</strong> ' . ($booking['flight_child'] ?? 0) . '</td>
<td colspan="2"><strong>Infants:</strong> ' . ($booking['flight_infant'] ?? 0) . '</td>
</tr>
</table>';
$pdf->writeHTML($departure_html, true, false, false, false, '');

// =============================
// SECTION: Return Details
// =============================
if (!empty($booking['flight_return_date'])) {
    $pdf->sectionTitle("Return Flight Details");

    $return_html = '
    <table cellpadding="5" border="0.5" width="100%">
    <tr style="background-color:#f0f8ff; font-weight:bold; color:#0a456e;">
    <td>From</td><td>To</td><td>Airline</td><td>Flight No</td><td>Return Date</td><td>Class</td>
    </tr>
    <tr>
    <td>' . strtoupper($booking['flight_to_city']) . '</td>
    <td>' . strtoupper($booking['flight_from_city']) . '</td>
    <td>' . strtoupper($booking['flight_return_name'] ?: '-') . '</td>
    <td>' . strtoupper($booking['flight_return_no'] ?: '-') . '</td>
    <td>' . date('d-m-Y', strtotime($booking['flight_return_date'])) . '</td>
    <td>' . strtoupper($booking['flight_class']) . '</td>
    </tr>
    </table>';
    $pdf->writeHTML($return_html, true, false, false, false, '');
}

// =============================
// SECTION: Pricing Summary
// =============================
$pdf->sectionTitle("Payment Summary");

$discount = floatval($booking['discount_amount']);
$gst = floatval($booking['gst_amount']);
$total = floatval($booking['total_amount']);
$paid = floatval($booking['paid_amount']);
$balance = floatval($booking['balance_amount']);
$extra = floatval($booking['extra_charges']);
$transport_charges = floatval($booking['transport_charges']);
$gst_rate = floatval($booking['gst_rate']);

$pricing_html = '
<table cellpadding="5" border="0.5" width="100%">
<tr><td><strong>Base Fare</strong></td><td align="right">'.$rupee.' '.indian_number_format($transport_charges).'</td></tr>';

if ($extra > 0)
    $pricing_html .= '<tr><td><strong>Extra Charges</strong></td><td align="right">'.$rupee.' '.indian_number_format($extra).'</td></tr>';

if ($discount > 0)
    $pricing_html .= '<tr><td><strong>Discount</strong></td><td align="right">-'.$rupee.' '.indian_number_format($discount).'</td></tr>';

if ($gst > 0)
    $pricing_html .= '<tr><td><strong>GST ('.$gst_rate.'%)</strong></td><td align="right">'.$rupee.' '.indian_number_format($gst).'</td></tr>';

$pricing_html .= '
<tr style="background-color:#f9f9f9; font-weight:bold; color:#0a456e;">
    <td>Total Amount</td><td align="right">'.$rupee.' '.indian_number_format($total).'</td>
</tr>
<tr><td><strong>Paid Amount</strong></td><td align="right">'.$rupee.' '.indian_number_format($paid).'</td></tr>
<tr style="font-weight:bold; color:#0c456e;">
    <td>Balance Amount</td><td align="right">'.$rupee.' '.indian_number_format($balance).'</td>
</tr>
</table>';

$pdf->writeHTML($pricing_html, true, false, false, false, '');

// =============================
// OUTPUT PDF
// =============================
$pdf->Output('flight_invoice_' . $booking['booking_code'] . '.pdf', 'I');
?>
