<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../TCPDF/tcpdf.php';

// ====== CUSTOM RECEIPT CLASS ======
class MYPDF extends TCPDF {
    public function Header() {
        // Logo & Company Info
        $this->Image(__DIR__ . '/../assets/img/logo.png', 12, 8, 35);
        $this->SetFont('helvetica', '', 9);
        $this->SetXY(130, 8);
        $this->MultiCell(70, 5,
            "My Treasure Trip\nGhodasar, Ahmedabad - 380050\n+91 98255 59080 | mytreasuretrip@gmail.com\nGST: 27ABCDE1234F1Z5",
            0, 'R'
        );

        $this->Ln(18);
        $this->SetFont('helvetica', 'B', 13);
        $this->Cell(0, 8, 'PAYMENT RECEIPT', 0, 1, 'C');
        $this->Line(10, 33, 200, 33);
    }

    public function Footer() {
        $this->SetY(-18);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'This is a computer-generated receipt. No signature required.', 0, 0, 'C');
    }
}

// ====== INDIAN CURRENCY FORMAT ======
function indian_number_format($num) {
    $num = number_format($num, 2, '.', '');
    $x = explode('.', $num);
    $x1 = $x[0];
    $x2 = isset($x[1]) ? '.' . $x[1] : '';
    $last3 = substr($x1, -3);
    $rest = substr($x1, 0, -3);
    if ($rest != '') $rest = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $rest) . ",";
    return $rest . $last3 . $x2;
}

// ====== FETCH PAYMENT DATA ======
$payment_id = (int)($_GET['payment_id'] ?? 0);
$sql = "
SELECT p.*, 
       b.booking_code, b.total_amount, b.package_name, b.package_start_date, b.package_end_date, 
       c.name AS customer_name, c.phone AS customer_phone, c.email AS customer_email, c.address AS customer_address
FROM payments p
LEFT JOIN bookings b ON p.booking_id = b.id
LEFT JOIN customers c ON p.customer_id = c.id
WHERE p.id = $payment_id
";
$res = $conn->query($sql);
$data = $res->fetch_assoc();
if (!$data) die("Payment not found!");

// ====== PDF SETTINGS ======
$pdf = new MYPDF('P', 'mm', 'A4', true, 'UTF-8', false);
$pdf->SetMargins(15, 40, 15);
$pdf->SetAutoPageBreak(true, 20);
$pdf->AddPage();
$pdf->SetFont('helvetica', '', 10);

// ====== CONTENT ======
$html = '
<style>
table { width:100%; border-collapse:collapse; }
th, td { padding:7px; font-size:10pt; vertical-align:top; }
.section-title {
    background-color:#004b91;
    color:#fff;
    font-weight:bold;
    text-align:center;
    letter-spacing:0.5px;
}
.bold { font-weight:bold; }
td b { color:#000; }
.main-box {
    border:1px solid #000;
    padding:10px;
    margin-top:5px;
}
</style>

<div class="main-box">
<table border="1" cellpadding="6">
  <tr>
    <td width="65%">
      <b>Customer Name:</b> ' . htmlspecialchars($data['customer_name']) . '<br>
      <b>Mobile:</b> ' . htmlspecialchars($data['customer_phone']) . '<br>
      <b>Email:</b> ' . htmlspecialchars($data['customer_email']) . '<br>
      <b>Address:</b> ' . htmlspecialchars($data['customer_address']) . '
    </td>
    <td width="35%">
      <b>Receipt No:</b> ' . htmlspecialchars($data['receipt_no']) . '<br>
      <b>Date:</b> ' . date('d M Y', strtotime($data['payment_date'])) . '<br>
      <b>Mode:</b> ' . strtoupper($data['mode']) . '
    </td>
  </tr>
</table><br>

<table border="1">
  <tr><th colspan="2" class="section-title">PAYMENT DETAILS</th></tr>
  <tr><td width="50%"><b>Amount Received:</b></td><td width="50%">₹ ' . indian_number_format($data['amount']) . '</td></tr>';

if ($data['mode'] == 'upi') {
    $html .= '<tr><td><b>UPI ID:</b></td><td>' . htmlspecialchars($data['upi_id']) . '</td></tr>';
} elseif ($data['mode'] == 'bank') {
    $html .= '<tr><td><b>Bank Name:</b></td><td>' . htmlspecialchars($data['bank_name']) . '</td></tr>';
    $html .= '<tr><td><b>Account No:</b></td><td>' . htmlspecialchars($data['account_no']) . '</td></tr>';
} elseif (in_array($data['mode'], ['card', 'online'])) {
    $html .= '<tr><td><b>Transaction ID:</b></td><td>' . htmlspecialchars($data['transaction_id']) . '</td></tr>';
}

$html .= '
  <tr><td><b>Remarks:</b></td><td>' . (!empty($data['narration']) ? htmlspecialchars($data['narration']) : 'N/A') . '</td></tr>
</table><br>


<table width="100%">
  <tr>
    <td width="50%"><b>Customer Signature</b></td>
    <td width="50%" align="right"><b>Authorized Signatory</b></td>
  </tr>
</table>
</div>
';

// ====== OUTPUT PDF ======
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output('Payment_Receipt_' . $data['receipt_no'] . '.pdf', 'I');
?>
