<?php include('inc/template.php');?>

<div class="container-fluid flex-grow-1 container-p-y">
<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
    <li class="breadcrumb-item active">City Master</li>
    </ol>
</nav>
    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#basicModal">
        <span class="ti-xs ti ti-plus me-1"></span> Add New City
    </button>
    <div class="row mb-4">
                <!--  Modal -->
        <div class="modal fade" id="basicModal" tabindex="-1" aria-labelledby="basicModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <form id="salesForm">
                        <div class="modal-header">
                            <h5 class="modal-title" id="basicModalLabel">Add/Edit City </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" id="role" name="role" value="sales" />
							<div class="row">
                                <div class="col mb-3">
                                    <label for="country" class="form-label">State</label>
									<select name="state_id" id="state_id" required class="select2 form-select form-select-lg">
								  <option value="">Select State</option>
								  <?php 
									$result = $conn->query("SELECT id, state_name FROM states WHERE status = '1' ORDER BY state_name ASC");

									while ($row = $result->fetch_assoc()) {
										$state_name = htmlspecialchars(ucwords(strtolower($row['state_name'])));
										echo '<option value="' . $row['id'] . '">' . $state_name . '</option>';
									}
								  ?>
								</select>

                                   
                                </div>
                            </div>
                            <!-- Name -->
                            <div class="row">
                                <div class="col mb-3">
                                    <label for="state_name" class="form-label">City Name</label>
                                    <input type="text" id="city_name" name="city_name" class="form-control"  required />
                                </div>
                            </div>
							
                            

                            <!-- Password -->
                            
                        </div>
                        <div class="modal-footer">
                            <input type="hidden" name="id" id="id" />
                            <input type="hidden" name="action" id="action" value="CreateCity" />
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="col-xl-12 col-lg-6 col-md-6">
            <div class="card">
                <div class="card-datatable table-responsive pt-0">
                    <table class="datatables-ajax table table-bordered table-responsive">
                        <thead>
                            <tr>
                                <th>#</th>
								<th>City</th>
                                <th>State</th>
                                <th>Country</th>
                               	<th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
							$n=0;
                            $result = mysqli_query($conn, "SELECT c.id AS city_id, c.city_name, c.state_id, s.state_name, s.country, c.status FROM cities c INNER JOIN states s ON c.state_id = s.id WHERE c.status = '1' AND s.status = '1' ORDER BY s.state_name ASC, c.city_name ASC");
                            while ($row = mysqli_fetch_array($result)) { $n++;
                            ?>
                            <tr class="showtr">
                                <td><?php echo htmlspecialchars($n); ?></td>
								<td><?php echo htmlspecialchars($row['city_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['state_name']); ?></td>
								<td><?php echo htmlspecialchars($row['country']); ?></td>
                                								
                                <td>
                                    <label class="switch">
                                        <input type="checkbox" class="switch-input" value="<?php echo $row[0]; ?>"
                                               <?php if ($row['status'] == '1') echo "checked"; ?>
                                               onClick="statusChange(this.value);" />
                                        <span class="switch-toggle-slider">
                                            <span class="switch-on"></span>
                                            <span class="switch-off"></span>
                                        </span>
                                    </label>
                                </td>
                                <td>
									
									<button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-warning update"><i class="far fa-edit"></i></button>
                   				 <button type="button" id="<?php echo $row[0]; ?>" class="btn btn-xs btn-danger delete"><i class="far fa-trash-alt"></i></button>
                                   
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function () {

    // Show modal for Create
    $('#basicModal').on('show.bs.modal', function () {
        if ($('#action').val() === 'CreateCity') {
            $('#salesForm')[0].reset();
            $('.modal-title').text("Add New City");
        }
    });

    // Show modal for Update
    $(document).on('click', '.update', function () {
        const id = $(this).attr("id");
        $.ajax({
            url: "controller/StateCityController.php",
            method: "POST",
            data: { id: id, action: 'SelectCity' },
            dataType: "json",
            success: function (data) {
                $('#city_name').val(data.city_name);
                $('#state_id').val(data.state_id);
                $('#id').val(id);
                $('#action').val('UpdateCity');
                $('.modal-title').text("Update City");
                $('#basicModal').modal('show');
            },
            error: function () {
                toastr.error('Error fetching data.');
            }
        });
    });

    // Submit form for Create or Update
    $('#salesForm').on('submit', function (e) {
        e.preventDefault();

        const formData = {
            city_name: $('#city_name').val(),
            state_id: $('#state_id').val(),
            action: $('#action').val(),
            id: $('#id').val()
        };

        if (formData.city_name && formData.state_id) {
            $.ajax({
                url: "controller/StateCityController.php",
                method: "POST",
                data: formData,
                dataType: "json",
                success: function (response) {
                    $('#basicModal').modal('hide');
                    if (response.status === 'success') {
                        toastr.success(response.message);
                        setTimeout(() => location.reload(), 1000); // reload table
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Error processing request.');
                }
            });
        } else {
            toastr.error("Please fill all required fields.");
        }
    });

    // Status change
    window.statusChange = function (id) {
        $.ajax({
            url: 'controller/StateCityController.php',
            method: 'POST',
            data: { id: id, action: 'CityToggleStatus' },
            dataType: "json",
            success: function (response) {
                if (response.status === 'success') {
                    const newStatus = response.new_status === "1" ? "Active" : "Inactive";
                    toastr.success(`Status changed to ${newStatus}`);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function () {
                toastr.error('Failed to update status.');
            }
        });
    };

    // Delete city
    $(document).on('click', '.delete', function () {
        const id = $(this).attr("id");
        const row = $(this).closest('tr');

        if (confirm('Are you sure you want to delete this city?')) {
            $.ajax({
                url: 'controller/StateCityController.php',
                method: 'POST',
                data: { id: id, action: 'DeleteCity' },
                dataType: "json",
                success: function (response) {
                    if (response.status === 'success') {
                        toastr.success(response.message);
                        row.css('background-color', '#f8d7da').fadeOut(800, function () {
                            $(this).remove();
                        });
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function () {
                    toastr.error('Error deleting city.');
                }
            });
        }
    });

});
</script>


<?php include('inc/footer.php');?>