<?php include('inc/template.php'); ?>
<div class="container-fluid flex-grow-1 container-p-y">

  <!-- Breadcrumb -->
  <nav aria-label="breadcrumb">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.php">Home</a></li>
      <li class="breadcrumb-item active">Booking Type Wise Report</li>
    </ol>
  </nav>

  <div class="card shadow-sm">
    <div class="card-body">

      <h5 class="card-title mb-4"><i class="ti ti-report me-2"></i>Booking Type Wise Report</h5>

      <!-- 🔹 Filter Form -->
      <form class="row g-3 mb-4" method="GET">
        <div class="col-md-3">
          <label for="from_date" class="form-label">From Date</label>
          <input type="date" id="from_date" name="from_date" class="form-control"
                 value="<?= htmlspecialchars($_GET['from_date'] ?? '') ?>">
        </div>
        <div class="col-md-3">
          <label for="to_date" class="form-label">To Date</label>
          <input type="date" id="to_date" name="to_date" class="form-control"
                 value="<?= htmlspecialchars($_GET['to_date'] ?? '') ?>">
        </div>
        <div class="col-md-3 align-self-end">
          <button type="submit" class="btn btn-primary w-100"><i class="ti ti-filter me-1"></i> Filter</button>
        </div>
        <div class="col-md-3 align-self-end">
          <a href="booking_type_report.php" class="btn btn-secondary w-100"><i class="ti ti-refresh me-1"></i> Reset</a>
        </div>
      </form>

      <!-- 🔹 Report Table -->
      <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle text-center">
          <thead class="table-light">
            <tr>
              <th>Booking Type</th>
              <th>Total Bookings</th>
              <th>Total Amount (₹)</th>
              <th>Paid Amount (₹)</th>
              <th>Pending Amount (₹)</th>
            </tr>
          </thead>
          <tbody>
          <?php
          

          // ✅ Date filter logic
          $where = "WHERE 1";
          if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
              $from = $_GET['from_date'];
              $to   = $_GET['to_date'];
              $where .= " AND booking_date BETWEEN '$from' AND '$to'";
          }

          $query = "
            SELECT 
              booking_type,
              COUNT(id) AS total_bookings,
              SUM(total_amount) AS total_amount,
              SUM(paid_amount) AS total_paid,
              SUM(balance_amount) AS total_pending
            FROM bookings
            $where
            GROUP BY booking_type
            ORDER BY total_amount DESC
          ";

          $result = $conn->query($query);

          $grandTotal = $grandPaid = $grandPending = 0;

          if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
              $grandTotal  += $row['total_amount'];
              $grandPaid   += $row['total_paid'];
              $grandPending += $row['total_pending'];
              ?>
              <tr>
                <td class="text-capitalize"><?= htmlspecialchars($row['booking_type']); ?></td>
                <td><?= (int)$row['total_bookings']; ?></td>
                <td><?= number_format($row['total_amount'], 2); ?></td>
                <td><?= number_format($row['total_paid'], 2); ?></td>
                <td class="text-danger"><?= number_format($row['total_pending'], 2); ?></td>
              </tr>
              <?php
            }
          } else {
              echo '<tr><td colspan="5" class="text-muted">No records found for the selected date range.</td></tr>';
          }
          ?>
          </tbody>
          <tfoot class="table-secondary fw-bold">
            <tr>
              <td>Total</td>
              <td>-</td>
              <td>₹<?= number_format($grandTotal, 2); ?></td>
              <td>₹<?= number_format($grandPaid, 2); ?></td>
              <td>₹<?= number_format($grandPending, 2); ?></td>
            </tr>
          </tfoot>
        </table>
      </div>

    </div>
  </div>
</div>
<?php include('inc/footer.php');?>