<?php 
include '../inc/db.php'; // database connection

$customer_id = isset($_POST['customer_id']) ? intval($_POST['customer_id']) : 0;

$response = ['status' => 'error', 'message' => 'Invalid request'];

if ($customer_id > 0) {

    // Common function to fetch latest inquiry by type
    function getLatestInquiry($conn, $customer_id, $type) {
        $fields = "";

        switch ($type) {
            case 'package':
                $fields = "id AS inquiry_id, package_name, destination, package_start_date AS start_date, 
                           package_end_date AS end_date, package_adults, package_children, package_special_requests, remarks";
                break;

            case 'hotel':
                $fields = "id AS inquiry_id, hotel_name, hotel_city, hotel_checkin_date, 
                           hotel_checkout_date, hotel_rooms, hotel_adults, hotel_children, hotel_type, remarks";
                break;

            case 'flight':
                $fields = "id AS inquiry_id, flight_from_city, flight_to_city, flight_departure_date, 
                           flight_return_date, flight_passengers, flight_class, remarks";
                break;

            case 'insurance':
                $fields = "id AS inquiry_id, insurance_destination,travel_type,no_of_travelers,insurance_type,insurance_start_date, insurance_end_date, insurance_sum_insured, remarks";
                break;

            case 'vehicle':
                $fields = "id AS inquiry_id, vehicle_type, vehicle_pickup_location, vehicle_drop_location, 
                           vehicle_pickup_datetime, vehicle_drop_datetime, vehicle_passengers, remarks";
                break;
        }

        if ($fields === "") return null;

        $sql = "SELECT $fields FROM inquiries 
                WHERE customer_id = '$customer_id' AND inquiry_type='$type' AND status='in-progress' 
                ORDER BY id DESC LIMIT 1";

        $res = mysqli_query($conn, $sql);
        if ($res && mysqli_num_rows($res) > 0) {
            return mysqli_fetch_assoc($res);
        }
        return null;
    }

    // Fetch all inquiry types
    $package_data   = getLatestInquiry($conn, $customer_id, 'package');
    $hotel_data     = getLatestInquiry($conn, $customer_id, 'hotel');
    $flight_data    = getLatestInquiry($conn, $customer_id, 'flight');
    $insurance_data = getLatestInquiry($conn, $customer_id, 'insurance');
    $vehicle_data   = getLatestInquiry($conn, $customer_id, 'vehicle');

    if ($package_data || $hotel_data || $flight_data || $insurance_data || $vehicle_data) {
        $response = [
            'status' => 'success',
            'package' => $package_data,
            'hotel' => $hotel_data,
            'flight' => $flight_data,
            'insurance' => $insurance_data,
            'vehicle' => $vehicle_data
        ];
    } else {
        $response = [
            'status' => 'no_data',
            'message' => 'No inquiry details found for this customer.'
        ];
    }
}

echo json_encode($response);
?>
