<?php
include('../inc/db.php');
session_start();

$userId = $_SESSION['user_id'] ?? 0;
$userRole = $_SESSION['role'] ?? 'sales';

$action = $_POST['action'] ?? '';
$from = $_POST['from'] ?? '';
$to = $_POST['to'] ?? '';

$dateCondition = '';
if ($from && $to) {
  $dateCondition = " AND DATE(created_at) BETWEEN '$from' AND '$to'";
} elseif ($from) {
  $dateCondition = " AND DATE(created_at) >= '$from'";
} elseif ($to) {
  $dateCondition = " AND DATE(created_at) <= '$to'";
}

if ($action == 'summary') {
  // INQUIRIES BY TYPE
  $types = ['package','hotel','flight','vehicle','insurance'];
  echo "<div class='row'>";
  foreach ($types as $type) {
    $sql = ($userRole == 'admin')
      ? "SELECT COUNT(*) AS total FROM inquiries WHERE inquiry_type='$type' $dateCondition"
      : "SELECT COUNT(*) AS total FROM inquiries WHERE inquiry_type='$type' AND assigned_to='$userId' $dateCondition";
    $res = mysqli_query($conn,$sql);
    $row = mysqli_fetch_assoc($res);
    echo "
    <div class='col-lg-2 col-6 mb-4'>
      <div class='card h-100'>
        <div class='card-body text-center'>
          <h5 class='card-title mb-2'>{$row['total']}</h5>
          <small>".ucfirst($type)." Inquiries</small>
        </div>
      </div>
    </div>";
  }

  // Quotations
  $sql = ($userRole == 'admin')
    ? "SELECT COUNT(*) AS total FROM quotations WHERE status='pending' $dateCondition"
    : "SELECT COUNT(*) AS total FROM quotations WHERE status='pending' AND assigned_to='$userId' $dateCondition";
  $r = mysqli_query($conn,$sql); $d = mysqli_fetch_assoc($r);
  echo "
  <div class='col-lg-2 col-6 mb-4'>
    <div class='card text-center h-100'>
      <div class='card-body'>
        <h5>{$d['total']}</h5><small>Pending Quotations</small>
      </div>
    </div>
  </div>";

  // Customers
  $r = mysqli_query($conn,"SELECT COUNT(*) AS total FROM customers");
  $d = mysqli_fetch_assoc($r);
  echo "
  <div class='col-lg-2 col-6 mb-4'>
    <div class='card text-center h-100'>
      <div class='card-body'>
        <h5>{$d['total']}</h5><small>Customers</small>
      </div>
    </div>
  </div>";

  // Sales Users
  $r = mysqli_query($conn,"SELECT COUNT(*) AS total FROM users WHERE role='sales'");
  $d = mysqli_fetch_assoc($r);
  echo "
  <div class='col-lg-2 col-6 mb-4'>
    <div class='card text-center h-100'>
      <div class='card-body'>
        <h5>{$d['total']}</h5><small>Sales Users</small>
      </div>
    </div>
  </div>";

  // Payments Summary
  $r = mysqli_query($conn,"
    SELECT 
      SUM(CASE WHEN type='debit' THEN amount ELSE 0 END) AS debit,
      SUM(CASE WHEN type='credit' THEN amount ELSE 0 END) AS credit
    FROM payments WHERE 1=1 $dateCondition");
  $d = mysqli_fetch_assoc($r);
  $pending = ($d['debit']??0)-($d['credit']??0);

  echo "
  <div class='col-lg-3 col-sm-6 mb-4'>
    <div class='card h-100'>
      <div class='card-body d-flex justify-content-between align-items-center'>
        <div><h5>₹".number_format($d['debit'])."</h5><small>Total Debit</small></div>
        <span class='badge bg-label-danger p-2'><i class='ti ti-arrow-down'></i></span>
      </div>
    </div>
  </div>
  <div class='col-lg-3 col-sm-6 mb-4'>
    <div class='card h-100'>
      <div class='card-body d-flex justify-content-between align-items-center'>
        <div><h5>₹".number_format($d['credit'])."</h5><small>Total Credit</small></div>
        <span class='badge bg-label-success p-2'><i class='ti ti-arrow-up'></i></span>
      </div>
    </div>
  </div>
  <div class='col-lg-3 col-sm-6 mb-4'>
    <div class='card h-100'>
      <div class='card-body d-flex justify-content-between align-items-center'>
        <div><h5>₹".number_format($pending)."</h5><small>Pending</small></div>
        <span class='badge bg-label-warning p-2'><i class='ti ti-clock'></i></span>
      </div>
    </div>
  </div>
  </div>";
}

// === TODAY’S ACTIVITY ===
if ($action == 'today') {
  $condition = $dateCondition ? $dateCondition : "AND DATE(created_at)=CURDATE()";
  
  echo "<div class='table-responsive'><table class='table table-sm table-bordered'>
  <thead class='table-light'><tr>
    <th>Type</th><th>Customer</th><th>Contact</th><th>Assigned</th><th>Status</th><th>Date</th>
  </tr></thead><tbody>";

  // Merge Inquiries + Quotations + Bookings
  $sql = "
  SELECT 'Inquiry' AS source, i.id, i.inquiry_type AS type, c.name AS customer, c.phone, u.name AS assigned, i.status, DATE(i.created_at) AS date
  FROM inquiries i
  LEFT JOIN customers c ON i.customer_id=c.id
  LEFT JOIN users u ON i.assigned_to=u.id
  WHERE 1=1 $condition
  UNION
  SELECT 'Quotation', q.id, q.quotation_type, c.name, c.phone, u.name, q.status, DATE(q.created_at)
  FROM quotations q
  LEFT JOIN customers c ON q.customer_id=c.id
  LEFT JOIN users u ON q.assigned_to=u.id
  WHERE 1=1 $condition
  UNION
  SELECT 'Booking', b.id, b.booking_type, c.name, c.phone, u.name, b.status, DATE(b.created_at)
  FROM bookings b
  LEFT JOIN customers c ON b.customer_id=c.id
  LEFT JOIN users u ON b.created_by=u.id
  WHERE 1=1 $condition
  ORDER BY date DESC";
  
  $res = mysqli_query($conn,$sql);
  if (mysqli_num_rows($res)>0){
    while($row=mysqli_fetch_assoc($res)){
      echo "<tr>
        <td>{$row['source']} ({$row['type']})</td>
        <td>{$row['customer']}</td>
        <td>{$row['phone']}</td>
        <td>{$row['assigned']}</td>
        <td>{$row['status']}</td>
        <td>{$row['date']}</td>
      </tr>";
    }
  } else echo "<tr><td colspan='6' class='text-center text-muted'>No records found</td></tr>";

  echo "</tbody></table></div>";
}
?>
