   <?php
   $title = "PP / HDPE Raffia Woven Sack Production Line | Heaven Extrusions";
   $meta_description = "High-performance PP / HDPE Raffia Woven Sack Bag Production Line. Complete production solution with technical specifications and machine video.";
   ob_start();
   ?>

<style>
	/* ---------- FLOW SECTION ---------- */
	.production-flow {
		display: flex;
		flex-direction: column;
		gap: 22px;
		margin-top: 20px;
	}
	
	.flow-item {
		display: grid;
		grid-template-columns: 280px 1fr;
		gap: 20px;
		padding: 18px 20px;
		border-left: 4px solid #e53935;
		background: #fafafa;
		border-radius: 6px;
	}
	
	.flow-title {
		font-weight: 700;
		font-size: 16px;
	}
	
	.flow-desc {
		font-size: 15px;
		line-height: 1.7;
		color: #444;
	}
	
	@media(max-width:768px) {
		.flow-item {
			grid-template-columns: 1fr;
		}
	}
	
	/* ---------- CTA ---------- */
	.product-cta {
		display: flex;
		gap: 15px;
		margin: 20px 0 30px;
		flex-wrap: wrap;
	}
	
	.cta-btn {
		padding: 12px 22px;
		font-size: 15px;
		font-weight: 600;
		border-radius: 5px;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 8px;
		transition: .3s;
	}
	
	.cta-btn.primary {
		background: #e53935;
		color: #fff;
	}
	
	.cta-btn.primary:hover {
		background: #c62828;
	}
	
	.cta-btn.secondary {
		background: #fff;
		border: 2px solid #2d2a8c;
		color: #2d2a8c;
	}
	
	.cta-btn.secondary:hover {
		background: #2d2a8c;
		color: #fff;
	}
	
	/* ---------- TABLE ---------- */
	.raffia-tech-table {
		width: 100%;
		border-collapse: collapse;
		font-size: 14px;
	}
	
	.raffia-tech-table th,
	.raffia-tech-table td {
		border: 1px solid #ddd;
		padding: 10px;
		text-align: center;
	}
	
	.raffia-tech-table thead {
		background: #2d2a8c;
		color: #fff;
	}
	
	@media(max-width:768px) {
		.raffia-tech-table {
			min-width: 900px;
		}
	}
	
	/* ---------- VIDEO MODAL ---------- */
	.video-modal {
		display: none;
		position: fixed;
		inset: 0;
		background: rgba(0, 0, 0, .85);
		z-index: 9999;
	}
	
	.video-content {
		max-width: 800px;
		margin: 80px auto;
		background: #000;
		padding: 10px;
		position: relative;
	}
	
	.close-video {
		position: absolute;
		top: -35px;
		right: 0;
		font-size: 30px;
		color: #fff;
		cursor: pointer;
	}
	
	.product-navigation {
		display: flex;
		justify-content: space-between;
		gap: 20px;
		margin-top: 50px;
		flex-wrap: wrap;
	}
	
	.nav-btn {
		text-decoration: none;
		border: 2px solid #e53935;
		padding: 14px 22px;
		border-radius: 6px;
		font-weight: 600;
		color: #e53935;
		transition: 0.3s;
		display: inline-flex;
		flex-direction: column;
		line-height: 1.3;
		max-width: 260px;
	}
	
	.nav-btn span {
		font-size: 13px;
		font-weight: 500;
		opacity: 0.8;
	}
	
	.nav-btn:hover {
		background: #e53935;
		color: #fff;
	}
	
	.prev-product-btn {
		align-items: flex-start;
		text-align: left;
	}
	
	.next-product-btn {
		align-items: flex-end;
		text-align: right;
	}
	
	@media (max-width: 768px) {
		.product-navigation {
			flex-direction: column;
		}
		.nav-btn {
			max-width: 100%;
			align-items: center;
			text-align: center;
		}
	}
	
	.cta-btn.whatsapp {
		background: #25D366;
		color: #fff;
	}
	
	.cta-btn.whatsapp:hover {
		background: #1ebe5d;
	}

</style>


<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
	<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
	<div class="container">
		<div class="row">
			<div class="col-xxl-6 col-xl-8 col-lg-8">
				<div class="rs-breadcrumb-content-wrapper">
					<div class="rs-breadcrumb-title-wrapper">
						<h1 class="rs-breadcrumb-title">Two-Layer Blown Film Extrusion Line</h1>
					</div>
					<div class="rs-breadcrumb-menu">
						<nav>
							<ul>
								<li><span><a href="index.php">Home</a></span>
								</li>
								<li><span>Products</span>
								</li>
								<li><span>Two-Layer Blown Film Extrusion Line</span>
								</li>
							</ul>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
   <!-- breadcrumb area end -->

   <!-- portfolio area start -->
<section class="rs-portfolio-area section-space">
	<div class="container">
		<div class="row g-5">
			<div class="col-xl-6 col-lg-6">
				<div class="rs-portfolio-details-wrapper">
					<div class="portfolio-details-thumb-wrapper">
						<div class="row g-5">
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/two-layer-blown-film-extrusion-line/1.jpg" alt="image">
								</div>
							</div>

							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/two-layer-blown-film-extrusion-line/2.png" alt="image">
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
			<div class="col-xl-6 col-lg-6">
				<h3>Two-Layer Blown Film Extrusion Line</h3>

				<p align="justify">The Heaven Extrusions Two-Layer Blown Film Extrusion Line is engineered to deliver high-quality 2-layer
films with enhanced strength, barrier properties, and optical clarity. Ideal for flexible packaging, lamination films, industrial applications, and agricultural films, this line offers precise layer control and superior productivity.</p>
				<p align="justify">Two Layer Blown Film Line adopts a lot of new technology such as higher Output Extrusion System, Energy Efficient screws, advance technology Spiral dies, High Precise Air Ring Cooling system to ensures consistent gauge profile with Uniform thickness and bubble stability, Bubble Stabilizing device, 360
Degree rotation Haul-Off unit or Rotating Die, Corona treatment Station, Central-guide system, Inline Trimming and Slitting System and Surface type Film Winding unit with Auto tension Control System. The line adopts automatic microcomputer control, equipped with colourful touch screen, integrated with HMI developed by ourselves to accomplish most of line operation, Control and achieve functions such as online help, Production Record, Safety protection and Start-up protection.</p>
				<p align="justify">Whether producing packaging films, barrier films, or industrial protective films, the line delivers reliable,
energy-efficient, and consistent performance for converters and exporters.</p>

				<div class="product-cta">
					<a href="https://wa.me/919999999999?text=Hello%20Heaven%20Extrusions,%20I%20am%20interested%20in%20the%20Extrusion%20Coating%20Tarpaulin%20Lamination%20Line." target="_blank" class="cta-btn whatsapp">
   <i class="fab fa-whatsapp"></i> WhatsApp
</a>
				


					<a href="contact-us.html" class="cta-btn primary">
        Get Inquiry
    </a>
				

					<a href="#productionVideo" class="cta-btn secondary video-btn">
        ▶ Watch Video
    </a>
				

				</div>




			</div>
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Optional Features</h3>
						<div class="rs-about-feature-list">
                                                <div class="rs-list-item">
                                                    <ul>
                                                        <li>
                                                            <i class="fa-regular fa-check"></i>
                                                            Enhance Performance
                                                        </li>
                                                        <li>
                                                            <i class="fa-regular fa-check"></i>
                                                            Improve Film Quality
                                                        </li>
                                                        <li>
                                                            <i class="fa-regular fa-check"></i>
                                                            Maximize Productivity
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
						
						<p class="mb-20 mt-15" align="justify">
							Our Multilayer Blown Film Line can be configure with a wide range of optional features to suit specific production needs, improve automation, & elevate film quality. These add-ons ensure maximum flexibility for diverse applications such as packaging, lamination, shrink films, stretch films, & barrier films.</p>
						<div class="rs-postbox-details-feature">
							<h6 class="mb-4">1. Automation & Process Control</h6>
							<ul>
								<li>Automatic Gauge Control (AGC) System – Ensures uniform film thickness across the web</li>
								<li>Gravimetric Dosing & Blending System – Accurate material proportioning and reduced wastage.</li>
								

							</ul>
							<h6 class="mt-4 mb-4">2. Film Quality Enhancement</h6>
							<ul>
								<li>Corona or Plasma Surface Treatment – Better printability and laminate bonding.</li>
								<li>Electrostatic Pinning Device – Enhances layflate and improves film clarity</li>
								<li>Inline Gusseting Unit – For producing gusseted film in a single pass.</li>


							</ul>
							<h6 class="mt-4 mb-4">3. Material Handling & Utility Upgrades</h6>
							<ul>
								<li>Vacuum Auto Loaders with Dryers – Efficient feeding of raw materials</li>
								<li>Online Flexo Printing Attachment – For inline Single Colour printing</li>

							</ul>
							<h6 class="mt-4 mb-4">4. Advanced Winding Solutions</h6>
							<ul>
								<li>Automatic Back to Back Two Station Winding System – Ensures perfect tension, roll density and smooth operation.</li>

							</ul>

						</div>



					</div>

				</div>
			</div>
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title">Two-Layer (A/B) Blown Film Line – Applications </h3>





					</div>

				</div>
			</div>
			<div class="col-xl-4 col-lg-4">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">

						<div class="rs-postbox-details-feature">
							<h6 class="mb-4">1.Packaging Films</h6>
							<ul>
								<li>Grocery bags</li>
								<li>Shopping bags</li>
								<li>Carry bags</li>
								<li>T-shirt bags</li>
								<li>Garbage bags / trash liners</li>
								<li>Industrial packing bags</li>
								
							</ul>
							

						</div>



					</div>

				</div>
			</div>
			<div class="col-xl-4 col-lg-4">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">

						<div class="rs-postbox-details-feature">
							<h6 class="mb-4">2.Industrial & Commercial Applications</h6>
							<ul>
								<li>Construction films</li>
								<li>General-purpose liners</li>
								<li>Box wrapping films</li>
								<li>Furniture and mattress packing</li>
								<li>PE sleeves & small-width rolls</li>
														
							</ul>
													

						</div>



					</div>

				</div>
			</div>
			<div class="col-xl-4 col-lg-4">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">

						<div class="rs-postbox-details-feature">
							<h6 class="mb-4">3.Agricultural Films</h6>
							<ul>
								<li>Mulching films </li>
								<li>Low-micron crop protection films</li>
								<li>Nursery bags</li>
								<li>Seedling bags</li>
																
							</ul>
							

						</div>



					</div>

				</div>
			</div>
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title">Why Two-Layer?</h3>
						
						
						<p align="justify">	Better strength than monolayer, Allows combination of stiffness + saleability, Suitable for medium-duty packaging, Cost-effective production with improved film properties </p>
						



					</div>

				</div>
			</div>

			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Technical Specification</h3>
						<div class="table-responsive raffia-table-wrapper">
							<table class="raffia-tech-table">
								<thead>
									<tr>
										<th>Model</th>
										<th>HEABABL-900</th>
										<th>HEABABL-1200</th>
										<th>HEABABL-1500</th>
										<th>HEABABL-2000</th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td>Lay Flat Width</td>
										<td>400 - 900 MM</td>
										<td>600- 1200 MM</td>
										<td>800 - 1500 MM</td>
										<td>1200 - 2000 mm</td>
									</tr>
									<tr>
										<td>Film Thickness</td>
										<td>20 -80 MICRON</td>
										<td>20-100 MICRON</td>
										<td>20-150 MICRON</td>
										<td>25-150 MICRON</td>
									</tr>
									<tr>
										<td>Max. Melting Capacity</td>
										<td>75 kg/hr</td>
										<td>120 kg/hr</td>
										<td>200 kg/hr</td>
										<td>250 kg/hr</td>
									</tr>
									<tr>
										<td>Screw Dia (MM)</td>
										<td>45-45 (HM-LD)</td>
										<td>55-55 (HM-LD</td>
										<td>65-65 (LD-LL)</td>
										<td>75-75 (LD-LL)</td>
									</tr>

								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>




			<div class="product-navigation">
				<a href="aba-co-ex-blown-film-extrusion-line" class="nav-btn prev-product-btn">
        ← Previous
        
    </a>
			

				<a href="monolayer-blown-film-extrusion-line" class="nav-btn next-product-btn">
        Next →
        
    </a>
			
			</div>

		</div>

	</div>
	</div>
</section>
   <!-- ================= VIDEO MODAL ================= -->
<div id="productionVideo" class="video-modal">
	<div class="video-content">
		<span class="close-video">&times;</span>
		<iframe width="100%" height="450" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allowfullscreen></iframe>
	</div>
</div>

<script>
	document.addEventListener( "DOMContentLoaded", function () {

		document.querySelectorAll( '.video-btn' ).forEach( btn => {
			btn.addEventListener( 'click', function ( e ) {
				e.preventDefault();
				document.getElementById( 'productionVideo' ).style.display = 'block';
			} );
		} );

		document.querySelector( '.close-video' ).addEventListener( 'click', function () {
			document.getElementById( 'productionVideo' ).style.display = 'none';
		} );

	} );
</script>

   <!--<section class="rs-services-area section-space ">
<div class="container">
	<div class="row g-5">
		<div class="col-xl-12 col-lg-12">
			<div class="rs-services-details-wrapper">

				<h3 class="rs-services-details-title">Best innovations in metallurgy</h3>
				<p class="mb-25 mt-15"><strong>At vero eos et accusamus et iusto odio dignissimos ducimus
                                    qui
                                    blanditiis praesentium voluptatum
                                    deleniti atque corrupti quos dolores et quas molestias excepturi.</strong>
				</p>
				<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga harum quidem rerum facilis est et expedita distinctio. </p>
				<h3 class="rs-services-details-title">Planning &amp; Strategy</h3>
				<p class="mt-20 mb-20">Demoralized voluptatum deleniti atque corrupti dolores quas molestias excepturi sint occaecati.</p>
				<div class="rs-services-details-feature-list">
					<div class="rs-list-item has-theme-orange">
						<ul>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Prepare Documentation
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Brand Consistency
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Industry Standard Dummy
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Quality Control System
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Prepare Documentation
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Prepare Documentation
							</li>
						</ul>
					</div>
				</div>

				<p class="mb-20"> At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi.
				</p>
				<h3 class="rs-services-details-title mb-15">Planning &amp; Strategy</h3>
				<p class="mb-55">At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate. </p>
				<h3 class="rs-services-details-title mb-15">Stats &amp; Charts</h3>
				<div class="rs-services-details-chart-wrapper">
					<p class="mb-0"> At vero eos et accusamus et iusto odio digmos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati .
					</p>
					<div class="rs-services-details-chart">
						<canvas id="pie-chart"></canvas>
					</div>
				</div>
				<div class="has-border-line"></div>
				<h3 class="rs-services-details-title mb-20">Questions? You’re covered</h3>
				<p> At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate. </p>
				<div class="rs-services-details-faq">
					<div class="rs-faq-content rs-accordion-one">
						<div class="accordion-wrapper">
							<div class="accordion" id="accordionExampleOne">
								<div class="rs-accordion-item">
									<h4 class="accordion-header" id="headingOne">
                                                    <button class="accordion-button" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseOne"
                                                        aria-expanded="true" aria-controls="collapseOne">
                                                        01. Why is sand important for industry?
                                                        <span class="accordion-btn"></span>
                                                    </button>
                                                </h4>
								

									<div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExampleOne">
										<div class="accordion-body"> Randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything.
										</div>
									</div>
								</div>
								<div class="rs-accordion-item">
									<h6 class="accordion-header" id="headingTwo">
                                                    <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                        aria-expanded="false" aria-controls="collapseTwo">
                                                        02. Can I switch to a different plan?
                                                        <span class="accordion-btn"></span>
                                                    </button>
                                                </h6>
								

									<div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExampleOne">
										<div class="accordion-body">Randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything.</div>
									</div>
								</div>
								<div class="rs-accordion-item">
									<h6 class="accordion-header" id="headingThree">
                                                    <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                                        aria-expanded="false" aria-controls="collapseThree">
                                                        03. What should I wear for an industry treatment?
                                                        <span class="accordion-btn"></span>
                                                    </button>
                                                </h6>
								

									<div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExampleOne">
										<div class="accordion-body">Randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything.</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="rs-services-details-cta">
					<div class="rs-services-details-cta-bg-thumb" data-background="assets/images/bg/cta-bg-08.png">
					</div>
					<div class="rs-services-details-cta-content">
						<h3 class="rs-services-details-title mb-40">We are always ready to help you and
                                        answer your
                                        questions</h3>
						<div class="rs-services-details-btn">
							<a class="rs-btn has-theme-orange has-icon has-bg" href="contact.html">Explore
                                            More
                                            <span class="icon-box">
                                                <svg class="icon-first" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                                <svg class="icon-second" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                            </span>
                                        </a>
						</div>
					</div>
					<div class="rs-services-details-cta-thumb">
						<img src="assets/images/services/details/services-details-02.png" alt="image">
					</div>
				</div>
			</div>
		</div>

	</div>
</div>
</section> -->
   <?php
   $content = ob_get_clean();
   include 'layout/layout.php';
   ?>