<?php
//require_once __DIR__ . '/iadmin/config/config.php';
//require_once LAYOUT_PATH . '/auth_check.php';

$title = "Price Monitoring Tool | Track Prices & Get Alerts";
$meta_description = "Track product prices automatically across multiple websites, view price history, and get instant alerts when prices change.";

ob_start();
?>
<style>
/* Counter number & text white */
.rs-elements-counter-area.purple-bg .rs-counter-number,
.rs-elements-counter-area.purple-bg .prefix,
.rs-elements-counter-area.purple-bg .rs-counter-title,
.rs-elements-counter-area.purple-bg .rs-counter-text {
    color: #ffffff !important;
}

/* Optional: slightly dim titles */
.rs-elements-counter-area.purple-bg .rs-counter-title {
    opacity: 0.85;
}

.wave-line {
  width: 100%;
  height: 6px;
  background: linear-gradient(
    90deg,
    #2b2e83,
    #5a3db8,
    #2b2e83
  );
  border-radius: 50px;
}
	
.rs-elements-counter-area {
    position: relative;
    background-color: #4a2cae; /* Purple background */
    color: #fff;
    overflow: hidden;
    padding: 80px 0;
}

/* Right-side half curve */
.right-curve {
    position: absolute;
    top: 0;
    right: -50px; /* move curve partly outside */
    width: 200px;
    height: 100%;
    background-color: #fff; /* color of curve */
    border-radius: 50% 0 0 50%; /* creates vertical half-curve */
    z-index: 1;
}

.rs-why-choose-thumb-wrapper {
    position: relative;
    z-index: 2; /* put image above curve */
}

.rs-why-choose-content-wrapper {
    position: relative;
    z-index: 2; /* counters on top of background */
}

.rs-counter-item {
    margin-bottom: 30px;
}

.rs-counter-number-wrapper {
    font-size: 36px;
    font-weight: bold;
}


</style>

<?php include __DIR__ . '/layout/slider.php'; ?>

<div class="rs-text-slide-area rs-text-slide-one">
            <div class="container-fluid">
                <div class="rs-text-slide-wrapper">
                    <div class="gsap-marquee right speed-20 move-to-1000">
                        <div class="rs-text-slide-inner">
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Architecture</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Oil</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Gas</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Materials</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Engineering</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Gas</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Oil</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                            <div class="rs-text-slide-item">
                                <h2 class="rs-text-slide-title">Architecture</h2>
                                <div class="rs-text-slide-thumb">
                                    <img src="assets/images/shape/gears-shape.png" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<!-- banner area end -->
<section class="rs-about-area section-space rs-about-four">
            <div class="container">
                <div class="row g-5">
                    <div class="col-xl-6 col-lg-6">
                        <div class="rs-about-thumb-wrapper">
                            <div class="rs-about-thumb-left-part">
                                <div class="rs-about-thumb">
                                    <img src="assets/images/about/about-thumb-04.png" alt="image">
                                </div>
                                <div class="rs-about-video-btn">
                                    <div class="rs-rotate-btn">
                                        <a href="https://www.youtube.com/watch?v=Yue48fUXuqI"
                                            class="rs-play-btn popup-video has-theme-red"><i
                                                class="ri-play-fill"></i></a>
                                        <div class="rs-circle-title gsap-rotate rs-text-circle-wrapper">
                                            <div class="rs-text-circle" data-rotate-degree="13.33">
                                                Watch Video - Watch Video -
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rs-about-thumb-right-part">
                                <div class="rs-about-counter">
                                    <div class="rs-counter-inner">
                                        <div class="rs-counter-number-wrapper">
                                            <span class="rs-counter-number odometer" data-count="52">00</span>
                                            <span class="prefix">+</span>
                                        </div>
                                        <span class="rs-counter-title">Years of Experience
                                        </span>
                                    </div>
                                </div>
                                <div
                                    class="rs-about-thumb has-large-thumb rs-image scroll_reveal reveal_left reveal-active">
                                    <img decoding="async" src="assets/images/about/about-thumb-05.png" alt="image">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6">
                        <div class="rs-about-wrapper">
                            <div class="rs-about-content-wrapper">
                                <div class="rs-section-title-wrapper">
                                    <span class="rs-section-subtitle  has-bg-field justify-content-start">
                                        Welcome
                                    </span>
                                    <h2 class="rs-section-title rs-split-text-enable split-in-fade">Pioneering Excellence in
</h2>
									<h3 class="rs-section-title rs-split-text-enable split-in-fade">Plastic Extrusion Machinery <span class="title-line">
  <svg viewBox="0 0 1000 10" preserveAspectRatio="none">
    <defs>
      <linearGradient id="lineGradient" x1="0%" y1="0%" x2="100%" y2="0%">
        <stop offset="0%" stop-color="#3b3f99" stop-opacity="0"/>
        <stop offset="50%" stop-color="#4c4fd9"/>
        <stop offset="100%" stop-color="#3b3f99" stop-opacity="0"/>
      </linearGradient>
    </defs>

    <!-- soft glow -->
    <rect x="0" y="3" width="1000" height="4"
          fill="url(#lineGradient)" opacity="0.5"/>

    <!-- thicker center line -->
    <rect x="0" y="4" width="1000" height="3"
          fill="url(#lineGradient)"/>
  </svg>
</span>
</h3>
                                    <p class="descrip">Delivers innovative, High-performance Plastic Extrusion
Machinery trusted across India and Global Markets</p>
									
                                </div>
                                <div class="rs-about-tab">
                                    <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="pills-item-one-tab"
                                                data-bs-toggle="pill" data-bs-target="#pills-item-one" type="button"
                                                role="tab" aria-controls="pills-item-one" aria-selected="true">
                                                Our History
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-item-two-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-item-two" type="button" role="tab"
                                                aria-controls="pills-item-two" aria-selected="false"> Our Mission
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="pills-item-three-tab" data-bs-toggle="pill"
                                                data-bs-target="#pills-item-three" type="button" role="tab"
                                                aria-controls="pills-item-three" aria-selected="false">
                                                Our Vision
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="rs-aobut-tab-content-wrapper">
                                    <div class="tab-content rs-about-tab-anim" id="pills-tabContent">
                                        <div class="tab-pane fade show active" id="pills-item-one" role="tabpanel"
                                            aria-labelledby="pills-item-one-tab" tabindex="0">
                                            <div class="rs-about-tab-content">
                                                <p>Welcome to Industrie, a leading industry innovator with a rich
                                                    history of
                                                    excellence
                                                    with a passion make also for precision we have been empowering
                                                    industries and
                                                    driving progress for</p>
                                                <div class="rs-about-feature-list">
                                                    <div class="rs-list-item has-theme-red">
                                                        <ul>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Quality Control System
                                                            </li>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Building Quality Industrial
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-item-two" role="tabpanel"
                                            aria-labelledby="pills-item-two-tab" tabindex="0">
                                            <div class="rs-about-tab-content">
                                                <p>Welcome to Industrie, a leading industry innovator with a rich
                                                    history of
                                                    excellence
                                                    with a passion make also for precision we have been empowering
                                                    industries and
                                                    driving progress for</p>
                                                <div class="rs-about-feature-list">
                                                    <div class="rs-list-item has-theme-red">
                                                        <ul>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Quality Control System
                                                            </li>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Building Quality Industrial
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="pills-item-three" role="tabpanel"
                                            aria-labelledby="pills-item-three-tab" tabindex="0">
                                            <div class="rs-about-tab-content">
                                                <p>Welcome to Industrie, a leading industry innovator with a rich
                                                    history of
                                                    excellence
                                                    with a passion make also for precision we have been empowering
                                                    industries and
                                                    driving progress for</p>
                                                <div class="rs-about-feature-list">
                                                    <div class="rs-list-item has-theme-red">
                                                        <ul>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Quality Control System
                                                            </li>
                                                            <li>
                                                                <i class="fa-regular fa-check"></i>
                                                                Building Quality Industrial
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="rs-about-author-info">
                                    <div class="rs-about-btn">
                                        <a class="rs-btn has-theme-red has-icon has-bg has-skew"
                                            href="about.html">Explore More
                                            <span class="icon-box">
                                                <svg class="icon-first" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                                <svg class="icon-second" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                            </span>
                                        </a>
                                    </div>
                                  
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {

    // Disable on mobile
    if (window.innerWidth < 992) return;

    const section = document.querySelector(".rs-elements-counter-area");
    const image = document.querySelector(".gsap-parallax");

    if (!section || !image) return;

    section.addEventListener("mousemove", (e) => {
        const rect = section.getBoundingClientRect();

        const x = (e.clientX - rect.left - rect.width / 2) * 0.03;
        const y = (e.clientY - rect.top - rect.height / 2) * 0.03;

        gsap.to(image, {
            x: x,
            y: y,
            duration: 0.6,
            ease: "power3.out"
        });
    });

    section.addEventListener("mouseleave", () => {
        gsap.to(image, {
            x: 0,
            y: 0,
            duration: 0.8,
            ease: "power3.out"
        });
    });
});
</script>

<section class="rs-elements-counter-area section-space rs-why-choose-two purple-bg">
    <div class="container">
        <div class="row g-5">
            <div class="col-xl-9 col-lg-9">
                <div class="rs-why-choose-content-wrapper">
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="27">0</span>
                            <span class="prefix">+</span>
                        </div>
                        <span class="rs-counter-title">Countries</span>
                    </div>
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="1">0</span>
                            <span class="prefix">K+</span>
                        </div>
                        <span class="rs-counter-title">Customers</span>
                    </div>
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="20">0</span>
                            <span class="prefix">+</span>
                        </div>
                        <span class="rs-counter-title">Experience</span>
                    </div>
                    <div class="rs-counter-item">
                        <div class="rs-counter-number-wrapper">
                            <span class="rs-counter-number odometer" data-count="20">0</span>
                            <span class="prefix">+</span>
                        </div>
                        <span class="rs-counter-title">Product Range</span>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-lg-3 position-relative">
                <!-- Right side half-curve -->
                <div class="right-curve"></div>

                <div class="rs-why-choose-section-area">
                    <div class="rs-why-choose-thumb-wrapper">
                        <div class="rs-why-choose-thumb image-two">
                            <img src="assets/images/bg/counterside.png" alt="image" class="gsap-parallax">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- feature area end -->
<section class="rs-feature-area section-space rs-feature-one">
            <div class="container">
                <div class="row g-5 process-counts">
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="rs-feature-item wow fadeInUp" data-wow-delay=".3s" data-wow-duration="1s">
                            <div class="rs-feature-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="62" viewBox="0 0 60 62"
                                    fill="none">
                                    <path
                                        d="M59.9964 28.3079C59.9731 27.8377 59.5714 27.4513 59.0983 27.4513H48.7252L50.4083 23.6125C50.5029 23.3969 50.5082 23.1427 50.4228 22.9233L49.561 20.7111C50.0407 20.535 50.5058 20.32 50.9509 20.0667L53.1115 21.4029C53.511 21.6257 53.8913 21.5723 54.2524 21.243L56.3415 18.9483C56.6369 18.6239 56.6558 18.1338 56.3862 17.7875L54.8348 15.7954C55.025 15.371 55.1822 14.9334 55.3054 14.4864L57.7829 13.9144C58.2086 13.8162 58.5025 13.4268 58.4804 12.9904L58.3244 9.90244C58.3024 9.46609 57.9706 9.10848 57.5373 9.05354L55.0147 8.73427C54.8472 8.30201 54.6466 7.88261 54.4146 7.47944L55.7571 5.34122C55.9905 4.96954 55.9224 4.48379 55.5957 4.19084L53.2859 2.11837C52.9628 1.82843 52.479 1.81004 52.1347 2.07438L50.12 3.62155C49.6895 3.43126 49.2459 3.27403 48.7926 3.15142L48.2195 0.696814C48.1202 0.272125 47.7301 -0.0231006 47.2961 0.0014214L44.1854 0.158531C43.7499 0.180528 43.3926 0.511095 43.3367 0.943477L43.014 3.4434C42.5753 3.61121 42.1498 3.8122 41.7409 4.04503L39.5803 2.70882C39.2111 2.48067 38.7316 2.54763 38.4394 2.8687L36.3503 5.16343C36.0549 5.48787 36.036 5.97795 36.3057 6.32426L37.857 8.3162C37.7092 8.64628 37.5832 8.98478 37.4756 9.32893L33.2529 7.47752C32.7289 7.30418 32.3331 7.45877 32.0652 7.94115L28.4809 16.1163V2.1114C28.4809 0.945761 26.6778 0.945761 26.6778 2.1114V6.06029C20.4988 6.3215 14.7998 9.58629 11.3786 14.8486C10.7644 15.7933 12.2231 16.8576 12.8903 15.8314C15.9789 11.0807 21.1104 8.12483 26.6778 7.8647V46.0341H21.1189C20.3605 46.0341 19.7436 45.4134 19.7436 44.6503V41.5592C19.7436 41.2275 19.5615 40.9227 19.2695 40.7654C13.5322 37.6756 10.0063 31.6998 10.0679 25.1698C10.084 23.4632 10.349 21.7753 10.8557 20.1529C11.2031 19.0403 9.482 18.5026 9.1346 19.6155C8.57529 21.4064 8.2827 23.2695 8.26503 25.1529C8.19892 32.1725 11.8926 38.612 17.9407 42.0891V44.6503C17.9407 46.0935 18.9028 47.315 20.2175 47.7058V51.9767C20.2175 54.7346 22.4613 56.9784 25.2191 56.9784H26.678V60.1678C26.678 61.3335 28.4811 61.3335 28.4811 60.1678V38.5895L37.6672 42.6171L37.4606 43.7947C37.1573 43.8977 36.8612 44.0195 36.574 44.1594L34.9552 43.0315C34.5969 42.7817 34.1109 42.8247 33.8021 43.134L32.0215 44.9162C31.7127 45.2252 31.67 45.7112 31.92 46.0694L33.0495 47.6872C32.9098 47.9746 32.7883 48.2707 32.6855 48.5742L30.7578 48.9144C30.3255 48.9907 30.0112 49.3671 30.0128 49.8058L30.0232 52.3343C30.025 52.7684 30.3358 53.1396 30.7628 53.2176L32.7022 53.5716C32.8081 53.8791 32.9332 54.1793 33.0768 54.4704L31.9632 56.0771C31.7148 56.4354 31.7585 56.9203 32.067 57.2284L33.8622 59.022C34.1705 59.3301 34.6553 59.3735 35.0137 59.1247L36.6194 58.0098C36.9106 58.153 37.2109 58.2778 37.5184 58.3835L37.8742 60.3226C37.9526 60.7496 38.324 61.0601 38.7581 61.0614L41.2866 61.0694H41.2895C41.727 61.0694 42.1017 60.755 42.1775 60.3237L42.516 58.3956C42.8194 58.2926 43.1153 58.1708 43.4025 58.0309L45.0212 59.1588C45.3796 59.4087 45.8656 59.3657 46.1743 59.0563L47.9549 57.2741C48.2637 56.965 48.3064 56.4791 48.0564 56.1208L46.9269 54.5031C47.0666 54.2157 47.1881 53.9196 47.2909 53.6161L49.2186 53.2759C49.6508 53.1996 49.9652 52.8232 49.9636 52.3845L49.9533 49.8559C49.9515 49.4219 49.6407 49.0507 49.2137 48.9727L47.3907 48.6399C49.9709 48.6284 52.5914 48.628 55.1393 48.628C55.4376 48.684 55.7131 48.5949 55.9658 48.3603L59.7551 44.3311C59.9123 44.1638 59.9999 43.943 59.9999 43.7134V28.3529C59.9998 28.3377 59.9972 28.3231 59.9964 28.3079ZM57.0127 29.2544L54.9585 31.4387H42.0238L44.0782 29.2544H57.0127ZM46.8388 13.7231C46.7538 13.5048 46.5756 13.3187 46.3607 13.2247L42.939 11.7244C43.1023 10.0813 44.4615 8.75447 46.1747 8.66792C48.0625 8.5762 49.6707 10.0152 49.7652 11.8832C49.8426 13.4146 48.8692 14.7917 47.4413 15.2698L46.8388 13.7231ZM45.9464 16.4001L46.9202 18.8997L47.9502 21.544L44.3724 19.9637L45.9464 16.4001ZM39.6246 7.65134L38.195 5.81567L39.2687 4.63621L41.2635 5.86988C41.5613 6.05392 41.9387 6.04911 42.2318 5.85726C42.8132 5.47621 43.4435 5.1787 44.1047 4.9729C44.4412 4.86821 44.6857 4.57695 44.7309 4.22751L45.0286 1.92135L46.6348 1.84021L47.1635 4.10454C47.2437 4.44772 47.5164 4.71278 47.8618 4.7831C48.5401 4.92098 49.197 5.15357 49.8143 5.47416C50.125 5.63548 50.5012 5.60218 50.7788 5.38906L52.639 3.96053L53.8261 5.02568L52.5889 6.99633C52.4004 7.29649 52.4053 7.67935 52.6014 7.97457C52.9841 8.55096 53.2828 9.17519 53.4892 9.83007C53.595 10.1659 53.8866 10.4093 54.2359 10.4536L56.5617 10.748L56.6415 12.3278L54.3572 12.8552C54.0141 12.9343 53.7486 13.2061 53.6772 13.5507C53.538 14.2231 53.3037 14.8743 52.981 15.4861C52.8157 15.7996 52.8493 16.1809 53.067 16.4606L54.4968 18.2964L53.423 19.4759L51.4282 18.2422C51.1304 18.0582 50.753 18.063 50.46 18.2547C49.9726 18.5741 49.451 18.8337 48.9061 19.0308L48.0957 16.9504C50.2334 16.1944 51.6829 14.1093 51.5657 11.7922C51.4211 8.93117 48.962 6.72154 46.0834 6.86723C43.669 6.98924 41.7156 8.73031 41.2338 10.977L39.1376 10.0579C39.2772 9.5637 39.4691 9.08395 39.7106 8.62597C39.8761 8.31235 39.8424 7.93106 39.6246 7.65134ZM25.2189 55.1754C23.4552 55.1754 22.0203 53.7405 22.0203 51.9769V47.8372H26.6777V55.1754H25.2189ZM28.4809 20.6067L33.3546 9.49097L44.8088 14.5131L42.3587 20.0597C42.1838 20.5832 42.3373 20.9794 42.8191 21.2487L48.3958 23.7121L46.7563 27.4514H43.6883C43.4396 27.4514 43.202 27.5541 43.0316 27.7353L39.2424 31.7644C39.0565 31.9619 38.9589 32.4888 38.982 32.7728V41.122L38.7454 41.1213L28.4809 36.6209V20.6067ZM48.1573 51.6323L46.4288 51.9374C46.0797 51.9991 45.7991 52.2595 45.7118 52.6029C45.5766 53.1341 45.3687 53.6412 45.0937 54.1103C44.9156 54.414 44.9307 54.7936 45.1322 55.0823L46.1456 56.5339L45.4323 57.2478L43.9797 56.2356C43.6908 56.0343 43.3111 56.0197 43.0076 56.198C42.539 56.4734 42.032 56.6817 41.5009 56.8174C41.1575 56.9051 40.8974 57.1859 40.8361 57.5351L40.5326 59.264L39.5122 59.2607L39.1924 57.5175C39.1291 57.1731 38.8723 56.8964 38.5335 56.8079C38.0002 56.6686 37.4904 56.4565 37.0181 56.1775C36.7148 55.9982 36.3348 56.0122 36.0453 56.2132L34.6035 57.2141L33.8739 56.4853L34.8736 55.0427C35.0742 54.7531 35.0879 54.3732 34.9084 54.0699C34.6289 53.5976 34.4162 53.0879 34.2764 52.5548C34.1876 52.2162 33.9108 51.9595 33.5663 51.8966L31.8228 51.5782L31.8186 50.5581L33.547 50.253C33.8961 50.1913 34.1767 49.9309 34.264 49.5875C34.3992 49.0563 34.6071 48.5492 34.8821 48.0801C35.0602 47.7764 35.0451 47.3968 34.8437 47.1081L33.8302 45.6565L34.5435 44.9426L35.996 45.9548C36.2847 46.1562 36.6644 46.1708 36.968 45.9924C37.437 45.717 37.9439 45.5086 38.4749 45.373C38.8183 45.2853 39.0784 45.0045 39.1397 44.6553L39.4431 42.9264L40.4634 42.9297L40.7833 44.6729C40.8465 45.0173 41.1034 45.294 41.4422 45.3825C41.9756 45.5218 42.4854 45.7339 42.9576 46.0129C43.261 46.1923 43.6411 46.1784 43.9304 45.9772L45.3721 44.9763L46.1017 45.7051L45.1019 47.1477C44.9012 47.4373 44.8876 47.8172 45.0671 48.1205C45.3466 48.5928 45.5592 49.1025 45.699 49.6356C45.7878 49.9742 46.0647 50.2309 46.4092 50.2938L48.1528 50.6122L48.1573 51.6323ZM56.2131 45.4656C56.2127 44.5779 56.2106 42.3848 56.2106 42.3848C56.2106 41.2191 54.4075 41.2191 54.4075 42.3848V46.8251C52.1314 46.8252 49.8075 46.8269 47.5117 46.8368L48.0131 46.1133C48.2614 45.755 48.2178 45.2701 47.9094 44.962L46.1141 43.1684C45.8056 42.8603 45.3208 42.8169 44.9626 43.0657L43.357 44.1806C43.0658 44.0374 42.7655 43.9126 42.458 43.8069L42.1022 41.8678C41.9886 41.2487 41.335 41.0486 40.7976 41.1275C40.7828 40.1262 40.8914 34.8904 40.7976 33.2836H54.4076V37.6777C54.4076 38.8434 56.2107 38.8434 56.2107 37.6777C56.2107 37.6777 56.2134 34.288 56.2134 32.7365L58.1968 30.6277V43.3565L56.2131 45.4656Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M39.985 47C39.9806 46.9998 39.9761 46.9998 39.9717 46.9998C38.8834 46.9998 37.8622 47.4225 37.0948 48.1905C36.3242 48.9617 35.9023 49.9885 35.9068 51.0818C35.9112 52.1727 36.3399 53.1992 37.1138 53.9724C37.8877 54.7456 38.9145 55.1733 40.0053 55.1767H40.0187C41.1069 55.1767 42.1283 54.7541 42.8957 53.9861C43.6662 53.2149 44.0881 52.1881 44.0837 51.0948C44.0792 50.004 43.6506 48.9775 42.8768 48.2043C42.1027 47.4311 41.0758 47.0035 39.985 47ZM41.6199 52.7117C41.1915 53.1405 40.6196 53.3803 40.0108 53.3737C39.3992 53.3717 38.8229 53.1313 38.3881 52.6969C37.9532 52.2624 37.7123 51.6862 37.7097 51.0746C37.7072 50.4654 37.9419 49.8938 38.3703 49.4649C38.7986 49.0361 39.3728 48.799 39.9792 48.8029C40.5908 48.805 41.1672 49.0453 41.6021 49.4798C42.037 49.9142 42.2779 50.4904 42.2803 51.102C42.2829 51.7113 42.0483 52.2828 41.6199 52.7117Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M11.6896 10.377C12.4465 10.377 12.8624 9.37328 12.3272 8.838L9.25306 5.76337C8.42893 4.93899 7.15378 6.21402 7.97804 7.03815L11.0521 10.1129C11.2282 10.289 11.459 10.377 11.6896 10.377Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M5.2216 24.5806H0.874229C-0.29141 24.5806 -0.29141 26.3837 0.874229 26.3837H5.22172C6.38736 26.3837 6.38736 24.5806 5.2216 24.5806Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M11.327 40.7375L8.25294 43.8121C7.42869 44.6364 8.70383 45.9114 9.52797 45.0869L12.602 42.0123C13.4263 41.188 12.1511 39.9131 11.327 40.7375Z"
                                        fill="#EA5501"></path>
                                </svg>
                            </div>
                            <h5 class="rs-feature-title">
                                Quality First
                            </h5>
                            <div class="rs-feature-descrip">
                                <p>Ensuring high precision, durable, and performancedriven machines.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="rs-feature-item wow fadeInUp" data-wow-delay=".5s" data-wow-duration="1s">
                            <div class="rs-feature-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="69" viewBox="0 0 60 69"
                                    fill="none">
                                    <path
                                        d="M58.2461 47.1707C58.2431 47.1707 58.2401 47.1696 58.2361 47.1696L56.2 46.8572C55.9581 46.073 55.6456 45.3261 55.2656 44.6245L56.4812 42.9765C57.094 42.157 57.0124 40.9959 56.2887 40.2742L54.557 38.5516C53.8484 37.8047 52.6852 37.7089 51.8526 38.3278L50.1935 39.5494C49.4638 39.1594 48.7138 38.8499 47.9538 38.6221L47.6454 36.5981C47.5033 35.5861 46.6203 34.8231 45.5912 34.8231H43.1338C42.1218 34.8231 41.2569 35.5539 41.0705 36.5941L40.7751 38.6262C40.4506 38.7249 40.1462 38.8348 39.8549 38.9588C39.7107 39.0021 39.5787 39.0545 39.5031 39.0959C39.1805 39.2239 38.857 39.3741 38.5364 39.5454L36.8763 38.3228C36.0448 37.719 34.8836 37.8147 34.1881 38.5314L32.4554 40.2651C32.0092 40.6978 31.8059 41.2952 31.8482 41.8822C31.3836 41.8203 30.9172 41.7769 30.4496 41.7505V37.6273C33.8895 34.9974 36.0686 30.4769 36.3046 25.5176H37.6323C39.3448 25.5176 40.7388 24.1236 40.7388 22.411V21.3638C40.7388 19.7173 39.4465 18.3794 37.8252 18.2777C37.4136 12.4756 33.4955 7.53717 27.9226 5.83711V3.01885C27.9226 1.3547 26.5679 0 24.9037 0H22.6782C21.014 0 19.6593 1.3547 19.6593 3.01885V5.83711C14.0864 7.53717 10.1683 12.4756 9.7567 18.2777C8.13539 18.3794 6.84306 19.7173 6.84306 21.3638V22.411C6.84306 24.1236 8.23707 25.5176 9.9496 25.5176H11.2558C11.4923 30.4892 13.6997 35.0326 17.1293 37.6386V41.7691C7.59783 42.3011 0 50.2051 0 59.873V63.7234C0 66.1476 1.97258 68.1202 4.39774 68.1202H12.7962C12.7997 68.1202 12.8026 68.1222 12.8062 68.1222C12.8097 68.1222 12.8127 68.1202 12.8162 68.1202H35.8725C35.876 68.1202 35.8789 68.1222 35.8825 68.1222C35.886 68.1222 35.889 68.1202 35.8925 68.1202H43.1751C45.0677 68.1202 46.7598 66.8785 47.3372 65.0859C47.4802 64.8556 47.5945 64.6028 47.6434 64.3131L47.9548 62.278C48.731 62.0401 49.4769 61.7327 50.1834 61.3577L51.8627 62.5905C52.6973 63.1882 53.8565 63.0864 54.5328 62.3717L56.3028 60.6219C56.8652 60.0403 57.0436 59.2098 56.7695 58.483C56.712 58.2925 56.6163 58.105 56.4852 57.9286L55.2646 56.2736C55.6456 55.565 55.9591 54.8181 56.199 54.0419L58.226 53.7325C59.238 53.5873 60 52.7084 60 51.6883V49.2219C60 48.2159 59.246 47.3339 58.2461 47.1707ZM46.7992 54.6562C45.9481 51.7904 44.3933 49.1761 42.2548 47.0376C42.0801 46.8622 41.8968 46.6942 41.7138 46.5265C42.5001 45.9881 43.4234 45.692 44.4038 45.692C47.0557 45.692 49.2138 47.849 49.2138 50.501C49.2138 52.2287 48.2549 53.8054 46.7992 54.6562ZM20.1402 39.3323C20.2228 39.3623 20.3042 39.3948 20.3874 39.4226C21.4808 39.7951 22.6188 39.9919 23.7698 39.9919C24.9287 39.9919 26.0768 39.7921 27.1821 39.4147C27.2653 39.3867 27.3472 39.3545 27.4299 39.3244C27.6841 39.2307 27.9353 39.1273 28.184 39.0143C28.2504 38.9842 28.3194 38.9631 28.3852 38.9316V42.3113L23.7966 46.4546L19.1936 42.2519V38.9447C19.2661 38.9793 19.3422 39.0026 19.4153 39.0354C19.6544 39.1434 19.8959 39.2424 20.1402 39.3323ZM19.6593 8.02263V11.522C19.6593 12.0925 20.121 12.5542 20.6915 12.5542C21.262 12.5542 21.7236 12.0925 21.7236 11.522V6.62433V3.01885C21.7236 2.49269 22.152 2.06431 22.6782 2.06431H24.9037C25.4299 2.06431 25.8583 2.49269 25.8583 3.01885V6.62433C25.8583 6.79959 25.9144 6.95948 25.9933 7.10608V11.9806C25.9933 12.5512 26.455 13.0128 27.0255 13.0128C27.596 13.0128 28.0577 12.5512 28.0577 11.9806V8.07315C32.3629 9.69849 35.3667 13.6398 35.7585 18.2572H11.8234C12.2193 13.5924 15.2817 9.6159 19.6593 8.02263ZM8.90737 22.411V21.3638C8.90737 20.7892 9.37506 20.3225 9.9496 20.3225H37.6323C38.2068 20.3225 38.6745 20.7892 38.6745 21.3638V22.411C38.6745 22.9856 38.2068 23.4533 37.6323 23.4533H35.321H12.2306H9.9496C9.37506 23.4533 8.90737 22.9856 8.90737 22.411ZM13.3031 25.5176H34.2657C34.0278 30.0242 31.9917 34.0933 28.8318 36.2867C28.6067 36.4433 28.3687 36.5659 28.1353 36.7008C25.3844 38.2751 22.087 38.2657 19.3642 36.6654C19.1583 36.5426 18.9484 36.4357 18.7471 36.2947C15.5962 34.1256 13.542 30.0343 13.3031 25.5176ZM43.1751 66.0558H36.9146V56.0407C36.9146 55.4702 36.453 55.0086 35.8825 55.0086C35.312 55.0086 34.8503 55.4702 34.8503 56.0407V66.0558H13.8383V56.0407C13.8383 55.4702 13.3767 55.0086 12.8062 55.0086C12.2357 55.0086 11.774 55.4702 11.774 56.0407V66.0558H4.39774C3.11158 66.0558 2.06431 65.0096 2.06431 63.7234V59.873C2.06431 51.1322 9.06366 43.9978 17.809 43.7872L23.0934 48.613C23.291 48.7935 23.54 48.8832 23.7899 48.8832C24.0379 48.8832 24.2849 48.7945 24.4814 48.6171L24.5305 48.5728L29.8417 43.7879C31.0815 43.8202 32.3183 43.9936 33.5208 44.305C35.7061 44.8796 37.7119 45.8976 39.492 47.338C39.9476 47.6968 40.385 48.0859 40.7943 48.4961C42.9543 50.6562 44.4431 53.3616 45.1013 56.325C45.3644 57.4771 45.4974 58.6705 45.4974 59.873V63.7234C45.4974 63.9494 45.4672 64.1469 45.4135 64.3308C45.4068 64.3493 45.3992 64.3674 45.3936 64.3867C45.1104 65.3694 44.1982 66.0558 43.1751 66.0558ZM57.9357 49.2219L57.9236 51.6904L55.2293 52.1026C54.8191 52.1651 54.4854 52.4685 54.3846 52.8707C54.1216 53.9159 53.7083 54.9017 53.1549 55.8028C52.9342 56.1607 52.9533 56.6173 53.2033 56.956L54.8271 59.1594C54.8271 59.1584 54.7999 59.119 54.7818 59.0384C54.7959 59.0989 54.811 59.113 54.8352 59.1705L53.0753 60.9193L50.8668 59.2985C50.6854 59.1664 50.4707 59.0989 50.256 59.0989C50.0716 59.0989 49.8871 59.1483 49.7218 59.2481C49.0475 59.6553 48.3238 59.9869 47.5617 60.2369V59.873C47.5617 59.258 47.5214 58.6468 47.4597 58.0389C47.4406 57.8495 47.411 57.6635 47.386 57.4753C47.3535 57.2323 47.3329 56.9871 47.2906 56.7463C49.7097 55.6325 51.2781 53.2275 51.2781 50.501C51.2781 46.711 48.1947 43.6277 44.4038 43.6277C42.8203 43.6277 41.2841 44.183 40.0665 45.1759C39.901 45.0548 39.726 44.9515 39.5571 44.8365C39.377 44.7139 39.1979 44.5904 39.0141 44.4747C38.668 44.257 38.313 44.057 37.9542 43.8642C37.7955 43.779 37.6409 43.6859 37.4798 43.6056C36.9581 43.3454 36.4259 43.107 35.8799 42.8989C35.8109 42.8726 35.7385 42.8542 35.6691 42.8287C35.2514 42.6754 34.8306 42.5287 34.3998 42.406L33.9038 41.7357L35.6587 39.9889L37.8571 41.6087C38.1978 41.8607 38.6574 41.8778 39.0172 41.6521C39.4305 41.394 39.8498 41.1793 40.3447 40.9787C40.3911 40.9556 40.4304 40.9404 40.4697 40.9293C40.5191 40.9162 40.5675 40.8991 40.6149 40.8789C41.0059 40.7086 41.4384 40.5685 41.9363 40.4516C42.3486 40.3538 42.66 40.0141 42.7205 39.5948L43.1338 36.8874L45.6033 36.8975L46.0155 39.6019C46.079 40.0202 46.3915 40.3568 46.8037 40.4526C47.7996 40.6824 48.7844 41.0886 49.7319 41.6611C50.0907 41.8778 50.5433 41.8577 50.8779 41.6087L53.0793 39.9929L54.8241 41.7448L53.2033 43.9432C52.9523 44.2838 52.9342 44.7415 53.1569 45.1003C53.7053 45.9833 54.1175 46.968 54.3846 48.0284C54.4854 48.4306 54.8191 48.734 55.2293 48.7965L57.9236 49.2098L58.0798 48.1897L57.9357 49.2219Z"
                                        fill="#EA5501"></path>
                                </svg>
                            </div>
                            <h5 class="rs-feature-title">
                                Innovation
                            </h5>
                            <div class="rs-feature-descrip">
                                <p> Continuous R&D to meet evolving global market standards.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="rs-feature-item wow fadeInUp" data-wow-delay=".7s" data-wow-duration="1s">
                            <div class="rs-feature-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60"
                                    fill="none">
                                    <path
                                        d="M17.4193 38.7095C16.6537 38.7095 15.9053 38.9365 15.2687 39.3618C14.6321 39.7872 14.136 40.3918 13.843 41.0991C13.55 41.8064 13.4734 42.5847 13.6227 43.3356C13.7721 44.0865 14.1408 44.7763 14.6821 45.3176C15.2235 45.859 15.9132 46.2277 16.6641 46.377C17.415 46.5264 18.1933 46.4497 18.9007 46.1567C19.608 45.8638 20.2126 45.3676 20.6379 44.731C21.0632 44.0945 21.2903 43.346 21.2903 42.5804C21.2903 41.5538 20.8824 40.5692 20.1565 39.8433C19.4305 39.1173 18.446 38.7095 17.4193 38.7095ZM17.4193 44.5159C17.0365 44.5159 16.6623 44.4024 16.344 44.1897C16.0257 43.9771 15.7776 43.6748 15.6312 43.3211C15.4847 42.9675 15.4463 42.5783 15.521 42.2028C15.5957 41.8274 15.78 41.4825 16.0507 41.2118C16.3214 40.9412 16.6663 40.7568 17.0417 40.6821C17.4172 40.6075 17.8063 40.6458 18.16 40.7923C18.5137 40.9388 18.8159 41.1869 19.0286 41.5051C19.2413 41.8234 19.3548 42.1976 19.3548 42.5804C19.3548 43.0938 19.1509 43.5861 18.7879 43.949C18.4249 44.312 17.9326 44.5159 17.4193 44.5159Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M5.80658 25.1611C6.87552 25.1611 7.74206 24.2945 7.74206 23.2256C7.74206 22.1566 6.87552 21.2901 5.80658 21.2901C4.73764 21.2901 3.87109 22.1566 3.87109 23.2256C3.87109 24.2945 4.73764 25.1611 5.80658 25.1611Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M18.3871 7.7417C19.4561 7.7417 20.3226 6.87515 20.3226 5.80621C20.3226 4.73727 19.4561 3.87073 18.3871 3.87073C17.3182 3.87073 16.4517 4.73727 16.4517 5.80621C16.4517 6.87515 17.3182 7.7417 18.3871 7.7417Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M59.7164 27.3801L55.1613 22.8249V20.3223C55.1612 20.0657 55.0592 19.8196 54.8777 19.6382L52.4681 17.2285L54.0968 13.9807H54.0871C54.1565 13.8471 54.193 13.6988 54.1935 13.5482V7.7417C54.192 6.45887 53.6817 5.22902 52.7746 4.32192C51.8675 3.41482 50.6377 2.90453 49.3548 2.90299H30.9426C30.4956 2.30416 29.9155 1.81754 29.248 1.48162C28.5805 1.1457 27.844 0.969688 27.0968 0.967511H21.5903C20.7668 0.420808 19.8172 0.0937273 18.8317 0.0173399C17.8462 -0.0590475 16.8575 0.117795 15.9596 0.531069C15.0617 0.944342 14.2844 1.58032 13.7014 2.37859C13.1185 3.17687 12.7493 4.11092 12.629 5.09203L9.17903 6.24267C7.74512 6.72082 6.45944 7.56211 5.44716 8.68462C4.43488 9.80713 3.7305 11.1726 3.40258 12.6482L2.03226 18.8243C1.1648 19.5659 0.535495 20.547 0.223208 21.6447C-0.0890778 22.7424 -0.0704571 23.9078 0.276737 24.995C0.623931 26.0821 1.28426 27.0426 2.17497 27.7561C3.06567 28.4696 4.14715 28.9044 5.28387 29.0059L11.3681 37.6972C10.5009 38.7561 9.92688 40.0242 9.70355 41.3746L7.89 52.2578H4.83871C3.55588 52.2594 2.32602 52.7697 1.41892 53.6768C0.511821 54.5839 0.00153664 55.8137 0 57.0965V59.032C0 59.2887 0.101958 59.5348 0.283445 59.7163C0.464932 59.8978 0.711081 59.9998 0.967742 59.9998H33.871C34.1276 59.9998 34.3738 59.8978 34.5553 59.7163C34.7368 59.5348 34.8387 59.2887 34.8387 59.032V57.0965C34.8372 55.8137 34.3269 54.5839 33.4198 53.6768C32.5127 52.7697 31.2828 52.2594 30 52.2578H26.9487L25.1352 41.3746C24.8648 39.7393 24.0812 38.2325 22.8977 37.072L11.4426 24.5978C11.6771 23.6672 11.6691 22.6919 11.4194 21.7653L17.9603 11.5914C18.1016 11.6011 18.2429 11.6127 18.3871 11.6127C19.527 11.6136 20.6416 11.2769 21.5903 10.6449H27.0968C27.844 10.6428 28.5805 10.4667 29.248 10.1308C29.9155 9.7949 30.4956 9.30828 30.9426 8.70945H44.5161V13.5482C44.5188 13.6979 44.5569 13.8448 44.6274 13.9769H44.6177L46.2416 17.2256L43.8319 19.6353C43.7417 19.7254 43.6702 19.8326 43.6216 19.9505C43.5729 20.0684 43.548 20.1948 43.5484 20.3223V22.8249L38.9932 27.3801C38.8117 27.5615 38.7097 27.8076 38.7097 28.0643V34.8385C38.7097 35.0951 38.8117 35.3412 38.9932 35.5227L43.8319 40.3614C43.9673 40.4967 44.1397 40.5888 44.3274 40.6261C44.5151 40.6635 44.7096 40.6443 44.8864 40.5711C45.0632 40.4978 45.2144 40.3738 45.3207 40.2147C45.4271 40.0556 45.4838 39.8686 45.4839 39.6772V33.8707C45.4838 33.6141 45.3818 33.368 45.2003 33.1865L44.5161 32.5023V30.4004L46.8523 28.0643H51.8574L54.1935 30.4004V32.5023L53.5094 33.1865C53.3279 33.368 53.2259 33.6141 53.2258 33.8707V39.6772C53.2258 39.8686 53.2826 40.0556 53.389 40.2147C53.4953 40.3738 53.6464 40.4978 53.8232 40.5711C54 40.6443 54.1946 40.6635 54.3823 40.6261C54.57 40.5888 54.7424 40.4967 54.8777 40.3614L59.7164 35.5227C59.8979 35.3412 59.9999 35.0951 60 34.8385V28.0643C59.9999 27.8076 59.8979 27.5615 59.7164 27.3801ZM48.0174 16.4514L47.0497 14.5159H51.66L50.6923 16.4514H48.0174ZM52.2581 7.7417V12.5804H46.4516V7.7417C46.4516 6.97172 46.7575 6.23327 47.3019 5.68881C47.8464 5.14435 48.5849 4.83848 49.3548 4.83848C50.1248 4.83848 50.8633 5.14435 51.4077 5.68881C51.9522 6.23327 52.2581 6.97172 52.2581 7.7417ZM5.29258 13.0643C5.54779 11.915 6.09635 10.8514 6.8848 9.97715C7.67325 9.10289 8.67471 8.44775 9.79161 8.07558L12.7306 7.09622C12.8027 7.41567 12.9017 7.72841 13.0268 8.03106L5.32742 17.4433C4.97273 17.4731 4.62156 17.5356 4.27839 17.6301L5.29258 13.0643ZM1.93548 23.2256C1.93548 22.46 2.16251 21.7116 2.58786 21.075C3.01321 20.4384 3.61777 19.9423 4.3251 19.6493C5.03242 19.3563 5.81075 19.2796 6.56164 19.429C7.31253 19.5783 8.00227 19.947 8.54364 20.4884C9.085 21.0298 9.45368 21.7195 9.60304 22.4704C9.7524 23.2213 9.67574 23.9996 9.38276 24.7069C9.08978 25.4143 8.59362 26.0188 7.95705 26.4442C7.32047 26.8695 6.57206 27.0965 5.80645 27.0965C4.77981 27.0965 3.79521 26.6887 3.06926 25.9628C2.34332 25.2368 1.93548 24.2522 1.93548 23.2256ZM32.9032 57.0965V58.0643H1.93548V57.0965C1.93548 56.3266 2.24136 55.5881 2.78582 55.0437C3.33028 54.4992 4.06873 54.1933 4.83871 54.1933H30C30.77 54.1933 31.5084 54.4992 32.0529 55.0437C32.5973 55.5881 32.9032 56.3266 32.9032 57.0965ZM23.2258 41.693L24.9871 52.2578H9.85161L11.6129 41.693C11.8423 40.3187 12.5516 39.0704 13.6148 38.17C14.678 37.2695 16.0261 36.7754 17.4194 36.7754C18.8126 36.7754 20.1607 37.2695 21.2239 38.17C22.2871 39.0704 22.9964 40.3187 23.2258 41.693ZM18.2652 34.8878C17.9843 34.8567 17.702 34.8403 17.4194 34.8385C15.7541 34.8359 14.1318 35.3662 12.7897 36.352L7.48936 28.7814C8.74516 28.398 9.83468 27.6018 10.5813 26.5217L18.2652 34.8878ZM10.4265 19.7272C9.71419 18.7849 8.73245 18.0812 7.61129 17.7094L14.129 9.74203C14.6523 10.3085 15.2829 10.7654 15.9842 11.0862L10.4265 19.7272ZM18.3871 9.67719C17.6215 9.67719 16.8731 9.45016 16.2365 9.02481C15.5999 8.59947 15.1038 7.9949 14.8108 7.28758C14.5178 6.58025 14.4411 5.80193 14.5905 5.05103C14.7399 4.30014 15.1085 3.6104 15.6499 3.06903C16.1913 2.52767 16.881 2.15899 17.6319 2.00963C18.3828 1.86027 19.1611 1.93693 19.8685 2.22991C20.5758 2.5229 21.1803 3.01905 21.6057 3.65563C22.031 4.2922 22.2581 5.04062 22.2581 5.80622C22.2581 6.83287 21.8502 7.81746 21.1243 8.54341C20.3983 9.26936 19.4137 9.67719 18.3871 9.67719ZM27.0968 8.70945H23.4077C23.9223 7.82845 24.1935 6.8265 24.1935 5.80622C24.1935 4.78594 23.9223 3.78399 23.4077 2.90299H27.0968C27.8668 2.90299 28.6052 3.20887 29.1497 3.75333C29.6941 4.29779 30 5.03624 30 5.80622C30 6.5762 29.6941 7.31465 29.1497 7.85911C28.6052 8.40357 27.8668 8.70945 27.0968 8.70945ZM31.8387 4.83848H45.509C45.0688 5.40817 44.7625 6.0697 44.6129 6.77396H31.8387C31.9691 6.13539 31.9691 5.47706 31.8387 4.83848ZM45.4839 20.723L47.82 18.3869H50.8897L53.2258 20.723V22.9972L51.66 26.1288H47.0497L45.4839 22.9972V20.723ZM42.8642 29.3156C42.6827 29.497 42.5807 29.7431 42.5806 29.9998V32.903C42.5807 33.1596 42.6827 33.4057 42.8642 33.5872L43.5484 34.2714V37.3411L40.6452 34.4378V28.4649L44.251 24.8591L45.2739 26.903L42.8642 29.3156ZM58.0645 34.4378L55.1613 37.3411V34.2714L55.8455 33.5872C56.027 33.4057 56.129 33.1596 56.129 32.903V29.9998C56.129 29.7431 56.027 29.497 55.8455 29.3156L53.4358 26.9059L54.4587 24.8591L58.0645 28.4649V34.4378Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M49.3549 24.1933C50.4239 24.1933 51.2904 23.3267 51.2904 22.2578C51.2904 21.1889 50.4239 20.3223 49.3549 20.3223C48.286 20.3223 47.4194 21.1889 47.4194 22.2578C47.4194 23.3267 48.286 24.1933 49.3549 24.1933Z"
                                        fill="#EA5501"></path>
                                </svg>
                            </div>
                            <h5 class="rs-feature-title">
                                Focus
                            </h5>
                            <div class="rs-feature-descrip">
                                <p>Custom-built solutions, transparent communication, and responsive service. </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="rs-feature-item wow fadeInUp" data-wow-delay=".9s" data-wow-duration="1s">
                            <div class="rs-feature-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60"
                                    fill="none">
                                    <path
                                        d="M55.1859 4.3288H47.5171C47.0317 4.3288 46.6382 4.72231 46.6382 5.2077C46.6382 5.69309 47.0317 6.08661 47.5171 6.08661H55.1859C55.6713 6.08661 56.0648 5.69309 56.0648 5.2077C56.0648 4.72231 55.6714 4.3288 55.1859 4.3288Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M43.1621 6.08661H44.0969C44.5823 6.08661 44.9758 5.69309 44.9758 5.2077C44.9758 4.72231 44.5823 4.3288 44.0969 4.3288H43.1621C42.6767 4.3288 42.2832 4.72231 42.2832 5.2077C42.2832 5.69309 42.6767 6.08661 43.1621 6.08661Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M43.1621 10.2153H55.186C55.6714 10.2153 56.0649 9.82181 56.0649 9.33642C56.0649 8.85103 55.6714 8.45752 55.186 8.45752H43.1621C42.6767 8.45752 42.2832 8.85103 42.2832 9.33642C42.2832 9.82181 42.6767 10.2153 43.1621 10.2153Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M46.3409 52.0062C46.3409 48.4954 45.1688 45.0511 43.0339 42.2683L43.1968 39.2677C43.3076 37.2251 41.6867 35.4971 39.6251 35.4971H30.0043C29.5617 35.1843 29.2932 34.6763 29.2932 34.1277V31.6736C30.7849 30.7089 31.8322 29.6088 32.6015 28.2996H34.3024C36.27 28.2996 37.8708 26.6988 37.8708 24.7311V18.1672C37.8708 17.0601 37.2304 16.0815 36.2726 15.6185V11.0119C36.2726 8.91469 34.5665 7.20845 32.4693 7.20845H32.3708C32.3108 7.20845 32.262 7.15958 32.262 7.09969C32.262 5.00251 30.5558 3.29626 28.4586 3.29626H19.1505C14.5302 3.29626 10.7712 7.05528 10.7712 11.6756V15.6184C9.8135 16.0814 9.17295 17.06 9.17295 18.1671V21.5053C9.17295 23.0672 10.4436 24.3378 12.0055 24.3378H13.1401C13.4338 26.8217 14.599 29.0902 16.424 30.6673C16.8522 31.0374 17.2951 31.368 17.7506 31.6633V34.1275C17.7506 34.6746 17.4811 35.1827 17.0365 35.497H7.41901C5.37339 35.497 3.7357 37.2091 3.84749 39.2676L4.01038 42.2682C1.87535 45.0511 0.703241 48.4954 0.703241 52.0062V55.3166C0.266249 55.8064 0 56.4515 0 57.1579C0 58.6846 1.24207 59.9265 2.76878 59.9265H44.2753C45.8021 59.9265 47.0441 58.6845 47.0441 57.1579C47.0441 56.4515 46.7779 55.8064 46.3409 55.3167V52.0062ZM44.5831 52.0062V54.4066C44.4819 54.3953 44.3794 54.3891 44.2753 54.3891H42.376L42.872 45.2497C43.9845 47.3158 44.5831 49.6435 44.5831 52.0062ZM36.0229 17.7381C36.0807 17.8703 36.1133 18.0153 36.1133 18.1673V21.5055C36.1133 22.0981 35.6311 22.5803 35.0385 22.5803H33.9933V19.267L34.535 19.0783C35.2051 18.8449 35.732 18.3527 36.0229 17.7381ZM30.155 27.9214H27.9493C27.5937 27.9214 27.3044 27.6322 27.3044 27.2766C27.3044 26.9211 27.5937 26.6319 27.9493 26.6319H30.155C30.5105 26.6319 30.7997 26.9211 30.7997 27.2766C30.7997 27.6322 30.5105 27.9214 30.155 27.9214ZM34.3026 26.5419H33.4142C33.6617 25.8362 33.8326 25.097 33.9227 24.3381H35.0385C35.4188 24.3381 35.7816 24.2622 36.1133 24.1257V24.7313C36.1133 25.7297 35.3009 26.5419 34.3026 26.5419ZM12.5292 11.6759C12.5292 8.02477 15.4997 5.05431 19.1507 5.05431H28.4588C29.5867 5.05431 30.5044 5.972 30.5044 7.09993C30.5044 8.12919 31.3419 8.96649 32.371 8.96649H32.4695C33.5975 8.96649 34.515 9.88418 34.515 11.0121V16.6328C34.515 16.9864 34.2906 17.3021 33.9567 17.4185L32.1097 18.0617C32.0353 18.0875 31.9585 18.0339 31.9585 17.9538L31.9619 14.4612C31.9726 11.9122 29.5858 9.68918 26.2417 10.7633C24.5599 11.3038 22.4785 11.3019 20.8023 10.7633C17.4929 9.69973 15.0715 11.8833 15.0821 14.4585L15.0862 17.954C15.0862 18.0347 15.0077 18.0878 14.9351 18.0617L13.0875 17.4184C12.7535 17.3021 12.5291 16.9863 12.5291 16.6326L12.5292 11.6759ZM10.931 21.5055V18.1672C10.931 18.0153 10.9636 17.8701 11.0213 17.738C11.3123 18.3527 11.8393 18.8449 12.5096 19.0783L13.0511 19.2669V22.5801H12.0058C11.4131 22.5803 10.931 22.098 10.931 21.5055ZM14.825 23.3229C14.7958 22.1674 14.8138 20.9409 14.8088 19.818C14.863 19.8227 14.9172 19.8254 14.9715 19.8254C16.0165 19.8254 16.8458 18.976 16.844 17.9515L16.8399 14.4537C16.834 13.0266 18.1141 11.7456 20.2645 12.4368C22.3026 13.0916 24.7481 13.0896 26.7795 12.4368C28.8283 11.7785 30.2104 12.9374 30.2041 14.4566L30.2007 17.9517C30.1993 19.0411 31.1304 19.9139 32.2353 19.818V23.394C32.2097 24.1536 32.0847 24.8949 31.8726 25.5999C31.4361 25.1527 30.8278 24.874 30.155 24.874H27.9493C26.6245 24.874 25.5466 25.9517 25.5466 27.2765C25.5466 28.6013 26.6245 29.6791 27.9493 29.6791H29.066C27.4426 30.9463 25.5965 31.607 23.5681 31.6406C19.1309 31.6051 14.9519 28.327 14.825 23.3229ZM19.5088 34.1278V32.5899C20.7792 33.116 22.1345 33.3885 23.5658 33.3986H23.572C23.5766 33.3986 23.5811 33.3986 23.5857 33.3985C24.9792 33.3768 26.2985 33.1068 27.5357 32.5971V34.1277C27.5357 34.6075 27.6362 35.0721 27.8211 35.4971H19.2223C19.4079 35.0719 19.5088 34.6073 19.5088 34.1278ZM4.1721 45.2497L4.31085 47.8068C4.33722 48.2916 4.75241 48.6644 5.23604 48.6368C5.72073 48.6106 6.09233 48.1963 6.06608 47.7116L5.60261 39.1726C5.54624 38.1338 6.37053 37.255 7.41901 37.255H39.6252C40.666 37.255 41.4984 38.126 41.4416 39.1726L40.6157 54.3892H26.8335C27.0015 53.3853 27.4536 52.441 28.15 51.6673L28.1752 51.6392C30.8356 48.6629 30.0393 44.0086 26.6006 42.0547C25.7182 41.5533 24.5975 42.1785 24.5975 43.2179V47.2057C24.5975 47.3886 24.4488 47.5372 24.266 47.5372H22.7782C22.5953 47.5372 22.4466 47.3884 22.4466 47.2057V43.2179C22.4466 42.1805 21.3277 41.5523 20.4436 42.0547C16.995 44.014 16.2149 48.67 18.8716 51.6421L18.8941 51.6673C19.5905 52.4409 20.0427 53.3852 20.2106 54.3891H6.42854L6.28757 51.7907C6.26132 51.306 5.84706 50.9339 5.36237 50.9607C4.87769 50.9869 4.50608 51.4012 4.53233 51.8859L4.66816 54.3891H2.76878C2.66472 54.3891 2.56218 54.3954 2.46105 54.4066V52.0062C2.46105 49.6436 3.05976 47.3158 4.1721 45.2497ZM21.9866 54.3891C21.8067 52.949 21.1893 51.5895 20.2007 50.4913L20.1795 50.4675C18.4814 48.5679 18.7088 45.6304 20.6889 44.0103V47.2056C20.6889 48.3577 21.6262 49.2948 22.7783 49.2948H24.2661C25.4182 49.2948 26.3554 48.3576 26.3554 47.2056V44.0103C28.3224 45.6196 28.5744 48.555 26.8626 50.47L26.8436 50.4912C25.8549 51.5895 25.2376 52.949 25.0577 54.3891H21.9866ZM44.2753 58.1689H2.76878C2.21132 58.1689 1.75781 57.7153 1.75781 57.158C1.75781 56.6007 2.21132 56.147 2.76878 56.147H44.2753C44.8328 56.147 45.2863 56.6005 45.2863 57.158C45.2863 57.7155 44.8328 58.1689 44.2753 58.1689Z"
                                        fill="#EA5501"></path>
                                    <path
                                        d="M59.1209 6.01487C59.6063 6.01487 59.9998 5.62136 59.9998 5.13597V3.43488C59.9998 1.5409 58.4589 0 56.5648 0H41.7827C39.8886 0 38.3477 1.5409 38.3477 3.43488V10.828C38.3477 12.7221 39.8886 14.263 41.7827 14.263C42.1211 14.263 42.3965 14.5384 42.3965 14.8768V19.4489C42.3965 20.1092 42.824 20.6712 43.4604 20.8474C44.1006 21.0246 44.7545 20.7581 45.0921 20.1951L48.4706 14.5611C48.5809 14.3772 48.7827 14.263 48.9972 14.263H56.5649C58.459 14.263 59.9999 12.7221 59.9999 10.828V9.24502C59.9999 8.75963 59.6064 8.36612 59.121 8.36612C58.6356 8.36612 58.2421 8.75963 58.2421 9.24502V10.828C58.2421 11.7528 57.4897 12.5052 56.5649 12.5052H48.9971C48.1685 12.5052 47.3891 12.9466 46.963 13.6571L44.1542 18.3411V14.8768C44.1542 13.5691 43.0902 12.5052 41.7825 12.5052C40.8577 12.5052 40.1054 11.7528 40.1054 10.828V3.43488C40.1054 2.51015 40.8577 1.75781 41.7825 1.75781H56.5648C57.4896 1.75781 58.242 2.51015 58.242 3.43488V5.13597C58.242 5.62136 58.6355 6.01487 59.1209 6.01487Z"
                                        fill="#EA5501"></path>
                                </svg>
                            </div>
                            <h5 class="rs-feature-title">
                                Integrity
                            </h5>
                            <div class="rs-feature-descrip">
                                <p> Ethical business processes, long-term relationships, and trust-driven partnerships. </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

<section class="rs-why-choose-area rs-why-choose-three">
            <span class="rs-why-choose-shape gsap-move down-200 start-61"></span>
            <div class="rs-why-choose-bg-thumb" data-background="assets/images/bg/why-choose-bg.png"></div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 col-lg-6 col-md-10">
                        <div class="rs-why-choose-content-wrapper section-space">
                            <div class="rs-section-title-wrapper section-title-space">
                                <span class="justify-content-start rs-section-subtitle has-stroke">
                                    Why Choose Us
                                </span>
                                <h2 class="rs-section-title rs-split-text-enable split-in-fade">Always Powering Your
                                    Business
                                    For Over 20 Years</h2>
                            </div>
							
                            <div class="rs-why-choose-content-inner">
                                <div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".3s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="52" height="39"
                                            viewBox="0 0 52 39" fill="none">
                                            <path
                                                d="M47.7749 4.22461C47.7749 5.91816 46.7266 5.91816 46.7266 7.69235C46.7266 9.3859 47.7749 9.3859 47.7749 11.1601C47.7749 12.8536 46.7266 12.8536 46.7266 14.6278C46.7266 16.3214 47.7749 16.3214 47.7749 18.0956C47.7749 19.7891 46.7266 19.7891 46.7266 21.5633C46.7266 23.2569 47.7749 23.2569 47.7749 25.0311C47.7749 26.7246 46.7266 26.7246 46.7266 28.4988C46.7266 30.1923 47.7749 30.1924 47.7749 31.9665"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M26.0003 29.7916C30.3206 29.7916 33.8229 26.2894 33.8229 21.9691C33.8229 17.6488 30.3206 14.1465 26.0003 14.1465C21.68 14.1465 18.1777 17.6488 18.1777 21.9691C18.1777 26.2894 21.68 29.7916 26.0003 29.7916Z"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M30.3542 28.4199V38.0973L25.9994 34.4683L21.6445 38.0973V28.4199C22.9349 29.307 24.3865 29.7909 25.9994 29.7909C27.6123 29.7909 29.1445 29.307 30.3542 28.4199Z"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M26.0014 16.8086L27.5336 19.8731L30.9207 20.357L28.5014 22.7763L29.0659 26.2441L26.0014 24.6312L22.9369 26.2441L23.5014 22.7763L21.082 20.357L24.4691 19.8731L26.0014 16.8086Z"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M18.4194 35.0323H1V1H51V35.0323H33.5806" stroke="white"
                                                stroke-width="1.7" stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round"></path>
                                            <path
                                                d="M4.22656 4.22461C5.75882 4.22461 5.75882 5.273 7.37172 5.273C8.90398 5.273 8.90398 4.22461 10.5169 4.22461C12.0491 4.22461 12.0491 5.273 13.662 5.273C15.1943 5.273 15.1943 4.22461 16.8072 4.22461C18.3395 4.22461 18.3395 5.273 19.9524 5.273C21.4846 5.273 21.4846 4.22461 23.0975 4.22461C24.6298 4.22461 24.6298 5.273 26.2427 5.273C27.7749 5.273 27.7749 4.22461 29.3879 4.22461C30.9201 4.22461 30.9201 5.273 32.533 5.273C34.0653 5.273 34.0653 4.22461 35.6782 4.22461C37.2104 4.22461 37.2104 5.273 38.8233 5.273C40.4362 5.273 40.3556 4.22461 41.9685 4.22461C43.5008 4.22461 43.5008 5.273 45.1137 5.273C46.6459 5.273 46.6459 4.22461 48.2588 4.22461"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M4.22656 4.22461C4.22656 5.91816 5.27495 5.91816 5.27495 7.69235C5.27495 9.3859 4.22656 9.3859 4.22656 11.1601C4.22656 12.8536 5.27495 12.8536 5.27495 14.6278C5.27495 16.3214 4.22656 16.3214 4.22656 18.0149C4.22656 19.7085 5.27495 19.7085 5.27495 21.4827C5.27495 23.1762 4.22656 23.1762 4.22656 24.9504C4.22656 26.644 5.27495 26.644 5.27495 28.4182C5.27495 30.1117 4.22656 30.1117 4.22656 31.8859"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M33.582 31.1613C34.0659 31.4839 34.3885 31.8064 35.2756 31.8064C36.8078 31.8064 36.8078 30.7581 38.4207 30.7581C40.0336 30.7581 39.953 31.8064 41.5659 31.8064C43.1788 31.8064 43.0982 30.7581 44.7111 30.7581C46.2433 30.7581 46.2433 31.8064 47.8562 31.8064"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path
                                                d="M4.22656 31.8062C5.75882 31.8062 5.75882 30.7578 7.37172 30.7578C8.98463 30.7578 8.90398 31.8062 10.5169 31.8062C12.1298 31.8062 12.0491 30.7578 13.662 30.7578C15.275 30.7578 15.1943 31.8062 16.8072 31.8062C17.6943 31.8062 18.0975 31.4836 18.5008 31.161"
                                                stroke="white" stroke-width="1.7" stroke-miterlimit="10"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M10.2754 9.95117H41.727" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M41.7259 12.8535H32.3711" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M19.6302 12.8535H10.2754" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M39.0663 15.8379H35.1953" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                            <path d="M16.8065 15.8379H12.9355" stroke="white" stroke-width="1.7"
                                                stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                            </path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title"> Extensive Product Range</h6>
                                        <!--<p class="descrip"> Stands as a multidimensional force of progress. </p>-->
                                    </div>
                                </div>
                                <div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".5s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="52" height="44"
                                            viewBox="0 0 52 44" fill="none">
                                            <path
                                                d="M1 35.972L11.8434 42.8999H41.6627L51 35.9721M1 35.972V29.6468L3.71084 28.442M1 35.972C2.13109 35.7807 3.23424 35.6004 4.31325 35.4312M51 35.9721V30.5504C50.367 28.7154 49.5632 28.2966 47.3855 28.442M51 35.9721C49.7161 35.7685 48.5209 35.5779 47.3855 35.4002M3.71084 28.442L4.31325 35.4312M3.71084 28.442C3.71295 17.0045 6.19652 11.6895 14.5542 6.45407L14.5643 6.75527M4.31325 35.4312C7.72785 34.8957 10.9007 34.4713 13.9518 34.1606M14.8554 15.4902C14.332 16.2806 14.1829 16.7992 14.253 17.8999L13.9518 34.1606M14.8554 15.4902C16.2976 13.0882 17.5835 11.4975 19.0723 10.4783M14.8554 15.4902L14.5643 6.75527M13.9518 34.1606C21.9015 33.3511 29.0249 33.3131 37.4458 34.0922M37.4458 34.0922C37.3505 27.4542 37.6415 23.4852 36.8081 17.2974M37.4458 34.0922C40.7709 34.3998 43.7753 34.8349 47.3855 35.4002M36.8081 17.2974C36.7298 16.716 36.6416 16.1149 36.5422 15.4902C35.2686 13.357 34.0887 11.8955 32.6265 10.8879M36.8081 17.2974V6.15284M32.6265 3.44202C32.8186 2.38671 34.1325 1.93599 34.4337 1.93599C34.7349 1.93599 36.3427 2.40407 36.8081 3.44202V6.15284M32.6265 3.44202V10.8879M32.6265 3.44202H29.012M32.6265 10.8879C31.603 10.1826 30.4411 9.69973 29.012 9.36462M29.012 3.44202V9.36462M29.012 3.44202C28.6022 1.27565 27.7684 0.898007 25.6988 1.03238C23.8847 0.867197 23.1108 1.28444 22.3855 3.44202V9.13869M29.012 9.36462C28.0437 9.13755 26.9527 8.97833 25.6988 8.86371C24.4485 8.86923 23.36 8.95033 22.3855 9.13869M22.3855 9.13869C21.1242 9.38253 20.0541 9.80613 19.0723 10.4783M22.0843 3.44202C20.7961 3.16488 20.1168 3.24563 19.0723 4.34563M19.0723 4.34563V10.4783M19.0723 4.34563C18.496 2.93306 17.9234 2.55188 16.6627 2.2372C15.1406 2.94065 14.8086 3.42516 14.5542 4.34563L14.5643 6.75527M47.3855 28.442V35.4002M47.3855 28.442V20.9119C45.6681 14.2309 44.1887 10.6804 36.8081 6.15284M17.2651 22.1167V31.454"
                                                stroke="white" stroke-width="2"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title"> Advanced Manufacturing Infrastructure</h6>
                                        <!--<p class="descrip"> Stands as a multidimensional force of progress. </p>-->
                                    </div>
                                </div>
                                <div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".7s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Strong AfterSales Support</h6>
                                        
                                    </div>
                                </div>
								<div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".8s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Customization</h6>
                                       
                                    </div>
                                </div>
								<div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".9s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Experienced Technical Team</h6>
                                        
                                    </div>
                                </div>
								<div class="rs-why-choose-content-item wow fadeInUp" data-wow-delay=".10s"
                                    data-wow-duration="1s">
                                    <div class="rs-why-choose-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="50" height="49"
                                            viewBox="0 0 50 49" fill="none">
                                            <path
                                                d="M46.9297 21.1611C46.7344 15.5954 44.4805 10.3908 40.5229 6.43317C36.3747 2.28418 30.8615 0 25 0C13.1613 0 3.48806 9.42294 3.07108 21.1611C1.26447 21.964 0 23.7722 0 25.8738V31.6636C0 34.5066 2.31288 36.8203 5.15674 36.8203C6.99684 36.8203 8.49332 35.3239 8.49332 33.4838V24.0528C8.49332 22.3252 7.16826 20.9164 5.48362 20.749C6.10549 10.5224 14.6187 2.39181 25 2.39181C30.2237 2.39181 35.1357 4.42804 38.8326 8.12498C42.2274 11.5198 44.2142 15.9446 44.5132 20.7498C42.8302 20.9188 41.5075 22.3268 41.5075 24.0528V33.483C41.5075 35.225 42.8533 36.6425 44.5578 36.79V39.1731C44.5578 41.8567 42.3741 44.0396 39.6905 44.0396H36.086C35.909 43.5341 35.6316 43.0669 35.2425 42.6795C34.5609 41.9946 33.652 41.6175 32.6841 41.6175H28.9688C28.4354 41.6175 27.9236 41.7307 27.4548 41.9492C26.176 42.5368 25.35 43.8267 25.35 45.2355C25.35 46.2034 25.7271 47.1123 26.4104 47.7924C27.0936 48.4772 28.0025 48.8543 28.9688 48.8543H32.6841C34.2244 48.8543 35.5822 47.8585 36.0884 46.4314H39.6905C43.6936 46.4314 46.9496 43.1754 46.9496 39.1731V36.3643C48.7451 35.5567 50 33.7548 50 31.662V25.8722C50 23.7722 48.7355 21.964 46.9297 21.1611ZM6.10071 24.0528V33.483C6.10071 34.0036 5.67736 34.4277 5.15595 34.4277C3.63157 34.4277 2.39101 33.1872 2.39101 31.6628V25.873C2.39101 24.3478 3.63157 23.1081 5.15595 23.1081C5.67736 23.1081 6.10071 23.5322 6.10071 24.0528ZM33.884 45.4922C33.7652 46.0551 33.2597 46.4641 32.6833 46.4641H28.968C28.6411 46.4641 28.3342 46.3365 28.0998 46.1021C27.8686 45.8717 27.741 45.564 27.741 45.2371C27.741 44.7595 28.0209 44.3234 28.4594 44.1217C28.6156 44.0484 28.787 44.0109 28.968 44.0109H32.6833C33.0102 44.0109 33.3171 44.1377 33.5507 44.3721C33.7819 44.6025 33.9095 44.9102 33.9095 45.2371C33.9103 45.3248 33.9007 45.4125 33.884 45.4922ZM47.6082 31.6628C47.6082 33.1872 46.3676 34.4277 44.8433 34.4277C44.3226 34.4277 43.8985 34.0044 43.8985 33.483V24.0528C43.8985 23.5322 44.3218 23.1081 44.8433 23.1081C46.3676 23.1081 47.6082 24.3486 47.6082 25.873V31.6628Z"
                                                fill="white"></path>
                                            <path
                                                d="M32.7427 32.0756C35.5372 32.0756 37.8102 29.8018 37.8102 27.0081V16.6827C37.8102 15.3321 37.2824 14.0597 36.3241 13.1013C35.3657 12.143 34.0941 11.6152 32.7427 11.6152H17.255C14.4605 11.6152 12.1875 13.8883 12.1875 16.6827V27.0081C12.1875 29.8026 14.4605 32.0756 17.255 32.0756H17.3498V34.7512C17.3498 35.7717 17.9581 36.6774 18.8989 37.0593C19.2027 37.1813 19.5184 37.2419 19.8309 37.2419C20.4823 37.2419 21.1169 36.9836 21.5817 36.5028L26.0329 32.0756H32.7427ZM24.6975 30.0314L19.8804 34.8222C19.8588 34.8445 19.8429 34.8612 19.7974 34.8413C19.7424 34.819 19.7424 34.7831 19.7424 34.7512V30.8797C19.7424 30.2195 19.2075 29.6838 18.5465 29.6838H17.2557C15.78 29.6838 14.5801 28.4831 14.5801 27.0081V16.6827C14.5801 15.2069 15.78 14.007 17.2557 14.007H32.7435C33.4563 14.007 34.1268 14.2861 34.6338 14.7924C35.1409 15.2994 35.4192 15.9707 35.4192 16.6827V27.0081C35.4192 28.4839 34.2185 29.6838 32.7435 29.6838H25.541C25.2245 29.6838 24.9215 29.8089 24.6975 30.0314Z"
                                                fill="white"></path>
                                            <path
                                                d="M19.1901 20.2715C18.2175 20.2715 17.4258 21.064 17.4258 22.0358C17.4258 23.0077 18.2183 23.8002 19.1901 23.8002C20.1636 23.8002 20.9561 23.0077 20.9561 22.0358C20.9561 21.064 20.1644 20.2715 19.1901 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M24.9987 20.2715C24.0261 20.2715 23.2344 21.064 23.2344 22.0358C23.2344 23.0077 24.0269 23.8002 24.9987 23.8002C25.973 23.8002 26.7647 23.0077 26.7647 22.0358C26.7647 21.064 25.973 20.2715 24.9987 20.2715Z"
                                                fill="white"></path>
                                            <path
                                                d="M30.8073 20.2715C29.8347 20.2715 29.043 21.064 29.043 22.0358C29.043 23.0077 29.8355 23.8002 30.8073 23.8002C31.7808 23.8002 32.5733 23.0077 32.5733 22.0358C32.5733 21.064 31.7808 20.2715 30.8073 20.2715Z"

                                                fill="white"></path>
                                        </svg>
                                    </div>
                                    <div class="rs-why-choose-content">
                                        <h6 class="rs-why-choose-title">Global Export Capability</h6>
                                       
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="rs-why-choose-btn-wrapper" data-background="assets/images/bg/video-bg-05.png">
                <div class="rs-why-choose-btn">
                    <a href="https://www.youtube.com/watch?v=go7QYaQR494" class="rs-play-btn popup-video"><i
                            class="fa-duotone fa-play"></i></a>
                </div>
            </div>
        </section>

<section class="rs-services-area section-space rs-services-eight rs-swiper">
            <div class="rs-services-bg-thumb" data-background="assets/images/bg/services-bg-05.png">
            </div>
            <div class="container">
                <div class="row align-items-center g-5 section-title-space">
                    <div class="col-xl-7 col-lg-7">
                        <div class="rs-section-title-wrapper">
                            <span class="rs-section-subtitle has-theme-yellow justify-content-start">
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                    fill="none">
                                    <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                        fill="#EA5501"></path>
                                </svg>
                                Best Services
                            </span>
                            <h2 class="rs-section-title rs-split-text-enable split-in-fade">Get best industrial services
                                for
                                your business</h2>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-5">
                        <!-- If we need navigation buttons -->
                        <div class="rs-services-navigation">
                            <button class="swiper-button-prev rs-swiper-btn has-theme-yellow"><i
                                    class="fa-regular fa-arrow-left"></i></button>
                            <button class="swiper-button-next rs-swiper-btn has-theme-yellow"><i
                                    class="fa-regular fa-arrow-right"></i></button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="rs-services-slide-wrapper">
                        <div class="swiper" data-clone-slides="false" data-loop="false" data-speed="1500"
                            data-autoplay="true" data-dots-dynamic="false" data-hover-pause="true" data-effect="false"
                            data-delay="1000" data-item="3" data-item-xl="3" data-item-lg="3" data-item-md="2"
                            data-item-sm="1" data-item-xs="1" data-item-mobile="1" data-margin="30">
                            <div class="swiper-wrapper process-counts">
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-21.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Best
                                                    innovations in
                                                    metallurgy</a></h5>
                                            <!--<p class="descrip"> Consectetur ipiscing elit tellus ullam corper mattis
                                            </p>-->
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                               
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-22.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Manufacturer
                                                    of tin lead
                                                    and lead...</a></h5>
                                           
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                               
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-23.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> State of the
                                                    art for
                                                    hight control in... </a></h5>
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-08.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Automation
                                                    industry
                                                    management</a></h5>
                                                                                        
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-21.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Best
                                                    innovations in
                                                    metallurgy</a></h5>
                                                                                        
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-22.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> Manufacturer
                                                    of tin lead
                                                    and lead...</a></h5>
                                                                                      
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rs-services-item">
                                        <div class="rs-services-thumb">
                                            <a href="services-details.html"> <img
                                                    src="assets/images/services/services-thumb-23.png" alt="image"></a>
                                        </div>
                                        <div class="rs-services-content">
                                            <h5 class="rs-services-title"><a href="services-details.html"> State of the
                                                    art for
                                                    hight control in... </a></h5>
                                            
                                            <div class="rs-services-btn-wrapper">
                                                <div class="rs-services-text-btn underline has-theme-yellow">
                                                    <a class="rs-text-btn" href="services-details.html">View
                                                        Details</a>
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

<!-- testimonial area start -->
<section class="rs-faq-area section-space rs-faq-one">
            <div class="rs-faq-bg-thumb" data-background="assets/images/bg/faq-bg-01.png"></div>
            <div class="container">
                <div class="row g-5">
                    <div class="col-xl-6 col-lg-6">
                        <!-- faq area start -->
                        <div class="rs-faq-wrapper">
                            <div class="rs-section-title-wrapper section-title-space">
                                <span class="rs-section-subtitle has-theme-red justify-content-start">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                        fill="none">
                                        <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                            fill="#EA5501"></path>
                                    </svg>
                                    Faq's
                                </span>
                                <h2 class="rs-section-title rs-split-text-enable split-in-fade">General Questions</h2>
                            </div>
                            <div class="rs-faq-content rs-accordion-one has-theme-red">
                                <div class="accordion-wrapper">
                                    <div class="accordion" id="accordionExampleOne">
                                        <div class="rs-accordion-item has-border-active">
                                            <h4 class="accordion-header" id="headingOne">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne" aria-expanded="true"
                                                    aria-controls="collapseOne">
                                                    01. Why is sand important for industry?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h4>
                                            <div id="collapseOne" class="accordion-collapse collapse show"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body"> Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="rs-accordion-item has-border-active">
                                            <h6 class="accordion-header" id="headingTwo">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                    aria-expanded="false" aria-controls="collapseTwo">
                                                    02. Can I switch to a different plan?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h6>
                                            <div id="collapseTwo" class="accordion-collapse collapse"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body">Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.</div>
                                            </div>
                                        </div>
                                        <div class="rs-accordion-item has-border-active">
                                            <h6 class="accordion-header" id="headingThree">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                                    aria-expanded="false" aria-controls="collapseThree">
                                                    03. What should I wear for an industry treatment?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h6>
                                            <div id="collapseThree" class="accordion-collapse collapse"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body">Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.</div>
                                            </div>
                                        </div>
                                        <div class="rs-accordion-item has-border-active">
                                            <h6 class="accordion-header" id="headingFour">
                                                <button class="accordion-button collapsed" type="button"
                                                    data-bs-toggle="collapse" data-bs-target="#collapseFour"
                                                    aria-expanded="false" aria-controls="collapseFour">
                                                    04. Can you give tips for the stock market?
                                                    <span class="accordion-btn"></span>
                                                </button>
                                            </h6>
                                            <div id="collapseFour" class="accordion-collapse collapse"
                                                data-bs-parent="#accordionExampleOne">
                                                <div class="accordion-body">Randomised words which don’t look even
                                                    slightly
                                                    believable. If you are going to use a passage of Lorem Ipsum, you
                                                    need to be sure
                                                    there isn’t anything.</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- faq area end -->
                    </div>
                    <!-- testimonial area start -->
                    <div class="col-xl-6 col-lg-6">
                        <div class="rs-testimonial-wrapper rs-testimonial-two rs-swiper">
                            <div class="rs-section-title-wrapper section-title-space">
                                <span class="rs-section-subtitle has-theme-red justify-content-start">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                        fill="none">
                                        <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                            fill="#EA5501"></path>
                                    </svg>
                                    Reviews
                                </span>
                                <h2 class="rs-section-title rs-split-text-enable split-in-fade">Customer Feedback</h2>
                            </div>
                            <div class="rs-testimonial-slider-wrapper">
                                <div class="swiper" data-clone-slides="false" data-loop="true" data-speed="1500"
                                    data-autoplay="true" data-dots-dynamic="false" data-hover-pause="true"
                                    data-effect="false" data-delay="2500" data-item="1" data-item-xl="1"
                                    data-item-lg="1" data-item-md="1" data-item-sm="1" data-item-xs="1"
                                    data-item-mobile="1" data-margin="30" data-margin-xl="30">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <div class="rs-testimonial-item">
                                                <div class="rs-testimonial-avater-thumb">
                                                    <div class="rs-testimonial-thumb">
                                                        <img src="assets/images/user/user-thumb-01.png" alt="image">
                                                    </div>
                                                    <div class="rs-testimonial-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="29"
                                                            viewBox="0 0 40 29" fill="none">
                                                            <path
                                                                d="M2.85714 29H11.4286L17.1429 17.4V0H0V17.4H8.57143L2.85714 29ZM25.7143 29H34.2857L40 17.4V0H22.8571V17.4H31.4286L25.7143 29Z"
                                                                fill="white" fill-opacity="0.4"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                                <div class="rs-testimonial-content">
                                                    <h5 class="rs-testimonial-title">Best Company</h5>
                                                    <div class="rs-testimonial-description">
                                                        <p>Podcasting operational change management inside of workflows
                                                            to establish a
                                                            framework Taking seamless key performance indicators.</p>
                                                    </div>
                                                    <div class="rs-tesimonial-avater-info">
                                                        <h6 class="rs-testimonial-avater-title">Nayeem</h6>
                                                        <span class="rs-testimonial-avater-designation">Manager</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="rs-testimonial-item">
                                                <div class="rs-testimonial-avater-thumb">
                                                    <div class="rs-testimonial-thumb">
                                                        <img src="assets/images/user/user-thumb-02.png" alt="image">
                                                    </div>
                                                    <div class="rs-testimonial-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="29"
                                                            viewBox="0 0 40 29" fill="none">
                                                            <path
                                                                d="M2.85714 29H11.4286L17.1429 17.4V0H0V17.4H8.57143L2.85714 29ZM25.7143 29H34.2857L40 17.4V0H22.8571V17.4H31.4286L25.7143 29Z"
                                                                fill="white" fill-opacity="0.4"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                                <div class="rs-testimonial-content">
                                                    <h5 class="rs-testimonial-title">Best Company</h5>
                                                    <div class="rs-testimonial-description">
                                                        <p>Podcasting operational change management inside of workflows
                                                            to establish a
                                                            framework Taking seamless key performance indicators.</p>
                                                    </div>
                                                    <div class="rs-tesimonial-avater-info">
                                                        <h6 class="rs-testimonial-avater-title">Abdur Rashid</h6>
                                                        <span class="rs-testimonial-avater-designation">Founder &amp;
                                                            CEO</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="swiper-slide">
                                            <div class="rs-testimonial-item">
                                                <div class="rs-testimonial-avater-thumb">
                                                    <div class="rs-testimonial-thumb">
                                                        <img src="assets/images/user/user-thumb-03.png" alt="image">
                                                    </div>
                                                    <div class="rs-testimonial-icon">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="29"
                                                            viewBox="0 0 40 29" fill="none">
                                                            <path
                                                                d="M2.85714 29H11.4286L17.1429 17.4V0H0V17.4H8.57143L2.85714 29ZM25.7143 29H34.2857L40 17.4V0H22.8571V17.4H31.4286L25.7143 29Z"
                                                                fill="white" fill-opacity="0.4"></path>
                                                        </svg>
                                                    </div>
                                                </div>
                                                <div class="rs-testimonial-content">
                                                    <h5 class="rs-testimonial-title">Best Company</h5>
                                                    <div class="rs-testimonial-description">
                                                        <p>Podcasting operational change management inside of workflows
                                                            to establish a
                                                            framework Taking seamless key performance indicators.</p>
                                                    </div>
                                                    <div class="rs-tesimonial-avater-info">
                                                        <h6 class="rs-testimonial-avater-title">Tom Hanks</h6>
                                                        <span class="rs-testimonial-avater-designation">Customer</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- If we need navigation buttons -->
                                    <div class=" rs-testimonial-navigation">
                                        <button
                                            class="swiper-button-prev rs-swiper-btn has-bg-white hover-black has-small"><i
                                                class="fa-regular fa-arrow-left"></i></button>
                                        <button
                                            class="swiper-button-next rs-swiper-btn has-bg-white hover-black has-small"><i
                                                class="fa-regular fa-arrow-right"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- testimonial area end -->
                </div>
            </div>
        </section>
<!-- testimonial area start -->

<!-- brand area start -->
<section class="rs-brand-area rs-brand-one section-space-bottom primary-bg rs-swiper">
	<div class="container">
		<div class="row  g-5 section-title-space justify-content-center">
			<div class="col-xl-7 col-lg-7">
				<div class="rs-section-title-wrapper text-center">
					<span class="rs-section-subtitle has-theme-orange">
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="15" viewBox="0 0 11 15"
                                    fill="none">
                                    <path d="M3.14286 10L0 15L8.78104e-07 0L3.14286 5V10Z" fill="#EA5501"></path>
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M6.28571 10L3.14286 15L3.14286 10L4.71428 7.5L3.14286 5L3.14286 0L6.28571 5L6.28571 10ZM6.28571 10L7.85714 7.5L6.28571 5V0L11 7.5L6.28571 15V10Z"
                                        fill="#EA5501"></path>
                                </svg>
                                Partners
                            </span>
				
					<h2 class="rs-section-title rs-split-text-enable split-in-fade">Partners Who Trust Industrie
                            </h2>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xl-12">
				<div class="rs-brand-wrapper">
					<div class="swiper" data-clone-slides="false" data-loop="true" data-speed="1500" data-autoplay="false" data-dots-dynamic="false" data-center-mode="false" data-hover-pause="true" data-effect="false" data-delay="1500" data-item="6" data-item-xl="4" data-item-lg="4" data-item-md="3" data-item-sm="2" data-item-xs="2" data-item-mobile="1">
						<div class="swiper-wrapper">
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-02.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-03.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-04.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-05.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-06.png" alt="image">
									</div>
								</div>
							</div>
							<div class="swiper-slide">
								<div class="rs-brand-item has-clip-path">
									<div class="rs-brand-thumb">
										<img src="assets/images/brand/brand-thumb-07.png" alt="image">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php
$content = ob_get_clean();
include 'layout/layout.php';
?>