   <?php
   $title = "PP / HDPE Raffia Woven Sack Production Line | Heaven Extrusions";
   $meta_description = "High-performance PP / HDPE Raffia Woven Sack Bag Production Line. Complete production solution with technical specifications and machine video.";
   ob_start();
   ?>

<style>
	/* ---------- FLOW SECTION ---------- */
	.production-flow {
		display: flex;
		flex-direction: column;
		gap: 22px;
		margin-top: 20px;
	}
	
	.flow-item {
		display: grid;
		grid-template-columns: 280px 1fr;
		gap: 20px;
		padding: 18px 20px;
		border-left: 4px solid #e53935;
		background: #fafafa;
		border-radius: 6px;
	}
	
	.flow-title {
		font-weight: 700;
		font-size: 16px;
	}
	
	.flow-desc {
		font-size: 15px;
		line-height: 1.7;
		color: #444;
	}
	
	@media(max-width:768px) {
		.flow-item {
			grid-template-columns: 1fr;
		}
	}
	
	/* ---------- CTA ---------- */
	.product-cta {
		display: flex;
		gap: 15px;
		margin: 20px 0 30px;
		flex-wrap: wrap;
	}
	
	.cta-btn {
		padding: 12px 22px;
		font-size: 15px;
		font-weight: 600;
		border-radius: 5px;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 8px;
		transition: .3s;
	}
	
	.cta-btn.primary {
		background: #e53935;
		color: #fff;
	}
	
	.cta-btn.primary:hover {
		background: #c62828;
	}
	
	.cta-btn.secondary {
		background: #fff;
		border: 2px solid #2d2a8c;
		color: #2d2a8c;
	}
	
	.cta-btn.secondary:hover {
		background: #2d2a8c;
		color: #fff;
	}
	
	/* ---------- TABLE ---------- */
	.raffia-tech-table {
		width: 100%;
		border-collapse: collapse;
		font-size: 14px;
	}
	
	.raffia-tech-table th,
	.raffia-tech-table td {
		border: 1px solid #ddd;
		padding: 10px;
		text-align: center;
	}
	
	.raffia-tech-table thead {
		background: #2d2a8c;
		color: #fff;
	}
	
	@media(max-width:768px) {
		.raffia-tech-table {
			min-width: 900px;
		}
	}
	
	/* ---------- VIDEO MODAL ---------- */
	.video-modal {
		display: none;
		position: fixed;
		inset: 0;
		background: rgba(0, 0, 0, .85);
		z-index: 9999;
	}
	
	.video-content {
		max-width: 800px;
		margin: 80px auto;
		background: #000;
		padding: 10px;
		position: relative;
	}
	
	.close-video {
		position: absolute;
		top: -35px;
		right: 0;
		font-size: 30px;
		color: #fff;
		cursor: pointer;
	}
	
	.product-navigation {
		display: flex;
		justify-content: space-between;
		gap: 20px;
		margin-top: 50px;
		flex-wrap: wrap;
	}
	
	.nav-btn {
		text-decoration: none;
		border: 2px solid #e53935;
		padding: 14px 22px;
		border-radius: 6px;
		font-weight: 600;
		color: #e53935;
		transition: 0.3s;
		display: inline-flex;
		flex-direction: column;
		line-height: 1.3;
		max-width: 260px;
	}
	
	.nav-btn span {
		font-size: 13px;
		font-weight: 500;
		opacity: 0.8;
	}
	
	.nav-btn:hover {
		background: #e53935;
		color: #fff;
	}
	
	.prev-product-btn {
		align-items: flex-start;
		text-align: left;
	}
	
	.next-product-btn {
		align-items: flex-end;
		text-align: right;
	}
	
	@media (max-width: 768px) {
		.product-navigation {
			flex-direction: column;
		}
		.nav-btn {
			max-width: 100%;
			align-items: center;
			text-align: center;
		}
	}
	
	.cta-btn.whatsapp {
		background: #25D366;
		color: #fff;
	}
	
	.cta-btn.whatsapp:hover {
		background: #1ebe5d;
	}

</style>


<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
	<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
	<div class="container">
		<div class="row">
			<div class="col-xxl-6 col-xl-8 col-lg-8">
				<div class="rs-breadcrumb-content-wrapper">
					<div class="rs-breadcrumb-title-wrapper">
						<h1 class="rs-breadcrumb-title">PP/HDPE Monofilament Extrusion Line</h1>
					</div>
					<div class="rs-breadcrumb-menu">
						<nav>
							<ul>
								<li><span><a href="index.php">Home</a></span>
								</li>
								<li><span>Products</span>
								</li>
								<li><span>PP/HDPE Monofilament Extrusion Line</span>
								</li>
							</ul>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
   <!-- breadcrumb area end -->

   <!-- portfolio area start -->
<section class="rs-portfolio-area section-space">
	<div class="container">
		<div class="row g-2">
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">
					<div class="portfolio-details-thumb-wrapper">
						<div class="row g-5">
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/pp-hdpe-pe-monofilament-extrusion-line/1.jpg" alt="image">
								</div>
							</div>

							
						</div>
					</div>

				</div>
			</div>
			<div class="col-xl-12 col-lg-12">
				<h3>PP/HDPE Monofilament Extrusion Line</h3>
				
				<p align="justify">The Heaven Extrusions PP/HDPE Monofilament Extrusion Line is engineered for producing high-strength, uniform monofilaments used in brush filaments, brooms, fishing lines, ropes, industrial fabrics, and filter applications.</p>
				<p align="justify">This line features precision extruders, high-quality die heads, and advanced cooling and take-up systems, ensuring consistent filament diameter, excellent mechanical strength, and superior surface finish. Equipped with PLC-HMI automation, high-speed winding units, and tension control, the line delivers
stable operation, minimal waste, and high production efficiency.</p>
				<p align="justify">Capable of processing PP, HDPE, PE with blended resins, this line is ideal for industrial and export-grade monofilament applications, offering flexibility, precision, and energy-efficient operation.</p>
				
				<div class="product-cta">
					<a href="https://wa.me/919999999999?text=Hello%20Heaven%20Extrusions,%20I%20am%20interested%20in%20the%20Extrusion%20Coating%20Tarpaulin%20Lamination%20Line." target="_blank" class="cta-btn whatsapp">
   <i class="fab fa-whatsapp"></i> WhatsApp
</a>
				


					<a href="contact-us.html" class="cta-btn primary">
        Get Inquiry
    </a>
				

					<a href="#productionVideo" class="cta-btn secondary video-btn">
        ▶ Watch Video
    </a>
				

				</div>




			</div>
			
			
					<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Applications</h3>
                                <div class="rs-portfolio-details-feature-list mb-40">
                                    <div class="rs-list-item has-theme-orange">
                                        <ul>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                                Thermoformed containers & trays
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                               Automotive interior parts
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                                Stationery products (files, folders, sheets)
											</li>                        
                                            
                                            
											
                                        </ul>
                                    </div>
                                </div>
						
                                
						<img src="assets/images/products/pp-hdpe-pe-monofilament-extrusion-line/2.png" alt="image">

					</div>
					
				</div>
			</div>
			
			
			
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mt-4">Technical Specification</h3>
						<div class="table-responsive raffia-table-wrapper">
							<table class="raffia-tech-table">
								<thead>
									<tr>
										<th>Model</th>
										<th>Extruder (MM)</th>
										<td>Output (KG/HR.)</td>
										<td>Filament Diameter (MM)</td>
										<td>Line Speed (MPM)</td>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td>HEMF/70</td>
										<td>70</td>
										<td>50-100</td>
										<td>0.10-1.00</td>
										<td>50-150</td>
																			
									</tr>
									<tr>
										<td>HEMF/80</td>
										<td>80</td>
										<td>100-150</td>
										<td>0.10-1.00</td>
										<td>50-150</td>
																				
									</tr>
									<tr>
										<td>HEMF/90</td>
										<td>90</td>
										<td>150-200</td>
										<td>0.20-2.00</td>
										<td>70-180</td>
																			
									</tr>
									
									
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
			<div class="product-navigation">
				<a href="pp-hdpe-sheet-extrusion-line" class="nav-btn prev-product-btn">
        ← Previous
        
    </a>
			

				<a href="pp-pet-box-strapping-extrusion-line" class="nav-btn next-product-btn">
        Next →
        
    </a>
			
			</div>

		</div>

	</div>
	</div>
</section>
   <!-- ================= VIDEO MODAL ================= -->
<div id="productionVideo" class="video-modal">
	<div class="video-content">
		<span class="close-video">&times;</span>
		<iframe width="100%" height="450" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allowfullscreen></iframe>
	</div>
</div>

<script>
	document.addEventListener( "DOMContentLoaded", function () {

		document.querySelectorAll( '.video-btn' ).forEach( btn => {
			btn.addEventListener( 'click', function ( e ) {
				e.preventDefault();
				document.getElementById( 'productionVideo' ).style.display = 'block';
			} );
		} );

		document.querySelector( '.close-video' ).addEventListener( 'click', function () {
			document.getElementById( 'productionVideo' ).style.display = 'none';
		} );

	} );
</script>

   
   <?php
   $content = ob_get_clean();
   include 'layout/layout.php';
   ?>