   <?php
   $title = "PP / HDPE Raffia Woven Sack Production Line | Heaven Extrusions";
   $meta_description = "High-performance PP / HDPE Raffia Woven Sack Bag Production Line. Complete production solution with technical specifications and machine video.";
   ob_start();
   ?>

<style>
	/* ---------- FLOW SECTION ---------- */
	.production-flow {
		display: flex;
		flex-direction: column;
		gap: 22px;
		margin-top: 20px;
	}
	
	.flow-item {
		display: grid;
		grid-template-columns: 280px 1fr;
		gap: 20px;
		padding: 18px 20px;
		border-left: 4px solid #e53935;
		background: #fafafa;
		border-radius: 6px;
	}
	
	.flow-title {
		font-weight: 700;
		font-size: 16px;
	}
	
	.flow-desc {
		font-size: 15px;
		line-height: 1.7;
		color: #444;
	}
	
	@media(max-width:768px) {
		.flow-item {
			grid-template-columns: 1fr;
		}
	}
	
	/* ---------- CTA ---------- */
	.product-cta {
		display: flex;
		gap: 15px;
		margin: 20px 0 30px;
		flex-wrap: wrap;
	}
	
	.cta-btn {
		padding: 12px 22px;
		font-size: 15px;
		font-weight: 600;
		border-radius: 5px;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 8px;
		transition: .3s;
	}
	
	.cta-btn.primary {
		background: #e53935;
		color: #fff;
	}
	
	.cta-btn.primary:hover {
		background: #c62828;
	}
	
	.cta-btn.secondary {
		background: #fff;
		border: 2px solid #2d2a8c;
		color: #2d2a8c;
	}
	
	.cta-btn.secondary:hover {
		background: #2d2a8c;
		color: #fff;
	}
	
	/* ---------- TABLE ---------- */
	.raffia-tech-table {
		width: 100%;
		border-collapse: collapse;
		font-size: 14px;
	}
	
	.raffia-tech-table th,
	.raffia-tech-table td {
		border: 1px solid #ddd;
		padding: 10px;
		text-align: center;
	}
	
	.raffia-tech-table thead {
		background: #2d2a8c;
		color: #fff;
	}
	
	@media(max-width:768px) {
		.raffia-tech-table {
			min-width: 900px;
		}
	}
	
	/* ---------- VIDEO MODAL ---------- */
	.video-modal {
		display: none;
		position: fixed;
		inset: 0;
		background: rgba(0, 0, 0, .85);
		z-index: 9999;
	}
	
	.video-content {
		max-width: 800px;
		margin: 80px auto;
		background: #000;
		padding: 10px;
		position: relative;
	}
	
	.close-video {
		position: absolute;
		top: -35px;
		right: 0;
		font-size: 30px;
		color: #fff;
		cursor: pointer;
	}

</style>


<section class="rs-breadcrumb-area rs-breadcrumb-one p-relative">
	<div class="rs-breadcrumb-bg" data-background="assets/images/bg/breadcrumb-bg-01.png"></div>
	<div class="container">
		<div class="row">
			<div class="col-xxl-6 col-xl-8 col-lg-8">
				<div class="rs-breadcrumb-content-wrapper">
					<div class="rs-breadcrumb-title-wrapper">
						<h1 class="rs-breadcrumb-title">Extrusion Coating Tarpaulin Lamination Line</h1>
					</div>
					<div class="rs-breadcrumb-menu">
						<nav>
							<ul>
								<li><span><a href="index.php">Home</a></span>
								</li>
								<li><span>Products</span>
								</li>
								<li><span>Extrusion Coating Tarpaulin Lamination Line</span>
								</li>
							</ul>
						</nav>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
   <!-- breadcrumb area end -->

   <!-- portfolio area start -->
<section class="rs-portfolio-area section-space">
	<div class="container">
		<div class="row g-5">
			<div class="col-xl-6 col-lg-6">
				<div class="rs-portfolio-details-wrapper">
					<div class="portfolio-details-thumb-wrapper">
						<div class="row g-5">
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/extrusion-coating-tarpaulin-lamination-line/1.jpg" alt="image">
								</div>
							</div>
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/extrusion-coating-tarpaulin-lamination-line/3.png" alt="image">
								</div>
							</div>
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="rs-portfolio-details-thumb">
									<img src="assets/images/products/extrusion-coating-tarpaulin-lamination-line/2.jpg" alt="image">
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
			<div class="col-xl-6 col-lg-6">
				<h3>Extrusion Coating Tarpaulin Lamination Line</h3>

				<p align="justify">The Extrusion Coating Tarpaulin Lamination Line from Heaven Extrusions is engineered for manufacturing
premium-quality laminated tarpaulins used in agriculture, construction, logistics, transportation, and industrial covering applications. The line combines robust mechanical design with advanced extrusion coating technology to deliver uniform coating, excellent adhesion, and long service life of finished tarpaulin fabric.
</p>
				<p align="justify">Designed for continuous operation and high output, this line ensures superior bonding of
LDPE/HDPE/LLDPE coating onto woven HDPE or PP fabric, resulting in tarpaulins with high tensile
strength, water resistance, UV stability, and tear resistance.
</p>
				<div class="product-cta">
					<a href="contact-us.html" class="cta-btn primary">
        Get Price & Quotation
    </a>
				
					<a href="#productionVideo" class="cta-btn secondary video-btn">
        ▶ Watch Machine Video
    </a>
				
				</div>
				
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Key Features</h3>
                                
						<div class="rs-postbox-details-feature">
                                    <ul>
                                        <li>Heavy-duty single or twin-screw extruder for stable melt flow</li>
                                        <li>Precision T-die with uniform coating thickness control </li>
                                        <li>Advanced corona treatment system for strong fabric-to-polymer adhesion </li>
										<li>Effcient lamination nip & cooling drum system </li>
										<li>Smooth edge trimming and scrap recycling option </li>
										<li>Automatic tension control & winding system </li>
                                    </ul>
                                </div>
                                
						

					</div>

				</div>

				
			</div>
			
			
			<div class="col-xl-6 col-lg-6">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Raw Materials</h3>
                                
						<div class="rs-postbox-details-feature">
                                    <ul>
                                        <li>Base fabric: HDPE / PP Woven Fabric</li>
                                        <li>Coating polymers: LDPE, LLDPE, HDPE </li>
                                        <li>Additives: UV stabilizers, colour Masterbatch,Anti-aging agents </li>
										
                                    </ul>
                                </div>
                                
						

					</div>

				</div>
			</div>
			<div class="col-xl-6 col-lg-6">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Advantages</h3>
                                
						<div class="rs-postbox-details-feature">
                                    <ul>
                                        <li>Excellent coating adhesion & peel strength</li>
                                        <li>Uniform GSM coating across full width </li>
                                        <li>High productivity with consistent quality </li>
										<li>Reduced energy consumption </li>
										<li>Long machine life with minimal maintenance </li>
										<li>Suitable for domestic and export markets </li>
										
                                    </ul>
                                </div>
                                
						

					</div>

				</div>
			</div>
			<div class="col-xl-12 col-lg-12">
				<h6 class="rs-portfolio-details-title mb-4">
    Technical Specification
</h6>
			
				<div class="table-responsive raffia-table-wrapper">
					<table class="raffia-tech-table">
    <thead>
        <tr>
            <th>Model</th>
            <th>Screw Size (MM)</th>
            <th>Die Width (MM)</th>
            <th>Max. Coating Width (MM)</th>
            <th>Coating Thickness (Micron)</th>
            <th>Line Speed (MPM)</th>
            <th>Max. Melting Capacity (KG/Hr)</th>
            <th>Connected Load (KW)</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>HETDL/950</td>
            <td>70 × 70</td>
            <td>900</td>
            <td>800</td>
            <td>20 – 75</td>
            <td>150</td>
            <td>150</td>
            <td>95</td>
        </tr>
        <tr>
            <td>HEL/1200</td>
            <td>70</td>
            <td>1200</td>
            <td>1050</td>
            <td>20 – 75</td>
            <td>120</td>
            <td>100</td>
            <td>62</td>
        </tr>
        <tr>
            <td>HEL/1650</td>
            <td>75</td>
            <td>1650</td>
            <td>1500</td>
            <td>20 – 75</td>
            <td>120</td>
            <td>150</td>
            <td>78</td>
        </tr>
        <tr>
            <td>HEL/2200</td>
            <td>90</td>
            <td>2200</td>
            <td>2000</td>
            <td>20 – 75</td>
            <td>100</td>
            <td>180</td>
            <td>86</td>
        </tr>
        <tr>
            <td>HEL/2600</td>
            <td>90</td>
            <td>2650</td>
            <td>2500</td>
            <td>20 – 75</td>
            <td>80</td>
            <td>200</td>
            <td>105</td>
        </tr>
        <tr>
            <td>HEL/3250</td>
            <td>100</td>
            <td>3330</td>
            <td>3100</td>
            <td>20 – 75</td>
            <td>60</td>
            <td>220</td>
            <td>125</td>
        </tr>
        <tr>
            <td>HEL/3860</td>
            <td>100</td>
            <td>3800</td>
            <td>3650</td>
            <td>20 – 75</td>
            <td>50</td>
            <td>350</td>
            <td>135</td>
        </tr>
        <tr>
            <td>HEL/4300</td>
            <td>110</td>
            <td>4300</td>
            <td>4150</td>
            <td>20 – 75</td>
            <td>40</td>
            <td>450</td>
            <td>165</td>
        </tr>
        <tr>
            <td>HEL/5300</td>
            <td>120</td>
            <td>5300</td>
            <td>5100</td>
            <td>20 – 75</td>
            <td>40</td>
            <td>550</td>
            <td>185</td>
        </tr>
    </tbody>
</table>

				</div>
			</div>
			<div class="col-xl-12 col-lg-12">
				<div class="rs-portfolio-details-wrapper">

					<div class="rs-portfolio-details-content">
						<h3 class="rs-portfolio-details-title mb-4">Applications</h3>
                                <div class="rs-portfolio-details-feature-list mb-40">
                                    <div class="rs-list-item has-theme-orange">
                                        <ul>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                                Agriculture tarpaulins
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                               Truck & container covers
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                                Construction site covers
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                                Monsoon & all-weather protective sheets
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                                Pond lining & canal lining sheets
                                            </li>
                                            <li>
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor">
                                                    <path
                                                        d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
                                                    </path>
                                                </svg>
                                                Industrial and warehouse covers
                                            </li>
                                        </ul>
                                    </div>
                                </div>
						
                                
						

					</div>

				</div>
			</div>
		</div>

	</div>
	</div>
</section>
   <!-- ================= VIDEO MODAL ================= -->
<div id="productionVideo" class="video-modal">
	<div class="video-content">
		<span class="close-video">&times;</span>
		<iframe width="100%" height="450" src="https://www.youtube.com/embed/YOUR_VIDEO_ID" frameborder="0" allowfullscreen></iframe>
	</div>
</div>

<script>
	document.addEventListener( "DOMContentLoaded", function () {

		document.querySelectorAll( '.video-btn' ).forEach( btn => {
			btn.addEventListener( 'click', function ( e ) {
				e.preventDefault();
				document.getElementById( 'productionVideo' ).style.display = 'block';
			} );
		} );

		document.querySelector( '.close-video' ).addEventListener( 'click', function () {
			document.getElementById( 'productionVideo' ).style.display = 'none';
		} );

	} );
</script>

   <!--<section class="rs-services-area section-space ">
<div class="container">
	<div class="row g-5">
		<div class="col-xl-12 col-lg-12">
			<div class="rs-services-details-wrapper">

				<h3 class="rs-services-details-title">Best innovations in metallurgy</h3>
				<p class="mb-25 mt-15"><strong>At vero eos et accusamus et iusto odio dignissimos ducimus
                                    qui
                                    blanditiis praesentium voluptatum
                                    deleniti atque corrupti quos dolores et quas molestias excepturi.</strong>
				</p>
				<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga harum quidem rerum facilis est et expedita distinctio. </p>
				<h3 class="rs-services-details-title">Planning &amp; Strategy</h3>
				<p class="mt-20 mb-20">Demoralized voluptatum deleniti atque corrupti dolores quas molestias excepturi sint occaecati.</p>
				<div class="rs-services-details-feature-list">
					<div class="rs-list-item has-theme-orange">
						<ul>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Prepare Documentation
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Brand Consistency
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Industry Standard Dummy
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Quality Control System
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Prepare Documentation
							</li>
							<li>
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
									<path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11.0026 16L6.75999 11.7574L8.17421 10.3431L11.0026 13.1716L16.6595 7.51472L18.0737 8.92893L11.0026 16Z">
									</path>
								</svg>
								Prepare Documentation
							</li>
						</ul>
					</div>
				</div>

				<p class="mb-20"> At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi.
				</p>
				<h3 class="rs-services-details-title mb-15">Planning &amp; Strategy</h3>
				<p class="mb-55">At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate. </p>
				<h3 class="rs-services-details-title mb-15">Stats &amp; Charts</h3>
				<div class="rs-services-details-chart-wrapper">
					<p class="mb-0"> At vero eos et accusamus et iusto odio digmos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati .
					</p>
					<div class="rs-services-details-chart">
						<canvas id="pie-chart"></canvas>
					</div>
				</div>
				<div class="has-border-line"></div>
				<h3 class="rs-services-details-title mb-20">Questions? You’re covered</h3>
				<p> At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate. </p>
				<div class="rs-services-details-faq">
					<div class="rs-faq-content rs-accordion-one">
						<div class="accordion-wrapper">
							<div class="accordion" id="accordionExampleOne">
								<div class="rs-accordion-item">
									<h4 class="accordion-header" id="headingOne">
                                                    <button class="accordion-button" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseOne"
                                                        aria-expanded="true" aria-controls="collapseOne">
                                                        01. Why is sand important for industry?
                                                        <span class="accordion-btn"></span>
                                                    </button>
                                                </h4>
								
									<div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExampleOne">
										<div class="accordion-body"> Randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything.
										</div>
									</div>
								</div>
								<div class="rs-accordion-item">
									<h6 class="accordion-header" id="headingTwo">
                                                    <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                        aria-expanded="false" aria-controls="collapseTwo">
                                                        02. Can I switch to a different plan?
                                                        <span class="accordion-btn"></span>
                                                    </button>
                                                </h6>
								
									<div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExampleOne">
										<div class="accordion-body">Randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything.</div>
									</div>
								</div>
								<div class="rs-accordion-item">
									<h6 class="accordion-header" id="headingThree">
                                                    <button class="accordion-button collapsed" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                                        aria-expanded="false" aria-controls="collapseThree">
                                                        03. What should I wear for an industry treatment?
                                                        <span class="accordion-btn"></span>
                                                    </button>
                                                </h6>
								
									<div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExampleOne">
										<div class="accordion-body">Randomised words which don’t look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isn’t anything.</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="rs-services-details-cta">
					<div class="rs-services-details-cta-bg-thumb" data-background="assets/images/bg/cta-bg-08.png">
					</div>
					<div class="rs-services-details-cta-content">
						<h3 class="rs-services-details-title mb-40">We are always ready to help you and
                                        answer your
                                        questions</h3>
						<div class="rs-services-details-btn">
							<a class="rs-btn has-theme-orange has-icon has-bg" href="contact.html">Explore
                                            More
                                            <span class="icon-box">
                                                <svg class="icon-first" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                                <svg class="icon-second" xmlns="http://www.w3.org/2000/svg"
                                                    viewBox="0 0 32 32">
                                                    <path
                                                        d="M31.71,15.29l-10-10L20.29,6.71,28.59,15H0v2H28.59l-8.29,8.29,1.41,1.41,10-10A1,1,0,0,0,31.71,15.29Z">
                                                    </path>
                                                </svg>
                                            </span>
                                        </a>
						</div>
					</div>
					<div class="rs-services-details-cta-thumb">
						<img src="assets/images/services/details/services-details-02.png" alt="image">
					</div>
				</div>
			</div>
		</div>

	</div>
</div>
</section> -->
   <?php
   $content = ob_get_clean();
   include 'layout/layout.php';
   ?>