<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>

<div class="container-xxl flex-grow-1 container-p-y">
	<div class="d-flex flex-column justify-content-center">
     <h5 class="card-header mb-2">Product Media</h5>
      </div>
	<button class="btn btn-secondary create-new btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#mediaModal" type="button"><span><i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block">Add New</span></span></button>
	<button class="btn btn-secondary create-new btn-primary waves-effect waves-light"  type="button"><span><i class="ti ti-plus me-sm-1"></i> <span class="d-none d-sm-inline-block">Back</span></span></button>
	<?php $productid = $_GET['productid']; ?>
<div class="modal fade" id="mediaModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <form id="mediaForm" method="post" enctype="multipart/form-data">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Add/Edit Media</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="id">
          <input type="hidden" name="product_id" id="product_id" value="<?= (int)$productid ?>">

          <div class="row mb-3">
            <div class="col-md-12 mb-3">
              <label class="form-label">Media Type</label>
              <select class="form-select" name="media_type" id="media_type" required>
                <option value="">Select Type</option>
                <option value="image">Image</option>
                <option value="video">Video</option>
              </select>
            </div>
            <div class="col-md-12 mb-3">
              <label class="form-label">Upload File</label>
              <input type="file" class="form-control" name="media_file" id="media_file" required>
              <img id="output" src="" style="display: none; width: 100px; margin-top: 10px;" />
            </div>
            <div class="col-md-12 mb-3">
              <label class="form-label">Alt Text</label>
              <input type="text" class="form-control" name="alt_text" id="alt_text">
            </div>
            <div class="col-md-12 mb-3">
              <label class="form-label">Set as Primary?</label>
              <select class="form-select" name="is_primary" id="is_primary">
                <option value="0">No</option>
                <option value="1">Yes</option>
              </select>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </div>
    </form>
  </div>
</div>

	<div class="card">
              
		<div id="alert-box" class="alert d-none" role="alert"></div>
                <div class="card-datatable table-responsive">
                  <table class="datatables-ajax table table-bordered table-responsive">
  <thead>
    <tr>
      <th>Sr No.</th>
      <th>Media</th>
      <th>Type</th>
      <th>Alt Text</th>
      <th>Sort Order</th>
      <th>Status</th>
      <th>Action</th>
    </tr>
  </thead>
  <tbody></tbody>
</table>

                </div>
              </div>
</div>
<script>
$(document).ready(function () {
  // 📦 Get product ID from URL
  const productId = new URLSearchParams(window.location.search).get("productid");

  // ✅ Toast alert
  function showToast(message, type = 'success') {
    const alertBox = $('#alert-box');
    alertBox.removeClass('d-none alert-success alert-danger')
            .addClass(`alert alert-${type}`)
            .text(message);

    setTimeout(() => {
      alertBox.addClass('d-none').removeClass(`alert-${type}`).text('');
    }, 3000);
  }

  // 🖼 Preview image
  $('#media_file').on('change', function () {
    const file = this.files[0];
    if (file && file.type.startsWith("image/")) {
      const reader = new FileReader();
      reader.onload = function (e) {
        $('#output').attr('src', e.target.result).show();
      };
      reader.readAsDataURL(file);
    } else {
      $('#output').hide();
    }
  });

  // 🚀 Submit media form
  $('#mediaForm').on('submit', function (e) {
    e.preventDefault();
    const formData = new FormData(this);

    $.ajax({
      url: 'controllers/ProductMediaController.php',
      type: 'POST',
      data: formData,
      contentType: false,
      processData: false,
      success: function (res) {
        const result = JSON.parse(res);
        if (result.status === 'success') {
          $('#mediaModal').modal('hide');
          $('#mediaForm')[0].reset();
          $('#output').hide();
          fetchMedias(productId);
          showToast(result.message, 'success');
        } else {
          showToast(result.message, 'danger');
        }
      }
    });
  });

  // ✏️ Edit media
  $(document).on('click', '.editBtn', function () {
    const id = $(this).data('id');
    $.post('controllers/ProductMediaController.php', { action: 'get', id }, function (res) {
      const media = JSON.parse(res);
      $('#id').val(media.id);
      $('#media_type').val(media.media_type);
      $('#alt_text').val(media.alt_text);
      $('#is_primary').val(media.is_primary);
      $('#product_id').val(media.product_id);

      if (media.media_url && media.media_type === 'image') {
        $('#output').attr('src', '../uploads/media/' + media.media_url).show();
      } else {
        $('#output').hide();
      }

      $('#mediaModal').modal('show');
    });
  });

  // 🗑 Delete media
  $(document).on('click', '.deleteBtn', function () {
    const id = $(this).data('id');
    if (confirm("Are you sure you want to delete?")) {
      $.post('controllers/ProductMediaController.php', { action: 'delete', id }, function (res) {
        const result = JSON.parse(res);
        if (result.status === 'success') {
          fetchMedias(productId);
          showToast(result.message, 'success');
        } else {
          showToast(result.message, 'danger');
        }
      });
    }
  });

  // 🔄 Toggle media status
  $(document).on('change', '.toggleStatus', function () {
    const id = $(this).data('id');
    $.post('controllers/ProductMediaController.php', { action: 'toggleStatus', id }, function (res) {
      const result = JSON.parse(res);
      if (result.status === 'success') {
        showToast(result.message, 'success');
      } else {
        showToast(result.message, 'danger');
      }
    });
  });

  // 📊 Update sort order inline
  $(document).on('change', '.sort-order-input', function () {
    const id = $(this).data('id');
    const sort_order = $(this).val();

    if (!id || sort_order === '') {
      showToast("Invalid sort order.", "danger");
      return;
    }

    $.post('controllers/ProductMediaController.php', {
      action: 'updateSortOrder',
      id,
      sort_order
    }, function (res) {
      const result = JSON.parse(res);
      if (result.status === 'success') {
        showToast(result.message, 'success');
      } else {
        showToast(result.message, 'danger');
      }
    });
  });

  // 📥 Fetch and render media
  function fetchMedias(productId) {
    if (!productId) {
      showToast("Product ID is missing.", 'danger');
      return;
    }

    $.get('controllers/ProductMediaController.php', { action: 'medialist', product_id: productId }, function (html) {
      if ($.fn.DataTable.isDataTable('.datatables-ajax')) {
        $('.datatables-ajax').DataTable().destroy();
      }

      $('.datatables-ajax tbody').html(html);

      $('.datatables-ajax').DataTable({
        processing: true,
        dom:
          '<"row mx-3 justify-content-between"' +
            '<"d-md-flex justify-content-between align-items-center dt-layout-start col-md-auto me-auto"l>' +
            '<"d-md-flex justify-content-between align-items-center dt-layout-end col-md-auto ms-auto mt-0"f>' +
          '>' +
          '<"table-responsive"t>' +
          '<"row mx-3 justify-content-between"' +
            '<"col-sm-12 col-md-6"i>' +
            '<"col-sm-12 col-md-6 d-flex justify-content-end"p>' +
          '>',
        order: [[0, 'ASC']]
      });
    });
  }

  // 🚀 Initial load
  if (productId) {
    fetchMedias(productId);
  } else {
    showToast("Product ID missing in URL.", 'danger');
  }

});
</script>


<?php } ?>