<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>
	<!-- <link rel="stylesheet" href="assets/vendor/libs/quill/editor.css" />-->
	<div class="container-xxl flex-grow-1 container-p-y">
		<div class="d-flex flex-column justify-content-center">
			<h5 class="card-header mb-2">Product Cat Add</h5>
		</div>
		<button class="btn btn-primary" onclick="window.location.href='product_cat_list.php'" type="button"><span><i class="ti ti-list me-sm-1"></i> <span class="d-none d-sm-inline-block">Product Cat List</span></span></button>
		<div class="row">
			<!-- Basic Layout -->
			<div class="col-12">
				<div class="card mb-6">
					<div id="alert-box" class="alert d-none" role="alert"></div>
					<form class="card-body" id="serviceCatForm" method="POST" enctype="multipart/form-data">
						<div class="row g-6">


							<!-- Room Title -->
							<div class="col-md-12">
								<label class="form-label" for="roomTitle">Product Cat</label>
								<input type="text" class="form-control" id="catname" name="catname" required>
							</div>


							<!-- Room Description -->
							<div class="col-md-12">
								<label class="form-label" for="roomDescription">Description</label>

								<textarea class="form-control" id="description" name="description" rows="8" ></textarea>

							</div>

							<div class="col-md-12">
								<label class="form-label" for="multicol-email">Image</label>

								<input type="file" id="photo" name="photo" class="form-control" accept="image/png, image/jpeg, image/jpg" onchange="loadFile(event)"/>
								<script>
									var loadFile = function ( event ) {
										var output = document.getElementById( 'output' );
										output.src = URL.createObjectURL( event.target.files[ 0 ] );
										output.onload = function () {
											URL.revokeObjectURL( output.src ) // free memory
										}
									};
								</script>

							</div>
							<div class="col-md-3">


								<img id="output" src="" height="70" width="70" style="display: none;"/>


							</div>
						</div>

						<!-- Submit and Cancel Buttons -->
						<div class="pt-6">
							<input type="hidden" id="upd" value="<?php echo isset($_GET['id']) ? $_GET['id'] : ''; ?>">
							<input type="hidden" name="id" id="id">
							<input type="hidden" name="action" id="action" value="<?php echo isset($_GET['id']) ? 'Update' : 'Create'; ?>">
							<button type="submit" class="btn btn-primary me-2">
								<?php echo isset($_GET['id']) ? 'Update' : 'Save'; ?> </button>
							<button type="reset" class="btn btn-label-secondary">Cancel</button>
						</div>
					</form>
					<script>
						$( document ).ready( function () {
							
							function showToast(message, type = 'success') {
    const alertBox = $('#alert-box');
    alertBox.removeClass('d-none alert-success alert-danger')
            .addClass(`alert alert-${type}`)
            .text(message);

    setTimeout(() => {
      alertBox.addClass('d-none').removeClass(`alert-${type}`).text('');
    }, 3000);
  }
						
								$( '#photo' ).on( 'change', function () {
									const file = this.files[ 0 ];
									if ( file ) {
										const reader = new FileReader();
										reader.onload = function ( e ) {
											$( '#output' ).attr( 'src', e.target.result ).show();
										};
										reader.readAsDataURL( file );
									}
								} );

								// Toast notification function
//								function showToast( message, type = 'success' ) {
//									alert( message ); // Replace with Bootstrap toast or custom if needed
//								}

								// Handle form submit
								$( '#serviceCatForm' ).on( 'submit', function ( e ) {
									e.preventDefault();

									const formData = new FormData( this );
									const isUpdate = $('#id').val() !== '';
									$.ajax( {
										url: 'controllers/ProductCategoryController.php',
										method: 'POST',
										data: formData,
										contentType: false,
										processData: false,
										success: function ( res ) {
											try {
												const result = JSON.parse( res );
												if (result.status === 'success') {
													  showToast(result.message, 'success');

													  // If it's an update, redirect after a short delay
													  if (isUpdate) {
														setTimeout(() => {
														  window.location.href = 'product_cat_list.php';
														}, 1500);
													  } else {
														// If it's a create, reset the form
														$('#serviceCatForm')[0].reset();
														$('#output').hide();
													  }
													} else {
													  showToast(result.message, 'danger');
													}
											} catch ( e ) {
												console.error( "Parse error:", res );
												showToast( 'Invalid server response.', 'danger' );
											}
										},
										error: function () {
											showToast( 'Something went wrong.', 'danger' );
										}
									} );
								} );

								// Optional: Load existing data for editing
								const editId = $( '#upd' ).val();
								if ( editId !== '' ) {
									$.post( 'controllers/ProductCategoryController.php', {
										action: 'getCategory',
										id: editId
									}, function ( res ) {
										const category = JSON.parse( res );
										$( '#id' ).val( category.id );
										$( '#catname' ).val( category.catname );
										$( '#description' ).val( category.description );
										if ( category.image ) {
											$( '#output' ).attr( 'src', '../uploads/products/' + category.image ).show();
										}
									} );
								}
							} );
					</script>
				</div>
			</div>
			<!-- Basic with Icons -->

		</div>


	</div>

	<?php } ?>