<!doctype html>
<html lang="en"  class="light-style layout-wide customizer-hide"  dir="ltr"  data-theme="theme-default"  data-assets-path="assets/"  data-template="vertical-menu-template"  data-style="light">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Login | Verix Engineers </title>

    <meta name="description" content="" />
	<link rel="apple-touch-icon" sizes="180x180" href="../assets/images/favicon/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="../assets/images/favicon/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="../assets/images/favicon/favicon-16x16.png">
	<link rel="manifest" href="../assets/images/favicon/site.webmanifest">
   <!-- Icons -->
    <link rel="stylesheet" href="assets/vendor/fonts/fontawesome.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/tabler-icons.css" />
    <link rel="stylesheet" href="assets/vendor/fonts/flag-icons.css" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor/css/rtl/core.css"  />
    <link rel="stylesheet" href="assets/vendor/css/rtl/theme-default.css" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="assets/vendor/libs/typeahead-js/typeahead.css" />
    <link rel="stylesheet" href="assets/vendor/css/pages/page-auth.css" />
    <script src="assets/vendor/js/helpers.js"></script>
    <script src="assets/js/config.js"></script>
  </head>

  <body>
    <!-- Content -->

    <div class="container-xxl">
      <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner py-6">
          <!-- Login -->
          <div class="card">
            <div class="card-body">
              <!-- Logo -->
              <div class="app-brand justify-content-center mb-6">
                <a href="index.html" class="app-brand-link">
                  
                  <img src="../assets/images/logo/logo.png" width="200" alt="Verix Engineers" style="background:none;">
                </a>
              </div>
              <!-- /Logo -->
             

              <form id="formAuthentication" class="mb-4" action="#" method="post">
                <div class="mb-6">
                  <label for="email" class="form-label">Email</label>
                  <input
                    type="text"
                    class="form-control"
                    id="email"
                    name="email-username"
                    placeholder="Enter your email or username"
                    autofocus />
                </div>
                <div class="mb-6 form-password-toggle">
                  <label class="form-label" for="password">Password</label>
                  <div class="input-group input-group-merge">
                    <input
                      type="password"
                      id="password"
                      class="form-control"
                      name="password"
                      placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                      aria-describedby="password" />
                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                  </div>
                </div>
                <div class="my-8" st>
                  <div class="d-flex justify-content-between">
                    <div class="form-check mb-0 ms-2">
                      <input class="form-check-input" type="checkbox" id="remember-me" />
                      <label class="form-check-label" for="remember-me"> Remember Me </label>
                    </div>
                    <!--<a href="auth-forgot-password-basic.html">-->
                    <!--  <p class="mb-0">Forgot Password?</p>-->
                    <!--</a>-->
                  </div>
                </div>
                <div class="mb-6">
                  <button class="btn btn-primary d-grid w-100" type="submit">Login</button>
                </div>
              </form>

                          
            </div>
          </div>
          <!-- /Register -->
        </div>
      </div>
    </div>
<script src="assets/js/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    // Autofill from cookies if available
    if (document.cookie.includes("remember_email")) {
        const email = getCookie("remember_email");
        const pass = getCookie("remember_pass");
        $('#email').val(email);
        $('#password').val(pass);
        $('#remember-me').prop('checked', true);
    }

    $('#formAuthentication').on('submit', function (e) {
        e.preventDefault();

        // Show spinner in button
        const btn = $(this).find('button[type="submit"]');
        btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Logging in...');

        const formData = $(this).serialize() + '&rememberMe=' + ($('#remember-me').is(':checked') ? 'on' : 'off');

        $.ajax({
            type: 'POST',
            url: 'login_action.php',
            dataType: 'json',
            data: formData,
            success: function (response) {
                showToast(response.status === 'success' ? 'success' : 'danger', response.message);
                if (response.status === 'success') {
                    setTimeout(() => window.location.href = 'blog_details_list.php', 1500);
                }
            },
            complete: function () {
                btn.prop('disabled', false).text('Login');
            }
        });
    });

    function getCookie(name) {
        let match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
        if (match) return decodeURIComponent(match[2]);
        return '';
    }

    function showToast(type, message) {
        const toastHTML = `
        <div class="toast align-items-center text-white bg-${type} border-0 position-fixed top-0 end-0 m-4" role="alert" aria-live="assertive" aria-atomic="true" style="z-index: 1056;">
          <div class="d-flex">
            <div class="toast-body">${message}</div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
          </div>
        </div>`;
        $('body').append(toastHTML);
        const toastEl = document.querySelector('.toast');
        new bootstrap.Toast(toastEl).show();
        $(toastEl).on('hidden.bs.toast', function () {
            $(this).remove();
        });
    }
});
</script>


    <script src="assets/vendor/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/libs/popper/popper.js"></script>
    <script src="assets/vendor/js/bootstrap.js"></script>
    <script src="assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/libs/hammer/hammer.js"></script>
    <script src="assets/vendor/libs/i18n/i18n.js"></script>
    <script src="assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="assets/vendor/js/menu.js"></script>
    <script src="assets/vendor/libs/@form-validation/popular.js"></script>
    <script src="assets/vendor/libs/@form-validation/bootstrap5.js"></script>
    <script src="assets/vendor/libs/@form-validation/auto-focus.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/pages-auth.js"></script>
  </body>
</html>
