<?php
require_once '../inc/db.php';
require_once '../models/ProductDetailsModel.php';


$productDetails = new ProductDetailsModel($conn); // Corrected variable name

if ($_SERVER['REQUEST_METHOD'] === 'GET' && ($_GET['action'] ?? '') === 'productdetaillist') {
    $result = $conn->query("
        SELECT pd.*, pc.catname, psc.subcat_name 
        FROM product_details pd 
        JOIN product_categories pc ON pd.cat_id = pc.id 
        JOIN product_subcategories psc ON pd.subcat_id = psc.id 
        ORDER BY pd.id ASC
    ");

    $html = '';

    while ($row = $result->fetch_assoc()) {
        $img = $row['product_image'] 
            ? "<img src='../uploads/{$row['product_image']}' width='60' class='img-thumbnail'>" 
            : '<span class="text-muted">No image</span>';

        // Status text and switch
        $checked = ($row['status'] === 'active') ? 'checked' : '';
        $statusSwitch = "
            <label class='switch switch-success'>
                <input type='checkbox' class='switch-input toggleStatus' data-id='{$row['id']}' $checked />
                <span class='switch-toggle-slider'>
                    <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
                    <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
                </span>
            </label>
        ";

        // Action buttons
        $actionButtons = "
            <div class='btn-group' role='group'>
                <button class='btn btn-sm btn-info rounded-pill editBtn' data-id='{$row['id']}' data-bs-toggle='tooltip' title='Edit'>
                    <i class='far fa-edit'></i>
                </button>
                <button class='btn btn-sm btn-danger rounded-pill deleteBtn' data-id='{$row['id']}' data-bs-toggle='tooltip' title='Delete'>
                    <i class='far fa-trash-alt'></i>
                </button>
            </div>
        ";

        $html .= "
            <tr>
                <td>" . htmlspecialchars(ucwords($row['catname'])) . "</td>
                <td>" . htmlspecialchars(ucwords($row['subcat_name'])) . "</td>
                <td>" . nl2br(htmlspecialchars(mb_strimwidth($row['short_description'], 0, 80, '...'))) . "</td>
				<td>" . nl2br(htmlspecialchars(mb_strimwidth($row['full_description'], 0, 120, '...'))) . "</td>

                <td>
            <a href='product_media.php?productid=" . urlencode($row['subcat_id']) . "'>
                Add/View
            </a>
        </td>
                <td class='text-center'>$statusSwitch</td>
                <td class='text-center'>$actionButtons</td>
            </tr>
        ";
    }

    echo $html;
    exit;
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'Create';

    // 🔹 Handle getCategory request
    if ($action === 'getProductDetail') {
        $id = $_POST['id'] ?? 0;
        $productdetail = $productDetails->getById($id);
        echo json_encode($productdetail);
        exit;
    }

    // 🔹 Handle Create/Update
    $cat_id = $_POST['cat_id'] ?? '';
	$subcat_id = $_POST['subcat_id'] ?? '';
    $short_description = $_POST['short_description'] ?? '';
	$full_description = $_POST['full_description'] ?? '';
	$product_description = $_POST['product_description'] ?? '';
	$id = $_POST['id'] ?? null;

    // File upload
   $imageName = '';

if (isset($_FILES['product_image']) && $_FILES['product_image']['error'] === 0) {
    $uploadDir = '../../uploads/';
    if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);

    // 🔹 Sanitize the original filename (remove spaces, special characters)
    $originalName = pathinfo($_FILES['product_image']['name'], PATHINFO_FILENAME); // without extension
    $extension = pathinfo($_FILES['product_image']['name'], PATHINFO_EXTENSION);

    // 🔹 Clean filename: lowercase, dashes, no spaces or parentheses
    $safeName = preg_replace('/[^a-zA-Z0-9-_]/', '', str_replace(' ', '-', strtolower($originalName)));

    // 🔹 Final image name: timestamp_safe-name.ext
    $imageName = time() . '_' . $safeName . '.' . $extension;

    move_uploaded_file($_FILES['product_image']['tmp_name'], $uploadDir . $imageName);
}


    // Prepare data
    $data = [
        'cat_id' => $cat_id,
		'subcat_id' => $subcat_id,
		'short_description' => $short_description,
		'full_description' => $full_description,
		'product_description' => $product_description,
        'product_image' => $imageName
    ];

    $response = ['status' => 'error', 'message' => 'Something went wrong'];

    if ($action === 'Create') {
        if ($productDetails->create($data)) {
            $response = ['status' => 'success', 'message' => 'Product subcategory added'];
        }
    } elseif ($action === 'Update' && $id) {
        if ($productDetails->update($id, $data)) {
            $response = ['status' => 'success', 'message' => 'Product subcategory updated'];
        }
    } elseif ($action === 'delete') {
        $id = $_POST['id'] ?? 0;
        $result = $productDetails->delete($id);
        echo json_encode(['status' => $result ? 'success' : 'error', 'message' => $result ? 'Deleted successfully' : 'Failed to delete']);
        exit;
    } elseif ($action === 'toggleStatus') {
        $id = $_POST['id'] ?? 0;
        $result = $productDetails->toggleStatus($id);
        echo json_encode(['status' => $result ? 'success' : 'error', 'message' => $result ? 'Status updated' : 'Status update failed']);
        exit;
    }

	
	

    echo json_encode($response);
    exit;
}
