<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>
 <link rel="stylesheet" href="assets/vendor/libs/quill/editor.css" />
<div class="container-xxl flex-grow-1 container-p-y">
	<div class="d-flex flex-column justify-content-center">
     <h5 class="card-header mb-2">Blog Add</h5>
      </div>
	<button class="btn btn-primary" onclick="window.location.href='blog_details_list.php'" type="button"><span><i class="ti ti-list me-sm-1"></i> <span class="d-none d-sm-inline-block">Blog List</span></span></button>
	<div class="row">
		<!-- Basic Layout -->
		<div class="col-12">
			<div class="card mb-6">
               
                <form class="card-body" id="blogForm" method="POST" enctype="multipart/form-data">
    <div class="row g-4">
        <div class="col-md-12">
            <label class="form-label" for="roomTitle">Title</label>
            <input type="text" class="form-control" id="title"  required>
        </div>
        <div class="col-md-12">
            <label class="form-label">Blog Description</label>
            <div id="editor" style="height: 300px;"></div>
        </div>

        <!-- Blog Image Upload -->
        <div class="col-md-12">
            <label class="form-label">Blog Image</label>
            <input type="file" id="blogImage" class="form-control" accept="image/jpeg, image/png"  onchange="loadFile(event)"  />
        </div>

        <div class="col-md-3">
            <img id="output" src="" height="70" width="70" style="display: none;" />
        </div>
    </div>

    <!-- Hidden fields -->
    <input type="hidden" id="blog_id" name="id">
    <input type="hidden" id="blog_action" name="action" value="<?= isset($_GET['id']) ? 'Update' : 'Create' ?>">

    <!-- Buttons -->
    <div class="pt-4">
        <button type="submit" class="btn btn-primary"><?= isset($_GET['id']) ? 'Update' : 'Save' ?></button>
        <button type="reset" class="btn btn-label-secondary">Cancel</button>
    </div>
</form>






<script>
$(document).ready(function () {
   const quill = new Quill('#editor', {
    theme: 'snow',
    placeholder: 'Write your blog content here...',
    modules: {
        toolbar: [
            [{ header: [1, 2, 3, false] }],
            ['bold', 'italic', 'underline'],
            ['link', 'blockquote', 'code-block'],
            [{ list: 'ordered' }, { list: 'bullet' }],
            [{ align: [] }], // This adds left, center, right, justify
            ['clean']
        ]
    }
});
// Submit handler
    $('#blogForm').on('submit', function (e) {
        e.preventDefault();

        const formData = new FormData();
        const blogContent = quill.root.innerHTML;
        const title = $('#title').val().trim();

        if (!title) {
            Swal.fire('Error', 'Please enter a title.', 'error');
            return;
        }

        if (blogContent.trim() === '<p><br></p>') {
            Swal.fire('Error', 'Please enter blog content.', 'error');
            return;
        }

        formData.append('title', title);
        formData.append('description', blogContent);
        formData.append('id', $('#blog_id').val());
        formData.append('action', $('#blog_action').val());

        const imageFile = $('#blogImage')[0].files[0];
        if (imageFile) {
            formData.append('image', imageFile);
        }

        $.ajax({
            url: 'blog_details_action.php',
            method: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (res) {
                let response = typeof res === 'string' ? JSON.parse(res) : res;
                if (response.status === 'success') {
                    Swal.fire('Success', response.message, 'success').then(() => {
                        window.location.href = 'blog_details_list.php';
                    });
                } else {
                    Swal.fire('Error', response.message || 'Submission failed.', 'error');
                }
            },
            error: function () {
                Swal.fire('Error', 'Server error while submitting blog.', 'error');
            }
        });
    });

    // Load blog data if update mode
   const urlParams = new URLSearchParams(window.location.search);
const blogId = urlParams.get('id');
if (blogId) {
    $('#blog_id').val(blogId); // This line is important
    $.post('blog_details_action.php', { id: blogId, action: 'Select' }, function (res) {
        let data = typeof res === 'string' ? JSON.parse(res) : res;
        console.log('Select Response:', data);
        if (data.status === 'Select') {
            $('#title').val(data.data.title || '');
            quill.root.innerHTML = data.data.description || '';
            $('#blog_action').val('Update');
            if (data.data.image) {
                $('#output').attr('src', data.data.image).show();
            }
        } else {
            Swal.fire('Error', data.message || 'Blog not found.', 'error');
        }
    });
}



    // Image preview
    window.loadFile = function (event) {
        const output = document.getElementById('output');
        output.src = URL.createObjectURL(event.target.files[0]);
        output.style.display = 'block';
        output.onload = function () {
            URL.revokeObjectURL(output.src); // free memory
        };
    };
});
</script>


              </div>
		</div>
		<!-- Basic with Icons -->
		
	</div>
	

</div>
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="assets/vendor/libs/quill/quill.js"></script>
    <script src="assets/js/forms-editors.js"></script>
<?php } ?>