<?php $__env->startSection('pageTitle'); ?> <?php echo $__env->make('layouts.includes.title', ['moduleTitle' => __('Students')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('pageBreadcrumb'); ?> <?php echo $__env->make('layouts.includes.breadcrumb', ['moduleTitle' => __('Students')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row __sms__datatable">
        <div class="col-md-12">
            <div class="card card-topline-aqua">
                    <?php echo $__env->make('layouts.modules.header', ['actionAddNew' => route($moduleName.'.create'), 'title' => __('Students').' '.__('List')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="card-body">
                    <div class="table-scrollable">
                        <table id="<?php echo e($moduleName); ?>-table" class="display table table-checkable order-column valign-middle" style="width: 100%">
                            <thead>
                            <tr>
                                <th width="10%"> <?php echo e(__('locale.admission_no')); ?></th>
                                <th> <?php echo e(__('locale.name')); ?></th>
                                <th width="15%"> <?php echo e(__('locale.email')); ?></th>
                                <th width="7%"> <?php echo e(__('locale.class')); ?></th>
                                <th width="10%"> <?php echo e(__('locale.contact_no')); ?></th>
                                <th width="7%"> <?php echo e(__('locale.gender')); ?></th>
                                <th width="7%"> <?php echo e(__('locale.category')); ?></th>
                                <th width="15%"> <?php echo e(__('Actions')); ?></th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

    <!-- data tables -->
    <link href="<?php echo e(asset('assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet"
          type="text/css" />
    <script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap4.min.js')); ?>"></script>

    <script>
        $(function () {
            $('#<?php echo e($moduleName); ?>-table').DataTable({
                processing: true,
                serverSide: false,
                autoWidth: false,
                responsive: false,
                orderClasses: false,
                ajax: '<?php echo route($moduleName.'.index'); ?>',
                columns: [
                    {data: 'admission_no', name: 'admission_no'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'class', name: 'class'},
                    {data: 'contact_no', name: 'contact_no'},
                    {data: 'gender', name: 'gender'},
                    {data: 'category', name: 'category'},
                    {data: 'action', name: 'action'},
                ],
                columnDefs: [
                    {className: "__sms__ta__right", targets: "_all"},
                    <?php if(\App\Facades\General::isSchoolTeacher() && !\App\Facades\General::isStaffStudentACL()): ?>
                    { "visible": false, "targets": 7 },
                    <?php endif; ?>
                ],
                order: [[1, 'desc']],
                language: {
                    search: '<span>Filter:</span> _INPUT_',
                    lengthMenu: '<span>Show:</span> _MENU_',
                    paginate: {'first': 'First', 'last': 'Last', 'next': '&rarr;', 'previous': '&larr;'}
                },
                lengthMenu: [25, 50, 100],
                displayLength: 25
            });

            $('#<?php echo e($moduleName); ?>-table tbody').on('click', 'tr', function (evt) {
                let href = $(this).find("a#view").attr('href');
                let $cell = $(evt.target).closest('td');
                if ($cell.index() != 4 && href) {
                    $(location).attr('href', href);

                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sms/app/Modules/Student/Resources/Views/index.blade.php ENDPATH**/ ?>