<?php
    use App\Models\Permission;
    use Illuminate\Support\Facades\Auth;
    $user = Auth::user();

    // Fetch all the permissions
    $permissions = Permission::getPermissions();
    $rolePermissions = null;
    // Get the role id of current user
    $roleId = Auth::user()->role_id;

    if (!is_null($roleId)){
        $role = \App\Models\Role::find($roleId);

        if(!is_null($role)){
            // Fetch all the role permissions
            $rolePermissions = $role->permissions()->pluck('route_name')->toArray();
        }
    }

?>
<!-- start sidebar menu -->
<div class="sidebar-container">
    <div class="sidemenu-container navbar-collapse collapse fixed-menu">
        <div id="remove-scroll" class="left-sidemenu">
            <ul class="sidemenu  page-header-fixed" data-keep-expanded="false" data-auto-scroll="true"
                data-slide-speed="200" style="padding-top: 20px">
                <li class="sidebar-toggler-wrapper hide">
                    <div class="sidebar-toggler">
                        <span></span>
                    </div>
                </li>
                <li class="sidebar-user-panel">
                    <div class="user-panel">
                        
                        <div class="pull-left image">
                            <img
                                src="<?php echo e(\Illuminate\Support\Facades\Storage::url( $user->avatar ?? 'avatars/dp.png')); ?>"
                                class="img-circle user-img-circle"
                                alt="User Image"/>
                        </div>
                        <div class="pull-left info">
                            <p><?php echo e($user->name); ?></p>
                            <a href="#"><i class="fa fa-circle user-online"></i>
                                <span class="txtOnline"><?php echo e(__('locale.online')); ?>  </span>
                            </a>
                        </div>
                    </div>
                </li>

                <?php if(\App\Facades\General::isSuperAdmin()): ?>
                    <li class="nav-item <?php echo e((request()->is('dashboard') || request()->is('dashboard/*')) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('dashboard.index')); ?>" class="nav-link nav-toggle">
                            <span class="title"><?php echo e(__('locale.dashboard')); ?></span>
                            <i class="material-icons">dashboard</i>
                        </a>
                    </li><li class="nav-item <?php echo e((request()->is('saas-user') || request()->is('saas-user/*')) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('saas-user.index')); ?>" class="nav-link nav-toggle">
                            <span class="title"><?php echo e(__('locale.users') . ' ' .__('locale.management')); ?></span>
                            <i class="material-icons">group</i>
                        </a>
                    </li>
                    <li class="nav-item <?php echo e((request()->is('saas-school') || request()->is('saas-school/*')) ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('saas-school.index')); ?>" class="nav-link nav-toggle">
                            <span class="title"><?php echo e(__('locale.schools') . ' ' .__('locale.management')); ?></span>
                            <i class="material-icons">school</i>
                        </a>
                    </li>
                <?php else: ?>

                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(isset($permission['children']) && !is_null($permission['children'])): ?>
                            <?php if(in_array($permission['route_name'],$rolePermissions) && $permission['is_active'] == 1): ?>
                                <li class="nav-item">
                                    <a href="javaScript:void(0)" class="nav-link nav-toggle"> <i
                                            class="material-icons"><?php echo e($permission['icon']); ?></i>
                                        <span class="title"><?php echo e(__('locale.'.strtolower($permission['name']))); ?></span>
                                        <span class="arrow"></span>
                                    </a>
                                    <ul class="sub-menu">
                                        <?php $__currentLoopData = $permission['children']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $children): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(in_array($children['route_name'],$rolePermissions) && $children['is_active'] == 1): ?>
                                                <li class="nav-item">
                                                    <a href="<?php echo e((Route::has($children['route_name'].'.index')) ?
route($children['route_name'].'.index') : 'javaScript:void(0)'); ?>" class="nav-link ">
                                                        <span
                                                            class="title"><?php echo e(__('locale.'.strtolower($children['name']))); ?> </span>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if(in_array($permission['route_name'],$rolePermissions) && $permission['is_active'] == 1): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e((Route::has($permission['route_name'].'.index')) ?
route($permission['route_name'].'.index') : 'javaScript:void(0)'); ?>" class="nav-link nav-toggle">
                                        <span class="title"><?php echo e(__('locale.'.strtolower($permission['name']))); ?></span>
                                        <i class="material-icons"><?php echo e($permission['icon']); ?></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<!-- end sidebar menu -->
<?php /**PATH /var/www/html/sms/resources/views/layouts/includes/right.blade.php ENDPATH**/ ?>