<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/**
 * Here, Getting main domain from url
 *
 * */
$mainHost = Request::root();
preg_match('/(?:http[s]*\:\/\/)*(.*?)\.(?=[^\/]*\..{2,5})/i', $mainHost, $match);
$subDomain         = isset($match[1]) ? $match[1] : '';
$subDomainWithHttp = isset($match[0]) ? $match[0] : '';
$host              = str_replace($subDomainWithHttp, '', $mainHost);
$mainHostUrlPort   = parse_url($mainHost, PHP_URL_PORT);


Route::get('/t', function () {
    event(new \App\Events\SendMessage());
    dd('Event Run Successfully.');
});



Route::get('auth/login', ['as' => 'user.login', 'uses' => 'Auth\LoginController@showUserLoginForm']);
Route::post('auth/login', ['as' => 'user_auth.login', 'uses' => 'Auth\LoginController@userLogin']);
Route::get('admin/auth/login', ['as' => 'admin.login', 'uses' => 'Auth\LoginController@showAdminLoginForm']);
Route::post('admin/auth/login', ['as' => 'admin_auth.login', 'uses' => 'Auth\LoginController@adminLogin']);

Auth::routes();
Route::group(['middleware' => ['auth:web,saas', 'acl']], function () {

    Route::get('/change-locale', ['as' => 'change_locale', 'uses' => 'HomeController@changeLocale']);

    Route::get('dashboard',
        ['as' => 'dashboard.index', 'uses' => '\App\Modules\Saasuser\Http\Controllers\SaasUserController@dashboard']);

    Route::pattern('subDomain', '^((?!www).)*$');
    Route::group(['domain' => "{subDomain}"], function ($host) {
        Route::get('/',
            ['middleware' => ['auth', 'acl'], 'uses' => '\App\Modules\Saasuser\Http\Controllers\SaasUserController@dashboard']);
    });

    Route::post('config-account', ['as' => 'config.account', 'uses' => 'HomeController@setConfigAccount']);
});

