<?php

/** @var Factory $factory */

use App\Model;
use App\Models\Account;
use App\Models\Role;
use App\Modules\Student\Model\CastCategory;
use App\Modules\Student\Model\Section;
use App\Modules\Student\Model\Student;
use App\Modules\Student\Model\StudentClass;
use App\Modules\Student\Model\StudentHouse;
use App\User;
use Faker\Generator as Faker;
use Illuminate\Database\Eloquent\Factory;

$factory->define(Student::class, function (Faker $faker) {
    return [
        'account_id'   => 1,
        'user_id'      => \factory(User::class),
        'admission_no' => $faker->unique()->randomDigit,
        'roll_no'      => 2,
        'class_id'     => 1,
        'section_id'   => 1,
        'category_id'  => 1,
        'house_id'     => 1,
        'father_name'  => $faker->name,
        'guardian_id'  => \factory(User::class),
        'created_by'   => \factory(User::class),
        'updated_by'   => \factory(User::class),
    ];
});
