<?php

namespace App\Modules\Timetable\Providers;

use Caffeinated\Modules\Support\ServiceProvider;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(module_path('timetable', 'Resources/Lang', 'app'), 'timetable');
        $this->loadViewsFrom(module_path('timetable', 'Resources/Views', 'app'), 'timetable');
        $this->loadMigrationsFrom(module_path('timetable', 'Database/Migrations', 'app'));
        if(!$this->app->configurationIsCached()) {
            $this->loadConfigsFrom(module_path('timetable', 'Config', 'app'));
        }
        $this->loadFactoriesFrom(module_path('timetable', 'Database/Factories', 'app'));
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }
}
