<?php

namespace App\Modules\Staff\Http\Requests;

use App\Facades\General;
use App\Modules\Staff\Model\Staff;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class Store extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id        = $this->segment(2);
        $userId = 0;
        if ($id > 0){
            $userId = Staff::where('id', $id)->pluck('user_id')->first();
        }

        $accountId = General::getAccountId();

        return [
//            'staff_id'       => 'required',
            'role'           => 'required',
//            'designation_id' => 'required',
//            'department_id'  => 'required',
//            'gender'         => 'required',
//            'dob'            => 'required',
            'name'     => 'required|max:255',
            'email'          => [
                'required',
                Rule::unique('users')->where(function ($query) use ($userId, $accountId) {
                    $query->where('account_id', $accountId);
                    if ($userId > 0) {
                        $query->where('id', '!=', $userId);
                    }
                    return $query;
                }),
            ],
        ];
    }

}
