<?php

namespace App\Modules\Staff\Providers;

use Caffeinated\Modules\Support\ServiceProvider;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(module_path('staff', 'Resources/Lang', 'app'), 'staff');
        $this->loadViewsFrom(module_path('staff', 'Resources/Views', 'app'), 'staff');
        $this->loadMigrationsFrom(module_path('staff', 'Database/Migrations', 'app'));
        if(!$this->app->configurationIsCached()) {
            $this->loadConfigsFrom(module_path('staff', 'Config', 'app'));
        }
        $this->loadFactoriesFrom(module_path('staff', 'Database/Factories', 'app'));
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }
}
