@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Schools')]) @stop

@section('content')
    <div class="row __sms__datatable">
        <div class="col-md-12">
            <div class="card card-topline-aqua">
                @include('layouts.modules.header', ['actionAddNew' => route($moduleName.'.create'), 'title' => __('School').' '.__('List')])
                <div class="card-body">
                    <div class="table-scrollable">
                        <table id="{{$moduleName}}-table"
                               class="display table table-checkable order-column valign-middle" style="width: 100%">
                            <thead>
                            <tr>
                                <th width="10%"> {{ __('saasuser::locale.logo') }}</th>
                                <th width="20%"> {{ __('locale.name') }}</th>
                                <th width="15%"> {{ __('saasuser::locale.domain_alias') }}</th>
                                <th> {{ __('locale.address') }}</th>
                                <th> {{ __('locale.status') }}</th>
                                <th width="15%"> {{ __('locale.actions') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('scripts')

    <script>
        let columnsArray = [
            {data: 'logo', name: 'logo'},
            {data: 'name', name: 'name'},
            {data: 'domain_alias', name: 'domain_alias'},
            {data: 'address', name: 'address'},
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action'}];
        let routeUrl = "{{ route($moduleName.'.index') }}";
        let tableRef = "{{ $moduleName.'-table'}}";
        // Run the Datatable
        let table = __commonDatatableListing(tableRef, routeUrl, columnsArray);

        $(function () {
            $('#{{$moduleName}}-table tbody').on('click', 'tr', function (evt) {
                let href = $(this).find("a#view").attr('href');
                let $cell = $(evt.target).closest('td');
                if ($cell.index() != 4 && href) {
                    $(location).attr('href', href);

                }
            });
        });
    </script>
@stop

