@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => (!isset($saasSchool) ? __('locale.add') : __('locale.edit')) .' '.__('School') ]) @stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <div class="card-box">
            @include('layouts.modules.header', [ 'title' => (!isset($saasSchool) ? __('locale.add') : __('locale.edit')). ' '.__('locale.school')])
            <div class="card-body row">
                @if(isset($saasSchool))
                {!! Form::model($saasSchool, ['route' => [$moduleName.'.update', $saasSchool->id] ,'files' => true, "type" => "card" ]) !!}
                @else
                {!! Form::open([ 'route' => $moduleName.'.store' ,'files' => true, "type" => "card"]) !!}
                @endif
                <div class="row">
                    {!! Form::hidden('user_id', $saasSchool->adminUser->id  ??  old('user_id')) !!}
                    {!!  Form::openGroup('name', __('locale.name'),array("lbl_class" => "required")) !!}
                    {!!  Form::text('name', $saasSchool->name ?? old('name'), ["required" => true] ) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('domain_alias', __('saasuser::locale.domain_alias'),array("lbl_class" => "required")) !!}
                    {!!  Form::text('domain_alias', $saasSchool->domain_alias ?? old('domain_alias'), ["required" => true] ) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('account_code', 'saasuser::locale.account_code') !!}
                    {!!  Form::text('account_code', $saasSchool->account_code ?? old('account_code')) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('school_start_year', 'saasuser::locale.school_start_year') !!}
                    {!!  Form::text('school_start_year', $staff->school_start_year ?? old('school_start_year'),["autocomplete" => "off",'class' => 'setDatePicker']) !!}
                    {!!  Form::closeGroup() !!}
                </div>
                <div class="row">
                    {!!  Form::openGroup('reg_no', 'saasuser::locale.reg_no') !!}
                    {!!  Form::text('reg_no', $saasSchool->reg_no ?? old('reg_no')) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('reg_date', 'saasuser::locale.reg_date') !!}
                    {!!  Form::text('reg_date', $staff->reg_date ?? old('reg_date'),["autocomplete" => "off",'class' => 'setDatePicker']) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('school_type', 'saasuser::locale.school_type',array("lbl_class" => "required")) !!}
                    {!!  Form::select('school_type', $schoolTypes,$saasSchool->school_type ?? old('school_type'), ["required" => true] ) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('school_category', __('saasuser::locale.school_category'),array("lbl_class" => "required")) !!}
                    {!!  Form::select('school_category', $schoolCategories,$saasSchool->school_category ?? old('school_category'), ["required" => true] ) !!}
                    {!!  Form::closeGroup() !!}
                </div>
                <div class="row">
                    {!!  Form::openGroup('pincode', 'saasuser::locale.pincode') !!}
                    {!!  Form::text('pincode', $saasSchool->pincode ?? old('pincode')) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('email', __('locale.email'),array("lbl_class" => "required")) !!}
                    {!!  Form::text('email', $saasSchool->adminUser->email ?? old('email'), ["required" => true] ) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('contact_number', __('saasuser::locale.contact_number'),array("lbl_class" => "contact_number")) !!}
                    {!!  Form::text('contact_number', $saasSchool->contact_number ?? old('contact_number') ) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('website', __('locale.website'),array("lbl_class" => "website")) !!}
                    {!!  Form::text('website', $saasSchool->website ?? old('website') ) !!}
                    {!!  Form::closeGroup() !!}
                </div>
                <div class="row">
                    {!!  Form::openGroup('logo',  Lang::get('locale.logo')) !!}
                        {!!  Form::file('logo') !!}
                        @push("scripts-footer")
                            @php
                            $options = [];
                            if (isset($saasSchool->logo)) {
                                $options["initialPreview"][] = $saasSchool->logo;
                            } @endphp
                            {!!  Form::filejs() !!}
                        @endpush
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('address', 'locale.address',array("lbl_class" => "required")) !!}
                    {!!  Form::textarea('address', $saasSchool->address ?? old('address'),["required" => true, "rows" => 3]) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('about_us', 'locale.about_us') !!}
                    {!!  Form::textarea('about_us', $saasSchool->about_us ?? old('about_us'),["rows" => 3]) !!}
                    {!!  Form::closeGroup() !!}

                    {!!  Form::openGroup('is_activated', 'locale.is_active') !!}
                    {!!  Form::checkbox('is_activated',1) !!}
                    {!!  Form::closeGroup() !!}
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row"> @include('layouts.forms.actions')</div>
{!! Form::close() !!}
</div>
@stop
@section('scripts')
@stop

