@extends('layouts.master')

@section('pageBreadcrumb') @include('layouts.includes.breadcrumb', ['moduleTitle' => __('Dashboard')]) @stop

@section('content')

<!-- start widget -->
<div class="row">
    <div class="state-overview col-lg-3 col-md-12 col-sm-12 col-12">
        <div class="overview-panel purple">
            <div class="symbol">
                <i class="fa fa-book usr-clr"></i>
            </div>
            <div class="value white">
                <p class="sbold addr-font-h1" data-counter="counterup" data-value="{{ $total_schools }}">{{ $total_schools }}</p>
                <p>{{ __('locale.total')}} {{ __('locale.schools')}}</p>
            </div>
        </div>
        <div class="overview-panel bg-blue">
            <div class="symbol">
                <i class="fa fa-users usr-clr"></i>
            </div>
            <div class="value white">
                <p class="sbold addr-font-h1" data-counter="counterup" data-value="{{ $total_users }}">{{ $total_users }}</p>
                <p>{{ __('locale.total')}} {{ __('locale.users')}}</p>
            </div>
        </div>
    </div>
    <div class="col-lg-9 col-md-12 col-sm-12 col-12">
        <div class="card card-box">
            <div class="card-head">
                    <header>{{ __('locale.school_report')}}</header>
                    <div class="tools">
                            <a class="fa fa-repeat btn-color box-refresh" href="javascript:;"></a>
                            <a class="t-collapse btn-color fa fa-chevron-down" href="javascript:;"></a>
                            <a class="t-close btn-color fa fa-times" href="javascript:;"></a>
                    </div>
            </div>
            <div class="card-body no-padding height-9">
                <div class="row">
                    <canvas id="myChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
@stop
@section('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.12.3/js/bootstrap-select.min.js" charset="utf-8"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.6.0/Chart.bundle.js" charset="utf-8"></script>
<script>
var url = "{{url('stock/chart')}}";
var Years = new Array();
var Labels = new Array();
var Prices = new Array();
$(document).ready(function(){
    var Years = <?php echo json_encode($years); ?>;
    var Schools = <?php echo json_encode($year_schools); ?>;
    var color = Chart.helpers.color;
    var ctx = document.getElementById("myChart").getContext('2d');
    var myChart = new Chart(ctx, {
      type: 'bar',
      backgroundColor: window.chartColors.red,
      borderColor: window.chartColors.red,
      data: {
          labels:Years,
          
          datasets: [{
              label: 'Schools',
              data: Schools,
              borderWidth: 1,
              backgroundColor: color(window.chartColors.blue).alpha(0.5).rgbString(),
              borderColor: window.chartColors.blue,
              barPercentage: 1,
              categoryPercentage: 1,
          }]
      },
      options: {
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero:true,
                      stepSize: 1
                  }
              }]
          }
      }
  });
});
</script>
@stop

