<?php

namespace App\Modules\Saasuser\Http\Requests;

use App\Models\Account;
use App\Modules\Student\Model\Student;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreSchool extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id     = $this->segment(2);
        $userId = 0;
        if ($id > 0) {
            $userId = Account::where('id', $id)->pluck('user_id')->first();
        }
        return [
            'name'            => 'required|max:255',
            'address'         => 'required|max:255',
            'domain_alias'    => 'required',
            'school_type'     => 'required',
            'school_category' => 'required',
            'email'           => [
                'required',
                Rule::unique('users')->where(function ($query) use ($userId) {
                    if ($userId > 0) {
                        $query->where('id', '!=', $userId);
                    }
                    return $query;
                }),
            ],
        ];

    }
}
