<?php

namespace App\Modules\Designation\Providers;

use Caffeinated\Modules\Support\ServiceProvider;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the module services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(module_path('designation', 'Resources/Lang', 'app'), 'designation');
        $this->loadViewsFrom(module_path('designation', 'Resources/Views', 'app'), 'designation');
        $this->loadMigrationsFrom(module_path('designation', 'Database/Migrations', 'app'));
        if(!$this->app->configurationIsCached()) {
            $this->loadConfigsFrom(module_path('designation', 'Config', 'app'));
        }
        $this->loadFactoriesFrom(module_path('designation', 'Database/Factories', 'app'));
    }

    /**
     * Register the module services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }
}
