<?php

namespace App\Models;

use App\Facades\General;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Auth;

class Account extends Model
{

    use SoftDeletes;

    protected $fillable = ['name', 'account_code', 'reg_no'
        , 'reg_date', 'school_type', 'school_category', 'contact_number', 'email', 'website', 'pincode', 'logo', 'school_start_year', 'is_activated'
        , 'logo', 'address', 'domain_alias', 'about_us', 'is_activated', 'created_by'];

    /**
     * @return HasMany
     */
    public function users()
    {
        return $this->hasMany('App\User', 'account_id');
    }

    /**
     * @return BelongsTo
     */
    public function adminUser()
    {
        return $this->belongsTo(User::class, 'user_id')->withDefault();
    }

    /**
     * Return all the school accounts
     *
     * @return mixed
     */
    public static function getAccounts()
    {
//        return self::get();
    }

    /**
     * Return school datatable
     *
     * @param $moduleName
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     */
    public static function getSaasAccounts($moduleName)
    {
        $schoolModel = self::query();

        return DataTables::eloquent($schoolModel)
                        ->addColumn('action', function ($account) use ($moduleName) {
                            $action = '';
                            $action .= View('layouts.actions.view')->with('model', $account)->with('route', $moduleName . '.show');
                            $action .= View('layouts.actions.edit')->with('model', $account)->with('route', $moduleName . '.edit');
                            if(\Illuminate\Support\Facades\Auth::user()->is_super){
                                $action .= View('layouts.actions.delete')->with('model', $account)->with('route', $moduleName . '.destroy');
                            }
                            return $action .= '';
                        })
                        ->addColumn('logo', function ($account) {
                            return '<img style="width:50px; height:50px;" src="'.Storage::url( $account->logo ?? 'avatars/dp.png').'" alt="">';
                        })
                        ->addColumn('status', function ($account) {
                            return '<button type="button" class="btn yellow btn-outline btn-circle btn-xs m-b-10">'.($account->is_activated == 1 ? 'Active' : 'Inactive').'</button>';
                        })
                        ->rawColumns(['action', 'logo', 'status'])
                        ->make(true);
    }
    public static function getSchoolTypes(){
        $types =  ["Private","Government","Self Finance","Not Specified"];
        return array_combine($types,$types);
    }
    public static function getSchoolCategories(){
        $categories = ["Primary","Secondary","Univerisity","Not Specified"];
        return array_combine($categories,$categories);
    }

    /**
     * Upload file on server
     *
     * @param $request
     * @param $fileName
     * @return mixed
     */
    public static function uploadSchoolLogo($request, $fileName)
    {
        if ($request->hasFile($fileName)) {

            return General::uploadAvatar($request, $fileName);
        }
    }

    /**
     * Save student details into user table
     *
     * @param $request
     * @param bool $update
     * @return User|mixed|object|null
     */
    public static function addUpdateSchoolUser($request, $update = false)
    {
        $user   = null;
        $insert = false;
        // Request to update data
        if ($update == true) {
            $user = (new User())->findById($request->user_id);
        }
        if ($user == null) {
            $user   = new User();
            $insert = true;
        }
        // match the requested fields with resource
        $user->fill($request->all());
        if ($insert == true) {
            $user->created_by = Auth::user()->id;
            $user->password = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi'; // password
        } else {
            $user->updated_by = Auth::user()->id;
        }
        $user->role_id    = 1;
        $user->save();

        return $user;
    }
}
