<?php

namespace App\Http\Middleware;

use App\Facades\General;
use Closure;
use App\Models\Permission;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Request;

class Acl
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $routeName = Request::route()->getName();

        if (!$request->ajax()) {

            if (!Permission::checkAccessAllow($routeName) && !General::isSuperAdmin() && $routeName != 'change_locale') {

                if ($routeName != null){
                    Session::flash('error',
                        "You don't have permission to access this module. Kindly contact administration.");
                }

                return redirect('dashboard');
            }
        }

        return $next($request);
    }
}
