<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
include( "inc/template.php" );

function main() {
	global $conn;
	?>
	<div class="container-xxl flex-grow-1 container-p-y">
		<nav aria-label="breadcrumb">
			<ol class="breadcrumb breadcrumb-custom-icon">
				<li class="breadcrumb-item"><a href="dashboard.php">Home</a><i class="breadcrumb-icon icon-base ti tabler-chevron-right align-middle icon-xs"></i>
				</li>
				<li class="breadcrumb-item active">News Papers</li>
			</ol>
		</nav>
		<button type="button" class="btn btn-sm rounded-pill btn-primary" data-bs-toggle="modal" data-bs-target="#newsModal"><i class="ti ti-plus me-sm-1"></i>Add News Papers</button>

		<div class="modal fade" id="newsModal" tabindex="-1" aria-hidden="true">
			<div class="modal-dialog modal-lg">
				<form id="newsForm" method="post" enctype="multipart/form-data">
					<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title">Add/Edit News Papers</h5>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						</div>
						<div class="modal-body">
							<input type="hidden" id="id" name="id"/>
							<div class="row mb-3">
								<div class="col-md-12 mb-3">
									<label for="name" class="form-label">Newspaper Name</label>
									<input type="text" name="name" id="name" class="form-control" required>
								</div>

								<div class="col-md-6 mb-3">
									<label class="form-label">Agency</label>
									<select name="agency_id" id="agency_id" class="form-select" required>
										<option value="">-- Select Agency --</option>
										<?php
										require_once 'models/AgencyModel.php';
										$agencyModel = new AgencyModel( $conn );
										$agencies = $agencyModel->dropdownAgency();
										while ( $row = $agencies->fetch_assoc() ) {
											echo '<option value="' . $row[ 'id' ] . '">' . ucwords( htmlspecialchars( $row[ 'agencyname' ] ) ) . '</option>';

										}
										?>
									</select>
								</div>

								<div class="col-md-6 mb-3">

									<label for="price" class="form-label">Price</label>
									<input type="number" name="price" id="price" class="form-control" step="0.01" value="0.00" required>
								</div>
								<div class="col-md-6 mb-3">
									<label for="language" class="form-label">Language</label>
									<select name="language" id="language" class="form-select">
										<option value="Gujarati" selected>Gujarati</option>
										<option value="Hindi">Hindi</option>
										<option value="English">English</option>
										<option value="Marathi">Marathi</option>
										<option value="Other">Other</option>
									</select>
								</div>

								<div class="col-md-6 mb-3">
									<label for="circulation" class="form-label">Circulation</label>
									<input type="number" name="circulation" id="circulation" class="form-control" value="0">
								</div>
							</div>
						</div>
						<input type="hidden" name="status" id="status" value="active">
						<div class="modal-footer">
							<button type="submit" class="btn btn-primary">Save</button>
							<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
						</div>
					</div>
				</form>

			</div>
		</div>

		<div class="card">

			<div id="alert-box" class="alert d-none" role="alert"></div>
			<div class="card-datatable text-nowrap">
				<table class="datatables-ajax table table-bordered">
					<thead>
						<tr>
							<th>Pepar Name</th>
							<th>Agency Name</th>
							<th>Price</th>
							<th>Language</th>
							<th>Circulation</th>
							<th>Status</th>
							<th>Action</th>
						</tr>
					</thead>
					<tbody></tbody>
				</table>

			</div>
		</div>
	</div>
	<script>
		$(document).ready(function() {
    // Toast function
    function showToast(message, type = 'success') {
        const alertBox = $('#alert-box');
        alertBox.removeClass('d-none alert-success alert-danger')
            .addClass(`alert alert-${type}`)
            .text(message);

        setTimeout(() => {
            alertBox.addClass('d-none').removeClass(`alert-${type}`).text('');
        }, 3000);
    }

    // Capitalize words
    function capitalizeWords(str) {
        if (!str) return '';
        return str.toLowerCase().replace(/\b\w/g, txt => txt.toUpperCase());
    }

    // Handle newspapers form submit
    $('#newsForm').on('submit', function(e) {
    e.preventDefault();
    const modalEl = document.getElementById('newsModal');
    const modal = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl);
    modal.hide();

    const formData = new FormData(this);
    formData.append('action', 'saveNewspaper'); // <-- ADD THIS

    $.ajax({
        url: 'controllers/NewspaperController.php',
        method: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function(res) {
            try {
                let result = JSON.parse(res);
                if (result.status === 'success') {
                    $('#newsForm')[0].reset();
                    $('#id').val('');
                    fetchNewspapers();
                    showToast(result.message, 'success');
                } else {
                    showToast(result.message, 'danger');
                }
            } catch(err) {
                console.error("Parse error:", res);
                showToast('Invalid server response.', 'danger');
            }
        },
        error: function() {
            showToast('Something went wrong. Try again.', 'danger');
        }
    });
});


    // Fetch newspapers DataTable
    function fetchNewspapers() {
        if ($.fn.DataTable.isDataTable('.datatables-ajax')) {
            $('.datatables-ajax').DataTable().ajax.reload(null, false);
            return;
        }

        $('.datatables-ajax').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: 'controllers/NewspaperController.php',
                type: 'POST',
                data: { action: 'listNewspapers' }
            },
            columns: [
                { data: 'name', render: d => capitalizeWords(d) },
                { data: 'agencyname', render: d => capitalizeWords(d) },
                { data: 'price' },
                { data: 'language' },
                { data: 'circulation' },
                {
                    data: 'status',
                   render: function(data, type, row) {
        const checked = data === 'active' ? 'checked' : '';
        return `
        <label class='switch switch-success'>
            <input type='checkbox' class='switch-input toggleStatus' data-id='${row.id}' ${checked} />
            <span class='switch-toggle-slider'>
                <span class='switch-on'><i class='icon-base ti tabler-check'></i></span>
                <span class='switch-off'><i class='icon-base ti tabler-x'></i></span>
            </span>
        </label>`;
    }
                },
                { data: 'actions', orderable: false, searchable: false }
            ],
            order: [[0,'asc']]
        });
    }

    fetchNewspapers();

    // Edit button
    $(document).on('click', '.editBtn', function() {
        const id = $(this).data('id');
        $.post('controllers/NewspaperController.php', { action: 'getNewspaper', id: id }, function(data) {
            const news = JSON.parse(data);
            $('#id').val(news.id);
            $('#name').val(news.name);
            $('#agency_id').val(news.agency_id);
            $('#price').val(news.price);
            $('#language').val(news.language);
            $('#circulation').val(news.circulation);
            $('#status').val(news.status);
            $('#newsModal').modal('show');
        });
    });

    // Delete button
    $(document).on('click', '.deleteBtn', function() {
        const id = $(this).data('id');
        Swal.fire({
            title: 'Are you sure?',
            text: "Do you really want to delete this newspaper?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post('controllers/NewspaperController.php', { action: 'deleteNewspaper', id: id }, function(res) {
                    let result = JSON.parse(res);
                    if (result.status === 'success') {
                        fetchNewspapers();
                        Swal.fire('Deleted!', result.message, 'success');
                    } else {
                        Swal.fire('Error!', result.message, 'error');
                    }
                });
            }
        });
    });

    // Status toggle
    $(document).on('change', '.toggleStatus', function() {
    const id = $(this).data('id'); 
    $.post('controllers/NewspaperController.php', { action: 'toggleStatus', id: id }, function(res) {
        const result = JSON.parse(res);
        showToast(result.message, result.status === 'success' ? 'success' : 'danger');
        fetchNewspapers();
    });
});


});

	</script>
	<?php } ?>