<?php
class NewspaperModel {
    private $conn;

    public function __construct($db){
        $this->conn = $db;
    }

    // Get all newspapers with pagination and search
    public function getNewspapers($start, $length, $search=''){
        $where = "WHERE 1";

        if(!empty($search)){
            $search = $this->conn->real_escape_string($search);
            $where .= " AND (n.name LIKE '%$search%' OR a.agencyname LIKE '%$search%')";
        }

        // Total count
        $totalResult = $this->conn->query("SELECT COUNT(*) as total FROM newspapers");
        $total = $totalResult->fetch_assoc()['total'];

        // Filtered count
        $filteredResult = $this->conn->query("SELECT COUNT(*) as total FROM newspapers n LEFT JOIN agency a ON n.agency_id=a.id $where");
        $filtered = $filteredResult->fetch_assoc()['total'];

        // Fetch data
        $sql = "SELECT n.*, a.agencyname 
                FROM newspapers n 
                LEFT JOIN agency a ON n.agency_id = a.id 
                $where ORDER BY n.id DESC LIMIT $start, $length";
        $res = $this->conn->query($sql);

        $data = [];
        while($row = $res->fetch_assoc()){
            $row['actions'] = '
                <button class="btn btn-warning btn-xs editBtn" data-id="'.$row['id'].'"><i class="ti ti-edit"></i></button>
                <button class="btn btn-danger btn-xs deleteBtn" data-id="'.$row['id'].'"><i class="ti ti-trash"></i></button>
            ';
            $data[] = $row;
        }

        return [
            'total'=>$total,
            'filtered'=>$filtered,
            'data'=>$data
        ];
    }

    // Get single newspaper
    public function getNewspaperById($id){
        $id = intval($id);
        $sql = "SELECT * FROM newspapers WHERE id = $id";
        $res = $this->conn->query($sql);
        return $res->fetch_assoc();
    }

    // Create newspaper
    public function createNewspaper($name, $agency_id, $price, $language, $edition, $circulation, $status){
        $name = $this->conn->real_escape_string($name);
        $edition = $this->conn->real_escape_string($edition);
        $status = $this->conn->real_escape_string($status);

        $sql = "INSERT INTO newspapers (name, agency_id, price, language, edition, circulation, status)
                VALUES ('$name', $agency_id, $price, '$language', '$edition', $circulation, '$status')";
        return $this->conn->query($sql);
    }

    // Update newspaper
    public function updateNewspaper($id, $name, $agency_id, $price, $language, $edition, $circulation){
        $id = intval($id);
        $name = $this->conn->real_escape_string($name);
        $edition = $this->conn->real_escape_string($edition);
        
        $sql = "UPDATE newspapers SET 
                name='$name',
                agency_id=$agency_id,
                price=$price,
                language='$language',
                edition='$edition',
                circulation=$circulation
                WHERE id=$id";
        return $this->conn->query($sql);
    }

    // Delete newspaper
    public function deleteNewspaper($id){
        $id = intval($id);
        $sql = "DELETE FROM newspapers WHERE id=$id";
        return $this->conn->query($sql);
    }

    // Toggle status
    public function toggleStatus($id) {
    $id = intval($id);
    if (!$id) return false;

    // Get current status
    $stmt = $this->conn->prepare("SELECT status FROM newspapers WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $newspaper = $result->fetch_assoc();

    if (!$newspaper) return false;

    // Flip status
    $newStatus = ($newspaper['status'] === 'active') ? 'inactive' : 'active';

    // Update status
    $stmt = $this->conn->prepare("UPDATE newspapers SET status = ? WHERE id = ?");
    $stmt->bind_param("si", $newStatus, $id);

    if ($stmt->execute()) {
        return $newStatus; // return the updated status
    }
    return false;
}
}
