<?php
class AuthModel {
    private $conn;
    private $table = 'users';

    public function __construct($conn) {
        $this->conn = $conn;
    }

    // Login by email
    public function login($email, $password) {
        $stmt = $this->conn->prepare("SELECT * FROM {$this->table} WHERE email=? LIMIT 1");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($user = $result->fetch_assoc()) {

            // Check if user is admin
            if ($user['role'] !== 'admin') {
                return 'not_admin';
            }

            // Check if status is active
            if ($user['status'] !== 'active') {
                return 'inactive';
            }

            // Check password
            if (!password_verify($password, $user['password'])) {
                return 'invalid_password';
            }

            return $user;
        }

        return 'not_found';
    }

    // Login using cookies
    public function loginWithCookie($email, $userId) {
        $stmt = $this->conn->prepare("SELECT * FROM {$this->table} WHERE id=? AND email=? AND role='admin' AND status='active' LIMIT 1");
        $stmt->bind_param("is", $userId, $email);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_assoc() ?: false;
    }
}
