<?php
require_once '../inc/db.php';
require_once '../models/AgencyModel.php';

$model = new AgencyModel($conn);

// Detect request type
$action = $_REQUEST['action'] ?? '';

switch ($action) {

    case 'saveAgency':
    $id = $_POST['id'] ?? 0;

    if ($model->checkDuplicate("email", $_POST['email'], $id)) {
        echo json_encode(["status" => "error", "message" => "Email already exists"]);
        exit;
    }
    if ($model->checkDuplicate("phone", $_POST['phone'], $id)) {
        echo json_encode(["status" => "error", "message" => "Phone already exists"]);
        exit;
    }
    if (!empty($_POST['registration_no']) && $model->checkDuplicate("registration_no", $_POST['registration_no'], $id)) {
        echo json_encode(["status" => "error", "message" => "Registration No already exists"]);
        exit;
    }

     // Handle logo upload
		$logo_file = $_FILES['logo'] ?? null;
		$logo_filename = $_POST['old_logo'] ?? ''; // ✅ default to old logo

		if ($logo_file && $logo_file['error'] === 0) {
			$ext = pathinfo($logo_file['name'], PATHINFO_EXTENSION);
			$logo_filename = 'agency_' . time() . '.' . $ext;
			move_uploaded_file($logo_file['tmp_name'], '../uploads/agency/' . $logo_filename);

			// delete old logo if exists
			if (!empty($_POST['old_logo']) && file_exists('../uploads/agency/' . $_POST['old_logo'])) {
				unlink('../uploads/agency/' . $_POST['old_logo']);
			}
		}

		$ok = $model->saveAgency($_POST, $logo_filename);

    if ($ok) {
        if (!empty($id)) {
            echo json_encode(["status" => "success", "message" => "Agency updated successfully!"]);
        } else {
            echo json_encode(["status" => "success", "message" => "Agency created successfully!"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to save agency"]);
    }
    break;

case 'deleteAgency':
    $id = $_POST['id'] ?? 0;
    $ok = $model->deleteAgency($id);
    echo json_encode($ok ? ["status" => "success"] : ["status" => "error", "message" => "Delete failed"]);
    break;

		
	// DataTable hotel listing
    case 'listAgency':
        $draw   = intval($_POST['draw'] ?? 1);
        $start  = intval($_POST['start'] ?? 0);
        $length = intval($_POST['length'] ?? 10);
        $search = $_POST['search']['value'] ?? '';

        $result = $model->getAgency($start, $length, $search);

        echo json_encode([
            "draw" => $draw,
            "recordsTotal" => $result['total'],
            "recordsFiltered" => $result['filtered'],
            "data" => $result['data']
        ]);
        break;
		
	


    // Toggle hotel status
    case 'toggleStatus':
    $id = intval($_POST['id']);
    $newStatus = $model->toggleStatus($id); // now returns 'active' or 'inactive'

    if ($newStatus !== false) {
        $statusText = ($newStatus === 'active') ? "Active" : "Inactive";
        echo json_encode([
            "status" => "success",
            "message" => "Status updated to {$statusText}.",
            "new_status" => $newStatus
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Failed to update status."
        ]);
    }
    break;


    // Delete hotel
    case 'deleteAgency':
        $id = intval($_POST['id']);
        $res = $model->deleteAgency($id);

        if ($res) {
            echo json_encode(["status" => "success", "message" => "Agency deleted successfully."]);
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to delete Agency."]);
        }
        break;
		
	case 'viewAgency':
    $id = intval($_GET['id'] ?? 0);
    $agency = $model->viewAgencyById($id);
    if ($agency) {
        echo json_encode($agency);
    } else {
        echo json_encode(["error" => "Agency not found"]);
    }
    break;
		
	case 'getAgency':
    $id = intval($_GET['id'] ?? 0);
    if ($id) {
        $agency = $model->getAgencyById($id); // Call model function
        if ($agency) {
            // Return logo full path
            if (!empty($agency['logo']) && file_exists('../uploads/agency/' . $agency['logo'])) {
                $agency['logo'] = 'uploads/agency/' . $agency['logo'];
            } else {
                $agency['logo'] = '';
            }
            echo json_encode($agency);
        } else {
            echo json_encode(["error" => "Agency not found"]);
        }
    } else {
        echo json_encode(["error" => "Invalid ID"]);
    }
    break;


    default:
        echo json_encode(["status" => "error", "message" => "Invalid action"]);
        break;
}
