<?php include('inc/template.php'); ?>
<div class="container-fluid flex-grow-1 container-p-y">
	<nav aria-label="breadcrumb">
	<ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="index.php" data-bs-toggle="modal"  data-bs-target="#smallModal"><i class="ti ti-search ti-xs"></i> Search</a></li>
    </ol>
</nav>
	<style>
		.scroll-list {
			max-height: 350px;
			overflow-y: auto;
			list-style-type: none;
			padding: 0;
			margin: 0;
		}
		
		.scroll-list::-webkit-scrollbar {
			width: 1px;
		}
		
		.scroll-list::-webkit-scrollbar-thumb {
			background-color: #888;
			border-radius: 5px;
		}
		
		.scroll-list2 {
			max-height: 350px;
			overflow-y: auto;
			list-style-type: none;
			padding: 0;
			margin: 0;
		}
		
		.scroll-list2::-webkit-scrollbar {
			width: 1px;
		}
		
		.scroll-list2::-webkit-scrollbar-thumb {
			background-color: #888;
			border-radius: 5px;
		}

	</style>
	<?php 
	function formatIndianCurrency($number) {
    $number = (string)$number;
    $decimal = '';
    if (strpos($number, '.') !== false) {
        list($number, $decimal) = explode('.', $number);
        $decimal = '.' . $decimal;
    }
    $lastThree = substr($number, -3);
    $restUnits = substr($number, 0, -3);
    if ($restUnits != '') {
        $restUnits = preg_replace("/\B(?=(\d{2})+(?!\d))/", ",", $restUnits);
        return '₹' . $restUnits . "," . $lastThree . $decimal;
    } else {
        return '₹' . $lastThree . $decimal;
    }
}
$today = date( 'Y-m-d' );
?>
	<div class="row">
		<div class="modal fade" id="smallModal" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-sm" role="document">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h5 class="modal-title" id="exampleModalLabel2">Modal title</h5>
                              <button
                                type="button"
                                class="btn-close"
                                data-bs-dismiss="modal"
                                aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                              
                              <div class="row g-2">
                                <div class="col mb-0">
                                  <label class="form-label" for="emailSmall">From</label>
                                  <input type="date" class="form-control" id="fromdate"  />
                                </div>
                                <div class="col mb-0">
                                  <label for="dobSmall" class="form-label">To</label>
                                  <input id="todate" type="date"  class="form-control" />
                                </div>
                              </div>
                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                                Close
                              </button>
                              <button type="button" class="btn btn-primary">Search</button>
                            </div>
                          </div>
                        </div>
                      </div>
		<div class="col-lg-2 col-6 mb-4">
			<div class="card h-100">
				<a href="inquiry_list.php">
					<div class="card-body text-center">
						<div class="badge rounded-pill p-2 bg-label-success mb-2">
							<i class="ti ti-headset ti-sm"></i>
						</div>
						<?php
						$sql5 = "SELECT COUNT(*) AS total_inquiries FROM inquiries WHERE assigned_to = '$adminId'";
						$result5 = mysqli_query( $conn, $sql5 );
						$row5 = mysqli_fetch_assoc( $result5 );
						?>
						<h5 class="card-title mb-2">
							<?php echo $row5['total_inquiries']; ?>
						</h5>
						<small>Inquiries</small>
					</div>
				</a>
			</div>
		</div>
		<div class="col-lg-2 col-6 mb-4">
			<div class="card h-100">
				<a href="quotation_list.php">
					<div class="card-body text-center">
						<div class="badge rounded-pill p-2 bg-label-success mb-2">
							<i class="ti ti-file-description ti-sm"></i>
						</div>
						<?php
						$sql5 = "SELECT COUNT(*) AS total_inquiries FROM inquiries WHERE assigned_to = '$adminId'";
						$result5 = mysqli_query( $conn, $sql5 );
						$row5 = mysqli_fetch_assoc( $result5 );
						?>
						<h5 class="card-title mb-2">
							<?php echo $row5['total_inquiries']; ?>
						</h5>
						<small>Quotation</small>
					</div>
				</a>
			</div>
		</div>
		<!-- Bookings -->
		<div class="col-lg-2 col-6 mb-4">
			<div class="card h-100">
				<a href="booking_list.php">
					<div class="card-body text-center">
						<div class="badge rounded-pill p-2 bg-label-success mb-2">
							<i class="ti ti-directions ti-sm"></i>
						</div>
						<?php
						$sql1 = "SELECT COUNT(*) AS total_bookings FROM package_bookings WHERE assigned_to = '$adminId'";
						$result1 = mysqli_query( $conn, $sql1 );
						$row1 = mysqli_fetch_assoc( $result1 );
						?>
						<h5 class="card-title mb-2">
							<?php echo $row1['total_bookings']; ?>
						</h5>
						<small>Bookings</small>
					</div>
				</a>
			</div>
		</div>

		<!-- Customers -->
		<div class="col-lg-2 col-6 mb-4">
			<div class="card h-100">
				<a href="customers_list.php">
					<div class="card-body text-center">
						<div class="badge rounded-pill p-2 bg-label-success mb-2">
							<i class="ti ti-user ti-sm"></i>
						</div>
						<?php
						$sql2 = "SELECT COUNT(*) AS total_customers FROM customers";
						$result2 = mysqli_query( $conn, $sql2 );
						$row2 = mysqli_fetch_assoc( $result2 );
						?>
						<h5 class="card-title mb-2">
							<?php echo $row2['total_customers']; ?>
						</h5>
						<small>Customers</small>
					</div>
				</a>
			</div>
		</div>

		<!-- Packages -->
		<!-- Agents -->
		<?php /*?>
		<div class="col-lg-2 col-6 mb-4">
			<div class="card h-100">
				<a href="agents_list.php">
					<div class="card-body text-center">
						<div class="badge rounded-pill p-2 bg-label-success mb-2">
							<i class="ti ti-id-badge ti-sm"></i>
						</div>
						<?php
						$sql4 = "SELECT COUNT(*) AS total_agents FROM Agents WHERE id = '$adminId'";
						$result4 = mysqli_query( $conn, $sql4 );
						$row4 = mysqli_fetch_assoc( $result4 );
						?>
						<h5 class="card-title mb-2">
							<?php echo $row4['total_agents']; ?>
						</h5>
						<small>Agents</small>
					</div>
				</a>
			</div>
		</div>
		<?php */?>

		<!-- Inquiries -->
		

		<!-- Payments -->
		<div class="col-lg-2 col-6 mb-4">
			<div class="card h-100">
				<a href="payments_list.php">
					<div class="card-body text-center">
						<div class="badge rounded-pill p-2 bg-label-success mb-2">
							<i class="ti ti-money ti-sm"></i>
						</div>
						<?php
						$sql6 = "SELECT COUNT(*) AS total_payments FROM package_payments WHERE assigned_to = '$adminId'";
						$result6 = mysqli_query( $conn, $sql6 );
						$row6 = mysqli_fetch_assoc( $result6 );
						?>
						<h5 class="card-title mb-2">
							<?php echo $row6['total_payments']; ?>
						</h5>
						<small>Payments</small>
					</div>
				</a>
			</div>
		</div>
		
		<div class="col-lg-2 col-6 mb-4">
			<div class="card h-100">
				<a href="sales_master.php">
					<div class="card-body text-center">
						<div class="badge rounded-pill p-2 bg-label-success mb-2">
							<i class="ti ti-money ti-sm"></i>
						</div>
						<?php
						$sql7 = "SELECT COUNT(*) AS total_sales FROM users WHERE role = 'sales'";
						$result7 = mysqli_query( $conn, $sql7 );
						$row7 = mysqli_fetch_assoc( $result7 );
						?>
						<h5 class="card-title mb-2">
							<?php echo $row7['total_sales']; ?>
						</h5>
						<small>Sales</small>
					</div>
				</a>
			</div>
		</div>
		
		<?php
		// Fetch total debit and credit
		$sql = "
    SELECT 
        SUM(CASE WHEN type = 'debit' THEN amount ELSE 0 END) AS total_debit,
        SUM(CASE WHEN type = 'credit' THEN amount ELSE 0 END) AS total_credit
    FROM package_payments
";
		$result = mysqli_query( $conn, $sql );
		$data = mysqli_fetch_assoc( $result );

		$total_debit = $data[ 'total_debit' ] ?? 0;
		$total_credit = $data[ 'total_credit' ] ?? 0;
		$total_pending = $total_debit - $total_credit;
		?>

		<div class="col-lg-3 col-sm-6 mb-4">
			<div class="card h-100">
				<div class="card-body d-flex justify-content-between align-items-center">
					<div class="card-title mb-0">
						<h5 class="mb-0 me-2">
							<?= formatIndianCurrency($total_debit) ?>
						</h5>
						<small>Total Debit</small>
					</div>
					<div class="card-icon">
						<span class="badge bg-label-danger rounded-pill p-2">
          <i class="ti ti-arrow-down ti-sm"></i>
        </span>
					
					</div>
				</div>
			</div>
		</div>

		<div class="col-lg-3 col-sm-6 mb-4">
			<div class="card h-100">
				<div class="card-body d-flex justify-content-between align-items-center">
					<div class="card-title mb-0">
						<h5 class="mb-0 me-2">
							<?= formatIndianCurrency($total_credit) ?>
						</h5>
						<small>Total Credit</small>
					</div>
					<div class="card-icon">
						<span class="badge bg-label-success rounded-pill p-2">
          <i class="ti ti-arrow-up ti-sm"></i>
        </span>
					
					</div>
				</div>
			</div>
		</div>

		<div class="col-lg-3 col-sm-6 mb-4">
			<div class="card h-100">
				<div class="card-body d-flex justify-content-between align-items-center">
					<div class="card-title mb-0">
						<h5 class="mb-0 me-2">
							<?= formatIndianCurrency($total_pending) ?>
						</h5>
						<small>Total Pending</small>
					</div>
					<div class="card-icon">
						<span class="badge bg-label-warning rounded-pill p-2">
          <i class="ti ti-clock ti-sm"></i>
        </span>
					
					</div>
				</div>
			</div>
		</div>

	

	</div>
	<div class="row">

		<!-- Inquiries -->
		<div class="col-12 col-xl-6 col-md-6 mb-4">
			<div class="card h-100">
				<div class="card-header d-flex justify-content-between pb-2">
					<div class="card-title mb-1">
						<h5 class="m-0 me-2">Todays</h5>
					</div>
				</div>
				<div class="card-body">
					<div class="nav-align-top">
						<ul class="nav nav-tabs nav-fill" role="tablist">
							<li class="nav-item">
								<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#navs-justified-inquiries" aria-controls="navs-justified-inquiries" aria-selected="true">
                Inquiries
              </button>
							
							</li>
							<li class="nav-item">
								<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-justified-quotations" aria-controls="navs-justified-quotations" aria-selected="false">
                Quotations
              </button>
							
							</li>
							<li class="nav-item">
								<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-justified-bookings" aria-controls="navs-justified-bookings" aria-selected="false">
                Package Bookings
              </button>
							
							</li>
						</ul>

						<div class="tab-content px-2 mx-1 pb-0">
							<!-- Inquiries Tab -->
							<div class="tab-pane fade show active" id="navs-justified-inquiries" role="tabpanel">
								<?php
								
								$sqlInquiries = "
    SELECT inquiries.id AS inquiry_id, inquiries.*, customers.id AS customer_id, customers.*,users.name AS assigned_user
    FROM inquiries
    JOIN customers ON inquiries.customer_id = customers.id LEFT JOIN users ON inquiries.assigned_to = users.id
    WHERE inquiries.inquiry_date = '$today'
    ORDER BY inquiries.created_at ASC
";

								// Execute the query
								$resultInquiries = mysqli_query( $conn, $sqlInquiries );

								// Check if there are any results
								if ( mysqli_num_rows( $resultInquiries ) > 0 ) {
									?>
								<ul class="timeline mb-0 pb-1 scroll-list">
									<?php while ($row = mysqli_fetch_assoc($resultInquiries)) { ?>
									<li class="timeline-item">
										<div class="timeline-event px-0 pb-0">
											<h6 class="mb-1">Customer: <?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?></h6>
											<p class="text-muted mb-0"><strong>Inquiry Type:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_type']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Destination:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['destination']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Travel Date:</strong>
												<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Status:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['followup_status']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Assign to :</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['assigned_user']))); ?>
											</p>
											<p class="text-muted mb-0"><a href="#" data-bs-toggle="modal" data-bs-target="#viewInquiry<?php echo $row['inquiry_id']; ?>" class="fst-italic">More Details</a>
											</p>

										</div>
									</li>

									<!-- Modal for Inquiry Details -->
									<div class="modal fade" id="viewInquiry<?php echo $row['inquiry_id']; ?>" tabindex="-1" aria-hidden="true">
										<div class="modal-dialog modal-dialog-centered">
											<div class="modal-content">
												<div class="modal-header">
													<h5 class="modal-title">Inquiry Details</h5>
													<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
												</div>
												<div class="modal-body">
													<ul class="list-unstyled mb-0 mt-0">
														<li><strong>Customer Name:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?>
														</li>
														<li><strong>Email:</strong>
															<?php echo htmlspecialchars($row['email']); ?>
														</li>
														<li><strong>Phone:</strong>
															<?php echo htmlspecialchars($row['phone']); ?>
														</li>
														<li><strong>Destination:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['destination']))); ?>
														</li>
														<li><strong>Travel Date:</strong>
															<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
														</li>
														<li><strong>Nights:</strong>
															<?php echo htmlspecialchars($row['nights']); ?>
														</li>
														<li><strong>Adults/Children:</strong>
															<?php echo htmlspecialchars($row['adults']) . '/' . htmlspecialchars($row['child']); ?>
														</li>
														<li><strong>Rooms:</strong>
															<?php echo htmlspecialchars($row['rooms']); ?>
														</li>
														<li><strong>Remarks:</strong>
															<?php echo htmlspecialchars($row['remarks']); ?>
														</li>
													</ul>
												</div>
											</div>
										</div>
									</div>
									<?php } ?>
								</ul>


								<?php } else { echo "<h6 class='text-center'>No inquiries today</h6>"; } ?>
							</div>

							<!-- Quotations Tab -->
							<div class="tab-pane fade" id="navs-justified-quotations" role="tabpanel">
								<?php
								$sqlQuotations = "SELECT quotations.id AS quotation_id,quotations.status AS quotation_status, quotations.*, customers.id AS customer_id, customers.*,users.name AS assigned_user FROM quotations JOIN customers ON quotations.customer_id = customers.id LEFT JOIN users ON quotations.assigned_to = users.id WHERE DATE(quotations.quotation_date) = '$today' ORDER BY quotations.created_at ASC";						$resultQuotations = mysqli_query( $conn, $sqlQuotations );
								if ( mysqli_num_rows( $resultQuotations ) > 0 ) {
									?>
								<ul class="timeline mb-0 pb-1 scroll-list">
									<?php while ($row = mysqli_fetch_assoc($resultQuotations)) { ?>
									<li class="timeline-item">
										<div class="timeline-event px-0 pb-0">
											<h6 class="mb-1">Customer: <?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?></h6>
											<p class="text-muted mb-0"><strong>Quotation No.:</strong>
												<?php echo htmlspecialchars($row['quotation_no']); ?>
											</p>
											<p class="text-muted mb-0"><strong>Package Name:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['package_name']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Quotation Amount:</strong>
												<?php echo htmlspecialchars($row['grand_total']); ?>
											</p>
											<p class="text-muted mb-0"><strong>Status:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['quotation_status']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Assign to :</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['assigned_user']))); ?>
											</p>
											<p class="text-muted mb-0"><a href="#" data-bs-toggle="modal" data-bs-target="#viewQuotation<?php echo $row['quotation_id']; ?>" class="fst-italic">More Details</a>
											</p>
										</div>
									</li>

									<!-- Modal for Quotation Details -->
									<div class="modal fade" id="viewQuotation<?php echo $row['quotation_id']; ?>" tabindex="-1" aria-hidden="true">
										<div class="modal-dialog modal-dialog-centered">
											<div class="modal-content">
												<div class="modal-header">
													<h5 class="modal-title">Quotation Details</h5>
													<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
												</div>
												<div class="modal-body">
													<ul class="list-unstyled mb-0 mt-0">
														<li><strong>Customer Name:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?>
														</li>
														<li><strong>Email:</strong>
															<?php echo htmlspecialchars($row['email']); ?>
														</li>
														<li><strong>Phone:</strong>
															<?php echo htmlspecialchars($row['phone']); ?>
														</li>
														<li><strong>Package Name:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['package_name']))); ?>
														</li>
														<li><strong>Travel Date:</strong>
															<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
														</li>
														<li><strong>Nights:</strong>
															<?php echo htmlspecialchars($row['nights']); ?>
														</li>
														<li><strong>Adults/Children:</strong>
															<?php echo htmlspecialchars($row['adults']) . '/' . htmlspecialchars($row['child']); ?>
														</li>
														<li><strong>Rooms / Extrabed:</strong>
															<?php echo htmlspecialchars($row['rooms']) . '/' . htmlspecialchars($row['extrabed']); ?>
														</li>
														<li><strong>Package (Per Person):</strong>
															<?php echo htmlspecialchars($row['adult_price']); ?>
														</li>
														
													</ul>
												</div>
											</div>
										</div>
									</div>
									<?php } ?>
								</ul>
								<?php } else { echo "<h6 class='text-center'>No quotations today</h6>"; } ?>
							</div>

							<!-- Package Bookings Tab -->
							<div class="tab-pane fade" id="navs-justified-bookings" role="tabpanel">
								<?php
								 $sqlBookings = "SELECT package_bookings.*, customers.id AS customer_id, customers.*, users.name AS assigned_user, SUM(CASE WHEN package_payments.type = 'credit' THEN package_payments.amount ELSE 0 END) AS total_credit, SUM(CASE WHEN package_payments.type = 'debit' THEN package_payments.amount ELSE 0 END) AS total_debit FROM package_bookings JOIN customers ON package_bookings.customer_id = customers.id LEFT JOIN users ON package_bookings.assigned_to = users.id LEFT JOIN package_payments ON package_bookings.id = package_payments.booking_id WHERE DATE(package_bookings.booking_date) = '$today' GROUP BY package_bookings.id, customers.id, users.name ORDER BY package_bookings.created_at ASC
";
								$resultBookings = mysqli_query( $conn, $sqlBookings );
								if ( mysqli_num_rows( $resultBookings ) > 0 ) {
									?>
								<ul class="timeline mb-0 pb-1 scroll-list">
									<?php while ($row = mysqli_fetch_assoc($resultBookings)) { ?>
									<li class="timeline-item">
										<div class="timeline-event px-0 pb-0">
											<h6 class="mb-1">Customer: <?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?></h6>
											<p class="text-muted mb-0"><strong>Book No.:</strong>
												<?php echo htmlspecialchars($row['booking_no']); ?>
											</p>
											<p class="text-muted mb-0"><strong>Package Name:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['package_name']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Total Amount:</strong>
												<?php echo htmlspecialchars($row['grand_total']); ?>
											</p>
											<p class="text-muted mb-0"><strong>Adv Amount:</strong>
												<?php echo htmlspecialchars($row['total_credit']); ?>
											</p>
											<p class="text-muted mb-0"><strong>Assign to :</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['assigned_user']))); ?>
											</p>
											<p class="text-muted mb-0"><a href="#" data-bs-toggle="modal" data-bs-target="#viewBooking<?php echo $row['id']; ?>" class="fst-italic">More Details</a>
											</p>
										</div>
									</li>

									<!-- Modal for Package Booking Details -->
									<div class="modal fade" id="viewBooking<?php echo $row['id']; ?>" tabindex="-1" aria-hidden="true">
										<div class="modal-dialog modal-dialog-centered">
											<div class="modal-content">
												<div class="modal-header">
													<h5 class="modal-title">Booking Details</h5>
													<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
												</div>
												<div class="modal-body">
													<ul class="list-unstyled mb-0 mt-0">
														<li><strong>Customer Name:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?>
														</li>
														<li><strong>Email:</strong>
															<?php echo htmlspecialchars($row['email']); ?>
														</li>
														<li><strong>Phone:</strong>
															<?php echo htmlspecialchars($row['phone']); ?>
														</li>
														<li><strong>Package Name:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['package_name']))); ?>
														</li>
														<li><strong>Travel Date:</strong>
															<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
														</li>
														<li><strong>Nights:</strong>
															<?php echo htmlspecialchars($row['nights']); ?>
														</li>
														<li><strong>Adults/Children:</strong>
															<?php echo htmlspecialchars($row['adults']) . '/' . htmlspecialchars($row['child']); ?>
														</li>
														<li><strong>Rooms / Extrabed:</strong>
															<?php echo htmlspecialchars($row['rooms']) . '/' . htmlspecialchars($row['extrabed']); ?>
														</li>
														<li><strong>Package (Per Person):</strong>
															<?php echo htmlspecialchars($row['adult_price']); ?>
														</li>
														
														
													</ul>
												</div>
											</div>
										</div>
									</div>
									<?php } ?>
								</ul>
								<?php } else { echo "<h6 class='text-center'>No bookings today</h6>"; } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col-12 col-xl-6 col-md-6 mb-4">
			<div class="card h-100">
				<div class="card-header d-flex justify-content-between pb-2">
					<div class="card-title mb-1">
						<h5 class="m-0 me-2">Followup</h5>
					</div>
				</div>
				<div class="card-body">
					<div class="nav-align-top">
						<ul class="nav nav-tabs nav-fill" role="tablist">
							<li class="nav-item">
								<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#navs-justified-followup" aria-controls="navs-justified-followup" aria-selected="true">
                Today Followup
              </button>
							
							</li>
							<li class="nav-item">
								<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-justified-reminder" aria-controls="navs-justified-reminder" aria-selected="false">
                Reminder Call
              </button>
							
							</li>
							
						</ul>

						<div class="tab-content px-2 mx-1 pb-0">
							<!-- Inquiries Tab -->
							<div class="tab-pane fade show active" id="navs-justified-followup" role="tabpanel">
								<?php
								// Get today's date
								$today = date( 'Y-m-d' );

								// Query to fetch today's inquiry details along with customer information
								$sqlInquiries = "SELECT inquiries.id AS inquiry_id, inquiries.*, customers.id AS customer_id, customers.*, users.name AS assigned_user FROM inquiries JOIN customers ON inquiries.customer_id = customers.id LEFT JOIN users ON inquiries.assigned_to = users.id WHERE inquiries.next_followup_date = '$today' ORDER BY inquiries.created_at ASC";
								$resultInquiries = mysqli_query( $conn, $sqlInquiries );

								// Check if there are any results
								if ( mysqli_num_rows( $resultInquiries ) > 0 ) {
									?>
								<ul class="timeline mb-0 pb-1 scroll-list">
									<?php while ($row = mysqli_fetch_assoc($resultInquiries)) { ?>
									<li class="timeline-item">
										<div class="timeline-event px-0 pb-0">
											<h6 class="mb-1">Customer: <?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?></h6>
											<p class="text-muted mb-0"><strong>Inquiry Type:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_type']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Destination:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['destination']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Travel Date:</strong>
												<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Status:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['followup_status']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Assign to :</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['assigned_user']))); ?>
											</p>
											
											<p class="text-muted mb-0"><a href="#" data-bs-toggle="modal" data-bs-target="#viewFollowup<?php echo $row['inquiry_id']; ?>" class="fst-italic">More Details</a>
											</p>

										</div>
									</li>

									<!-- Modal for Inquiry Details -->
									<div class="modal fade" id="viewFollowup<?php echo $row['inquiry_id']; ?>" tabindex="-1" aria-hidden="true">
										<div class="modal-dialog modal-dialog-centered">
											<div class="modal-content">
												<div class="modal-header">
													<h5 class="modal-title">Inquiry Details</h5>
													<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
												</div>
												<div class="modal-body">
													<ul class="list-unstyled mb-0 mt-0">
														<li><strong>Customer Name:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?>
														</li>
														<li><strong>Email:</strong>
															<?php echo htmlspecialchars($row['email']); ?>
														</li>
														<li><strong>Phone:</strong>
															<?php echo htmlspecialchars($row['phone']); ?>
														</li>
														<li><strong>Destination:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['destination']))); ?>
														</li>
														<li><strong>Travel Date:</strong>
															<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
														</li>
														<li><strong>Nights:</strong>
															<?php echo htmlspecialchars($row['nights']); ?>
														</li>
														<li><strong>Adults/Children:</strong>
															<?php echo htmlspecialchars($row['adults']) . '/' . htmlspecialchars($row['child']); ?>
														</li>
														<li><strong>Rooms:</strong>
															<?php echo htmlspecialchars($row['rooms']); ?>
														</li>
														<li><strong>Remarks:</strong>
															<?php echo htmlspecialchars($row['remarks']); ?>
														</li>
													</ul>
												</div>
											</div>
										</div>
									</div>
									<?php } ?>
								</ul>


								<?php } else { echo "<h6 class='text-center'>No Followup today</h6>"; } ?>
							</div>

							<!-- Quotations Tab -->
							<div class="tab-pane fade" id="navs-justified-reminder" role="tabpanel">
								<?php
								$ten_days_later = date('Y-m-d', strtotime('+10 days'));
								$sqlReminders = "SELECT inquiries.id AS inquiry_id, inquiries.*, customers.id AS customer_id, customers.*, users.name AS assigned_user FROM inquiries JOIN customers ON inquiries.customer_id = customers.id LEFT JOIN users ON inquiries.assigned_to = users.id WHERE inquiries.next_followup_date BETWEEN '$today' AND '$ten_days_later' ORDER BY inquiries.next_followup_date ASC";
								$resultReminders = mysqli_query( $conn, $sqlReminders );
								if ( mysqli_num_rows( $resultReminders ) > 0 ) {
									?>
								<ul class="timeline mb-0 pb-1 scroll-list">
									<?php while ($row = mysqli_fetch_assoc($resultReminders)) { ?>
									<li class="timeline-item">
										<div class="timeline-event px-0 pb-0">
											<h6 class="mb-1">Customer: <?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?></h6>
											<p class="text-muted mb-0"><strong>Inquiry Type:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['inquiry_type']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Destination:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['destination']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Travel Date:</strong>
												<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Status:</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['followup_status']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Assign to :</strong>
												<?php echo htmlspecialchars(ucwords(strtolower($row['assigned_user']))); ?>
											</p>
											<p class="text-muted mb-0"><strong>Reminder Date:</strong>
												<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['next_followup_date']))); ?>
											</p>
											<p class="text-muted mb-0"><a href="#" data-bs-toggle="modal" data-bs-target="#viewReminder<?php echo $row['inquiry_id']; ?>" class="fst-italic">More Details</a>
											</p>

										</div>
									</li>

									<!-- Modal for Quotation Details -->
									<div class="modal fade" id="viewReminder<?php echo $row['inquiry_id']; ?>" tabindex="-1" aria-hidden="true">
										<div class="modal-dialog modal-dialog-centered">
											<div class="modal-content">
												<div class="modal-header">
													<h5 class="modal-title">Inquiry Details</h5>
													<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
												</div>
												<div class="modal-body">
													<ul class="list-unstyled mb-0 mt-0">
														<li><strong>Customer Name:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['name']))); ?>
														</li>
														<li><strong>Email:</strong>
															<?php echo htmlspecialchars($row['email']); ?>
														</li>
														<li><strong>Phone:</strong>
															<?php echo htmlspecialchars($row['phone']); ?>
														</li>
														<li><strong>Destination:</strong>
															<?php echo htmlspecialchars(ucwords(strtolower($row['destination']))); ?>
														</li>
														<li><strong>Travel Date:</strong>
															<?php echo htmlspecialchars(date('d-m-Y', strtotime($row['travel_date']))); ?>
														</li>
														<li><strong>Nights:</strong>
															<?php echo htmlspecialchars($row['nights']); ?>
														</li>
														<li><strong>Adults/Children:</strong>
															<?php echo htmlspecialchars($row['adults']) . '/' . htmlspecialchars($row['child']); ?>
														</li>
														<li><strong>Rooms:</strong>
															<?php echo htmlspecialchars($row['rooms']); ?>
														</li>
														<li><strong>Remarks:</strong>
															<?php echo htmlspecialchars($row['remarks']); ?>
														</li>
													</ul>
												</div>
											</div>
										</div>
									</div>
									<?php } ?>
								</ul>
								<?php } else { echo "<h6 class='text-center'>No Reminder Call</h6>"; } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row">

		<!-- Inquiries -->
		
		<div class="col-md-12 col-xxl-12 mb-4 order-0 order-xxl-4">
			<div class="card h-100">
				<div class="card-header d-flex justify-content-between pb-2">
					<div class="card-title mb-1">
						<h5 class="m-0 me-2">Team Follow-Up Status</h5>

					</div>

				</div>
				<div class="card-body">
					<div class="table-responsive text-nowrap">
						<table class="table table-sm">
							<thead>
								<tr>
									<th>Name</th>
									<th>Pending</th>
									<th>Done</th>
									<th>Cancel</th>
									<th>Closed</th>
								</tr>
							</thead>
							<tbody class="table-border-bottom-0">
								<?php 
$sql = "
SELECT 
    u.id AS user_id,
    u.name AS user_name,
    SUM(CASE WHEN i.followup_status = 'pending' THEN 1 ELSE 0 END) AS pending_count,
    SUM(CASE WHEN i.followup_status = 'done' THEN 1 ELSE 0 END) AS done_count,
    SUM(CASE WHEN i.followup_status = 'cancelled' THEN 1 ELSE 0 END) AS cancelled_count,
    SUM(CASE WHEN i.followup_status = 'closed' THEN 1 ELSE 0 END) AS closed_count
FROM users u
LEFT JOIN inquiries i ON i.assigned_to = u.id
GROUP BY u.id
ORDER BY u.name ASC
";

$result = mysqli_query($conn, $sql);

 while ($row = mysqli_fetch_assoc($result)) { ?>
								<tr>
									<td>
										<?php echo htmlspecialchars(ucwords($row['user_name'])); ?>
									</td>
									<td>
										<?php echo (int)$row['pending_count']; ?>
									</td>
									<td>
										<?php echo (int)$row['done_count']; ?>
									</td>
									<td>
										<?php echo (int)$row['cancelled_count']; ?>
									</td>
									<td>
										<?php echo (int)$row['closed_count']; ?>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>


					</div>
				</div>
			</div>
		</div>
	</div>








</div>
<?php include('inc/footer.php');?>