<?php
$packagebooking_id = isset($_GET['packagebookingid']) ? intval($_GET['packagebookingid']) : 0;
$result = mysqli_query($conn, "SELECT pb.*, c.name AS customer_name, c.phone AS customer_phone, c.email AS customer_email, c.address, u.name AS assigned_to_name FROM package_bookings pb JOIN customers c ON pb.customer_id = c.id JOIN users u ON pb.assigned_to = u.id WHERE pb.id = '$packagebooking_id'");
$row = mysqli_fetch_array($result);
$current_page = basename($_SERVER['PHP_SELF']); 
$breadcrumb_title = ($current_page == 'package_booking_payment.php') ? 'Payment History' : 'Profile';

$pquery = "SELECT pb.id AS booking_id,pb.gst_included, COALESCE(SUM(CASE WHEN pp.type = 'credit' THEN pp.amount ELSE 0 END), 0) AS total_credit, COALESCE(SUM(CASE WHEN pp.type = 'debit' THEN pp.amount ELSE 0 END), 0) AS total_debit, COALESCE(SUM(CASE WHEN pp.type = 'debit' THEN pp.amount ELSE 0 END), 0) - COALESCE(SUM(CASE WHEN pp.type = 'credit' THEN pp.amount ELSE 0 END), 0) AS due_amount FROM package_bookings pb LEFT JOIN package_payments pp ON pb.id = pp.booking_id WHERE pb.id = '$packagebooking_id'  GROUP BY pb.id";
$presult = mysqli_query($conn, $pquery);
$prow = mysqli_fetch_assoc($presult);
$total_credit = $prow['total_credit'] ?? 0;
$total_debit = $prow['total_debit'] ?? 0;
$due_amount = max($prow['due_amount'] ?? 0, 0);
$gst_included = $prow['gst_included'];

$breadcrumbLink = $gst_included === 'yes' ? 'booking_list_with_gst.php' : 'booking_list_without_gst.php';
?>
<nav aria-label="breadcrumb">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="index.php">Home</a></li>
        <li class="breadcrumb-item"><a href="<?php echo $breadcrumbLink; ?>">Package Booking List</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?= $breadcrumb_title; ?></li>
    </ol>
</nav>

<div class="row">
    <div class="col-md-12">
        <div class="nav-align-top">
            <ul class="nav nav-pills flex-column flex-sm-row mb-6 gap-2 gap-lg-0">
                <li class="nav-item">
                    <a class="nav-link <?= ($current_page == 'booking_details.php') ? 'active' : ''; ?>" 
                       href="booking_details.php?packagebookingid=<?= urlencode($packagebooking_id); ?>">
                        <i class="ti-sm ti ti-user-check me-1-5"></i> Profile
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($current_page == 'package_booking_payment.php') ? 'active' : ''; ?>" 
                       href="package_booking_payment.php?packagebookingid=<?= urlencode($packagebooking_id); ?>">
                        <i class="ti-sm ti ti-headset me-1-5"></i> Payment History
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
